/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM PositionStateEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "PositionStateEvent.h"
#include "PositionStateEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/FloatingPoint.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PositionStateEvent.h"
#include "mozilla/dom/PrimitiveConversions.h"

namespace mozilla::dom {


PositionStateEvent::PositionStateEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

PositionStateEvent::~PositionStateEvent()
{
}

PositionStateEvent*
PositionStateEvent::AsPositionStateEvent()
{
  return this;
}

JSObject*
PositionStateEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return PositionStateEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<PositionStateEvent>
PositionStateEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const PositionStateEventInit& aEventInitDict)
{
  RefPtr<PositionStateEvent> e = new PositionStateEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mDuration = aEventInitDict.mDuration;
  e->mPlaybackRate = aEventInitDict.mPlaybackRate;
  e->mPosition = aEventInitDict.mPosition;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<PositionStateEvent>
PositionStateEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const PositionStateEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

double
PositionStateEvent::Duration() const
{
  return mDuration;
}

double
PositionStateEvent::PlaybackRate() const
{
  return mPlaybackRate;
}

double
PositionStateEvent::Position() const
{
  return mPosition;
}


} // namespace mozilla::dom
