/* Generated by wayland-scanner 1.24.0 */

#ifndef GAMESCOPE_CONTROL_SERVER_PROTOCOL_H
#define GAMESCOPE_CONTROL_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_gamescope_control The gamescope_control protocol
 * gamescope-specific protocol
 *
 * @section page_desc_gamescope_control Description
 *
 * This is a private Gamescope protocol. Regular Wayland clients must not use
 * it.
 *
 * @section page_ifaces_gamescope_control Interfaces
 * - @subpage page_iface_gamescope_control - 
 * @section page_copyright_gamescope_control Copyright
 * <pre>
 *
 * Copyright © 2023 Valve Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct gamescope_control;

#ifndef GAMESCOPE_CONTROL_INTERFACE
#define GAMESCOPE_CONTROL_INTERFACE
/**
 * @page page_iface_gamescope_control gamescope_control
 * @section page_iface_gamescope_control_api API
 * See @ref iface_gamescope_control.
 */
/**
 * @defgroup iface_gamescope_control The gamescope_control interface
 */
extern const struct wl_interface gamescope_control_interface;
#endif

#ifndef GAMESCOPE_CONTROL_FEATURE_ENUM
#define GAMESCOPE_CONTROL_FEATURE_ENUM
/**
 * @ingroup iface_gamescope_control
 * gamescope feature types
 *
 * Enum of the features supported by Gamescope.
 */
enum gamescope_control_feature {
	/**
	 * sent at the end of the feature list
	 */
	GAMESCOPE_CONTROL_FEATURE_DONE = 0,
	GAMESCOPE_CONTROL_FEATURE_RESHADE_SHADERS = 1,
	GAMESCOPE_CONTROL_FEATURE_DISPLAY_INFO = 2,
	GAMESCOPE_CONTROL_FEATURE_PIXEL_FILTER = 3,
	GAMESCOPE_CONTROL_FEATURE_REFRESH_CYCLE_ONLY_CHANGE_REFRESH_RATE = 4,
	GAMESCOPE_CONTROL_FEATURE_MURA_CORRECTION = 5,
	GAMESCOPE_CONTROL_FEATURE_LOOK = 6,
	GAMESCOPE_CONTROL_FEATURE_PERF_QUERY = 7,
};
#endif /* GAMESCOPE_CONTROL_FEATURE_ENUM */

#ifndef GAMESCOPE_CONTROL_FEATURE_ENUM_IS_VALID
#define GAMESCOPE_CONTROL_FEATURE_ENUM_IS_VALID
/**
 * @ingroup iface_gamescope_control
 * Validate a gamescope_control feature value.
 *
 * @return true on success, false on error.
 * @ref gamescope_control_feature
 */
static inline bool
gamescope_control_feature_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case GAMESCOPE_CONTROL_FEATURE_DONE:
		return version >= 1;
	case GAMESCOPE_CONTROL_FEATURE_RESHADE_SHADERS:
		return version >= 1;
	case GAMESCOPE_CONTROL_FEATURE_DISPLAY_INFO:
		return version >= 1;
	case GAMESCOPE_CONTROL_FEATURE_PIXEL_FILTER:
		return version >= 1;
	case GAMESCOPE_CONTROL_FEATURE_REFRESH_CYCLE_ONLY_CHANGE_REFRESH_RATE:
		return version >= 1;
	case GAMESCOPE_CONTROL_FEATURE_MURA_CORRECTION:
		return version >= 1;
	case GAMESCOPE_CONTROL_FEATURE_LOOK:
		return version >= 1;
	case GAMESCOPE_CONTROL_FEATURE_PERF_QUERY:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* GAMESCOPE_CONTROL_FEATURE_ENUM_IS_VALID */

#ifndef GAMESCOPE_CONTROL_DISPLAY_FLAG_ENUM
#define GAMESCOPE_CONTROL_DISPLAY_FLAG_ENUM
enum gamescope_control_display_flag {
	GAMESCOPE_CONTROL_DISPLAY_FLAG_INTERNAL_DISPLAY = 0x1,
	GAMESCOPE_CONTROL_DISPLAY_FLAG_SUPPORTS_HDR = 0x2,
	GAMESCOPE_CONTROL_DISPLAY_FLAG_SUPPORTS_VRR = 0x4,
};
#endif /* GAMESCOPE_CONTROL_DISPLAY_FLAG_ENUM */

#ifndef GAMESCOPE_CONTROL_DISPLAY_FLAG_ENUM_IS_VALID
#define GAMESCOPE_CONTROL_DISPLAY_FLAG_ENUM_IS_VALID
/**
 * @ingroup iface_gamescope_control
 * Validate a gamescope_control display_flag value.
 *
 * @return true on success, false on error.
 * @ref gamescope_control_display_flag
 */
static inline bool
gamescope_control_display_flag_is_valid(uint32_t value, uint32_t version) {
	uint32_t valid = 0;
	if (version >= 1)
		valid |= GAMESCOPE_CONTROL_DISPLAY_FLAG_INTERNAL_DISPLAY;
	if (version >= 1)
		valid |= GAMESCOPE_CONTROL_DISPLAY_FLAG_SUPPORTS_HDR;
	if (version >= 1)
		valid |= GAMESCOPE_CONTROL_DISPLAY_FLAG_SUPPORTS_VRR;
	return (value & ~valid) == 0;
}
#endif /* GAMESCOPE_CONTROL_DISPLAY_FLAG_ENUM_IS_VALID */

#ifndef GAMESCOPE_CONTROL_TARGET_REFRESH_CYCLE_FLAG_ENUM
#define GAMESCOPE_CONTROL_TARGET_REFRESH_CYCLE_FLAG_ENUM
enum gamescope_control_target_refresh_cycle_flag {
	/**
	 * Whether we should change the target refresh cycle under external/internal display
	 */
	GAMESCOPE_CONTROL_TARGET_REFRESH_CYCLE_FLAG_INTERNAL_DISPLAY = 0x1,
	/**
	 * Whether or not to allow refresh rate switching
	 */
	GAMESCOPE_CONTROL_TARGET_REFRESH_CYCLE_FLAG_ALLOW_REFRESH_SWITCHING = 0x2,
	/**
	 * Only change refresh rate but don't apply frame limiter fps cap
	 */
	GAMESCOPE_CONTROL_TARGET_REFRESH_CYCLE_FLAG_ONLY_CHANGE_REFRESH_RATE = 0x4,
};
#endif /* GAMESCOPE_CONTROL_TARGET_REFRESH_CYCLE_FLAG_ENUM */

#ifndef GAMESCOPE_CONTROL_TARGET_REFRESH_CYCLE_FLAG_ENUM_IS_VALID
#define GAMESCOPE_CONTROL_TARGET_REFRESH_CYCLE_FLAG_ENUM_IS_VALID
/**
 * @ingroup iface_gamescope_control
 * Validate a gamescope_control target_refresh_cycle_flag value.
 *
 * @return true on success, false on error.
 * @ref gamescope_control_target_refresh_cycle_flag
 */
static inline bool
gamescope_control_target_refresh_cycle_flag_is_valid(uint32_t value, uint32_t version) {
	uint32_t valid = 0;
	if (version >= 1)
		valid |= GAMESCOPE_CONTROL_TARGET_REFRESH_CYCLE_FLAG_INTERNAL_DISPLAY;
	if (version >= 1)
		valid |= GAMESCOPE_CONTROL_TARGET_REFRESH_CYCLE_FLAG_ALLOW_REFRESH_SWITCHING;
	if (version >= 1)
		valid |= GAMESCOPE_CONTROL_TARGET_REFRESH_CYCLE_FLAG_ONLY_CHANGE_REFRESH_RATE;
	return (value & ~valid) == 0;
}
#endif /* GAMESCOPE_CONTROL_TARGET_REFRESH_CYCLE_FLAG_ENUM_IS_VALID */

#ifndef GAMESCOPE_CONTROL_SCREENSHOT_TYPE_ENUM
#define GAMESCOPE_CONTROL_SCREENSHOT_TYPE_ENUM
enum gamescope_control_screenshot_type {
	/**
	 * Just the game w/ no display color mgmt
	 */
	GAMESCOPE_CONTROL_SCREENSHOT_TYPE_BASE_PLANE_ONLY = 1,
	/**
	 * Just the game + overlays w/ no display color mgmt
	 */
	GAMESCOPE_CONTROL_SCREENSHOT_TYPE_ALL_REAL_LAYERS = 2,
	/**
	 * Every layer w/ no display color mgmt and no mura
	 */
	GAMESCOPE_CONTROL_SCREENSHOT_TYPE_FULL_COMPOSITION = 3,
	/**
	 * The buffer displayed on-screen - 1:1
	 */
	GAMESCOPE_CONTROL_SCREENSHOT_TYPE_SCREEN_BUFFER = 4,
};
#endif /* GAMESCOPE_CONTROL_SCREENSHOT_TYPE_ENUM */

#ifndef GAMESCOPE_CONTROL_SCREENSHOT_TYPE_ENUM_IS_VALID
#define GAMESCOPE_CONTROL_SCREENSHOT_TYPE_ENUM_IS_VALID
/**
 * @ingroup iface_gamescope_control
 * Validate a gamescope_control screenshot_type value.
 *
 * @return true on success, false on error.
 * @ref gamescope_control_screenshot_type
 */
static inline bool
gamescope_control_screenshot_type_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case GAMESCOPE_CONTROL_SCREENSHOT_TYPE_BASE_PLANE_ONLY:
		return version >= 1;
	case GAMESCOPE_CONTROL_SCREENSHOT_TYPE_ALL_REAL_LAYERS:
		return version >= 1;
	case GAMESCOPE_CONTROL_SCREENSHOT_TYPE_FULL_COMPOSITION:
		return version >= 1;
	case GAMESCOPE_CONTROL_SCREENSHOT_TYPE_SCREEN_BUFFER:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* GAMESCOPE_CONTROL_SCREENSHOT_TYPE_ENUM_IS_VALID */

#ifndef GAMESCOPE_CONTROL_SCREENSHOT_FLAGS_ENUM
#define GAMESCOPE_CONTROL_SCREENSHOT_FLAGS_ENUM
enum gamescope_control_screenshot_flags {
	GAMESCOPE_CONTROL_SCREENSHOT_FLAGS_DUMMY = 0x1,
};
#endif /* GAMESCOPE_CONTROL_SCREENSHOT_FLAGS_ENUM */

#ifndef GAMESCOPE_CONTROL_SCREENSHOT_FLAGS_ENUM_IS_VALID
#define GAMESCOPE_CONTROL_SCREENSHOT_FLAGS_ENUM_IS_VALID
/**
 * @ingroup iface_gamescope_control
 * Validate a gamescope_control screenshot_flags value.
 *
 * @return true on success, false on error.
 * @ref gamescope_control_screenshot_flags
 */
static inline bool
gamescope_control_screenshot_flags_is_valid(uint32_t value, uint32_t version) {
	uint32_t valid = 0;
	if (version >= 1)
		valid |= GAMESCOPE_CONTROL_SCREENSHOT_FLAGS_DUMMY;
	return (value & ~valid) == 0;
}
#endif /* GAMESCOPE_CONTROL_SCREENSHOT_FLAGS_ENUM_IS_VALID */

#ifndef GAMESCOPE_CONTROL_DISPLAY_TYPE_FLAGS_ENUM
#define GAMESCOPE_CONTROL_DISPLAY_TYPE_FLAGS_ENUM
enum gamescope_control_display_type_flags {
	/**
	 * The internal display of the device
	 */
	GAMESCOPE_CONTROL_DISPLAY_TYPE_FLAGS_INTERNAL_DISPLAY = 0x1,
	/**
	 * The external display attached to the device
	 */
	GAMESCOPE_CONTROL_DISPLAY_TYPE_FLAGS_EXTERNAL_DISPLAY = 0x2,
};
#endif /* GAMESCOPE_CONTROL_DISPLAY_TYPE_FLAGS_ENUM */

#ifndef GAMESCOPE_CONTROL_DISPLAY_TYPE_FLAGS_ENUM_IS_VALID
#define GAMESCOPE_CONTROL_DISPLAY_TYPE_FLAGS_ENUM_IS_VALID
/**
 * @ingroup iface_gamescope_control
 * Validate a gamescope_control display_type_flags value.
 *
 * @return true on success, false on error.
 * @ref gamescope_control_display_type_flags
 */
static inline bool
gamescope_control_display_type_flags_is_valid(uint32_t value, uint32_t version) {
	uint32_t valid = 0;
	if (version >= 1)
		valid |= GAMESCOPE_CONTROL_DISPLAY_TYPE_FLAGS_INTERNAL_DISPLAY;
	if (version >= 1)
		valid |= GAMESCOPE_CONTROL_DISPLAY_TYPE_FLAGS_EXTERNAL_DISPLAY;
	return (value & ~valid) == 0;
}
#endif /* GAMESCOPE_CONTROL_DISPLAY_TYPE_FLAGS_ENUM_IS_VALID */

#ifndef GAMESCOPE_CONTROL_DISPLAY_SLEEP_FLAGS_ENUM
#define GAMESCOPE_CONTROL_DISPLAY_SLEEP_FLAGS_ENUM
enum gamescope_control_display_sleep_flags {
	/**
	 * Go to sleep... zzz... (Conflicts with wake)
	 */
	GAMESCOPE_CONTROL_DISPLAY_SLEEP_FLAGS_SLEEP = 0x1,
	/**
	 * Wake up! (Conflicts with sleep)
	 */
	GAMESCOPE_CONTROL_DISPLAY_SLEEP_FLAGS_WAKE = 0x2,
};
#endif /* GAMESCOPE_CONTROL_DISPLAY_SLEEP_FLAGS_ENUM */

#ifndef GAMESCOPE_CONTROL_DISPLAY_SLEEP_FLAGS_ENUM_IS_VALID
#define GAMESCOPE_CONTROL_DISPLAY_SLEEP_FLAGS_ENUM_IS_VALID
/**
 * @ingroup iface_gamescope_control
 * Validate a gamescope_control display_sleep_flags value.
 *
 * @return true on success, false on error.
 * @ref gamescope_control_display_sleep_flags
 */
static inline bool
gamescope_control_display_sleep_flags_is_valid(uint32_t value, uint32_t version) {
	uint32_t valid = 0;
	if (version >= 1)
		valid |= GAMESCOPE_CONTROL_DISPLAY_SLEEP_FLAGS_SLEEP;
	if (version >= 1)
		valid |= GAMESCOPE_CONTROL_DISPLAY_SLEEP_FLAGS_WAKE;
	return (value & ~valid) == 0;
}
#endif /* GAMESCOPE_CONTROL_DISPLAY_SLEEP_FLAGS_ENUM_IS_VALID */

#ifndef GAMESCOPE_CONTROL_LOOK_FLAGS_ENUM
#define GAMESCOPE_CONTROL_LOOK_FLAGS_ENUM
enum gamescope_control_look_flags {
	GAMESCOPE_CONTROL_LOOK_FLAGS_DUMMY = 0x1,
};
#endif /* GAMESCOPE_CONTROL_LOOK_FLAGS_ENUM */

#ifndef GAMESCOPE_CONTROL_LOOK_FLAGS_ENUM_IS_VALID
#define GAMESCOPE_CONTROL_LOOK_FLAGS_ENUM_IS_VALID
/**
 * @ingroup iface_gamescope_control
 * Validate a gamescope_control look_flags value.
 *
 * @return true on success, false on error.
 * @ref gamescope_control_look_flags
 */
static inline bool
gamescope_control_look_flags_is_valid(uint32_t value, uint32_t version) {
	uint32_t valid = 0;
	if (version >= 1)
		valid |= GAMESCOPE_CONTROL_LOOK_FLAGS_DUMMY;
	return (value & ~valid) == 0;
}
#endif /* GAMESCOPE_CONTROL_LOOK_FLAGS_ENUM_IS_VALID */

/**
 * @ingroup iface_gamescope_control
 * @struct gamescope_control_interface
 */
struct gamescope_control_interface {
	/**
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * @param fps application's target refresh cycle in frames-per-second. 0 = disabled/native
	 * @param flags combination of 'target_refresh_cycle_flag' values
	 * @since 2
	 */
	void (*set_app_target_refresh_cycle)(struct wl_client *client,
					     struct wl_resource *resource,
					     uint32_t fps,
					     uint32_t flags);
	/**
	 * @param path Path to write the screenshot. Extension of the file determines the format
	 * @param type Type of screenshot to save
	 * @param flags combination of 'screenshot_flags' values
	 * @since 3
	 */
	void (*take_screenshot)(struct wl_client *client,
				struct wl_resource *resource,
				const char *path,
				uint32_t type,
				uint32_t flags);
	/**
	 * Attempts to make the display go to sleep/idle
	 *
	 * 
	 * @param display_type display type
	 * @param flags sleep flags
	 * @since 4
	 */
	void (*display_sleep)(struct wl_client *client,
			      struct wl_resource *resource,
			      uint32_t display_type,
			      uint32_t flags);
	/**
	 * Sets a look for the screen based on a 3D LUT.
	 *
	 * 
	 * @param lut3d_g22 file-descriptor containing the data for the look for Gamma 2.2. Expects .cube format
	 * @param lut3d_pq file-descriptor containing the data for the look for PQ. Expects .cube format
	 * @param flags look flags
	 * @since 5
	 */
	void (*set_look)(struct wl_client *client,
			 struct wl_resource *resource,
			 int32_t lut3d_g22,
			 int32_t lut3d_pq,
			 uint32_t flags);
	/**
	 * Unsets the current look.
	 *
	 * 
	 * @since 5
	 */
	void (*unset_look)(struct wl_client *client,
			   struct wl_resource *resource);
	/**
	 * Asks the compositor to send the most recent performance stats
	 *
	 * 
	 * @param app_id Appid 
	 * @since 6
	 */
	void (*request_app_performance_stats)(struct wl_client *client,
					      struct wl_resource *resource,
					      uint32_t app_id);
};

#define GAMESCOPE_CONTROL_FEATURE_SUPPORT 0
#define GAMESCOPE_CONTROL_ACTIVE_DISPLAY_INFO 1
#define GAMESCOPE_CONTROL_SCREENSHOT_TAKEN 2
#define GAMESCOPE_CONTROL_APP_PERFORMANCE_STATS 3

/**
 * @ingroup iface_gamescope_control
 */
#define GAMESCOPE_CONTROL_FEATURE_SUPPORT_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_control
 */
#define GAMESCOPE_CONTROL_ACTIVE_DISPLAY_INFO_SINCE_VERSION 2
/**
 * @ingroup iface_gamescope_control
 */
#define GAMESCOPE_CONTROL_SCREENSHOT_TAKEN_SINCE_VERSION 3
/**
 * @ingroup iface_gamescope_control
 */
#define GAMESCOPE_CONTROL_APP_PERFORMANCE_STATS_SINCE_VERSION 6

/**
 * @ingroup iface_gamescope_control
 */
#define GAMESCOPE_CONTROL_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_control
 */
#define GAMESCOPE_CONTROL_SET_APP_TARGET_REFRESH_CYCLE_SINCE_VERSION 2
/**
 * @ingroup iface_gamescope_control
 */
#define GAMESCOPE_CONTROL_TAKE_SCREENSHOT_SINCE_VERSION 3
/**
 * @ingroup iface_gamescope_control
 */
#define GAMESCOPE_CONTROL_DISPLAY_SLEEP_SINCE_VERSION 4
/**
 * @ingroup iface_gamescope_control
 */
#define GAMESCOPE_CONTROL_SET_LOOK_SINCE_VERSION 5
/**
 * @ingroup iface_gamescope_control
 */
#define GAMESCOPE_CONTROL_UNSET_LOOK_SINCE_VERSION 5
/**
 * @ingroup iface_gamescope_control
 */
#define GAMESCOPE_CONTROL_REQUEST_APP_PERFORMANCE_STATS_SINCE_VERSION 6

/**
 * @ingroup iface_gamescope_control
 * Sends an feature_support event to the client owning the resource.
 * @param resource_ The client's resource
 * @param feature one of the enum features
 * @param version feature version
 * @param flags feature flags
 */
static inline void
gamescope_control_send_feature_support(struct wl_resource *resource_, uint32_t feature, uint32_t version, uint32_t flags)
{
	wl_resource_post_event(resource_, GAMESCOPE_CONTROL_FEATURE_SUPPORT, feature, version, flags);
}

/**
 * @ingroup iface_gamescope_control
 * Sends an active_display_info event to the client owning the resource.
 * @param resource_ The client's resource
 * @param display_flags combination of 'display_flag' values
 * @param valid_refresh_rates valid refresh rates for the display for the purposes of combined fps limiting + refresh. empty if fixed at a mode. 32-bit unsigned integers.
 */
static inline void
gamescope_control_send_active_display_info(struct wl_resource *resource_, const char *connector_name, const char *display_make, const char *display_model, uint32_t display_flags, struct wl_array *valid_refresh_rates)
{
	wl_resource_post_event(resource_, GAMESCOPE_CONTROL_ACTIVE_DISPLAY_INFO, connector_name, display_make, display_model, display_flags, valid_refresh_rates);
}

/**
 * @ingroup iface_gamescope_control
 * Sends an screenshot_taken event to the client owning the resource.
 * @param resource_ The client's resource
 * @param path Path to written screenshot
 */
static inline void
gamescope_control_send_screenshot_taken(struct wl_resource *resource_, const char *path)
{
	wl_resource_post_event(resource_, GAMESCOPE_CONTROL_SCREENSHOT_TAKEN, path);
}

/**
 * @ingroup iface_gamescope_control
 * Sends an app_performance_stats event to the client owning the resource.
 * @param resource_ The client's resource
 * @param app_id Appid for this request
 * @param frametime_ns_lo Time delta between the two most recent frames
 * @param frametime_ns_hi frametime_ns high bits
 */
static inline void
gamescope_control_send_app_performance_stats(struct wl_resource *resource_, uint32_t app_id, uint32_t frametime_ns_lo, uint32_t frametime_ns_hi)
{
	wl_resource_post_event(resource_, GAMESCOPE_CONTROL_APP_PERFORMANCE_STATS, app_id, frametime_ns_lo, frametime_ns_hi);
}

#ifdef  __cplusplus
}
#endif

#endif
