/* limit_input_stream.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from limit_input_stream.vala, do not modify */

#include "libdino.h"
#include <gio/gio.h>
#include <glib.h>
#include <glib-object.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DINO_LIMIT_INPUT_STREAM_0_PROPERTY,
	DINO_LIMIT_INPUT_STREAM_MAX_BYTES_PROPERTY,
	DINO_LIMIT_INPUT_STREAM_RETRIEVED_BYTES_PROPERTY,
	DINO_LIMIT_INPUT_STREAM_REMAINING_BYTES_PROPERTY,
	DINO_LIMIT_INPUT_STREAM_NUM_PROPERTIES
};
static GParamSpec* dino_limit_input_stream_properties[DINO_LIMIT_INPUT_STREAM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _DinoLimitInputStreamReadAsyncData DinoLimitInputStreamReadAsyncData;
typedef struct _DinoLimitInputStreamCloseAsyncData DinoLimitInputStreamCloseAsyncData;

struct _DinoLimitInputStreamPrivate {
	GInputStream* inner;
	gint64 _max_bytes;
	gint64 _retrieved_bytes;
};

struct _DinoLimitInputStreamReadAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DinoLimitInputStream* self;
	guint8* buffer;
	gsize buffer_length1;
	gint io_priority;
	GCancellable* cancellable;
	gssize result;
	gint64 _tmp0_;
	gint64 _tmp1_;
	gint original_buffer_length;
	gboolean _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_;
	gint64 _tmp5_;
	gint64 _tmp6_;
	gint64 _tmp7_;
	gint64 _tmp8_;
	gssize read_bytes;
	GInputStream* _tmp9_;
	gint64 _tmp10_;
	GError* _inner_error0_;
};

struct _DinoLimitInputStreamCloseAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DinoLimitInputStream* self;
	gint io_priority;
	GCancellable* cancellable;
	gboolean result;
	gboolean _tmp0_;
	GInputStream* _tmp1_;
	GError* _inner_error0_;
};

static gint DinoLimitInputStream_private_offset;
static gpointer dino_limit_input_stream_parent_class = NULL;
static GPollableInputStreamInterface * dino_limit_input_stream_g_pollable_input_stream_parent_iface = NULL;

static void dino_limit_input_stream_set_max_bytes (DinoLimitInputStream* self,
                                            gint64 value);
static gboolean dino_limit_input_stream_real_can_poll (GPollableInputStream* base);
static GSource* dino_limit_input_stream_real_create_source (GPollableInputStream* base,
                                                     GCancellable* cancellable);
static gboolean dino_limit_input_stream_real_is_readable (GPollableInputStream* base);
static gssize dino_limit_input_stream_check_limit (DinoLimitInputStream* self,
                                            gssize read,
                                            GError** error);
static void dino_limit_input_stream_set_retrieved_bytes (DinoLimitInputStream* self,
                                                  gint64 value);
static gssize dino_limit_input_stream_real_read (GInputStream* base,
                                          guint8* buffer,
                                          gsize buffer_length1,
                                          GCancellable* cancellable,
                                          GError** error);
static void dino_limit_input_stream_real_read_async_data_free (gpointer _data);
static void dino_limit_input_stream_real_read_async (GInputStream* base,
                                              guint8* buffer,
                                              gsize buffer_length1,
                                              gint io_priority,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static gboolean dino_limit_input_stream_real_read_async_co (DinoLimitInputStreamReadAsyncData* _data_);
static void dino_limit_input_stream_read_async_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static gssize dino_limit_input_stream_real_read_nonblocking_fn (GPollableInputStream* base,
                                                         guint8* buffer,
                                                         gsize buffer_length1,
                                                         GError** error);
static gboolean dino_limit_input_stream_real_close (GInputStream* base,
                                             GCancellable* cancellable,
                                             GError** error);
static void dino_limit_input_stream_real_close_async_data_free (gpointer _data);
static void dino_limit_input_stream_real_close_async (GInputStream* base,
                                               gint io_priority,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean dino_limit_input_stream_real_close_async_co (DinoLimitInputStreamCloseAsyncData* _data_);
static void dino_limit_input_stream_close_async_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void dino_limit_input_stream_finalize (GObject * obj);
static GType dino_limit_input_stream_get_type_once (void);
static void _vala_dino_limit_input_stream_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_dino_limit_input_stream_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
dino_limit_input_stream_get_instance_private (DinoLimitInputStream* self)
{
	return G_STRUCT_MEMBER_P (self, DinoLimitInputStream_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

DinoLimitInputStream*
dino_limit_input_stream_construct (GType object_type,
                                   GInputStream* inner,
                                   gint64 max_bytes)
{
	DinoLimitInputStream * self = NULL;
	GInputStream* _tmp0_;
	g_return_val_if_fail (inner != NULL, NULL);
	self = (DinoLimitInputStream*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (inner);
	_g_object_unref0 (self->priv->inner);
	self->priv->inner = _tmp0_;
	dino_limit_input_stream_set_max_bytes (self, max_bytes);
	return self;
}

DinoLimitInputStream*
dino_limit_input_stream_new (GInputStream* inner,
                             gint64 max_bytes)
{
	return dino_limit_input_stream_construct (DINO_TYPE_LIMIT_INPUT_STREAM, inner, max_bytes);
}

static gboolean
dino_limit_input_stream_real_can_poll (GPollableInputStream* base)
{
	DinoLimitInputStream * self;
	gboolean _tmp0_ = FALSE;
	GInputStream* _tmp1_;
	gboolean result;
	self = (DinoLimitInputStream*) base;
	_tmp1_ = self->priv->inner;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, g_pollable_input_stream_get_type ())) {
		GInputStream* _tmp2_;
		_tmp2_ = self->priv->inner;
		_tmp0_ = g_pollable_input_stream_can_poll (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_pollable_input_stream_get_type (), GPollableInputStream));
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static GSource*
dino_limit_input_stream_real_create_source (GPollableInputStream* base,
                                            GCancellable* cancellable)
{
	DinoLimitInputStream * self;
	GInputStream* _tmp1_;
	GSource* _tmp2_;
	GError* _inner_error0_ = NULL;
	GSource* result;
	self = (DinoLimitInputStream*) base;
	if (!g_pollable_input_stream_can_poll ((GPollableInputStream*) self)) {
		GError* _tmp0_;
		_tmp0_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED, "Stream is not pollable");
		_inner_error0_ = _tmp0_;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp1_ = self->priv->inner;
	_tmp2_ = g_pollable_input_stream_create_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_pollable_input_stream_get_type (), GPollableInputStream), cancellable);
	result = _tmp2_;
	return result;
}

static gboolean
dino_limit_input_stream_real_is_readable (GPollableInputStream* base)
{
	DinoLimitInputStream * self;
	gboolean _tmp2_ = FALSE;
	gint64 _tmp3_;
	gint64 _tmp4_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (DinoLimitInputStream*) base;
	if (!g_pollable_input_stream_can_poll ((GPollableInputStream*) self)) {
		GError* _tmp0_;
		gboolean _tmp1_ = FALSE;
		_tmp0_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED, "Stream is not pollable");
		_inner_error0_ = _tmp0_;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp1_;
	}
	_tmp3_ = dino_limit_input_stream_get_remaining_bytes (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == ((gint64) 0)) {
		_tmp2_ = TRUE;
	} else {
		GInputStream* _tmp5_;
		_tmp5_ = self->priv->inner;
		_tmp2_ = g_pollable_input_stream_is_readable (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_pollable_input_stream_get_type (), GPollableInputStream));
	}
	result = _tmp2_;
	return result;
}

static gssize
dino_limit_input_stream_check_limit (DinoLimitInputStream* self,
                                     gssize read,
                                     GError** error)
{
	gint64 _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp5_;
	GError* _inner_error0_ = NULL;
	gssize result;
	g_return_val_if_fail (self != NULL, 0L);
	_tmp0_ = dino_limit_input_stream_get_remaining_bytes (self);
	_tmp1_ = _tmp0_;
	if ((_tmp1_ - ((gint64) read)) < ((gint64) 0)) {
		GError* _tmp2_;
		_tmp2_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, "Stream length exceeded limit");
		_inner_error0_ = _tmp2_;
		if (_inner_error0_->domain == G_IO_ERROR) {
			gssize _tmp3_ = -1L;
			g_propagate_error (error, _inner_error0_);
			return _tmp3_;
		} else {
			gssize _tmp4_ = -1L;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
	}
	_tmp5_ = self->priv->_retrieved_bytes;
	dino_limit_input_stream_set_retrieved_bytes (self, _tmp5_ + read);
	result = read;
	return result;
}

static gssize
dino_limit_input_stream_real_read (GInputStream* base,
                                   guint8* buffer,
                                   gsize buffer_length1,
                                   GCancellable* cancellable,
                                   GError** error)
{
	DinoLimitInputStream * self;
	gint64 _tmp0_;
	gint64 _tmp1_;
	gint original_buffer_length = 0;
	gboolean _tmp2_ = FALSE;
	gint64 _tmp3_;
	gint64 _tmp4_;
	gssize read_bytes = 0L;
	GInputStream* _tmp9_;
	gint64 _tmp12_;
	GError* _inner_error0_ = NULL;
	gssize result;
	self = (DinoLimitInputStream*) base;
	_tmp0_ = dino_limit_input_stream_get_remaining_bytes (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == ((gint64) 0)) {
		result = (gssize) 0;
		return result;
	}
	original_buffer_length = buffer_length1;
	_tmp3_ = dino_limit_input_stream_get_remaining_bytes (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != ((gint64) -1)) {
		gint64 _tmp5_;
		gint64 _tmp6_;
		_tmp5_ = dino_limit_input_stream_get_remaining_bytes (self);
		_tmp6_ = _tmp5_;
		_tmp2_ = ((gint64) buffer_length1) > _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint64 _tmp7_;
		gint64 _tmp8_;
		_tmp7_ = dino_limit_input_stream_get_remaining_bytes (self);
		_tmp8_ = _tmp7_;
		buffer_length1 = (gint) _tmp8_;
	}
	_tmp9_ = self->priv->inner;
	read_bytes = g_input_stream_read (_tmp9_, buffer, (gsize) buffer_length1, cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			gssize _tmp10_ = -1L;
			g_propagate_error (error, _inner_error0_);
			return _tmp10_;
		} else {
			gssize _tmp11_ = -1L;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp11_;
		}
	}
	_tmp12_ = self->priv->_retrieved_bytes;
	dino_limit_input_stream_set_retrieved_bytes (self, _tmp12_ + read_bytes);
	buffer_length1 = original_buffer_length;
	result = read_bytes;
	return result;
}

static void
dino_limit_input_stream_real_read_async_data_free (gpointer _data)
{
	DinoLimitInputStreamReadAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (DinoLimitInputStreamReadAsyncData, _data_);
}

static void
dino_limit_input_stream_real_read_async (GInputStream* base,
                                         guint8* buffer,
                                         gsize buffer_length1,
                                         gint io_priority,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	DinoLimitInputStream * self;
	DinoLimitInputStreamReadAsyncData* _data_;
	DinoLimitInputStream* _tmp0_;
	GCancellable* _tmp1_;
	self = (DinoLimitInputStream*) base;
	_data_ = g_slice_new0 (DinoLimitInputStreamReadAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, dino_limit_input_stream_real_read_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->buffer = buffer;
	_data_->buffer_length1 = buffer_length1;
	_data_->io_priority = io_priority;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	dino_limit_input_stream_real_read_async_co (_data_);
}

static gssize
dino_limit_input_stream_read_finish (GInputStream* base,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	gssize result;
	DinoLimitInputStreamReadAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gssize _tmp0_ = 0L;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
dino_limit_input_stream_read_async_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	DinoLimitInputStreamReadAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	dino_limit_input_stream_real_read_async_co (_data_);
}

static gboolean
dino_limit_input_stream_real_read_async_co (DinoLimitInputStreamReadAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = dino_limit_input_stream_get_remaining_bytes (_data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_data_->_tmp1_ == ((gint64) 0)) {
		_data_->result = (gssize) 0;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->original_buffer_length = _data_->buffer_length1;
	_data_->_tmp3_ = dino_limit_input_stream_get_remaining_bytes (_data_->self);
	_data_->_tmp4_ = _data_->_tmp3_;
	if (_data_->_tmp4_ != ((gint64) -1)) {
		_data_->_tmp5_ = dino_limit_input_stream_get_remaining_bytes (_data_->self);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp2_ = ((gint64) _data_->buffer_length1) > _data_->_tmp6_;
	} else {
		_data_->_tmp2_ = FALSE;
	}
	if (_data_->_tmp2_) {
		_data_->_tmp7_ = dino_limit_input_stream_get_remaining_bytes (_data_->self);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->buffer_length1 = (gint) _data_->_tmp8_;
	}
	_data_->_tmp9_ = _data_->self->priv->inner;
	_data_->_state_ = 1;
	g_input_stream_read_async (_data_->_tmp9_, _data_->buffer, (gsize) _data_->buffer_length1, _data_->io_priority, _data_->cancellable, dino_limit_input_stream_read_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->read_bytes = g_input_stream_read_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == G_IO_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp10_ = _data_->self->priv->_retrieved_bytes;
	dino_limit_input_stream_set_retrieved_bytes (_data_->self, _data_->_tmp10_ + _data_->read_bytes);
	_data_->buffer_length1 = _data_->original_buffer_length;
	_data_->result = _data_->read_bytes;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gssize
dino_limit_input_stream_real_read_nonblocking_fn (GPollableInputStream* base,
                                                  guint8* buffer,
                                                  gsize buffer_length1,
                                                  GError** error)
{
	DinoLimitInputStream * self;
	gssize _tmp2_ = 0L;
	GError* _inner_error0_ = NULL;
	gssize result;
	self = (DinoLimitInputStream*) base;
	if (!g_pollable_input_stream_is_readable ((GPollableInputStream*) self)) {
		GError* _tmp0_;
		gssize _tmp1_ = -1L;
		_tmp0_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_WOULD_BLOCK, "Stream is not readable");
		_inner_error0_ = _tmp0_;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	_tmp2_ = g_input_stream_read ((GInputStream*) self, buffer, (gsize) buffer_length1, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gssize _tmp3_ = -1L;
		g_propagate_error (error, _inner_error0_);
		return _tmp3_;
	}
	result = _tmp2_;
	return result;
}

static gboolean
dino_limit_input_stream_real_close (GInputStream* base,
                                    GCancellable* cancellable,
                                    GError** error)
{
	DinoLimitInputStream * self;
	gboolean _tmp0_ = FALSE;
	GInputStream* _tmp1_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (DinoLimitInputStream*) base;
	_tmp1_ = self->priv->inner;
	_tmp0_ = g_input_stream_close (_tmp1_, cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			gboolean _tmp2_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp2_;
		} else {
			gboolean _tmp3_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
	}
	result = _tmp0_;
	return result;
}

static void
dino_limit_input_stream_real_close_async_data_free (gpointer _data)
{
	DinoLimitInputStreamCloseAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (DinoLimitInputStreamCloseAsyncData, _data_);
}

static void
dino_limit_input_stream_real_close_async (GInputStream* base,
                                          gint io_priority,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	DinoLimitInputStream * self;
	DinoLimitInputStreamCloseAsyncData* _data_;
	DinoLimitInputStream* _tmp0_;
	GCancellable* _tmp1_;
	self = (DinoLimitInputStream*) base;
	_data_ = g_slice_new0 (DinoLimitInputStreamCloseAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, dino_limit_input_stream_real_close_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->io_priority = io_priority;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	dino_limit_input_stream_real_close_async_co (_data_);
}

static gboolean
dino_limit_input_stream_close_finish (GInputStream* base,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	gboolean result;
	DinoLimitInputStreamCloseAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
dino_limit_input_stream_close_async_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	DinoLimitInputStreamCloseAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	dino_limit_input_stream_real_close_async_co (_data_);
}

static gboolean
dino_limit_input_stream_real_close_async_co (DinoLimitInputStreamCloseAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->self->priv->inner;
	_data_->_state_ = 1;
	g_input_stream_close_async (_data_->_tmp1_, _data_->io_priority, _data_->cancellable, dino_limit_input_stream_close_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = g_input_stream_close_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == G_IO_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->result = _data_->_tmp0_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gint64
dino_limit_input_stream_get_max_bytes (DinoLimitInputStream* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_max_bytes;
	return result;
}

static void
dino_limit_input_stream_set_max_bytes (DinoLimitInputStream* self,
                                       gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = dino_limit_input_stream_get_max_bytes (self);
	if (old_value != value) {
		self->priv->_max_bytes = value;
		g_object_notify_by_pspec ((GObject *) self, dino_limit_input_stream_properties[DINO_LIMIT_INPUT_STREAM_MAX_BYTES_PROPERTY]);
	}
}

gint64
dino_limit_input_stream_get_retrieved_bytes (DinoLimitInputStream* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_retrieved_bytes;
	return result;
}

static void
dino_limit_input_stream_set_retrieved_bytes (DinoLimitInputStream* self,
                                             gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = dino_limit_input_stream_get_retrieved_bytes (self);
	if (old_value != value) {
		self->priv->_retrieved_bytes = value;
		g_object_notify_by_pspec ((GObject *) self, dino_limit_input_stream_properties[DINO_LIMIT_INPUT_STREAM_RETRIEVED_BYTES_PROPERTY]);
	}
}

gint64
dino_limit_input_stream_get_remaining_bytes (DinoLimitInputStream* self)
{
	gint64 result;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp1_ = self->priv->_max_bytes;
	if (_tmp1_ < ((gint64) 0)) {
		_tmp0_ = (gint64) -1;
	} else {
		gint64 _tmp2_;
		gint64 _tmp3_;
		_tmp2_ = self->priv->_max_bytes;
		_tmp3_ = self->priv->_retrieved_bytes;
		_tmp0_ = _tmp2_ - _tmp3_;
	}
	result = _tmp0_;
	return result;
}

static void
dino_limit_input_stream_class_init (DinoLimitInputStreamClass * klass,
                                    gpointer klass_data)
{
	dino_limit_input_stream_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DinoLimitInputStream_private_offset);
	((GInputStreamClass *) klass)->read_fn = (gssize (*) (GInputStream*, guint8*, gsize, GCancellable*, GError**)) dino_limit_input_stream_real_read;
	((GInputStreamClass *) klass)->read_async = (void (*) (GInputStream*, guint8*, gsize, gint, GCancellable*, GAsyncReadyCallback, gpointer)) dino_limit_input_stream_real_read_async;
	((GInputStreamClass *) klass)->read_finish = (gssize (*) (GInputStream*, GAsyncResult*, GError**)) dino_limit_input_stream_read_finish;
	((GInputStreamClass *) klass)->close_fn = (gboolean (*) (GInputStream*, GCancellable*, GError**)) dino_limit_input_stream_real_close;
	((GInputStreamClass *) klass)->close_async = (void (*) (GInputStream*, gint, GCancellable*, GAsyncReadyCallback, gpointer)) dino_limit_input_stream_real_close_async;
	((GInputStreamClass *) klass)->close_finish = (gboolean (*) (GInputStream*, GAsyncResult*, GError**)) dino_limit_input_stream_close_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_dino_limit_input_stream_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dino_limit_input_stream_set_property;
	G_OBJECT_CLASS (klass)->finalize = dino_limit_input_stream_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DINO_LIMIT_INPUT_STREAM_MAX_BYTES_PROPERTY, dino_limit_input_stream_properties[DINO_LIMIT_INPUT_STREAM_MAX_BYTES_PROPERTY] = g_param_spec_int64 ("max-bytes", "max-bytes", "max-bytes", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DINO_LIMIT_INPUT_STREAM_RETRIEVED_BYTES_PROPERTY, dino_limit_input_stream_properties[DINO_LIMIT_INPUT_STREAM_RETRIEVED_BYTES_PROPERTY] = g_param_spec_int64 ("retrieved-bytes", "retrieved-bytes", "retrieved-bytes", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DINO_LIMIT_INPUT_STREAM_REMAINING_BYTES_PROPERTY, dino_limit_input_stream_properties[DINO_LIMIT_INPUT_STREAM_REMAINING_BYTES_PROPERTY] = g_param_spec_int64 ("remaining-bytes", "remaining-bytes", "remaining-bytes", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
dino_limit_input_stream_g_pollable_input_stream_interface_init (GPollableInputStreamInterface * iface,
                                                                gpointer iface_data)
{
	dino_limit_input_stream_g_pollable_input_stream_parent_iface = g_type_interface_peek_parent (iface);
	iface->can_poll = (gboolean (*) (GPollableInputStream*)) dino_limit_input_stream_real_can_poll;
	iface->create_source = (GSource* (*) (GPollableInputStream*, GCancellable*)) dino_limit_input_stream_real_create_source;
	iface->is_readable = (gboolean (*) (GPollableInputStream*)) dino_limit_input_stream_real_is_readable;
	iface->read_nonblocking = (gssize (*) (GPollableInputStream*, guint8*, gsize, GError**)) dino_limit_input_stream_real_read_nonblocking_fn;
}

static void
dino_limit_input_stream_instance_init (DinoLimitInputStream * self,
                                       gpointer klass)
{
	self->priv = dino_limit_input_stream_get_instance_private (self);
}

static void
dino_limit_input_stream_finalize (GObject * obj)
{
	DinoLimitInputStream * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DINO_TYPE_LIMIT_INPUT_STREAM, DinoLimitInputStream);
	_g_object_unref0 (self->priv->inner);
	G_OBJECT_CLASS (dino_limit_input_stream_parent_class)->finalize (obj);
}

static GType
dino_limit_input_stream_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DinoLimitInputStreamClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dino_limit_input_stream_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DinoLimitInputStream), 0, (GInstanceInitFunc) dino_limit_input_stream_instance_init, NULL };
	static const GInterfaceInfo g_pollable_input_stream_info = { (GInterfaceInitFunc) dino_limit_input_stream_g_pollable_input_stream_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType dino_limit_input_stream_type_id;
	dino_limit_input_stream_type_id = g_type_register_static (g_input_stream_get_type (), "DinoLimitInputStream", &g_define_type_info, 0);
	g_type_add_interface_static (dino_limit_input_stream_type_id, g_pollable_input_stream_get_type (), &g_pollable_input_stream_info);
	DinoLimitInputStream_private_offset = g_type_add_instance_private (dino_limit_input_stream_type_id, sizeof (DinoLimitInputStreamPrivate));
	return dino_limit_input_stream_type_id;
}

GType
dino_limit_input_stream_get_type (void)
{
	static volatile gsize dino_limit_input_stream_type_id__once = 0;
	if (g_once_init_enter (&dino_limit_input_stream_type_id__once)) {
		GType dino_limit_input_stream_type_id;
		dino_limit_input_stream_type_id = dino_limit_input_stream_get_type_once ();
		g_once_init_leave (&dino_limit_input_stream_type_id__once, dino_limit_input_stream_type_id);
	}
	return dino_limit_input_stream_type_id__once;
}

static void
_vala_dino_limit_input_stream_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	DinoLimitInputStream * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DINO_TYPE_LIMIT_INPUT_STREAM, DinoLimitInputStream);
	switch (property_id) {
		case DINO_LIMIT_INPUT_STREAM_MAX_BYTES_PROPERTY:
		g_value_set_int64 (value, dino_limit_input_stream_get_max_bytes (self));
		break;
		case DINO_LIMIT_INPUT_STREAM_RETRIEVED_BYTES_PROPERTY:
		g_value_set_int64 (value, dino_limit_input_stream_get_retrieved_bytes (self));
		break;
		case DINO_LIMIT_INPUT_STREAM_REMAINING_BYTES_PROPERTY:
		g_value_set_int64 (value, dino_limit_input_stream_get_remaining_bytes (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_dino_limit_input_stream_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	DinoLimitInputStream * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DINO_TYPE_LIMIT_INPUT_STREAM, DinoLimitInputStream);
	switch (property_id) {
		case DINO_LIMIT_INPUT_STREAM_MAX_BYTES_PROPERTY:
		dino_limit_input_stream_set_max_bytes (self, g_value_get_int64 (value));
		break;
		case DINO_LIMIT_INPUT_STREAM_RETRIEVED_BYTES_PROPERTY:
		dino_limit_input_stream_set_retrieved_bytes (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

