#ifndef itkExtractImageFilterSwigInterface_h
#define itkExtractImageFilterSwigInterface_h
#include "itkCommand.h"
#include "itkOffset.h"
#include "itkVector.h"
#include "itkCovariantVector.h"
#include "itkContinuousIndex.h"
#include "itkArray.h"
#include "itkFixedArray.h"
#include "itkRGBPixel.h"
#include "itkRGBAPixel.h"
#include "complex"
#include "itkSymmetricSecondRankTensor.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include "itkPoint.h"
#include "itkExtractImageFilter.h"

using itkExtractImageFilterEnums = itk::ExtractImageFilterEnums;
using itkExtractImageFilterIRGBUC2IRGBUC2 = itk::ExtractImageFilter< itk::Image< itk::RGBPixel< unsigned char >,2 >, itk::Image< itk::RGBPixel< unsigned char >,2 > >;
using itkExtractImageFilterIRGBUC2IRGBUC2_Pointer = itk::ExtractImageFilter< itk::Image< itk::RGBPixel< unsigned char >,2 >, itk::Image< itk::RGBPixel< unsigned char >,2 > >::Pointer;
using itkExtractImageFilterIRGBUC3IRGBUC3 = itk::ExtractImageFilter< itk::Image< itk::RGBPixel< unsigned char >,3 >, itk::Image< itk::RGBPixel< unsigned char >,3 > >;
using itkExtractImageFilterIRGBUC3IRGBUC3_Pointer = itk::ExtractImageFilter< itk::Image< itk::RGBPixel< unsigned char >,3 >, itk::Image< itk::RGBPixel< unsigned char >,3 > >::Pointer;
using itkExtractImageFilterIRGBUC4IRGBUC4 = itk::ExtractImageFilter< itk::Image< itk::RGBPixel< unsigned char >,4 >, itk::Image< itk::RGBPixel< unsigned char >,4 > >;
using itkExtractImageFilterIRGBUC4IRGBUC4_Pointer = itk::ExtractImageFilter< itk::Image< itk::RGBPixel< unsigned char >,4 >, itk::Image< itk::RGBPixel< unsigned char >,4 > >::Pointer;
using itkExtractImageFilterIRGBUS2IRGBUS2 = itk::ExtractImageFilter< itk::Image< itk::RGBPixel< unsigned short >,2 >, itk::Image< itk::RGBPixel< unsigned short >,2 > >;
using itkExtractImageFilterIRGBUS2IRGBUS2_Pointer = itk::ExtractImageFilter< itk::Image< itk::RGBPixel< unsigned short >,2 >, itk::Image< itk::RGBPixel< unsigned short >,2 > >::Pointer;
using itkExtractImageFilterIRGBUS3IRGBUS3 = itk::ExtractImageFilter< itk::Image< itk::RGBPixel< unsigned short >,3 >, itk::Image< itk::RGBPixel< unsigned short >,3 > >;
using itkExtractImageFilterIRGBUS3IRGBUS3_Pointer = itk::ExtractImageFilter< itk::Image< itk::RGBPixel< unsigned short >,3 >, itk::Image< itk::RGBPixel< unsigned short >,3 > >::Pointer;
using itkExtractImageFilterIRGBUS4IRGBUS4 = itk::ExtractImageFilter< itk::Image< itk::RGBPixel< unsigned short >,4 >, itk::Image< itk::RGBPixel< unsigned short >,4 > >;
using itkExtractImageFilterIRGBUS4IRGBUS4_Pointer = itk::ExtractImageFilter< itk::Image< itk::RGBPixel< unsigned short >,4 >, itk::Image< itk::RGBPixel< unsigned short >,4 > >::Pointer;
using itkExtractImageFilterIRGBAUC2IRGBAUC2 = itk::ExtractImageFilter< itk::Image< itk::RGBAPixel< unsigned char >,2 >, itk::Image< itk::RGBAPixel< unsigned char >,2 > >;
using itkExtractImageFilterIRGBAUC2IRGBAUC2_Pointer = itk::ExtractImageFilter< itk::Image< itk::RGBAPixel< unsigned char >,2 >, itk::Image< itk::RGBAPixel< unsigned char >,2 > >::Pointer;
using itkExtractImageFilterIRGBAUC3IRGBAUC3 = itk::ExtractImageFilter< itk::Image< itk::RGBAPixel< unsigned char >,3 >, itk::Image< itk::RGBAPixel< unsigned char >,3 > >;
using itkExtractImageFilterIRGBAUC3IRGBAUC3_Pointer = itk::ExtractImageFilter< itk::Image< itk::RGBAPixel< unsigned char >,3 >, itk::Image< itk::RGBAPixel< unsigned char >,3 > >::Pointer;
using itkExtractImageFilterIRGBAUC4IRGBAUC4 = itk::ExtractImageFilter< itk::Image< itk::RGBAPixel< unsigned char >,4 >, itk::Image< itk::RGBAPixel< unsigned char >,4 > >;
using itkExtractImageFilterIRGBAUC4IRGBAUC4_Pointer = itk::ExtractImageFilter< itk::Image< itk::RGBAPixel< unsigned char >,4 >, itk::Image< itk::RGBAPixel< unsigned char >,4 > >::Pointer;
using itkExtractImageFilterIRGBAUS2IRGBAUS2 = itk::ExtractImageFilter< itk::Image< itk::RGBAPixel< unsigned short >,2 >, itk::Image< itk::RGBAPixel< unsigned short >,2 > >;
using itkExtractImageFilterIRGBAUS2IRGBAUS2_Pointer = itk::ExtractImageFilter< itk::Image< itk::RGBAPixel< unsigned short >,2 >, itk::Image< itk::RGBAPixel< unsigned short >,2 > >::Pointer;
using itkExtractImageFilterIRGBAUS3IRGBAUS3 = itk::ExtractImageFilter< itk::Image< itk::RGBAPixel< unsigned short >,3 >, itk::Image< itk::RGBAPixel< unsigned short >,3 > >;
using itkExtractImageFilterIRGBAUS3IRGBAUS3_Pointer = itk::ExtractImageFilter< itk::Image< itk::RGBAPixel< unsigned short >,3 >, itk::Image< itk::RGBAPixel< unsigned short >,3 > >::Pointer;
using itkExtractImageFilterIRGBAUS4IRGBAUS4 = itk::ExtractImageFilter< itk::Image< itk::RGBAPixel< unsigned short >,4 >, itk::Image< itk::RGBAPixel< unsigned short >,4 > >;
using itkExtractImageFilterIRGBAUS4IRGBAUS4_Pointer = itk::ExtractImageFilter< itk::Image< itk::RGBAPixel< unsigned short >,4 >, itk::Image< itk::RGBAPixel< unsigned short >,4 > >::Pointer;
using itkExtractImageFilterIVD22IVD22 = itk::ExtractImageFilter< itk::Image< itk::Vector< double,2 >,2 >, itk::Image< itk::Vector< double,2 >,2 > >;
using itkExtractImageFilterIVD22IVD22_Pointer = itk::ExtractImageFilter< itk::Image< itk::Vector< double,2 >,2 >, itk::Image< itk::Vector< double,2 >,2 > >::Pointer;
using itkExtractImageFilterIVD23IVD23 = itk::ExtractImageFilter< itk::Image< itk::Vector< double,2 >,3 >, itk::Image< itk::Vector< double,2 >,3 > >;
using itkExtractImageFilterIVD23IVD23_Pointer = itk::ExtractImageFilter< itk::Image< itk::Vector< double,2 >,3 >, itk::Image< itk::Vector< double,2 >,3 > >::Pointer;
using itkExtractImageFilterIVD24IVD24 = itk::ExtractImageFilter< itk::Image< itk::Vector< double,2 >,4 >, itk::Image< itk::Vector< double,2 >,4 > >;
using itkExtractImageFilterIVD24IVD24_Pointer = itk::ExtractImageFilter< itk::Image< itk::Vector< double,2 >,4 >, itk::Image< itk::Vector< double,2 >,4 > >::Pointer;
using itkExtractImageFilterIVD32IVD32 = itk::ExtractImageFilter< itk::Image< itk::Vector< double,3 >,2 >, itk::Image< itk::Vector< double,3 >,2 > >;
using itkExtractImageFilterIVD32IVD32_Pointer = itk::ExtractImageFilter< itk::Image< itk::Vector< double,3 >,2 >, itk::Image< itk::Vector< double,3 >,2 > >::Pointer;
using itkExtractImageFilterIVD33IVD33 = itk::ExtractImageFilter< itk::Image< itk::Vector< double,3 >,3 >, itk::Image< itk::Vector< double,3 >,3 > >;
using itkExtractImageFilterIVD33IVD33_Pointer = itk::ExtractImageFilter< itk::Image< itk::Vector< double,3 >,3 >, itk::Image< itk::Vector< double,3 >,3 > >::Pointer;
using itkExtractImageFilterIVD34IVD34 = itk::ExtractImageFilter< itk::Image< itk::Vector< double,3 >,4 >, itk::Image< itk::Vector< double,3 >,4 > >;
using itkExtractImageFilterIVD34IVD34_Pointer = itk::ExtractImageFilter< itk::Image< itk::Vector< double,3 >,4 >, itk::Image< itk::Vector< double,3 >,4 > >::Pointer;
using itkExtractImageFilterIVD42IVD42 = itk::ExtractImageFilter< itk::Image< itk::Vector< double,4 >,2 >, itk::Image< itk::Vector< double,4 >,2 > >;
using itkExtractImageFilterIVD42IVD42_Pointer = itk::ExtractImageFilter< itk::Image< itk::Vector< double,4 >,2 >, itk::Image< itk::Vector< double,4 >,2 > >::Pointer;
using itkExtractImageFilterIVD43IVD43 = itk::ExtractImageFilter< itk::Image< itk::Vector< double,4 >,3 >, itk::Image< itk::Vector< double,4 >,3 > >;
using itkExtractImageFilterIVD43IVD43_Pointer = itk::ExtractImageFilter< itk::Image< itk::Vector< double,4 >,3 >, itk::Image< itk::Vector< double,4 >,3 > >::Pointer;
using itkExtractImageFilterIVD44IVD44 = itk::ExtractImageFilter< itk::Image< itk::Vector< double,4 >,4 >, itk::Image< itk::Vector< double,4 >,4 > >;
using itkExtractImageFilterIVD44IVD44_Pointer = itk::ExtractImageFilter< itk::Image< itk::Vector< double,4 >,4 >, itk::Image< itk::Vector< double,4 >,4 > >::Pointer;
using itkExtractImageFilterIVF22IVF22 = itk::ExtractImageFilter< itk::Image< itk::Vector< float,2 >,2 >, itk::Image< itk::Vector< float,2 >,2 > >;
using itkExtractImageFilterIVF22IVF22_Pointer = itk::ExtractImageFilter< itk::Image< itk::Vector< float,2 >,2 >, itk::Image< itk::Vector< float,2 >,2 > >::Pointer;
using itkExtractImageFilterIVF23IVF23 = itk::ExtractImageFilter< itk::Image< itk::Vector< float,2 >,3 >, itk::Image< itk::Vector< float,2 >,3 > >;
using itkExtractImageFilterIVF23IVF23_Pointer = itk::ExtractImageFilter< itk::Image< itk::Vector< float,2 >,3 >, itk::Image< itk::Vector< float,2 >,3 > >::Pointer;
using itkExtractImageFilterIVF24IVF24 = itk::ExtractImageFilter< itk::Image< itk::Vector< float,2 >,4 >, itk::Image< itk::Vector< float,2 >,4 > >;
using itkExtractImageFilterIVF24IVF24_Pointer = itk::ExtractImageFilter< itk::Image< itk::Vector< float,2 >,4 >, itk::Image< itk::Vector< float,2 >,4 > >::Pointer;
using itkExtractImageFilterIVF32IVF32 = itk::ExtractImageFilter< itk::Image< itk::Vector< float,3 >,2 >, itk::Image< itk::Vector< float,3 >,2 > >;
using itkExtractImageFilterIVF32IVF32_Pointer = itk::ExtractImageFilter< itk::Image< itk::Vector< float,3 >,2 >, itk::Image< itk::Vector< float,3 >,2 > >::Pointer;
using itkExtractImageFilterIVF33IVF33 = itk::ExtractImageFilter< itk::Image< itk::Vector< float,3 >,3 >, itk::Image< itk::Vector< float,3 >,3 > >;
using itkExtractImageFilterIVF33IVF33_Pointer = itk::ExtractImageFilter< itk::Image< itk::Vector< float,3 >,3 >, itk::Image< itk::Vector< float,3 >,3 > >::Pointer;
using itkExtractImageFilterIVF34IVF34 = itk::ExtractImageFilter< itk::Image< itk::Vector< float,3 >,4 >, itk::Image< itk::Vector< float,3 >,4 > >;
using itkExtractImageFilterIVF34IVF34_Pointer = itk::ExtractImageFilter< itk::Image< itk::Vector< float,3 >,4 >, itk::Image< itk::Vector< float,3 >,4 > >::Pointer;
using itkExtractImageFilterIVF42IVF42 = itk::ExtractImageFilter< itk::Image< itk::Vector< float,4 >,2 >, itk::Image< itk::Vector< float,4 >,2 > >;
using itkExtractImageFilterIVF42IVF42_Pointer = itk::ExtractImageFilter< itk::Image< itk::Vector< float,4 >,2 >, itk::Image< itk::Vector< float,4 >,2 > >::Pointer;
using itkExtractImageFilterIVF43IVF43 = itk::ExtractImageFilter< itk::Image< itk::Vector< float,4 >,3 >, itk::Image< itk::Vector< float,4 >,3 > >;
using itkExtractImageFilterIVF43IVF43_Pointer = itk::ExtractImageFilter< itk::Image< itk::Vector< float,4 >,3 >, itk::Image< itk::Vector< float,4 >,3 > >::Pointer;
using itkExtractImageFilterIVF44IVF44 = itk::ExtractImageFilter< itk::Image< itk::Vector< float,4 >,4 >, itk::Image< itk::Vector< float,4 >,4 > >;
using itkExtractImageFilterIVF44IVF44_Pointer = itk::ExtractImageFilter< itk::Image< itk::Vector< float,4 >,4 >, itk::Image< itk::Vector< float,4 >,4 > >::Pointer;
using itkExtractImageFilterICVD22ICVD22 = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< double,2 >,2 >, itk::Image< itk::CovariantVector< double,2 >,2 > >;
using itkExtractImageFilterICVD22ICVD22_Pointer = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< double,2 >,2 >, itk::Image< itk::CovariantVector< double,2 >,2 > >::Pointer;
using itkExtractImageFilterICVD23ICVD23 = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< double,2 >,3 >, itk::Image< itk::CovariantVector< double,2 >,3 > >;
using itkExtractImageFilterICVD23ICVD23_Pointer = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< double,2 >,3 >, itk::Image< itk::CovariantVector< double,2 >,3 > >::Pointer;
using itkExtractImageFilterICVD24ICVD24 = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< double,2 >,4 >, itk::Image< itk::CovariantVector< double,2 >,4 > >;
using itkExtractImageFilterICVD24ICVD24_Pointer = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< double,2 >,4 >, itk::Image< itk::CovariantVector< double,2 >,4 > >::Pointer;
using itkExtractImageFilterICVD32ICVD32 = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< double,3 >,2 >, itk::Image< itk::CovariantVector< double,3 >,2 > >;
using itkExtractImageFilterICVD32ICVD32_Pointer = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< double,3 >,2 >, itk::Image< itk::CovariantVector< double,3 >,2 > >::Pointer;
using itkExtractImageFilterICVD33ICVD33 = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< double,3 >,3 >, itk::Image< itk::CovariantVector< double,3 >,3 > >;
using itkExtractImageFilterICVD33ICVD33_Pointer = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< double,3 >,3 >, itk::Image< itk::CovariantVector< double,3 >,3 > >::Pointer;
using itkExtractImageFilterICVD34ICVD34 = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< double,3 >,4 >, itk::Image< itk::CovariantVector< double,3 >,4 > >;
using itkExtractImageFilterICVD34ICVD34_Pointer = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< double,3 >,4 >, itk::Image< itk::CovariantVector< double,3 >,4 > >::Pointer;
using itkExtractImageFilterICVD42ICVD42 = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< double,4 >,2 >, itk::Image< itk::CovariantVector< double,4 >,2 > >;
using itkExtractImageFilterICVD42ICVD42_Pointer = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< double,4 >,2 >, itk::Image< itk::CovariantVector< double,4 >,2 > >::Pointer;
using itkExtractImageFilterICVD43ICVD43 = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< double,4 >,3 >, itk::Image< itk::CovariantVector< double,4 >,3 > >;
using itkExtractImageFilterICVD43ICVD43_Pointer = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< double,4 >,3 >, itk::Image< itk::CovariantVector< double,4 >,3 > >::Pointer;
using itkExtractImageFilterICVD44ICVD44 = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< double,4 >,4 >, itk::Image< itk::CovariantVector< double,4 >,4 > >;
using itkExtractImageFilterICVD44ICVD44_Pointer = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< double,4 >,4 >, itk::Image< itk::CovariantVector< double,4 >,4 > >::Pointer;
using itkExtractImageFilterICVF22ICVF22 = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< float,2 >,2 >, itk::Image< itk::CovariantVector< float,2 >,2 > >;
using itkExtractImageFilterICVF22ICVF22_Pointer = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< float,2 >,2 >, itk::Image< itk::CovariantVector< float,2 >,2 > >::Pointer;
using itkExtractImageFilterICVF23ICVF23 = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< float,2 >,3 >, itk::Image< itk::CovariantVector< float,2 >,3 > >;
using itkExtractImageFilterICVF23ICVF23_Pointer = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< float,2 >,3 >, itk::Image< itk::CovariantVector< float,2 >,3 > >::Pointer;
using itkExtractImageFilterICVF24ICVF24 = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< float,2 >,4 >, itk::Image< itk::CovariantVector< float,2 >,4 > >;
using itkExtractImageFilterICVF24ICVF24_Pointer = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< float,2 >,4 >, itk::Image< itk::CovariantVector< float,2 >,4 > >::Pointer;
using itkExtractImageFilterICVF32ICVF32 = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< float,3 >,2 >, itk::Image< itk::CovariantVector< float,3 >,2 > >;
using itkExtractImageFilterICVF32ICVF32_Pointer = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< float,3 >,2 >, itk::Image< itk::CovariantVector< float,3 >,2 > >::Pointer;
using itkExtractImageFilterICVF33ICVF33 = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< float,3 >,3 >, itk::Image< itk::CovariantVector< float,3 >,3 > >;
using itkExtractImageFilterICVF33ICVF33_Pointer = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< float,3 >,3 >, itk::Image< itk::CovariantVector< float,3 >,3 > >::Pointer;
using itkExtractImageFilterICVF34ICVF34 = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< float,3 >,4 >, itk::Image< itk::CovariantVector< float,3 >,4 > >;
using itkExtractImageFilterICVF34ICVF34_Pointer = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< float,3 >,4 >, itk::Image< itk::CovariantVector< float,3 >,4 > >::Pointer;
using itkExtractImageFilterICVF42ICVF42 = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< float,4 >,2 >, itk::Image< itk::CovariantVector< float,4 >,2 > >;
using itkExtractImageFilterICVF42ICVF42_Pointer = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< float,4 >,2 >, itk::Image< itk::CovariantVector< float,4 >,2 > >::Pointer;
using itkExtractImageFilterICVF43ICVF43 = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< float,4 >,3 >, itk::Image< itk::CovariantVector< float,4 >,3 > >;
using itkExtractImageFilterICVF43ICVF43_Pointer = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< float,4 >,3 >, itk::Image< itk::CovariantVector< float,4 >,3 > >::Pointer;
using itkExtractImageFilterICVF44ICVF44 = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< float,4 >,4 >, itk::Image< itk::CovariantVector< float,4 >,4 > >;
using itkExtractImageFilterICVF44ICVF44_Pointer = itk::ExtractImageFilter< itk::Image< itk::CovariantVector< float,4 >,4 >, itk::Image< itk::CovariantVector< float,4 >,4 > >::Pointer;
using itkExtractImageFilterISC2ISC2 = itk::ExtractImageFilter< itk::Image< signed char,2 >, itk::Image< signed char,2 > >;
using itkExtractImageFilterISC2ISC2_Pointer = itk::ExtractImageFilter< itk::Image< signed char,2 >, itk::Image< signed char,2 > >::Pointer;
using itkExtractImageFilterISC3ISC3 = itk::ExtractImageFilter< itk::Image< signed char,3 >, itk::Image< signed char,3 > >;
using itkExtractImageFilterISC3ISC3_Pointer = itk::ExtractImageFilter< itk::Image< signed char,3 >, itk::Image< signed char,3 > >::Pointer;
using itkExtractImageFilterISC4ISC4 = itk::ExtractImageFilter< itk::Image< signed char,4 >, itk::Image< signed char,4 > >;
using itkExtractImageFilterISC4ISC4_Pointer = itk::ExtractImageFilter< itk::Image< signed char,4 >, itk::Image< signed char,4 > >::Pointer;
using itkExtractImageFilterISS2ISS2 = itk::ExtractImageFilter< itk::Image< signed short,2 >, itk::Image< signed short,2 > >;
using itkExtractImageFilterISS2ISS2_Pointer = itk::ExtractImageFilter< itk::Image< signed short,2 >, itk::Image< signed short,2 > >::Pointer;
using itkExtractImageFilterISS3ISS3 = itk::ExtractImageFilter< itk::Image< signed short,3 >, itk::Image< signed short,3 > >;
using itkExtractImageFilterISS3ISS3_Pointer = itk::ExtractImageFilter< itk::Image< signed short,3 >, itk::Image< signed short,3 > >::Pointer;
using itkExtractImageFilterISS4ISS4 = itk::ExtractImageFilter< itk::Image< signed short,4 >, itk::Image< signed short,4 > >;
using itkExtractImageFilterISS4ISS4_Pointer = itk::ExtractImageFilter< itk::Image< signed short,4 >, itk::Image< signed short,4 > >::Pointer;
using itkExtractImageFilterIUC2IUC2 = itk::ExtractImageFilter< itk::Image< unsigned char,2 >, itk::Image< unsigned char,2 > >;
using itkExtractImageFilterIUC2IUC2_Pointer = itk::ExtractImageFilter< itk::Image< unsigned char,2 >, itk::Image< unsigned char,2 > >::Pointer;
using itkExtractImageFilterIUC3IUC3 = itk::ExtractImageFilter< itk::Image< unsigned char,3 >, itk::Image< unsigned char,3 > >;
using itkExtractImageFilterIUC3IUC3_Pointer = itk::ExtractImageFilter< itk::Image< unsigned char,3 >, itk::Image< unsigned char,3 > >::Pointer;
using itkExtractImageFilterIUC4IUC4 = itk::ExtractImageFilter< itk::Image< unsigned char,4 >, itk::Image< unsigned char,4 > >;
using itkExtractImageFilterIUC4IUC4_Pointer = itk::ExtractImageFilter< itk::Image< unsigned char,4 >, itk::Image< unsigned char,4 > >::Pointer;
using itkExtractImageFilterIULL2IULL2 = itk::ExtractImageFilter< itk::Image< unsigned long long,2 >, itk::Image< unsigned long long,2 > >;
using itkExtractImageFilterIULL2IULL2_Pointer = itk::ExtractImageFilter< itk::Image< unsigned long long,2 >, itk::Image< unsigned long long,2 > >::Pointer;
using itkExtractImageFilterIULL3IULL3 = itk::ExtractImageFilter< itk::Image< unsigned long long,3 >, itk::Image< unsigned long long,3 > >;
using itkExtractImageFilterIULL3IULL3_Pointer = itk::ExtractImageFilter< itk::Image< unsigned long long,3 >, itk::Image< unsigned long long,3 > >::Pointer;
using itkExtractImageFilterIULL4IULL4 = itk::ExtractImageFilter< itk::Image< unsigned long long,4 >, itk::Image< unsigned long long,4 > >;
using itkExtractImageFilterIULL4IULL4_Pointer = itk::ExtractImageFilter< itk::Image< unsigned long long,4 >, itk::Image< unsigned long long,4 > >::Pointer;
using itkExtractImageFilterIUS2IUS2 = itk::ExtractImageFilter< itk::Image< unsigned short,2 >, itk::Image< unsigned short,2 > >;
using itkExtractImageFilterIUS2IUS2_Pointer = itk::ExtractImageFilter< itk::Image< unsigned short,2 >, itk::Image< unsigned short,2 > >::Pointer;
using itkExtractImageFilterIUS3IUS3 = itk::ExtractImageFilter< itk::Image< unsigned short,3 >, itk::Image< unsigned short,3 > >;
using itkExtractImageFilterIUS3IUS3_Pointer = itk::ExtractImageFilter< itk::Image< unsigned short,3 >, itk::Image< unsigned short,3 > >::Pointer;
using itkExtractImageFilterIUS4IUS4 = itk::ExtractImageFilter< itk::Image< unsigned short,4 >, itk::Image< unsigned short,4 > >;
using itkExtractImageFilterIUS4IUS4_Pointer = itk::ExtractImageFilter< itk::Image< unsigned short,4 >, itk::Image< unsigned short,4 > >::Pointer;
using itkExtractImageFilterIF2IF2 = itk::ExtractImageFilter< itk::Image< float,2 >, itk::Image< float,2 > >;
using itkExtractImageFilterIF2IF2_Pointer = itk::ExtractImageFilter< itk::Image< float,2 >, itk::Image< float,2 > >::Pointer;
using itkExtractImageFilterIF3IF3 = itk::ExtractImageFilter< itk::Image< float,3 >, itk::Image< float,3 > >;
using itkExtractImageFilterIF3IF3_Pointer = itk::ExtractImageFilter< itk::Image< float,3 >, itk::Image< float,3 > >::Pointer;
using itkExtractImageFilterIF4IF4 = itk::ExtractImageFilter< itk::Image< float,4 >, itk::Image< float,4 > >;
using itkExtractImageFilterIF4IF4_Pointer = itk::ExtractImageFilter< itk::Image< float,4 >, itk::Image< float,4 > >::Pointer;
using itkExtractImageFilterID2ID2 = itk::ExtractImageFilter< itk::Image< double,2 >, itk::Image< double,2 > >;
using itkExtractImageFilterID2ID2_Pointer = itk::ExtractImageFilter< itk::Image< double,2 >, itk::Image< double,2 > >::Pointer;
using itkExtractImageFilterID3ID3 = itk::ExtractImageFilter< itk::Image< double,3 >, itk::Image< double,3 > >;
using itkExtractImageFilterID3ID3_Pointer = itk::ExtractImageFilter< itk::Image< double,3 >, itk::Image< double,3 > >::Pointer;
using itkExtractImageFilterID4ID4 = itk::ExtractImageFilter< itk::Image< double,4 >, itk::Image< double,4 > >;
using itkExtractImageFilterID4ID4_Pointer = itk::ExtractImageFilter< itk::Image< double,4 >, itk::Image< double,4 > >::Pointer;
using itkExtractImageFilterICD2ICD2 = itk::ExtractImageFilter< itk::Image< std::complex< double >,2 >, itk::Image< std::complex< double >,2 > >;
using itkExtractImageFilterICD2ICD2_Pointer = itk::ExtractImageFilter< itk::Image< std::complex< double >,2 >, itk::Image< std::complex< double >,2 > >::Pointer;
using itkExtractImageFilterICD3ICD3 = itk::ExtractImageFilter< itk::Image< std::complex< double >,3 >, itk::Image< std::complex< double >,3 > >;
using itkExtractImageFilterICD3ICD3_Pointer = itk::ExtractImageFilter< itk::Image< std::complex< double >,3 >, itk::Image< std::complex< double >,3 > >::Pointer;
using itkExtractImageFilterICD4ICD4 = itk::ExtractImageFilter< itk::Image< std::complex< double >,4 >, itk::Image< std::complex< double >,4 > >;
using itkExtractImageFilterICD4ICD4_Pointer = itk::ExtractImageFilter< itk::Image< std::complex< double >,4 >, itk::Image< std::complex< double >,4 > >::Pointer;
using itkExtractImageFilterICF2ICF2 = itk::ExtractImageFilter< itk::Image< std::complex< float >,2 >, itk::Image< std::complex< float >,2 > >;
using itkExtractImageFilterICF2ICF2_Pointer = itk::ExtractImageFilter< itk::Image< std::complex< float >,2 >, itk::Image< std::complex< float >,2 > >::Pointer;
using itkExtractImageFilterICF3ICF3 = itk::ExtractImageFilter< itk::Image< std::complex< float >,3 >, itk::Image< std::complex< float >,3 > >;
using itkExtractImageFilterICF3ICF3_Pointer = itk::ExtractImageFilter< itk::Image< std::complex< float >,3 >, itk::Image< std::complex< float >,3 > >::Pointer;
using itkExtractImageFilterICF4ICF4 = itk::ExtractImageFilter< itk::Image< std::complex< float >,4 >, itk::Image< std::complex< float >,4 > >;
using itkExtractImageFilterICF4ICF4_Pointer = itk::ExtractImageFilter< itk::Image< std::complex< float >,4 >, itk::Image< std::complex< float >,4 > >::Pointer;
using itkExtractImageFilterIUL2IUL2 = itk::ExtractImageFilter< itk::Image< unsigned long,2 >, itk::Image< unsigned long,2 > >;
using itkExtractImageFilterIUL2IUL2_Pointer = itk::ExtractImageFilter< itk::Image< unsigned long,2 >, itk::Image< unsigned long,2 > >::Pointer;
using itkExtractImageFilterIUL3IUL3 = itk::ExtractImageFilter< itk::Image< unsigned long,3 >, itk::Image< unsigned long,3 > >;
using itkExtractImageFilterIUL3IUL3_Pointer = itk::ExtractImageFilter< itk::Image< unsigned long,3 >, itk::Image< unsigned long,3 > >::Pointer;
using itkExtractImageFilterIUL4IUL4 = itk::ExtractImageFilter< itk::Image< unsigned long,4 >, itk::Image< unsigned long,4 > >;
using itkExtractImageFilterIUL4IUL4_Pointer = itk::ExtractImageFilter< itk::Image< unsigned long,4 >, itk::Image< unsigned long,4 > >::Pointer;
using itkExtractImageFilterISC3ISC2 = itk::ExtractImageFilter< itk::Image< signed char,3 >,itk::Image< signed char,2 > >;
using itkExtractImageFilterISC3ISC2_Pointer = itk::ExtractImageFilter< itk::Image< signed char,3 >,itk::Image< signed char,2 > >::Pointer;
using itkExtractImageFilterISS3ISS2 = itk::ExtractImageFilter< itk::Image< signed short,3 >,itk::Image< signed short,2 > >;
using itkExtractImageFilterISS3ISS2_Pointer = itk::ExtractImageFilter< itk::Image< signed short,3 >,itk::Image< signed short,2 > >::Pointer;
using itkExtractImageFilterIUC3IUC2 = itk::ExtractImageFilter< itk::Image< unsigned char,3 >,itk::Image< unsigned char,2 > >;
using itkExtractImageFilterIUC3IUC2_Pointer = itk::ExtractImageFilter< itk::Image< unsigned char,3 >,itk::Image< unsigned char,2 > >::Pointer;
using itkExtractImageFilterIULL3IULL2 = itk::ExtractImageFilter< itk::Image< unsigned long long,3 >,itk::Image< unsigned long long,2 > >;
using itkExtractImageFilterIULL3IULL2_Pointer = itk::ExtractImageFilter< itk::Image< unsigned long long,3 >,itk::Image< unsigned long long,2 > >::Pointer;
using itkExtractImageFilterIUS3IUS2 = itk::ExtractImageFilter< itk::Image< unsigned short,3 >,itk::Image< unsigned short,2 > >;
using itkExtractImageFilterIUS3IUS2_Pointer = itk::ExtractImageFilter< itk::Image< unsigned short,3 >,itk::Image< unsigned short,2 > >::Pointer;
using itkExtractImageFilterIF3IF2 = itk::ExtractImageFilter< itk::Image< float,3 >,itk::Image< float,2 > >;
using itkExtractImageFilterIF3IF2_Pointer = itk::ExtractImageFilter< itk::Image< float,3 >,itk::Image< float,2 > >::Pointer;
using itkExtractImageFilterID3ID2 = itk::ExtractImageFilter< itk::Image< double,3 >,itk::Image< double,2 > >;
using itkExtractImageFilterID3ID2_Pointer = itk::ExtractImageFilter< itk::Image< double,3 >,itk::Image< double,2 > >::Pointer;
using itkExtractImageFilterIRGBUC3IRGBUC2 = itk::ExtractImageFilter< itk::Image< itk::RGBPixel< unsigned char >,3 >,itk::Image< itk::RGBPixel< unsigned char >,2 > >;
using itkExtractImageFilterIRGBUC3IRGBUC2_Pointer = itk::ExtractImageFilter< itk::Image< itk::RGBPixel< unsigned char >,3 >,itk::Image< itk::RGBPixel< unsigned char >,2 > >::Pointer;
using itkExtractImageFilterIRGBUS3IRGBUS2 = itk::ExtractImageFilter< itk::Image< itk::RGBPixel< unsigned short >,3 >,itk::Image< itk::RGBPixel< unsigned short >,2 > >;
using itkExtractImageFilterIRGBUS3IRGBUS2_Pointer = itk::ExtractImageFilter< itk::Image< itk::RGBPixel< unsigned short >,3 >,itk::Image< itk::RGBPixel< unsigned short >,2 > >::Pointer;
using itkExtractImageFilterICD3ICD2 = itk::ExtractImageFilter< itk::Image< std::complex< double >,3 >,itk::Image< std::complex< double >,2 > >;
using itkExtractImageFilterICD3ICD2_Pointer = itk::ExtractImageFilter< itk::Image< std::complex< double >,3 >,itk::Image< std::complex< double >,2 > >::Pointer;
using itkExtractImageFilterICF3ICF2 = itk::ExtractImageFilter< itk::Image< std::complex< float >,3 >,itk::Image< std::complex< float >,2 > >;
using itkExtractImageFilterICF3ICF2_Pointer = itk::ExtractImageFilter< itk::Image< std::complex< float >,3 >,itk::Image< std::complex< float >,2 > >::Pointer;
using itkExtractImageFilterISC4ISC2 = itk::ExtractImageFilter< itk::Image< signed char,4 >,itk::Image< signed char,2 > >;
using itkExtractImageFilterISC4ISC2_Pointer = itk::ExtractImageFilter< itk::Image< signed char,4 >,itk::Image< signed char,2 > >::Pointer;
using itkExtractImageFilterISS4ISS2 = itk::ExtractImageFilter< itk::Image< signed short,4 >,itk::Image< signed short,2 > >;
using itkExtractImageFilterISS4ISS2_Pointer = itk::ExtractImageFilter< itk::Image< signed short,4 >,itk::Image< signed short,2 > >::Pointer;
using itkExtractImageFilterIUC4IUC2 = itk::ExtractImageFilter< itk::Image< unsigned char,4 >,itk::Image< unsigned char,2 > >;
using itkExtractImageFilterIUC4IUC2_Pointer = itk::ExtractImageFilter< itk::Image< unsigned char,4 >,itk::Image< unsigned char,2 > >::Pointer;
using itkExtractImageFilterIULL4IULL2 = itk::ExtractImageFilter< itk::Image< unsigned long long,4 >,itk::Image< unsigned long long,2 > >;
using itkExtractImageFilterIULL4IULL2_Pointer = itk::ExtractImageFilter< itk::Image< unsigned long long,4 >,itk::Image< unsigned long long,2 > >::Pointer;
using itkExtractImageFilterIUS4IUS2 = itk::ExtractImageFilter< itk::Image< unsigned short,4 >,itk::Image< unsigned short,2 > >;
using itkExtractImageFilterIUS4IUS2_Pointer = itk::ExtractImageFilter< itk::Image< unsigned short,4 >,itk::Image< unsigned short,2 > >::Pointer;
using itkExtractImageFilterIF4IF2 = itk::ExtractImageFilter< itk::Image< float,4 >,itk::Image< float,2 > >;
using itkExtractImageFilterIF4IF2_Pointer = itk::ExtractImageFilter< itk::Image< float,4 >,itk::Image< float,2 > >::Pointer;
using itkExtractImageFilterID4ID2 = itk::ExtractImageFilter< itk::Image< double,4 >,itk::Image< double,2 > >;
using itkExtractImageFilterID4ID2_Pointer = itk::ExtractImageFilter< itk::Image< double,4 >,itk::Image< double,2 > >::Pointer;
using itkExtractImageFilterIRGBUC4IRGBUC2 = itk::ExtractImageFilter< itk::Image< itk::RGBPixel< unsigned char >,4 >,itk::Image< itk::RGBPixel< unsigned char >,2 > >;
using itkExtractImageFilterIRGBUC4IRGBUC2_Pointer = itk::ExtractImageFilter< itk::Image< itk::RGBPixel< unsigned char >,4 >,itk::Image< itk::RGBPixel< unsigned char >,2 > >::Pointer;
using itkExtractImageFilterIRGBUS4IRGBUS2 = itk::ExtractImageFilter< itk::Image< itk::RGBPixel< unsigned short >,4 >,itk::Image< itk::RGBPixel< unsigned short >,2 > >;
using itkExtractImageFilterIRGBUS4IRGBUS2_Pointer = itk::ExtractImageFilter< itk::Image< itk::RGBPixel< unsigned short >,4 >,itk::Image< itk::RGBPixel< unsigned short >,2 > >::Pointer;
using itkExtractImageFilterICD4ICD2 = itk::ExtractImageFilter< itk::Image< std::complex< double >,4 >,itk::Image< std::complex< double >,2 > >;
using itkExtractImageFilterICD4ICD2_Pointer = itk::ExtractImageFilter< itk::Image< std::complex< double >,4 >,itk::Image< std::complex< double >,2 > >::Pointer;
using itkExtractImageFilterICF4ICF2 = itk::ExtractImageFilter< itk::Image< std::complex< float >,4 >,itk::Image< std::complex< float >,2 > >;
using itkExtractImageFilterICF4ICF2_Pointer = itk::ExtractImageFilter< itk::Image< std::complex< float >,4 >,itk::Image< std::complex< float >,2 > >::Pointer;
using itkExtractImageFilterISC4ISC3 = itk::ExtractImageFilter< itk::Image< signed char,4 >,itk::Image< signed char,3 > >;
using itkExtractImageFilterISC4ISC3_Pointer = itk::ExtractImageFilter< itk::Image< signed char,4 >,itk::Image< signed char,3 > >::Pointer;
using itkExtractImageFilterISS4ISS3 = itk::ExtractImageFilter< itk::Image< signed short,4 >,itk::Image< signed short,3 > >;
using itkExtractImageFilterISS4ISS3_Pointer = itk::ExtractImageFilter< itk::Image< signed short,4 >,itk::Image< signed short,3 > >::Pointer;
using itkExtractImageFilterIUC4IUC3 = itk::ExtractImageFilter< itk::Image< unsigned char,4 >,itk::Image< unsigned char,3 > >;
using itkExtractImageFilterIUC4IUC3_Pointer = itk::ExtractImageFilter< itk::Image< unsigned char,4 >,itk::Image< unsigned char,3 > >::Pointer;
using itkExtractImageFilterIULL4IULL3 = itk::ExtractImageFilter< itk::Image< unsigned long long,4 >,itk::Image< unsigned long long,3 > >;
using itkExtractImageFilterIULL4IULL3_Pointer = itk::ExtractImageFilter< itk::Image< unsigned long long,4 >,itk::Image< unsigned long long,3 > >::Pointer;
using itkExtractImageFilterIUS4IUS3 = itk::ExtractImageFilter< itk::Image< unsigned short,4 >,itk::Image< unsigned short,3 > >;
using itkExtractImageFilterIUS4IUS3_Pointer = itk::ExtractImageFilter< itk::Image< unsigned short,4 >,itk::Image< unsigned short,3 > >::Pointer;
using itkExtractImageFilterIF4IF3 = itk::ExtractImageFilter< itk::Image< float,4 >,itk::Image< float,3 > >;
using itkExtractImageFilterIF4IF3_Pointer = itk::ExtractImageFilter< itk::Image< float,4 >,itk::Image< float,3 > >::Pointer;
using itkExtractImageFilterID4ID3 = itk::ExtractImageFilter< itk::Image< double,4 >,itk::Image< double,3 > >;
using itkExtractImageFilterID4ID3_Pointer = itk::ExtractImageFilter< itk::Image< double,4 >,itk::Image< double,3 > >::Pointer;
using itkExtractImageFilterIRGBUC4IRGBUC3 = itk::ExtractImageFilter< itk::Image< itk::RGBPixel< unsigned char >,4 >,itk::Image< itk::RGBPixel< unsigned char >,3 > >;
using itkExtractImageFilterIRGBUC4IRGBUC3_Pointer = itk::ExtractImageFilter< itk::Image< itk::RGBPixel< unsigned char >,4 >,itk::Image< itk::RGBPixel< unsigned char >,3 > >::Pointer;
using itkExtractImageFilterIRGBUS4IRGBUS3 = itk::ExtractImageFilter< itk::Image< itk::RGBPixel< unsigned short >,4 >,itk::Image< itk::RGBPixel< unsigned short >,3 > >;
using itkExtractImageFilterIRGBUS4IRGBUS3_Pointer = itk::ExtractImageFilter< itk::Image< itk::RGBPixel< unsigned short >,4 >,itk::Image< itk::RGBPixel< unsigned short >,3 > >::Pointer;
using itkExtractImageFilterICD4ICD3 = itk::ExtractImageFilter< itk::Image< std::complex< double >,4 >,itk::Image< std::complex< double >,3 > >;
using itkExtractImageFilterICD4ICD3_Pointer = itk::ExtractImageFilter< itk::Image< std::complex< double >,4 >,itk::Image< std::complex< double >,3 > >::Pointer;
using itkExtractImageFilterICF4ICF3 = itk::ExtractImageFilter< itk::Image< std::complex< float >,4 >,itk::Image< std::complex< float >,3 > >;
using itkExtractImageFilterICF4ICF3_Pointer = itk::ExtractImageFilter< itk::Image< std::complex< float >,4 >,itk::Image< std::complex< float >,3 > >::Pointer;


#include "itkInPlaceImageFilterASwigInterface.h"
#include "ITKCommonBaseSwigInterface.h"
#include "itkInPlaceImageFilterBSwigInterface.h"
#include "itkImageRegionSwigInterface.h"
#include "itkExtractImageFilterSwigInterface.h"
#endif
