#ifndef SBK_KTOOLBARWRAPPER_H
#define SBK_KTOOLBARWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <ktoolbar.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KToolBarWrapper : public KToolBar
{
public:
    KToolBarWrapper(::QWidget * parent, bool isMainToolBar = false, bool readConfig = true);
    KToolBarWrapper(const ::QString & objectName, ::QMainWindow * parentWindow, ::Qt::ToolBarArea area, bool newLine = false, bool isMainToolBar = false, bool readConfig = true);
    KToolBarWrapper(const ::QString & objectName, ::QWidget * parent, bool readConfig = true);
    KToolBarWrapper(const KToolBarWrapper &) = delete;
    KToolBarWrapper& operator=(const KToolBarWrapper &) = delete;
    KToolBarWrapper(KToolBarWrapper &&) = delete;
    KToolBarWrapper& operator=(KToolBarWrapper &&) = delete;
    ~KToolBarWrapper() override;

    void actionEvent(::QActionEvent * arg__1) override;
    static void sbk_o_actionEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QActionEvent * arg__1);
    void changeEvent(::QEvent * event) override;
    static void sbk_o_changeEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event);
    void childEvent(::QChildEvent * event) override;
    void closeEvent(::QCloseEvent * event) override;
    static void sbk_o_closeEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QCloseEvent * event);
    void connectNotify(const ::QMetaMethod & signal) override;
    void contextMenuEvent(::QContextMenuEvent * arg__1) override;
    static void sbk_o_contextMenuEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QContextMenuEvent * arg__1);
    void customEvent(::QEvent * event) override;
    int devType() const override;
    static int sbk_o_devType(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    void disconnectNotify(const ::QMetaMethod & signal) override;
    void dragEnterEvent(::QDragEnterEvent * arg__1) override;
    static void sbk_o_dragEnterEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QDragEnterEvent * arg__1);
    void dragLeaveEvent(::QDragLeaveEvent * arg__1) override;
    static void sbk_o_dragLeaveEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QDragLeaveEvent * arg__1);
    void dragMoveEvent(::QDragMoveEvent * arg__1) override;
    static void sbk_o_dragMoveEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QDragMoveEvent * arg__1);
    void dropEvent(::QDropEvent * arg__1) override;
    static void sbk_o_dropEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QDropEvent * arg__1);
    void enterEvent(::QEnterEvent * event) override;
    static void sbk_o_enterEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEnterEvent * event);
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void focusInEvent(::QFocusEvent * event) override;
    static void sbk_o_focusInEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QFocusEvent * event);
    bool focusNextPrevChild(bool next) override;
    static bool sbk_o_focusNextPrevChild(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, bool next);
    void focusOutEvent(::QFocusEvent * event) override;
    static void sbk_o_focusOutEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QFocusEvent * event);
    bool hasHeightForWidth() const override;
    static bool sbk_o_hasHeightForWidth(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    int heightForWidth(int arg__1) const override;
    static int sbk_o_heightForWidth(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, int arg__1);
    void hideEvent(::QHideEvent * event) override;
    static void sbk_o_hideEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QHideEvent * event);
    void initPainter(::QPainter * painter) const override;
    static void sbk_o_initPainter(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QPainter * painter);
    void initStyleOption(::QStyleOptionToolBar * option) const override;
    static void sbk_o_initStyleOption(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QStyleOptionToolBar * option);
    void inputMethodEvent(::QInputMethodEvent * event) override;
    static void sbk_o_inputMethodEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QInputMethodEvent * event);
    ::QVariant inputMethodQuery(::Qt::InputMethodQuery arg__1) const override;
    static ::QVariant sbk_o_inputMethodQuery(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::Qt::InputMethodQuery arg__1);
    void keyPressEvent(::QKeyEvent * event) override;
    static void sbk_o_keyPressEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QKeyEvent * event);
    void keyReleaseEvent(::QKeyEvent * event) override;
    static void sbk_o_keyReleaseEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QKeyEvent * event);
    void leaveEvent(::QEvent * event) override;
    static void sbk_o_leaveEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event);
    int metric(::QPaintDevice::PaintDeviceMetric arg__1) const override;
    static int sbk_o_metric(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QPaintDevice::PaintDeviceMetric arg__1);
    ::QSize minimumSizeHint() const override;
    static ::QSize sbk_o_minimumSizeHint(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    void mouseDoubleClickEvent(::QMouseEvent * event) override;
    static void sbk_o_mouseDoubleClickEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QMouseEvent * event);
    void mouseMoveEvent(::QMouseEvent * arg__1) override;
    static void sbk_o_mouseMoveEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QMouseEvent * arg__1);
    void mousePressEvent(::QMouseEvent * arg__1) override;
    static void sbk_o_mousePressEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QMouseEvent * arg__1);
    void mouseReleaseEvent(::QMouseEvent * arg__1) override;
    static void sbk_o_mouseReleaseEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QMouseEvent * arg__1);
    void moveEvent(::QMoveEvent * event) override;
    static void sbk_o_moveEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QMoveEvent * event);
    bool nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result) override;
    static bool sbk_o_nativeEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QByteArray & eventType, void * message, ::qintptr * result);
    ::QPaintEngine * paintEngine() const override;
    static ::QPaintEngine * sbk_o_paintEngine(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    void paintEvent(::QPaintEvent * event) override;
    static void sbk_o_paintEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QPaintEvent * event);
    ::QPaintDevice * redirected(::QPoint * offset) const override;
    static ::QPaintDevice * sbk_o_redirected(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QPoint * offset);
    void resizeEvent(::QResizeEvent * event) override;
    static void sbk_o_resizeEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QResizeEvent * event);
    void setVisible(bool visible) override;
    static void sbk_o_setVisible(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, bool visible);
    ::QPainter * sharedPainter() const override;
    static ::QPainter * sbk_o_sharedPainter(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    void showEvent(::QShowEvent * event) override;
    static void sbk_o_showEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QShowEvent * event);
    ::QSize sizeHint() const override;
    void slotMovableChanged(bool movable) override;
    void tabletEvent(::QTabletEvent * event) override;
    static void sbk_o_tabletEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QTabletEvent * event);
    void timerEvent(::QTimerEvent * event) override;
    void wheelEvent(::QWheelEvent * event) override;
    static void sbk_o_wheelEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QWheelEvent * event);

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 49> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KTOOLBARWRAPPER_H
