// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                             avtUNICFileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_UNIC_FILE_FORMAT_H
#define AVT_UNIC_FILE_FORMAT_H

#include <avtSTMDFileFormat.h>

// Define this symbol BEFORE including hdf5.h to indicate the HDF5 code
// in this file uses version 1.6 of the HDF5 API. This is harmless for
// versions of HDF5 before 1.8 and ensures correct compilation with
// version 1.8 and thereafter. When, and if, the HDF5 code in this file
// is explicitly upgraded to the 1.8 API, this symbol should be removed.
#define H5_USE_16_API
#include <vtk_hdf5.h>

#include <vector>


// ****************************************************************************
//  Class: avtUNICFileFormat
//
//  Purpose:
//      Reads in UNIC files as a plugin to VisIt.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Wed Jul 9 07:28:15 PDT 2008
//
//  Modifications:
//
//    Hank Childs, Thu Jul 24 17:12:17 PDT 2008
//    Add support for 2D.
//
//    Hank Childs, Thu Mar 21 11:51:20 PDT 2013
//    Fix bug with the reader starting processing without being initialized.
//
// ****************************************************************************

class avtUNICFileFormat : public avtSTMDFileFormat
{
  public:
                       avtUNICFileFormat(const char *);
    virtual           ~avtUNICFileFormat() {;};

    //
    // This is used to return unconvention data -- ranging from material
    // information to information about block connectivity.
    //
    // virtual void      *GetAuxiliaryData(const char *var, int domain,
    //                                     const char *type, void *args, 
    //                                     DestructorFunction &);
    //

    //
    // If you know the cycle number, overload this function.
    // Otherwise, VisIt will make up a reasonable one for you.
    //
    // virtual int         GetCycle(void);
    //

    virtual const char    *GetType(void)   { return "UNIC"; };
    virtual void           FreeUpResources(void); 

    virtual vtkDataSet    *GetMesh(int, const char *);
    virtual vtkDataArray  *GetVar(int, const char *);
    virtual vtkDataArray  *GetVectorVar(int, const char *);

  protected:
    std::vector<std::string>   cellvarnames;
    std::vector<std::string>   ptvarnames;
    hid_t                      file_handle;
    int                        spatialDim;
    bool                       haveInitialized;

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *);
    void                   Initialize(void);
};


#endif


