// ClientServer wrapper for vtkDataSetToDataObjectFilter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkDataSetToDataObjectFilter.h"
#include "vtkSystemIncludes.h"
#include "vtkClientServerInterpreter.h"
#include "vtkClientServerStream.h"


static vtkObjectBase *vtkDataSetToDataObjectFilterClientServerNewCommand(void* /*ctx*/)
{
  return vtkDataSetToDataObjectFilter::New();
}


static int vtkDataSetToDataObjectFilterCommand(
  vtkClientServerInterpreter *arlu, vtkObjectBase *ob,
  const char *method, const vtkClientServerStream& msg,
  vtkClientServerStream& resultStream, void* /*ctx*/)
{
  vtkDataSetToDataObjectFilter *op = vtkDataSetToDataObjectFilter::SafeDownCast(ob);
  if(!op)
    {
    vtkOStrStreamWrapper vtkmsg;
    vtkmsg << "Cannot cast " << ob->GetClassName() << " object to vtkDataSetToDataObjectFilter.  "
           << "This probably means the class specifies the incorrect superclass in vtkTypeMacro.";
    resultStream.Reset();
    resultStream << vtkClientServerStream::Error
                 << vtkmsg.str() << 0 << vtkClientServerStream::End;
    return 0;
    }
  (void)arlu;
  if (!strcmp("IsTypeOf",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkDataSetToDataObjectFilter::IsTypeOf(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("IsA",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->IsA(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SafeDownCast",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkObjectBase  *temp0;
    vtkDataSetToDataObjectFilter  *temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkObjectBase"))
      {
      temp20 = vtkDataSetToDataObjectFilter::SafeDownCast(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("NewInstance",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkDataSetToDataObjectFilter  *temp20;
      {
      temp20 = (op)->NewInstance();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBaseType",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkDataSetToDataObjectFilter::GetNumberOfGenerationsFromBaseType(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBase",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->GetNumberOfGenerationsFromBase(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("New",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkDataSetToDataObjectFilter  *temp20;
      {
      temp20 = vtkDataSetToDataObjectFilter::New();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetGeometry",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetGeometry(temp0);
      return 1;
      }
    }
  if (!strcmp("GetGeometry",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetGeometry();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GeometryOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->GeometryOn();
      return 1;
      }
    }
  if (!strcmp("GeometryOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->GeometryOff();
      return 1;
      }
    }
  if (!strcmp("SetTopology",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetTopology(temp0);
      return 1;
      }
    }
  if (!strcmp("GetTopology",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetTopology();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TopologyOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->TopologyOn();
      return 1;
      }
    }
  if (!strcmp("TopologyOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->TopologyOff();
      return 1;
      }
    }
  if (!strcmp("SetLegacyTopology",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetLegacyTopology(temp0);
      return 1;
      }
    }
  if (!strcmp("GetLegacyTopology",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetLegacyTopology();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("LegacyTopologyOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->LegacyTopologyOn();
      return 1;
      }
    }
  if (!strcmp("LegacyTopologyOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->LegacyTopologyOff();
      return 1;
      }
    }
  if (!strcmp("SetModernTopology",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetModernTopology(temp0);
      return 1;
      }
    }
  if (!strcmp("GetModernTopology",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetModernTopology();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ModernTopologyOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ModernTopologyOn();
      return 1;
      }
    }
  if (!strcmp("ModernTopologyOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ModernTopologyOff();
      return 1;
      }
    }
  if (!strcmp("SetFieldData",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetFieldData(temp0);
      return 1;
      }
    }
  if (!strcmp("GetFieldData",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetFieldData();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("FieldDataOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->FieldDataOn();
      return 1;
      }
    }
  if (!strcmp("FieldDataOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->FieldDataOff();
      return 1;
      }
    }
  if (!strcmp("SetPointData",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetPointData(temp0);
      return 1;
      }
    }
  if (!strcmp("GetPointData",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetPointData();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("PointDataOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->PointDataOn();
      return 1;
      }
    }
  if (!strcmp("PointDataOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->PointDataOff();
      return 1;
      }
    }
  if (!strcmp("SetCellData",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetCellData(temp0);
      return 1;
      }
    }
  if (!strcmp("GetCellData",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetCellData();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("CellDataOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->CellDataOn();
      return 1;
      }
    }
  if (!strcmp("CellDataOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->CellDataOff();
      return 1;
      }
    }

  {
    const char* commandName = "vtkDataObjectAlgorithm";
    if (arlu->HasCommandFunction(commandName) &&
        arlu->CallCommandFunction(commandName, op, method, msg, resultStream)) { return 1; }
  }
  if(resultStream.GetNumberOfMessages() > 0 &&
     resultStream.GetCommand(0) == vtkClientServerStream::Error &&
     resultStream.GetNumberOfArguments(0) > 1)
    {
    /* A superclass wrapper prepared a special message. */
    return 0;
    }
  vtkOStrStreamWrapper vtkmsg;
  vtkmsg << "Object type: vtkDataSetToDataObjectFilter, could not find requested method: \""
         << method << "\"\nor the method was called with incorrect arguments.\n";
  resultStream.Reset();
  resultStream << vtkClientServerStream::Error
               << vtkmsg.str() << vtkClientServerStream::End;
  vtkmsg.rdbuf()->freeze(0);
  return 0;
}


//-------------------------------------------------------------------------auto
extern "C"
{
VTK_ABI_HIDDEN void vtkDataSetToDataObjectFilter_Init(vtkClientServerInterpreter* csi)
{
  static vtkClientServerInterpreter* last = nullptr;
  if(last != csi)
    {
    last = csi;
    csi->AddNewInstanceFunction("vtkDataSetToDataObjectFilter", vtkDataSetToDataObjectFilterClientServerNewCommand);
    csi->AddCommandFunction("vtkDataSetToDataObjectFilter", vtkDataSetToDataObjectFilterCommand);
    }
}
}
