/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkLabelOverlapMeasuresImageFilter.h"
#include "itkLabelOverlapMeasuresImageFilter.h"



namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
LabelOverlapMeasuresImageFilter::LabelOverlapMeasuresImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
LabelOverlapMeasuresImageFilter::~LabelOverlapMeasuresImageFilter(){
  if (this->m_Filter != nullptr)
    {
      m_Filter->UnRegister();
    }
}




//
// ToString
//
std::string LabelOverlapMeasuresImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::LabelOverlapMeasuresImageFilter\n";
  out << "  FalseNegativeError: " << this->m_FalseNegativeError << std::endl;
  out << "  FalsePositiveError: " << this->m_FalsePositiveError << std::endl;
  out << "  MeanOverlap: " << this->m_MeanOverlap << std::endl;
  out << "  UnionOverlap: " << this->m_UnionOverlap << std::endl;
  out << "  VolumeSimilarity: " << this->m_VolumeSimilarity << std::endl;
  out << "  JaccardCoefficient: " << this->m_JaccardCoefficient << std::endl;
  out << "  DiceCoefficient: " << this->m_DiceCoefficient << std::endl;
  out << "  FalseDiscoveryRate: " << this->m_FalseDiscoveryRate << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
void LabelOverlapMeasuresImageFilter::Execute ( const Image & sourceImage, const Image & targetImage )
{
  const PixelIDValueEnum type = sourceImage.GetPixelID();
  const unsigned int dimension = sourceImage.GetDimension();
  CheckImageMatchingDimension(  sourceImage, targetImage, "targetImage" );
  CheckImageMatchingSize(  sourceImage, targetImage, "targetImage" );

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( &sourceImage, &targetImage );
}



//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
void LabelOverlapMeasuresImageFilter::ExecuteInternal ( const Image * inSourceImage, const Image * inTargetImage )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  using OutputImageType = InputImageType;



  using FilterType = itk::LabelOverlapMeasuresImageFilter<InputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();


  assert( inSourceImage != nullptr );
  typename FilterType::InputImageType::ConstPointer image1 = this->CastImageToITK<typename FilterType::InputImageType>( *inSourceImage );
  filter->SetInput( image1 );
  assert( inTargetImage != nullptr );
  filter->SetTargetImage( this->CastImageToITK<typename FilterType::LabelImageType>(*inTargetImage) );





  // release the old filter ( and output data )
  if ( this->m_Filter != nullptr)
    {
      this->m_pfGetFalseNegativeError = nullptr;
      this->m_pfGetFalsePositiveError = nullptr;
      this->m_pfGetMeanOverlap = nullptr;
      this->m_pfGetUnionOverlap = nullptr;
      this->m_pfGetVolumeSimilarity = nullptr;
      this->m_pfGetJaccardCoefficient = nullptr;
      this->m_pfGetDiceCoefficient = nullptr;
      this->m_pfGetFalseDiscoveryRate = nullptr;
      this->m_Filter->UnRegister();
      this->m_Filter = nullptr;
    }

  this->m_Filter = filter;
  this->m_Filter->Register();


  this->PreUpdate( filter.GetPointer() );

  this->m_pfGetFalseNegativeError = [ f = filter.GetPointer() ](auto && label) {
    const auto & value = f->GetFalseNegativeError(std::forward<decltype(label)>(label));
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return value;
  };
  this->m_pfGetFalsePositiveError = [ f = filter.GetPointer() ](auto && label) {
    const auto & value = f->GetFalsePositiveError(std::forward<decltype(label)>(label));
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return value;
  };
  this->m_pfGetMeanOverlap = [ f = filter.GetPointer() ](auto && label) {
    const auto & value = f->GetMeanOverlap(std::forward<decltype(label)>(label));
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return value;
  };
  this->m_pfGetUnionOverlap = [ f = filter.GetPointer() ](auto && label) {
    const auto & value = f->GetUnionOverlap(std::forward<decltype(label)>(label));
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return value;
  };
  this->m_pfGetVolumeSimilarity = [ f = filter.GetPointer() ](auto && label) {
    const auto & value = f->GetVolumeSimilarity(std::forward<decltype(label)>(label));
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return value;
  };
  this->m_pfGetJaccardCoefficient = [ f = filter.GetPointer() ](auto && label) {
    const auto & value = f->GetJaccardCoefficient(std::forward<decltype(label)>(label));
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return value;
  };
  this->m_pfGetDiceCoefficient = [ f = filter.GetPointer() ](auto && label) {
    const auto & value = f->GetDiceCoefficient(std::forward<decltype(label)>(label));
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return value;
  };
  this->m_pfGetFalseDiscoveryRate = [ f = filter.GetPointer() ](auto && label) {
    const auto & value = f->GetFalseDiscoveryRate(std::forward<decltype(label)>(label));
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return value;
  };


  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();

  this->m_FalseNegativeError = filter->GetFalseNegativeError();
  this->m_FalsePositiveError = filter->GetFalsePositiveError();
  this->m_MeanOverlap = filter->GetMeanOverlap();
  this->m_UnionOverlap = filter->GetUnionOverlap();
  this->m_VolumeSimilarity = filter->GetVolumeSimilarity();
  this->m_JaccardCoefficient = filter->GetJaccardCoefficient();
  this->m_DiceCoefficient = filter->GetDiceCoefficient();
  this->m_FalseDiscoveryRate = filter->GetFalseDiscoveryRate();


  return;

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------




}
