//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/xpcom/base/nsISupports.idl
//


/// `interface nsISupports`
///

/// ```text
/// /**
///  * Basic component object model interface. Objects which implement
///  * this interface support runtime interface discovery (QueryInterface)
///  * and a reference counted memory model (AddRef/Release). This is
///  * modelled after the win32 IUnknown API.
///  *
///  * Historically, nsISupports needed to be binary compatible with COM's
///  * IUnknown, so the IID of nsISupports is the same as it. That is no
///  * longer a goal, and hopefully nobody depends on it. We may break
///  * this compatibility at any time.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsISupports {
    vtable: &'static nsISupportsVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsISupports.
unsafe impl XpCom for nsISupports {
    const IID: nsIID = nsID(0x00000000, 0x0000, 0x0000,
        [0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsISupports {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsISupports.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsISupportsCoerce {
    /// Cheaply cast a value of this type from a `nsISupports`.
    fn coerce_from(v: &nsISupports) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsISupportsCoerce for nsISupports {
    #[inline]
    fn coerce_from(v: &nsISupports) -> &Self {
        v
    }
}

impl nsISupports {
    /// Cast this `nsISupports` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsISupportsCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsISupports
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsISupportsVTable {/* void QueryInterface (in nsIIDRef aIID, [iid_is (aIID), retval] out nsQIResult aInstancePtr); */
    pub QueryInterface: unsafe extern "system" fn (this: *const nsISupports, aIID: *const nsIID, aInstancePtr: *mut *mut libc::c_void) -> ::nserror::nsresult,

    /* [noscript,notxpcom] MozExternalRefCountType AddRef (); */
    pub AddRef: unsafe extern "system" fn (this: *const nsISupports) -> MozExternalRefCountType,

    /* [noscript,notxpcom] MozExternalRefCountType Release (); */
    pub Release: unsafe extern "system" fn (this: *const nsISupports) -> MozExternalRefCountType,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsISupports {

    /// ```text
    /// /**
    ///    * A run time mechanism for interface discovery.
    ///    * @param aIID [in] A requested interface IID
    ///    * @param aInstancePtr [out] A pointer to an interface pointer to
    ///    * receive the result.
    ///    * @return <b>NS_OK</b> if the interface is supported by the associated
    ///    * instance, <b>NS_NOINTERFACE</b> if it is not.
    ///    *
    ///    * aInstancePtr must not be null.
    ///    */
    /// ```
    ///

    /// `void QueryInterface (in nsIIDRef aIID, [iid_is (aIID), retval] out nsQIResult aInstancePtr);`
    #[inline]
    pub unsafe fn QueryInterface(&self, aIID: *const nsIID, aInstancePtr: *mut *mut libc::c_void) -> ::nserror::nsresult {
        ((*self.vtable).QueryInterface)(self, aIID, aInstancePtr)
    }


    /// ```text
    /// /**
    ///    * Increases the reference count for this interface.
    ///    * The associated instance will not be deleted unless
    ///    * the reference count is returned to zero.
    ///    *
    ///    * @return The resulting reference count.
    ///    */
    /// ```
    ///

    /// `[noscript,notxpcom] MozExternalRefCountType AddRef ();`
    #[inline]
    pub unsafe fn AddRef(&self, ) -> MozExternalRefCountType {
        ((*self.vtable).AddRef)(self, )
    }


    /// ```text
    /// /**
    ///    * Decreases the reference count for this interface.
    ///    * Generally, if the reference count returns to zero,
    ///    * the associated instance is deleted.
    ///    *
    ///    * @return The resulting reference count.
    ///    */
    /// ```
    ///

    /// `[noscript,notxpcom] MozExternalRefCountType Release ();`
    #[inline]
    pub unsafe fn Release(&self, ) -> MozExternalRefCountType {
        ((*self.vtable).Release)(self, )
    }


}


