// python wrapper for ttkTopologicalSimplification
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkTopologicalSimplification.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkTopologicalSimplification(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkTopologicalSimplification_ClassNew(); }


static PyObject *
PyttkTopologicalSimplification_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkTopologicalSimplification::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkTopologicalSimplification::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkTopologicalSimplification *tempr = ttkTopologicalSimplification::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkTopologicalSimplification *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkTopologicalSimplification::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkTopologicalSimplification::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkTopologicalSimplification::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_SetForceInputOffsetScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForceInputOffsetScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetForceInputOffsetScalarField(temp0);
    }
    else
    {
      op->ttkTopologicalSimplification::SetForceInputOffsetScalarField(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_GetForceInputOffsetScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceInputOffsetScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetForceInputOffsetScalarField() :
      op->ttkTopologicalSimplification::GetForceInputOffsetScalarField());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_SetConsiderIdentifierAsBlackList(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetConsiderIdentifierAsBlackList");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetConsiderIdentifierAsBlackList(temp0);
    }
    else
    {
      op->ttkTopologicalSimplification::SetConsiderIdentifierAsBlackList(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_GetConsiderIdentifierAsBlackList(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetConsiderIdentifierAsBlackList");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetConsiderIdentifierAsBlackList() :
      op->ttkTopologicalSimplification::GetConsiderIdentifierAsBlackList());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_SetAddPerturbation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAddPerturbation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAddPerturbation(temp0);
    }
    else
    {
      op->ttkTopologicalSimplification::SetAddPerturbation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_GetAddPerturbation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAddPerturbation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetAddPerturbation() :
      op->ttkTopologicalSimplification::GetAddPerturbation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_SetForceInputVertexScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForceInputVertexScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetForceInputVertexScalarField(temp0);
    }
    else
    {
      op->ttkTopologicalSimplification::SetForceInputVertexScalarField(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_GetForceInputVertexScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceInputVertexScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetForceInputVertexScalarField() :
      op->ttkTopologicalSimplification::GetForceInputVertexScalarField());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_SetMethod(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMethod");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMethod(temp0);
    }
    else
    {
      op->ttkTopologicalSimplification::SetMethod(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_GetMethod(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMethod");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMethod() :
      op->ttkTopologicalSimplification::GetMethod());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_SetPersistenceThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPersistenceThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPersistenceThreshold(temp0);
    }
    else
    {
      op->ttkTopologicalSimplification::SetPersistenceThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_GetPersistenceThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPersistenceThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetPersistenceThreshold() :
      op->ttkTopologicalSimplification::GetPersistenceThreshold());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_SetUseFastPersistenceUpdate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseFastPersistenceUpdate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseFastPersistenceUpdate(temp0);
    }
    else
    {
      op->ttkTopologicalSimplification::SetUseFastPersistenceUpdate(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_GetUseFastPersistenceUpdate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseFastPersistenceUpdate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseFastPersistenceUpdate() :
      op->ttkTopologicalSimplification::GetUseFastPersistenceUpdate());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_SetFastAssignmentUpdate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFastAssignmentUpdate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFastAssignmentUpdate(temp0);
    }
    else
    {
      op->ttkTopologicalSimplification::SetFastAssignmentUpdate(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_GetFastAssignmentUpdate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFastAssignmentUpdate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetFastAssignmentUpdate() :
      op->ttkTopologicalSimplification::GetFastAssignmentUpdate());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_SetEpochNumber(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpochNumber");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEpochNumber(temp0);
    }
    else
    {
      op->ttkTopologicalSimplification::SetEpochNumber(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_GetEpochNumber(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEpochNumber");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetEpochNumber() :
      op->ttkTopologicalSimplification::GetEpochNumber());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_SetPDCMethod(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPDCMethod");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPDCMethod(temp0);
    }
    else
    {
      op->ttkTopologicalSimplification::SetPDCMethod(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_GetPDCMethod(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPDCMethod");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPDCMethod() :
      op->ttkTopologicalSimplification::GetPDCMethod());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_SetMethodOptimization(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMethodOptimization");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMethodOptimization(temp0);
    }
    else
    {
      op->ttkTopologicalSimplification::SetMethodOptimization(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_GetMethodOptimization(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMethodOptimization");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMethodOptimization() :
      op->ttkTopologicalSimplification::GetMethodOptimization());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_SetFinePairManagement(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFinePairManagement");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFinePairManagement(temp0);
    }
    else
    {
      op->ttkTopologicalSimplification::SetFinePairManagement(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_GetFinePairManagement(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFinePairManagement");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetFinePairManagement() :
      op->ttkTopologicalSimplification::GetFinePairManagement());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_SetChooseLearningRate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChooseLearningRate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetChooseLearningRate(temp0);
    }
    else
    {
      op->ttkTopologicalSimplification::SetChooseLearningRate(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_GetChooseLearningRate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetChooseLearningRate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetChooseLearningRate() :
      op->ttkTopologicalSimplification::GetChooseLearningRate());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_SetLearningRate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLearningRate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLearningRate(temp0);
    }
    else
    {
      op->ttkTopologicalSimplification::SetLearningRate(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_GetLearningRate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLearningRate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetLearningRate() :
      op->ttkTopologicalSimplification::GetLearningRate());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_SetAlpha(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAlpha");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAlpha(temp0);
    }
    else
    {
      op->ttkTopologicalSimplification::SetAlpha(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_GetAlpha(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAlpha");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetAlpha() :
      op->ttkTopologicalSimplification::GetAlpha());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_SetCoefStopCondition(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCoefStopCondition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCoefStopCondition(temp0);
    }
    else
    {
      op->ttkTopologicalSimplification::SetCoefStopCondition(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_GetCoefStopCondition(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCoefStopCondition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetCoefStopCondition() :
      op->ttkTopologicalSimplification::GetCoefStopCondition());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_SetOptimizationWithoutMatching(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOptimizationWithoutMatching");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOptimizationWithoutMatching(temp0);
    }
    else
    {
      op->ttkTopologicalSimplification::SetOptimizationWithoutMatching(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_GetOptimizationWithoutMatching(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOptimizationWithoutMatching");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetOptimizationWithoutMatching() :
      op->ttkTopologicalSimplification::GetOptimizationWithoutMatching());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_SetThresholdMethod(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetThresholdMethod");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetThresholdMethod(temp0);
    }
    else
    {
      op->ttkTopologicalSimplification::SetThresholdMethod(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_GetThresholdMethod(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetThresholdMethod");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetThresholdMethod() :
      op->ttkTopologicalSimplification::GetThresholdMethod());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_SetThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetThreshold(temp0);
    }
    else
    {
      op->ttkTopologicalSimplification::SetThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_GetThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetThreshold() :
      op->ttkTopologicalSimplification::GetThreshold());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_SetLowerThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLowerThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLowerThreshold(temp0);
    }
    else
    {
      op->ttkTopologicalSimplification::SetLowerThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_GetLowerThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLowerThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetLowerThreshold() :
      op->ttkTopologicalSimplification::GetLowerThreshold());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_SetUpperThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUpperThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUpperThreshold(temp0);
    }
    else
    {
      op->ttkTopologicalSimplification::SetUpperThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_GetUpperThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUpperThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetUpperThreshold() :
      op->ttkTopologicalSimplification::GetUpperThreshold());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_SetPairTypeToDelete(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPairTypeToDelete");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPairTypeToDelete(temp0);
    }
    else
    {
      op->ttkTopologicalSimplification::SetPairTypeToDelete(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_GetPairTypeToDelete(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPairTypeToDelete");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPairTypeToDelete() :
      op->ttkTopologicalSimplification::GetPairTypeToDelete());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_SetConstraintAveraging(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetConstraintAveraging");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetConstraintAveraging(temp0);
    }
    else
    {
      op->ttkTopologicalSimplification::SetConstraintAveraging(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_GetConstraintAveraging(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetConstraintAveraging");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetConstraintAveraging() :
      op->ttkTopologicalSimplification::GetConstraintAveraging());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_SetPrintFrequency(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPrintFrequency");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPrintFrequency(temp0);
    }
    else
    {
      op->ttkTopologicalSimplification::SetPrintFrequency(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalSimplification_GetPrintFrequency(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPrintFrequency");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalSimplification *op = static_cast<ttkTopologicalSimplification *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPrintFrequency() :
      op->ttkTopologicalSimplification::GetPrintFrequency());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkTopologicalSimplification_Methods[] = {
  {"IsTypeOf", PyttkTopologicalSimplification_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkTopologicalSimplification_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkTopologicalSimplification_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkTopologicalSimplification\nC++: static ttkTopologicalSimplification *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkTopologicalSimplification_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkTopologicalSimplification\nC++: ttkTopologicalSimplification *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkTopologicalSimplification_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkTopologicalSimplification_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetForceInputOffsetScalarField", PyttkTopologicalSimplification_SetForceInputOffsetScalarField, METH_VARARGS,
   "SetForceInputOffsetScalarField(self, _arg:bool) -> None\nC++: virtual void SetForceInputOffsetScalarField(bool _arg)\n\n"},
  {"GetForceInputOffsetScalarField", PyttkTopologicalSimplification_GetForceInputOffsetScalarField, METH_VARARGS,
   "GetForceInputOffsetScalarField(self) -> bool\nC++: virtual bool GetForceInputOffsetScalarField()\n\n"},
  {"SetConsiderIdentifierAsBlackList", PyttkTopologicalSimplification_SetConsiderIdentifierAsBlackList, METH_VARARGS,
   "SetConsiderIdentifierAsBlackList(self, _arg:bool) -> None\nC++: virtual void SetConsiderIdentifierAsBlackList(bool _arg)\n\n"},
  {"GetConsiderIdentifierAsBlackList", PyttkTopologicalSimplification_GetConsiderIdentifierAsBlackList, METH_VARARGS,
   "GetConsiderIdentifierAsBlackList(self) -> bool\nC++: virtual bool GetConsiderIdentifierAsBlackList()\n\n"},
  {"SetAddPerturbation", PyttkTopologicalSimplification_SetAddPerturbation, METH_VARARGS,
   "SetAddPerturbation(self, _arg:bool) -> None\nC++: virtual void SetAddPerturbation(bool _arg)\n\n"},
  {"GetAddPerturbation", PyttkTopologicalSimplification_GetAddPerturbation, METH_VARARGS,
   "GetAddPerturbation(self) -> bool\nC++: virtual bool GetAddPerturbation()\n\n"},
  {"SetForceInputVertexScalarField", PyttkTopologicalSimplification_SetForceInputVertexScalarField, METH_VARARGS,
   "SetForceInputVertexScalarField(self, _arg:bool) -> None\nC++: virtual void SetForceInputVertexScalarField(bool _arg)\n\n"},
  {"GetForceInputVertexScalarField", PyttkTopologicalSimplification_GetForceInputVertexScalarField, METH_VARARGS,
   "GetForceInputVertexScalarField(self) -> bool\nC++: virtual bool GetForceInputVertexScalarField()\n\n"},
  {"SetMethod", PyttkTopologicalSimplification_SetMethod, METH_VARARGS,
   "SetMethod(self, _arg:int) -> None\nC++: virtual void SetMethod(int _arg)\n\n"},
  {"GetMethod", PyttkTopologicalSimplification_GetMethod, METH_VARARGS,
   "GetMethod(self) -> int\nC++: virtual int GetMethod()\n\n"},
  {"SetPersistenceThreshold", PyttkTopologicalSimplification_SetPersistenceThreshold, METH_VARARGS,
   "SetPersistenceThreshold(self, _arg:float) -> None\nC++: virtual void SetPersistenceThreshold(double _arg)\n\n"},
  {"GetPersistenceThreshold", PyttkTopologicalSimplification_GetPersistenceThreshold, METH_VARARGS,
   "GetPersistenceThreshold(self) -> float\nC++: virtual double GetPersistenceThreshold()\n\n"},
  {"SetUseFastPersistenceUpdate", PyttkTopologicalSimplification_SetUseFastPersistenceUpdate, METH_VARARGS,
   "SetUseFastPersistenceUpdate(self, _arg:bool) -> None\nC++: virtual void SetUseFastPersistenceUpdate(bool _arg)\n\n"},
  {"GetUseFastPersistenceUpdate", PyttkTopologicalSimplification_GetUseFastPersistenceUpdate, METH_VARARGS,
   "GetUseFastPersistenceUpdate(self) -> bool\nC++: virtual bool GetUseFastPersistenceUpdate()\n\n"},
  {"SetFastAssignmentUpdate", PyttkTopologicalSimplification_SetFastAssignmentUpdate, METH_VARARGS,
   "SetFastAssignmentUpdate(self, _arg:bool) -> None\nC++: virtual void SetFastAssignmentUpdate(bool _arg)\n\n"},
  {"GetFastAssignmentUpdate", PyttkTopologicalSimplification_GetFastAssignmentUpdate, METH_VARARGS,
   "GetFastAssignmentUpdate(self) -> bool\nC++: virtual bool GetFastAssignmentUpdate()\n\n"},
  {"SetEpochNumber", PyttkTopologicalSimplification_SetEpochNumber, METH_VARARGS,
   "SetEpochNumber(self, _arg:int) -> None\nC++: virtual void SetEpochNumber(int _arg)\n\n"},
  {"GetEpochNumber", PyttkTopologicalSimplification_GetEpochNumber, METH_VARARGS,
   "GetEpochNumber(self) -> int\nC++: virtual int GetEpochNumber()\n\n"},
  {"SetPDCMethod", PyttkTopologicalSimplification_SetPDCMethod, METH_VARARGS,
   "SetPDCMethod(self, _arg:int) -> None\nC++: virtual void SetPDCMethod(int _arg)\n\n"},
  {"GetPDCMethod", PyttkTopologicalSimplification_GetPDCMethod, METH_VARARGS,
   "GetPDCMethod(self) -> int\nC++: virtual int GetPDCMethod()\n\n"},
  {"SetMethodOptimization", PyttkTopologicalSimplification_SetMethodOptimization, METH_VARARGS,
   "SetMethodOptimization(self, _arg:int) -> None\nC++: virtual void SetMethodOptimization(int _arg)\n\n"},
  {"GetMethodOptimization", PyttkTopologicalSimplification_GetMethodOptimization, METH_VARARGS,
   "GetMethodOptimization(self) -> int\nC++: virtual int GetMethodOptimization()\n\n"},
  {"SetFinePairManagement", PyttkTopologicalSimplification_SetFinePairManagement, METH_VARARGS,
   "SetFinePairManagement(self, _arg:int) -> None\nC++: virtual void SetFinePairManagement(int _arg)\n\n"},
  {"GetFinePairManagement", PyttkTopologicalSimplification_GetFinePairManagement, METH_VARARGS,
   "GetFinePairManagement(self) -> int\nC++: virtual int GetFinePairManagement()\n\n"},
  {"SetChooseLearningRate", PyttkTopologicalSimplification_SetChooseLearningRate, METH_VARARGS,
   "SetChooseLearningRate(self, _arg:bool) -> None\nC++: virtual void SetChooseLearningRate(bool _arg)\n\n"},
  {"GetChooseLearningRate", PyttkTopologicalSimplification_GetChooseLearningRate, METH_VARARGS,
   "GetChooseLearningRate(self) -> bool\nC++: virtual bool GetChooseLearningRate()\n\n"},
  {"SetLearningRate", PyttkTopologicalSimplification_SetLearningRate, METH_VARARGS,
   "SetLearningRate(self, _arg:float) -> None\nC++: virtual void SetLearningRate(double _arg)\n\n"},
  {"GetLearningRate", PyttkTopologicalSimplification_GetLearningRate, METH_VARARGS,
   "GetLearningRate(self) -> float\nC++: virtual double GetLearningRate()\n\n"},
  {"SetAlpha", PyttkTopologicalSimplification_SetAlpha, METH_VARARGS,
   "SetAlpha(self, _arg:float) -> None\nC++: virtual void SetAlpha(double _arg)\n\n"},
  {"GetAlpha", PyttkTopologicalSimplification_GetAlpha, METH_VARARGS,
   "GetAlpha(self) -> float\nC++: virtual double GetAlpha()\n\n"},
  {"SetCoefStopCondition", PyttkTopologicalSimplification_SetCoefStopCondition, METH_VARARGS,
   "SetCoefStopCondition(self, _arg:float) -> None\nC++: virtual void SetCoefStopCondition(double _arg)\n\n"},
  {"GetCoefStopCondition", PyttkTopologicalSimplification_GetCoefStopCondition, METH_VARARGS,
   "GetCoefStopCondition(self) -> float\nC++: virtual double GetCoefStopCondition()\n\n"},
  {"SetOptimizationWithoutMatching", PyttkTopologicalSimplification_SetOptimizationWithoutMatching, METH_VARARGS,
   "SetOptimizationWithoutMatching(self, _arg:bool) -> None\nC++: virtual void SetOptimizationWithoutMatching(bool _arg)\n\n"},
  {"GetOptimizationWithoutMatching", PyttkTopologicalSimplification_GetOptimizationWithoutMatching, METH_VARARGS,
   "GetOptimizationWithoutMatching(self) -> bool\nC++: virtual bool GetOptimizationWithoutMatching()\n\n"},
  {"SetThresholdMethod", PyttkTopologicalSimplification_SetThresholdMethod, METH_VARARGS,
   "SetThresholdMethod(self, _arg:int) -> None\nC++: virtual void SetThresholdMethod(int _arg)\n\n"},
  {"GetThresholdMethod", PyttkTopologicalSimplification_GetThresholdMethod, METH_VARARGS,
   "GetThresholdMethod(self) -> int\nC++: virtual int GetThresholdMethod()\n\n"},
  {"SetThreshold", PyttkTopologicalSimplification_SetThreshold, METH_VARARGS,
   "SetThreshold(self, _arg:float) -> None\nC++: virtual void SetThreshold(double _arg)\n\n"},
  {"GetThreshold", PyttkTopologicalSimplification_GetThreshold, METH_VARARGS,
   "GetThreshold(self) -> float\nC++: virtual double GetThreshold()\n\n"},
  {"SetLowerThreshold", PyttkTopologicalSimplification_SetLowerThreshold, METH_VARARGS,
   "SetLowerThreshold(self, _arg:int) -> None\nC++: virtual void SetLowerThreshold(int _arg)\n\n"},
  {"GetLowerThreshold", PyttkTopologicalSimplification_GetLowerThreshold, METH_VARARGS,
   "GetLowerThreshold(self) -> int\nC++: virtual int GetLowerThreshold()\n\n"},
  {"SetUpperThreshold", PyttkTopologicalSimplification_SetUpperThreshold, METH_VARARGS,
   "SetUpperThreshold(self, _arg:int) -> None\nC++: virtual void SetUpperThreshold(int _arg)\n\n"},
  {"GetUpperThreshold", PyttkTopologicalSimplification_GetUpperThreshold, METH_VARARGS,
   "GetUpperThreshold(self) -> int\nC++: virtual int GetUpperThreshold()\n\n"},
  {"SetPairTypeToDelete", PyttkTopologicalSimplification_SetPairTypeToDelete, METH_VARARGS,
   "SetPairTypeToDelete(self, _arg:int) -> None\nC++: virtual void SetPairTypeToDelete(int _arg)\n\n"},
  {"GetPairTypeToDelete", PyttkTopologicalSimplification_GetPairTypeToDelete, METH_VARARGS,
   "GetPairTypeToDelete(self) -> int\nC++: virtual int GetPairTypeToDelete()\n\n"},
  {"SetConstraintAveraging", PyttkTopologicalSimplification_SetConstraintAveraging, METH_VARARGS,
   "SetConstraintAveraging(self, _arg:bool) -> None\nC++: virtual void SetConstraintAveraging(bool _arg)\n\n"},
  {"GetConstraintAveraging", PyttkTopologicalSimplification_GetConstraintAveraging, METH_VARARGS,
   "GetConstraintAveraging(self) -> bool\nC++: virtual bool GetConstraintAveraging()\n\n"},
  {"SetPrintFrequency", PyttkTopologicalSimplification_SetPrintFrequency, METH_VARARGS,
   "SetPrintFrequency(self, _arg:int) -> None\nC++: virtual void SetPrintFrequency(int _arg)\n\n"},
  {"GetPrintFrequency", PyttkTopologicalSimplification_GetPrintFrequency, METH_VARARGS,
   "GetPrintFrequency(self) -> int\nC++: virtual int GetPrintFrequency()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkTopologicalSimplification_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("force_input_offset_scalar_field"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalSimplification_GetForceInputOffsetScalarField(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalSimplification_SetForceInputOffsetScalarField(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalSimplification_SetForceInputOffsetScalarField(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetForceInputOffsetScalarField/SetForceInputOffsetScalarField\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("consider_identifier_as_black_list"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalSimplification_GetConsiderIdentifierAsBlackList(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalSimplification_SetConsiderIdentifierAsBlackList(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalSimplification_SetConsiderIdentifierAsBlackList(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetConsiderIdentifierAsBlackList/SetConsiderIdentifierAsBlackList\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("add_perturbation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalSimplification_GetAddPerturbation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalSimplification_SetAddPerturbation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalSimplification_SetAddPerturbation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAddPerturbation/SetAddPerturbation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("force_input_vertex_scalar_field"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalSimplification_GetForceInputVertexScalarField(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalSimplification_SetForceInputVertexScalarField(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalSimplification_SetForceInputVertexScalarField(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetForceInputVertexScalarField/SetForceInputVertexScalarField\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("method"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalSimplification_GetMethod(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalSimplification_SetMethod(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalSimplification_SetMethod(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMethod/SetMethod\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("persistence_threshold"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalSimplification_GetPersistenceThreshold(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalSimplification_SetPersistenceThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalSimplification_SetPersistenceThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPersistenceThreshold/SetPersistenceThreshold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_fast_persistence_update"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalSimplification_GetUseFastPersistenceUpdate(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalSimplification_SetUseFastPersistenceUpdate(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalSimplification_SetUseFastPersistenceUpdate(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseFastPersistenceUpdate/SetUseFastPersistenceUpdate\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("fast_assignment_update"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalSimplification_GetFastAssignmentUpdate(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalSimplification_SetFastAssignmentUpdate(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalSimplification_SetFastAssignmentUpdate(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFastAssignmentUpdate/SetFastAssignmentUpdate\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("epoch_number"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalSimplification_GetEpochNumber(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalSimplification_SetEpochNumber(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalSimplification_SetEpochNumber(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEpochNumber/SetEpochNumber\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("pdc_method"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalSimplification_GetPDCMethod(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalSimplification_SetPDCMethod(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalSimplification_SetPDCMethod(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPDCMethod/SetPDCMethod\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("method_optimization"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalSimplification_GetMethodOptimization(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalSimplification_SetMethodOptimization(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalSimplification_SetMethodOptimization(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMethodOptimization/SetMethodOptimization\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("fine_pair_management"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalSimplification_GetFinePairManagement(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalSimplification_SetFinePairManagement(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalSimplification_SetFinePairManagement(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFinePairManagement/SetFinePairManagement\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("choose_learning_rate"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalSimplification_GetChooseLearningRate(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalSimplification_SetChooseLearningRate(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalSimplification_SetChooseLearningRate(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetChooseLearningRate/SetChooseLearningRate\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("learning_rate"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalSimplification_GetLearningRate(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalSimplification_SetLearningRate(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalSimplification_SetLearningRate(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLearningRate/SetLearningRate\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("alpha"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalSimplification_GetAlpha(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalSimplification_SetAlpha(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalSimplification_SetAlpha(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAlpha/SetAlpha\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("coef_stop_condition"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalSimplification_GetCoefStopCondition(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalSimplification_SetCoefStopCondition(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalSimplification_SetCoefStopCondition(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCoefStopCondition/SetCoefStopCondition\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("optimization_without_matching"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalSimplification_GetOptimizationWithoutMatching(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalSimplification_SetOptimizationWithoutMatching(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalSimplification_SetOptimizationWithoutMatching(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOptimizationWithoutMatching/SetOptimizationWithoutMatching\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("threshold_method"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalSimplification_GetThresholdMethod(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalSimplification_SetThresholdMethod(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalSimplification_SetThresholdMethod(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetThresholdMethod/SetThresholdMethod\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("threshold"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalSimplification_GetThreshold(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalSimplification_SetThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalSimplification_SetThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetThreshold/SetThreshold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("lower_threshold"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalSimplification_GetLowerThreshold(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalSimplification_SetLowerThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalSimplification_SetLowerThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLowerThreshold/SetLowerThreshold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("upper_threshold"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalSimplification_GetUpperThreshold(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalSimplification_SetUpperThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalSimplification_SetUpperThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUpperThreshold/SetUpperThreshold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("pair_type_to_delete"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalSimplification_GetPairTypeToDelete(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalSimplification_SetPairTypeToDelete(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalSimplification_SetPairTypeToDelete(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPairTypeToDelete/SetPairTypeToDelete\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("constraint_averaging"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalSimplification_GetConstraintAveraging(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalSimplification_SetConstraintAveraging(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalSimplification_SetConstraintAveraging(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetConstraintAveraging/SetConstraintAveraging\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("print_frequency"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalSimplification_GetPrintFrequency(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalSimplification_SetPrintFrequency(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalSimplification_SetPrintFrequency(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPrintFrequency/SetPrintFrequency\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkTopologicalSimplification_Doc =
  "ttkTopologicalSimplification - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Guillaume Favelier <guillaume.favelier@lip6.fr>\\date February\n"
  "2016\n\n"
  "TTK VTK-filter for the topological simplification of scalar\n"
  "data.\n\n"
  "Given an input scalar field and a list of critical points to remove,\n"
  "this filter minimally edits the scalar field such that the listed\n"
  "critical points disappear. This procedure is useful to speedup\n"
  "subsequent topological data analysis when outlier critical points can\n"
  "be easily identified. It is also useful for data simplification.\n\n"
  "The list of critical points to remove must be associated with a point\n"
  "data scalar field that represent the vertex global identifiers in the\n"
  "input geometry.\n\n"
  "Note that this filter will also produce an output vertex offset\n"
  "scalar field that can be used for further topological data analysis\n"
  "tasks to disambiguate vertices on flat plateaus. For instance, this\n"
  "output vertex offset field can specified to the ttkMergeTree,\n"
  "vtkIntegralLines, or vtkScalarFieldCriticalPoints filters.\n\n"
  "Also, this filter can be given a specific input vertex offset.\n\n"
  "\\param Input0 Input scalar field, either 2D or 3D, either regular\n"
  "    grid or\n"
  "triangulation (vtkDataSet)\n"
  "\\param Input1 List of critical point constraints (vtkPointSet)\n"
  "\\param Output Output simplified scalar field (vtkDataSet)\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "Related publications\n\n"
  "\"Generalized Topological Simplification of Scalar Fields on Surfaces\"\n\n"
  "Julien Tierny, Valerio Pascucci\n\n"
  "IEEE Transactions on Visualization and Computer Graphics.\n\n"
  "Proc. of IEEE VIS 2012.\n\n"
  "\"Localized Topological Simplification of Scalar Data\"\n\n"
  "Jonas Lukasczyk, Christoph Garth, Ross Maciejewski, Julien Tierny\n\n"
  "IEEE Transactions on Visualization and Computer Graphics.\n\n"
  "Proc. of IEEE VIS 2020.\n\n"
  "\"A Practical Solver for Scalar Data Topological Simplification\"\n\n"
  "Mohamed Kissi, Mathieu Pont, Joshua A. Levine, Julien Tierny\n\n"
  "IEEE Transactions on Visualization and Computer Graphics.\n\n"
  "Proc. of IEEE VIS 2024.\n\n"
  "\\sa ttkTopologicalSimplificationByPersistence\n"
  "\\sa ttkScalarFieldCriticalPoints\n"
  "\\sa ttkIntegralLines\n"
  "\\sa ttkMergeTree\n"
  "\\sa ttkMorseSmaleComplex\n"
  "\\sa ttkIdentifiers\n"
  "\\sa ttk::TopologicalSimplification\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/1manifoldLearning/\"\n"
  "  >1-Manifold Learning example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/1manifoldLearningCircles/\"\n"
  "  >1-Manifold Learning Circles example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/2manifoldLearning/\"\n"
  "  > 2-Manifold Learning example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/BuiltInExample1/\"\n"
  "  >BuiltInExample1 example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/contourTreeAlignment/\"\n"
  "  >Contour Tree Alignment example\\n\n"
  "- <a href=\"https://topology-tool-kit.github.io/examples/ctBones/\">CT\n"
  "  Bones example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/dragon/\">Dragon\n"
  "  example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/harmonicSkeleton/\"\n"
  "  > Harmonic Skeleton example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/imageProcessing/\"\n"
  "  >Image Processing example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/interactionSites/\"\n"
  "  > Interaction sites\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/karhunenLoveDigits64Dimensions/\"\n"
  "  >Karhunen-Love Digits 64-Dimensions example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/morsePersistence/\"\n"
  "  >Morse Persistence example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/morseSmaleQuadrangulation/\"\n"
  "  >Morse-Smale Quadrangulation example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistenceClustering0/\"\n"
  "  >Persistence clustering 0 example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistenceClustering0/\"\n"
  "  >Persistence clustering 1 example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistenceClustering0/\"\n"
  "  >Persistence clustering 2 example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistenceClustering0/\"\n"
  "  >Persistence clustering 3 example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistenceClustering0/\"\n"
  "  >Persistence clustering 4 example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/tectonicPuzzle/\">\n"
  "  Tectonic Puzzle example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/topologicalOptimization_darkSky/\"\n"
  "  >Topological Optimization DarkSky example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/topologicalOptimization_pegasus/\"\n"
  "  >Topological Optimization for Pegasus Genus Repair example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/topologicalOptimization_torus/\"\n"
  "  >Topological Optimization for Torus Repair example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/tribute/\">Tribute\n"
  "   example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/uncertainStartingVortex/\"\n"
  "  > Uncertain Starting Vortex example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkTopologicalSimplification_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkTopologicalSimplification.ttkTopologicalSimplification", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkTopologicalSimplification_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkTopologicalSimplification_StaticNew()
{
  return ttkTopologicalSimplification::New();
}

PyObject *PyttkTopologicalSimplification_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkTopologicalSimplification_Type, PyttkTopologicalSimplification_Methods,
    "ttkTopologicalSimplification",
 &PyttkTopologicalSimplification_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkTopologicalSimplification_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkTopologicalSimplification(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkTopologicalSimplification_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkTopologicalSimplification", o) != 0)
  {
    Py_DECREF(o);
  }

}

