//
// Copyright 2021 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////
// This file is generated by a script.  Do not edit directly.  Edit the
// dualQuat.template.cpp file to make changes.

#include "pxr/pxr.h"
#include "pxr/base/gf/dualQuath.h"
#include "pxr/base/gf/ostreamHelpers.h"
#include "pxr/base/tf/type.h"

#include "pxr/base/gf/dualQuatd.h"
#include "pxr/base/gf/dualQuatf.h"

PXR_NAMESPACE_OPEN_SCOPE

TF_REGISTRY_FUNCTION(TfType) {
    TfType::Define<GfDualQuath>();
}

GfDualQuath::GfDualQuath(const GfDualQuatd &other)
    : _real(other.GetReal()) , _dual(other.GetDual())
{
}
GfDualQuath::GfDualQuath(const GfDualQuatf &other)
    : _real(other.GetReal()) , _dual(other.GetDual())
{
}

std::pair<GfHalf, GfHalf>
GfDualQuath::GetLength() const
{
    const GfHalf realLength = _real.GetLength();

    if (realLength == 0)
        return std::pair<GfHalf, GfHalf>{0, 0};

    return std::pair<GfHalf, GfHalf>{ realLength, GfDot(_real, _dual)/realLength };
}

GfDualQuath
GfDualQuath::GetNormalized(GfHalf eps) const
{
    GfDualQuath dq(*this);
    dq.Normalize(eps);

    return dq;
}

std::pair<GfHalf, GfHalf>
GfDualQuath::Normalize(GfHalf eps)
{
    const std::pair<GfHalf, GfHalf> length = GetLength();
    const GfHalf realLength = length.first;

    if (realLength < eps) {
        (*this) = GfDualQuath::GetIdentity();
    } else {
        const GfHalf invRealLength = 1.0 / realLength;
        _real *= invRealLength;
        _dual *= invRealLength;

        _dual -= (GfDot(_real, _dual) * _real);
    }

    return length;
}

GfDualQuath
GfDualQuath::GetConjugate() const
{
    return GfDualQuath( _real.GetConjugate(), _dual.GetConjugate() );
}

GfDualQuath
GfDualQuath::GetInverse() const
{
    // DQ * DQ.GetInverse() == GetIdentity()
    const GfHalf realLengthSqr = GfDot(_real, _real);

    if ( realLengthSqr <= 0.0 )
        return GfDualQuath::GetIdentity();

    const GfHalf invRealLengthSqr = 1.0 / realLengthSqr;
    const GfDualQuath conjInvLenSqr = GetConjugate() * invRealLengthSqr;
    const GfQuath realPart = conjInvLenSqr.GetReal();
    const GfQuath dualPart = conjInvLenSqr.GetDual() -
        (2.0 * invRealLengthSqr * GfDot(_real, _dual) * conjInvLenSqr.GetReal());

    return GfDualQuath( realPart, dualPart );
}

void
GfDualQuath::SetTranslation( const GfVec3h &translation )
{
    // compute and set the dual part
    _dual = GfQuath( 0.0, 0.5*translation ) * _real;
}

GfVec3h
GfDualQuath::GetTranslation() const
{
    // _dual = GfQuath(0, 0.5*translation) * _real
    // => translation = 2 * (_dual * _real.GetConjugate()).GetImaginary()

    // Assume that this dual quaternion is normalized
    TF_DEV_AXIOM(GfIsClose(_real.GetLength(), 1.0, 0.001));
    const GfHalf r1 = _dual.GetReal();
    const GfHalf r2 = _real.GetReal();
    const GfVec3h &i1 = _dual.GetImaginary();
    const GfVec3h &i2 = _real.GetImaginary();

    // Translation of the dual quaternion: -2.0 * (r1*i2 - r2*i1 + i1^i2)
    return GfVec3h( -2.0*(r1*i2[0] - r2*i1[0] + (i1[1]*i2[2] - i1[2]*i2[1])),
                               -2.0*(r1*i2[1] - r2*i1[1] + (i1[2]*i2[0] - i1[0]*i2[2])),
                               -2.0*(r1*i2[2] - r2*i1[2] + (i1[0]*i2[1] - i1[1]*i2[0])) );
}

GfDualQuath &
GfDualQuath::operator *=(const GfDualQuath &dq)
{
    const GfQuath tempReal = GetReal() * dq.GetReal();
    const GfQuath tempDual = GetReal() * dq.GetDual() + GetDual() * dq.GetReal();

    SetReal(tempReal);
    SetDual(tempDual);

    return *this;
}

GfVec3h
GfDualQuath::Transform(const GfVec3h &vec) const
{
    // Apply rotation and translation
    return GetReal().Transform(vec) + GetTranslation();
}

std::ostream &
operator<<(std::ostream &out, const GfDualQuath &dq)
{
    return(out << '(' << Gf_OstreamHelperP(dq.GetReal()) << ", "
           << Gf_OstreamHelperP(dq.GetDual()) << ')');
}

PXR_NAMESPACE_CLOSE_SCOPE
