//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/extComputationPrimvarSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdExtComputationPrimvarSchemaTokens,
    HD_EXT_COMPUTATION_PRIMVAR_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdTokenDataSourceHandle
HdExtComputationPrimvarSchema::GetInterpolation() const
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdExtComputationPrimvarSchemaTokens->interpolation);
}

HdTokenDataSourceHandle
HdExtComputationPrimvarSchema::GetRole() const
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdExtComputationPrimvarSchemaTokens->role);
}

HdPathDataSourceHandle
HdExtComputationPrimvarSchema::GetSourceComputation() const
{
    return _GetTypedDataSource<HdPathDataSource>(
        HdExtComputationPrimvarSchemaTokens->sourceComputation);
}

HdTokenDataSourceHandle
HdExtComputationPrimvarSchema::GetSourceComputationOutputName() const
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdExtComputationPrimvarSchemaTokens->sourceComputationOutputName);
}

HdTupleTypeDataSourceHandle
HdExtComputationPrimvarSchema::GetValueType() const
{
    return _GetTypedDataSource<HdTupleTypeDataSource>(
        HdExtComputationPrimvarSchemaTokens->valueType);
}

/*static*/
HdContainerDataSourceHandle
HdExtComputationPrimvarSchema::BuildRetained(
        const HdTokenDataSourceHandle &interpolation,
        const HdTokenDataSourceHandle &role,
        const HdPathDataSourceHandle &sourceComputation,
        const HdTokenDataSourceHandle &sourceComputationOutputName,
        const HdTupleTypeDataSourceHandle &valueType
)
{
    TfToken _names[5];
    HdDataSourceBaseHandle _values[5];

    size_t _count = 0;

    if (interpolation) {
        _names[_count] = HdExtComputationPrimvarSchemaTokens->interpolation;
        _values[_count++] = interpolation;
    }

    if (role) {
        _names[_count] = HdExtComputationPrimvarSchemaTokens->role;
        _values[_count++] = role;
    }

    if (sourceComputation) {
        _names[_count] = HdExtComputationPrimvarSchemaTokens->sourceComputation;
        _values[_count++] = sourceComputation;
    }

    if (sourceComputationOutputName) {
        _names[_count] = HdExtComputationPrimvarSchemaTokens->sourceComputationOutputName;
        _values[_count++] = sourceComputationOutputName;
    }

    if (valueType) {
        _names[_count] = HdExtComputationPrimvarSchemaTokens->valueType;
        _values[_count++] = valueType;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdExtComputationPrimvarSchema::Builder &
HdExtComputationPrimvarSchema::Builder::SetInterpolation(
    const HdTokenDataSourceHandle &interpolation)
{
    _interpolation = interpolation;
    return *this;
}

HdExtComputationPrimvarSchema::Builder &
HdExtComputationPrimvarSchema::Builder::SetRole(
    const HdTokenDataSourceHandle &role)
{
    _role = role;
    return *this;
}

HdExtComputationPrimvarSchema::Builder &
HdExtComputationPrimvarSchema::Builder::SetSourceComputation(
    const HdPathDataSourceHandle &sourceComputation)
{
    _sourceComputation = sourceComputation;
    return *this;
}

HdExtComputationPrimvarSchema::Builder &
HdExtComputationPrimvarSchema::Builder::SetSourceComputationOutputName(
    const HdTokenDataSourceHandle &sourceComputationOutputName)
{
    _sourceComputationOutputName = sourceComputationOutputName;
    return *this;
}

HdExtComputationPrimvarSchema::Builder &
HdExtComputationPrimvarSchema::Builder::SetValueType(
    const HdTupleTypeDataSourceHandle &valueType)
{
    _valueType = valueType;
    return *this;
}

HdContainerDataSourceHandle
HdExtComputationPrimvarSchema::Builder::Build()
{
    return HdExtComputationPrimvarSchema::BuildRetained(
        _interpolation,
        _role,
        _sourceComputation,
        _sourceComputationOutputName,
        _valueType
    );
} 

PXR_NAMESPACE_CLOSE_SCOPE