// python wrapper for vtkADIOS2CoreImageReader
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkADIOS2CoreImageReader.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkADIOS2CoreImageReader(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkADIOS2CoreImageReader_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkADIOS2CoreImageReader_VarType_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOADIOS2.vtkADIOS2CoreImageReader.VarType", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkADIOS2CoreImageReader_VarType_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkADIOS2CoreImageReader_VarType_Type, static_cast<int>(val));
}


static PyObject *
PyvtkADIOS2CoreImageReader_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkADIOS2CoreImageReader::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkADIOS2CoreImageReader::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkADIOS2CoreImageReader *tempr = vtkADIOS2CoreImageReader::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkADIOS2CoreImageReader *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkADIOS2CoreImageReader::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkADIOS2CoreImageReader::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkADIOS2CoreImageReader::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_CanReadFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CanReadFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->CanReadFile(temp0) :
      op->vtkADIOS2CoreImageReader::CanReadFile(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_SetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileName(temp0);
    }
    else
    {
      op->vtkADIOS2CoreImageReader::SetFileName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_GetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetFileName() :
      op->vtkADIOS2CoreImageReader::GetFileName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_SetOrigin_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrigin");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetOrigin(temp0, temp1, temp2);
    }
    else
    {
      op->vtkADIOS2CoreImageReader::SetOrigin(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkADIOS2CoreImageReader_SetOrigin_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrigin");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetOrigin(temp0);
    }
    else
    {
      op->vtkADIOS2CoreImageReader::SetOrigin(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkADIOS2CoreImageReader_SetOrigin(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkADIOS2CoreImageReader_SetOrigin_s1(self, args);
    case 1:
      return PyvtkADIOS2CoreImageReader_SetOrigin_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetOrigin");
  return nullptr;
}


static PyObject *
PyvtkADIOS2CoreImageReader_GetOrigin(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOrigin");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetOrigin() :
      op->vtkADIOS2CoreImageReader::GetOrigin());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_SetSpacing_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetSpacing(temp0, temp1, temp2);
    }
    else
    {
      op->vtkADIOS2CoreImageReader::SetSpacing(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkADIOS2CoreImageReader_SetSpacing_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetSpacing(temp0);
    }
    else
    {
      op->vtkADIOS2CoreImageReader::SetSpacing(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkADIOS2CoreImageReader_SetSpacing(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkADIOS2CoreImageReader_SetSpacing_s1(self, args);
    case 1:
      return PyvtkADIOS2CoreImageReader_SetSpacing_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetSpacing");
  return nullptr;
}


static PyObject *
PyvtkADIOS2CoreImageReader_GetSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetSpacing() :
      op->vtkADIOS2CoreImageReader::GetSpacing());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_GetAllDimensionArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAllDimensionArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkStringArray *tempr = (ap.IsBound() ?
      op->GetAllDimensionArrays() :
      op->vtkADIOS2CoreImageReader::GetAllDimensionArrays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_SetDimensionArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDimensionArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDimensionArray(temp0);
    }
    else
    {
      op->vtkADIOS2CoreImageReader::SetDimensionArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_GetDimensionArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDimensionArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetDimensionArray() :
      op->vtkADIOS2CoreImageReader::GetDimensionArray());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_SetDimensionArrayAsCell(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDimensionArrayAsCell");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDimensionArrayAsCell(temp0);
    }
    else
    {
      op->vtkADIOS2CoreImageReader::SetDimensionArrayAsCell(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_GetDimensionArrayAsCell(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDimensionArrayAsCell");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDimensionArrayAsCell() :
      op->vtkADIOS2CoreImageReader::GetDimensionArrayAsCell());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_DimensionArrayAsCellOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DimensionArrayAsCellOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DimensionArrayAsCellOn();
    }
    else
    {
      op->vtkADIOS2CoreImageReader::DimensionArrayAsCellOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_DimensionArrayAsCellOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DimensionArrayAsCellOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DimensionArrayAsCellOff();
    }
    else
    {
      op->vtkADIOS2CoreImageReader::DimensionArrayAsCellOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_GetAllTimeStepArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAllTimeStepArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkStringArray *tempr = (ap.IsBound() ?
      op->GetAllTimeStepArrays() :
      op->vtkADIOS2CoreImageReader::GetAllTimeStepArrays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_SetTimeStepArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTimeStepArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTimeStepArray(temp0);
    }
    else
    {
      op->vtkADIOS2CoreImageReader::SetTimeStepArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_GetTimeStepArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeStepArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetTimeStepArray() :
      op->vtkADIOS2CoreImageReader::GetTimeStepArray());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_GetNumberOfArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfArrays() :
      op->vtkADIOS2CoreImageReader::GetNumberOfArrays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_GetArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetArrayName(temp0) :
      op->vtkADIOS2CoreImageReader::GetArrayName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_SetArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetArrayStatus(temp0, temp1);
    }
    else
    {
      op->vtkADIOS2CoreImageReader::SetArrayStatus(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_GetArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetArrayStatus(temp0) :
      op->vtkADIOS2CoreImageReader::GetArrayStatus(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_GetMTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned long tempr = (ap.IsBound() ?
      op->GetMTime() :
      op->vtkADIOS2CoreImageReader::GetMTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_SetIsColumnMajor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetIsColumnMajor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetIsColumnMajor(temp0);
    }
    else
    {
      op->vtkADIOS2CoreImageReader::SetIsColumnMajor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_GetIsColumnMajor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIsColumnMajor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetIsColumnMajor() :
      op->vtkADIOS2CoreImageReader::GetIsColumnMajor());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_IsColumnMajorOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsColumnMajorOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->IsColumnMajorOn();
    }
    else
    {
      op->vtkADIOS2CoreImageReader::IsColumnMajorOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_IsColumnMajorOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsColumnMajorOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->IsColumnMajorOff();
    }
    else
    {
      op->vtkADIOS2CoreImageReader::IsColumnMajorOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkADIOS2CoreImageReader_SetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkADIOS2CoreImageReader *op = static_cast<vtkADIOS2CoreImageReader *>(vp);

  vtkMultiProcessController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMultiProcessController"))
  {
    if (ap.IsBound())
    {
      op->SetController(temp0);
    }
    else
    {
      op->vtkADIOS2CoreImageReader::SetController(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkADIOS2CoreImageReader_Methods[] = {
  {"IsTypeOf", PyvtkADIOS2CoreImageReader_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkADIOS2CoreImageReader_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkADIOS2CoreImageReader_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkADIOS2CoreImageReader\nC++: static vtkADIOS2CoreImageReader *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkADIOS2CoreImageReader_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkADIOS2CoreImageReader\nC++: vtkADIOS2CoreImageReader *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkADIOS2CoreImageReader_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkADIOS2CoreImageReader_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"CanReadFile", PyvtkADIOS2CoreImageReader_CanReadFile, METH_VARARGS,
   "CanReadFile(self, name:str) -> int\nC++: int CanReadFile(const std::string &name)\n\nTest whether or not a given file should even be attempted for use\nwith this reader.\n"},
  {"SetFileName", PyvtkADIOS2CoreImageReader_SetFileName, METH_VARARGS,
   "SetFileName(self, _arg:str) -> None\nC++: virtual void SetFileName(std::string _arg)\n\nGet/Set the input filename\n"},
  {"GetFileName", PyvtkADIOS2CoreImageReader_GetFileName, METH_VARARGS,
   "GetFileName(self) -> str\nC++: virtual std::string GetFileName()\n\n"},
  {"SetOrigin", PyvtkADIOS2CoreImageReader_SetOrigin, METH_VARARGS,
   "SetOrigin(self, _arg1:float, _arg2:float, _arg3:float) -> None\nC++: virtual void SetOrigin(double _arg1, double _arg2,\n    double _arg3)\nSetOrigin(self, _arg:(float, float, float)) -> None\nC++: virtual void SetOrigin(const double _arg[3])\n\nGet/Set the origin of output vtkImageData. Default to be the\norigin point.\n"},
  {"GetOrigin", PyvtkADIOS2CoreImageReader_GetOrigin, METH_VARARGS,
   "GetOrigin(self) -> (float, float, float)\nC++: virtual double *GetOrigin()\n\n"},
  {"SetSpacing", PyvtkADIOS2CoreImageReader_SetSpacing, METH_VARARGS,
   "SetSpacing(self, _arg1:float, _arg2:float, _arg3:float) -> None\nC++: virtual void SetSpacing(double _arg1, double _arg2,\n    double _arg3)\nSetSpacing(self, _arg:(float, float, float)) -> None\nC++: virtual void SetSpacing(const double _arg[3])\n\nGet/Set the spacing of output vtkImageData Default to be 1.0,\n1.0, 1.0.\n"},
  {"GetSpacing", PyvtkADIOS2CoreImageReader_GetSpacing, METH_VARARGS,
   "GetSpacing(self) -> (float, float, float)\nC++: virtual double *GetSpacing()\n\n"},
  {"GetAllDimensionArrays", PyvtkADIOS2CoreImageReader_GetAllDimensionArrays, METH_VARARGS,
   "GetAllDimensionArrays(self) -> vtkStringArray\nC++: vtkStringArray *GetAllDimensionArrays()\n\nGet/Set the name of the array to deduce the dimension of\nvtkImageData. You can toggle the DimensionArrayAsCell flag as\nneeded.\n"},
  {"SetDimensionArray", PyvtkADIOS2CoreImageReader_SetDimensionArray, METH_VARARGS,
   "SetDimensionArray(self, _arg:str) -> None\nC++: virtual void SetDimensionArray(std::string _arg)\n\n"},
  {"GetDimensionArray", PyvtkADIOS2CoreImageReader_GetDimensionArray, METH_VARARGS,
   "GetDimensionArray(self) -> str\nC++: virtual std::string GetDimensionArray()\n\n"},
  {"SetDimensionArrayAsCell", PyvtkADIOS2CoreImageReader_SetDimensionArrayAsCell, METH_VARARGS,
   "SetDimensionArrayAsCell(self, _arg:bool) -> None\nC++: virtual void SetDimensionArrayAsCell(bool _arg)\n\nEnable/Disable the assumption that the dimension array is cell\ndata. On by default.\n"},
  {"GetDimensionArrayAsCell", PyvtkADIOS2CoreImageReader_GetDimensionArrayAsCell, METH_VARARGS,
   "GetDimensionArrayAsCell(self) -> bool\nC++: virtual bool GetDimensionArrayAsCell()\n\n"},
  {"DimensionArrayAsCellOn", PyvtkADIOS2CoreImageReader_DimensionArrayAsCellOn, METH_VARARGS,
   "DimensionArrayAsCellOn(self) -> None\nC++: virtual void DimensionArrayAsCellOn()\n\n"},
  {"DimensionArrayAsCellOff", PyvtkADIOS2CoreImageReader_DimensionArrayAsCellOff, METH_VARARGS,
   "DimensionArrayAsCellOff(self) -> None\nC++: virtual void DimensionArrayAsCellOff()\n\n"},
  {"GetAllTimeStepArrays", PyvtkADIOS2CoreImageReader_GetAllTimeStepArrays, METH_VARARGS,
   "GetAllTimeStepArrays(self) -> vtkStringArray\nC++: vtkStringArray *GetAllTimeStepArrays()\n\n"},
  {"SetTimeStepArray", PyvtkADIOS2CoreImageReader_SetTimeStepArray, METH_VARARGS,
   "SetTimeStepArray(self, _arg:str) -> None\nC++: virtual void SetTimeStepArray(std::string _arg)\n\nGet/Set the name of the time step array. Once it's set, vtk will\ntry to populate the time step info from this array.\n"},
  {"GetTimeStepArray", PyvtkADIOS2CoreImageReader_GetTimeStepArray, METH_VARARGS,
   "GetTimeStepArray(self) -> str\nC++: virtual std::string GetTimeStepArray()\n\n"},
  {"GetNumberOfArrays", PyvtkADIOS2CoreImageReader_GetNumberOfArrays, METH_VARARGS,
   "GetNumberOfArrays(self) -> int\nC++: int GetNumberOfArrays()\n\nGet information about arrays. As is typical with readers this is\nonly valid after the filename is set and UpdateInformation() has\nbeen called. Since adios2 does not differentiate between cell\narrays and point arrays, the dimensions info is appended to the\nname so that it can used to kdetermine the type of the array. The\narray name includes its dimension.\n"},
  {"GetArrayName", PyvtkADIOS2CoreImageReader_GetArrayName, METH_VARARGS,
   "GetArrayName(self, index:int) -> str\nC++: const char *GetArrayName(int index)\n\n"},
  {"SetArrayStatus", PyvtkADIOS2CoreImageReader_SetArrayStatus, METH_VARARGS,
   "SetArrayStatus(self, name:str, status:int) -> None\nC++: void SetArrayStatus(const char *name, int status)\n\nSet the array that should be read in. Based on the dimension\ninfo, proper adios2 arrays will be read in as point or cell dota.\n"},
  {"GetArrayStatus", PyvtkADIOS2CoreImageReader_GetArrayStatus, METH_VARARGS,
   "GetArrayStatus(self, name:str) -> int\nC++: int GetArrayStatus(const char *name)\n\n"},
  {"GetMTime", PyvtkADIOS2CoreImageReader_GetMTime, METH_VARARGS,
   "GetMTime(self) -> int\nC++: vtkMTimeType GetMTime() override;\n\nOverridden to take into account mtimes for vtkDataArraySelection\ninstances.\n"},
  {"SetIsColumnMajor", PyvtkADIOS2CoreImageReader_SetIsColumnMajor, METH_VARARGS,
   "SetIsColumnMajor(self, _arg:bool) -> None\nC++: virtual void SetIsColumnMajor(bool _arg)\n\nEnable/Disable the assumption that the order of input data is\ncolumn major. Off by default. As VTK's order is column\nmajor(Fortran order) whereas adios2 uses row major(C order), we\n**flip the dimensions** here to avoid a deep copy.\n"},
  {"GetIsColumnMajor", PyvtkADIOS2CoreImageReader_GetIsColumnMajor, METH_VARARGS,
   "GetIsColumnMajor(self) -> bool\nC++: virtual bool GetIsColumnMajor()\n\n"},
  {"IsColumnMajorOn", PyvtkADIOS2CoreImageReader_IsColumnMajorOn, METH_VARARGS,
   "IsColumnMajorOn(self) -> None\nC++: virtual void IsColumnMajorOn()\n\n"},
  {"IsColumnMajorOff", PyvtkADIOS2CoreImageReader_IsColumnMajorOff, METH_VARARGS,
   "IsColumnMajorOff(self) -> None\nC++: virtual void IsColumnMajorOff()\n\n"},
  {"SetController", PyvtkADIOS2CoreImageReader_SetController, METH_VARARGS,
   "SetController(self, __a:vtkMultiProcessController) -> None\nC++: void SetController(vtkMultiProcessController *)\n\nSet the MPI controller\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkADIOS2CoreImageReader_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkADIOS2CoreImageReader_GetFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkADIOS2CoreImageReader_SetFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkADIOS2CoreImageReader_SetFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileName/SetFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("file_name"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkADIOS2CoreImageReader_SetFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkADIOS2CoreImageReader_SetFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("origin"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkADIOS2CoreImageReader_GetOrigin(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkADIOS2CoreImageReader_SetOrigin(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkADIOS2CoreImageReader_SetOrigin(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOrigin/SetOrigin\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("spacing"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkADIOS2CoreImageReader_GetSpacing(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkADIOS2CoreImageReader_SetSpacing(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkADIOS2CoreImageReader_SetSpacing(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSpacing/SetSpacing\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("dimension_array"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkADIOS2CoreImageReader_GetDimensionArray(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkADIOS2CoreImageReader_SetDimensionArray(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkADIOS2CoreImageReader_SetDimensionArray(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDimensionArray/SetDimensionArray\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("dimension_array_as_cell"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkADIOS2CoreImageReader_GetDimensionArrayAsCell(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkADIOS2CoreImageReader_SetDimensionArrayAsCell(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkADIOS2CoreImageReader_SetDimensionArrayAsCell(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDimensionArrayAsCell/SetDimensionArrayAsCell\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("time_step_array"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkADIOS2CoreImageReader_GetTimeStepArray(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkADIOS2CoreImageReader_SetTimeStepArray(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkADIOS2CoreImageReader_SetTimeStepArray(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTimeStepArray/SetTimeStepArray\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("is_column_major"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkADIOS2CoreImageReader_GetIsColumnMajor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkADIOS2CoreImageReader_SetIsColumnMajor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkADIOS2CoreImageReader_SetIsColumnMajor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetIsColumnMajor/SetIsColumnMajor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("controller"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkADIOS2CoreImageReader_SetController(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkADIOS2CoreImageReader_SetController(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetController\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("all_dimension_arrays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkADIOS2CoreImageReader_GetAllDimensionArrays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetAllDimensionArrays\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("all_time_step_arrays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkADIOS2CoreImageReader_GetAllTimeStepArrays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetAllTimeStepArrays\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("m_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkADIOS2CoreImageReader_GetMTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_arrays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkADIOS2CoreImageReader_GetNumberOfArrays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfArrays\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkADIOS2CoreImageReader_Doc =
  "vtkADIOS2CoreImageReader - Read ADIOS2 bp files.\n\n"
  "Superclass: vtkDataObjectAlgorithm\n\n"
  "vtkADIOS2CoreImageReader reads ADIOS2 bp data files so that they can\n"
  "be processed or visualized using VTK as vtkImageDatas. When\n"
  "processing data, the assumption is that the all variables share the\n"
  "same number of blocks. If the the data has multiple time steps, the\n"
  "user can specify the name of the time array then reader will use it\n"
  "to calculate the number of time steps. By default we flips the\n"
  "dimensions as vtk data array uses column major order whereas adios2\n"
  "uses row major order. Check IsColumnMajor flag for more details. This\n"
  "reader can be launched either in serial or parallel. // TODO: Expose\n"
  "attribute info in PV GUI.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkADIOS2CoreImageReader_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOADIOS2.vtkADIOS2CoreImageReader", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkADIOS2CoreImageReader_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkADIOS2CoreImageReader_StaticNew()
{
  return vtkADIOS2CoreImageReader::New();
}

PyObject *PyvtkADIOS2CoreImageReader_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkADIOS2CoreImageReader_Type, PyvtkADIOS2CoreImageReader_Methods,
    "vtkADIOS2CoreImageReader",
 &PyvtkADIOS2CoreImageReader_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkDataObjectAlgorithm");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkADIOS2CoreImageReader_VarType_Type);
  // members of vtkADIOS2CoreImageReader::VarType
  {
    PyObject *enumval;
    PyObject *enumdict = PyDict_New();
    PyvtkADIOS2CoreImageReader_VarType_Type.tp_dict = enumdict;

    typedef vtkADIOS2CoreImageReader::VarType cxx_enum_type;
    static const struct {
      const char *name; cxx_enum_type value;
    } constants[2] = {
      { "PointData", cxx_enum_type::PointData },
      { "CellData", cxx_enum_type::CellData },
    };

    for (int c = 0; c < 2; c++)
    {
      enumval = PyvtkADIOS2CoreImageReader_VarType_FromEnum(constants[c].value);
      if (enumval)
      {
        PyDict_SetItemString(enumdict, constants[c].name, enumval);
        Py_DECREF(enumval);
      }
    }
  }

  PyVTKEnum_Add(&PyvtkADIOS2CoreImageReader_VarType_Type, "vtkADIOS2CoreImageReader.VarType");

  o = (PyObject *)&PyvtkADIOS2CoreImageReader_VarType_Type;
  if (PyDict_SetItemString(d, "VarType", o) != 0)
  {
    Py_DECREF(o);
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkADIOS2CoreImageReader_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkADIOS2CoreImageReader(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkADIOS2CoreImageReader_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkADIOS2CoreImageReader", o) != 0)
  {
    Py_DECREF(o);
  }

}

