// python wrapper for vtkXdmf3ArraySelection
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkXdmf3ArraySelection.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkXdmf3ArraySelection(PyObject *dict); }

static PyObject *
PyvtkXdmf3ArraySelection_Merge(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Merge");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkXdmf3ArraySelection *op = static_cast<vtkXdmf3ArraySelection *>(vp);

  vtkXdmf3ArraySelection *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkXdmf3ArraySelection"))
  {
    op->Merge(*temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj0);

  return result;
}


static PyObject *
PyvtkXdmf3ArraySelection_AddArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddArray");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkXdmf3ArraySelection *op = static_cast<vtkXdmf3ArraySelection *>(vp);

  const char *temp0 = nullptr;
  bool temp1 = true;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    op->AddArray(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3ArraySelection_ArrayIsEnabled(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ArrayIsEnabled");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkXdmf3ArraySelection *op = static_cast<vtkXdmf3ArraySelection *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = op->ArrayIsEnabled(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3ArraySelection_HasArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasArray");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkXdmf3ArraySelection *op = static_cast<vtkXdmf3ArraySelection *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = op->HasArray(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3ArraySelection_SetArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetArrayStatus");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkXdmf3ArraySelection *op = static_cast<vtkXdmf3ArraySelection *>(vp);

  const char *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    op->SetArrayStatus(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3ArraySelection_GetArraySetting(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetArraySetting");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkXdmf3ArraySelection *op = static_cast<vtkXdmf3ArraySelection *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = op->GetArraySetting(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3ArraySelection_GetArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetArrayName");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkXdmf3ArraySelection *op = static_cast<vtkXdmf3ArraySelection *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = op->GetArrayName(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3ArraySelection_GetNumberOfArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfArrays");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkXdmf3ArraySelection *op = static_cast<vtkXdmf3ArraySelection *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = op->GetNumberOfArrays();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkXdmf3ArraySelection_Methods[] = {
  {"Merge", PyvtkXdmf3ArraySelection_Merge, METH_VARARGS,
   "Merge(self, other:vtkXdmf3ArraySelection) -> None\nC++: void Merge(const vtkXdmf3ArraySelection &other)\n\nused in parallel to send of combine sets\n"},
  {"AddArray", PyvtkXdmf3ArraySelection_AddArray, METH_VARARGS,
   "AddArray(self, name:str, status:bool=True) -> None\nC++: void AddArray(const char *name, bool status=true)\n\nadd a new array to the set, with a particular status\n"},
  {"ArrayIsEnabled", PyvtkXdmf3ArraySelection_ArrayIsEnabled, METH_VARARGS,
   "ArrayIsEnabled(self, name:str) -> bool\nC++: bool ArrayIsEnabled(const char *name)\n\ntest if a particular array is enablled or not\n"},
  {"HasArray", PyvtkXdmf3ArraySelection_HasArray, METH_VARARGS,
   "HasArray(self, name:str) -> bool\nC++: bool HasArray(const char *name)\n\ncheck if a particular array is in the set yet or not\n"},
  {"SetArrayStatus", PyvtkXdmf3ArraySelection_SetArrayStatus, METH_VARARGS,
   "SetArrayStatus(self, name:str, status:bool) -> None\nC++: void SetArrayStatus(const char *name, bool status)\n\nget/set user choice of whether a particular array is to be loaded\n"},
  {"GetArraySetting", PyvtkXdmf3ArraySelection_GetArraySetting, METH_VARARGS,
   "GetArraySetting(self, name:str) -> int\nC++: int GetArraySetting(const char *name)\n\n"},
  {"GetArrayName", PyvtkXdmf3ArraySelection_GetArrayName, METH_VARARGS,
   "GetArrayName(self, index:int) -> str\nC++: const char *GetArrayName(int index)\n\nget string name of a particular array\n"},
  {"GetNumberOfArrays", PyvtkXdmf3ArraySelection_GetNumberOfArrays, METH_VARARGS,
   "GetNumberOfArrays(self) -> int\nC++: int GetNumberOfArrays()\n\nget number of arrays in the set\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkXdmf3ArraySelection_GetSets[] = {
  {
    /*name=*/pystr("number_of_arrays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkXdmf3ArraySelection_GetNumberOfArrays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfArrays\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};

static PyObject *
PyvtkXdmf3ArraySelection_vtkXdmf3ArraySelection_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkXdmf3ArraySelection");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkXdmf3ArraySelection *op = new vtkXdmf3ArraySelection();

    result = PyVTKSpecialObject_New("vtkXdmf3ArraySelection", op);
  }

  return result;
}

static PyObject *
PyvtkXdmf3ArraySelection_vtkXdmf3ArraySelection_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkXdmf3ArraySelection");

  vtkXdmf3ArraySelection *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkXdmf3ArraySelection"))
  {
    vtkXdmf3ArraySelection *op = new vtkXdmf3ArraySelection(*temp0);

    result = PyVTKSpecialObject_New("vtkXdmf3ArraySelection", op);
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyMethodDef PyvtkXdmf3ArraySelection_vtkXdmf3ArraySelection_Methods[] = {
  {"vtkXdmf3ArraySelection", PyvtkXdmf3ArraySelection_vtkXdmf3ArraySelection_s2, METH_VARARGS,
   "@W vtkXdmf3ArraySelection"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkXdmf3ArraySelection_vtkXdmf3ArraySelection(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 0:
      return PyvtkXdmf3ArraySelection_vtkXdmf3ArraySelection_s1(self, args);
    case 1:
      return PyvtkXdmf3ArraySelection_vtkXdmf3ArraySelection_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "vtkXdmf3ArraySelection");
  return nullptr;
}


static const char *PyvtkXdmf3ArraySelection_Doc =

  "vtkXdmf3ArraySelection() -> vtkXdmf3ArraySelection\nC++: vtkXdmf3ArraySelection()\nvtkXdmf3ArraySelection(__a:vtkXdmf3ArraySelection)\n    -> vtkXdmf3ArraySelection\nC++: vtkXdmf3ArraySelection(const &vtkXdmf3ArraySelection)\n""\n"
  "vtkXdmf3ArraySelection - helper to identify requested arrays with\n\n"
  "Used by ParaView GUI to mark arrays, sets, and blocks that reader can\n"
  "optionally read in. Note: we use it for more than just arrays but\n"
  "Paraview code requires \"Array\" name in the API.\n\n"
  "This file is a helper for the vtkXdmf3Reader and not intended to be\n"
  "part of VTK public API\n\n";

static PyObject *
PyvtkXdmf3ArraySelection_New(PyTypeObject *, PyObject *args, PyObject *kwds)
{
  if (kwds && PyDict_Size(kwds))
  {
    PyErr_SetString(PyExc_TypeError,
                    "this function takes no keyword arguments");
    return nullptr;
  }

  return PyvtkXdmf3ArraySelection_vtkXdmf3ArraySelection(nullptr, args);
}

static void PyvtkXdmf3ArraySelection_Delete(PyObject *self)
{
  PyVTKSpecialObject *obj = (PyVTKSpecialObject *)self;
  delete static_cast<vtkXdmf3ArraySelection *>(obj->vtk_ptr);
  PyObject_Del(self);
}

static Py_hash_t PyvtkXdmf3ArraySelection_Hash(PyObject *self)
{
  return PyObject_HashNotImplemented(self);
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkXdmf3ArraySelection_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOXdmf3.vtkXdmf3ArraySelection", // tp_name
  sizeof(PyVTKSpecialObject), // tp_basicsize
  0, // tp_itemsize
  PyvtkXdmf3ArraySelection_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKSpecialObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  PyvtkXdmf3ArraySelection_Hash, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT, // tp_flags
  PyvtkXdmf3ArraySelection_Doc, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  PyvtkXdmf3ArraySelection_New, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static void *PyvtkXdmf3ArraySelection_CCopy(const void *obj)
{
  if (obj)
  {
    return new vtkXdmf3ArraySelection(*static_cast<const vtkXdmf3ArraySelection*>(obj));
  }
  return nullptr;
}

#ifndef DECLARED_PyvtkXdmf3ArraySelection_TypeNew
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkXdmf3ArraySelection_TypeNew(); }
#define DECLARED_PyvtkXdmf3ArraySelection_TypeNew
#endif

PyObject *PyvtkXdmf3ArraySelection_TypeNew()
{
  PyTypeObject *pytype = PyVTKSpecialType_Add(
    &PyvtkXdmf3ArraySelection_Type,
    PyvtkXdmf3ArraySelection_Methods,
    PyvtkXdmf3ArraySelection_GetSets,
    PyvtkXdmf3ArraySelection_vtkXdmf3ArraySelection_Methods,
    &PyvtkXdmf3ArraySelection_CCopy);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkXdmf3ArraySelection(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkXdmf3ArraySelection_TypeNew();

  if (o && PyDict_SetItemString(dict, "vtkXdmf3ArraySelection", o) != 0)
  {
    Py_DECREF(o);
  }

}

