// python wrapper for vtkPPainterCommunicator
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkPPainterCommunicator.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPPainterCommunicator(PyObject *dict); }

static PyObject *
PyvtkPPainterCommunicator_GetRank(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRank");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPainterCommunicator *op = static_cast<vtkPPainterCommunicator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = op->GetRank();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPPainterCommunicator_GetSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSize");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPainterCommunicator *op = static_cast<vtkPPainterCommunicator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = op->GetSize();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPPainterCommunicator_GetIsNull(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIsNull");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPainterCommunicator *op = static_cast<vtkPPainterCommunicator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = op->GetIsNull();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPPainterCommunicator_GetWorldRank(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWorldRank");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPainterCommunicator *op = static_cast<vtkPPainterCommunicator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = op->GetWorldRank();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPPainterCommunicator_GetWorldSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWorldSize");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPainterCommunicator *op = static_cast<vtkPPainterCommunicator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = op->GetWorldSize();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPPainterCommunicator_GetMPIInitialized(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMPIInitialized");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPainterCommunicator *op = static_cast<vtkPPainterCommunicator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = op->GetMPIInitialized();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPPainterCommunicator_GetMPIFinalized(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMPIFinalized");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPainterCommunicator *op = static_cast<vtkPPainterCommunicator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = op->GetMPIFinalized();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPPainterCommunicator_MPIInitialized(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "MPIInitialized");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    bool tempr = vtkPPainterCommunicator::MPIInitialized();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPPainterCommunicator_MPIFinalized(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "MPIFinalized");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    bool tempr = vtkPPainterCommunicator::MPIFinalized();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPPainterCommunicator_SetCommunicator(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCommunicator");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPainterCommunicator *op = static_cast<vtkPPainterCommunicator *>(vp);

  vtkMPICommunicatorOpaqueComm *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMPICommunicatorOpaqueComm"))
  {
    op->SetCommunicator(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPPainterCommunicator_GetCommunicator_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCommunicator");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPainterCommunicator *op = static_cast<vtkPPainterCommunicator *>(vp);

  vtkMPICommunicatorOpaqueComm *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMPICommunicatorOpaqueComm"))
  {
    op->GetCommunicator(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPPainterCommunicator_GetCommunicator_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCommunicator");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPainterCommunicator *op = static_cast<vtkPPainterCommunicator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    void  *tempr = op->GetCommunicator();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkPPainterCommunicator_GetCommunicator(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 1:
      return PyvtkPPainterCommunicator_GetCommunicator_s1(self, args);
    case 0:
      return PyvtkPPainterCommunicator_GetCommunicator_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetCommunicator");
  return nullptr;
}


static PyObject *
PyvtkPPainterCommunicator_SubsetCommunicator(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SubsetCommunicator");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPainterCommunicator *op = static_cast<vtkPPainterCommunicator *>(vp);

  vtkMPICommunicatorOpaqueComm *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkMPICommunicatorOpaqueComm") &&
      ap.GetValue(temp1))
  {
    op->SubsetCommunicator(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPPainterCommunicator_GetGlobalCommunicator(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetGlobalCommunicator");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkMPICommunicatorOpaqueComm *tempr = vtkPPainterCommunicator::GetGlobalCommunicator();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPPainterCommunicator_Methods[] = {
  {"GetRank", PyvtkPPainterCommunicator_GetRank, METH_VARARGS,
   "GetRank(self) -> int\nC++: int GetRank() override;\n\nQuery MPI for information about the communicator.\n"},
  {"GetSize", PyvtkPPainterCommunicator_GetSize, METH_VARARGS,
   "GetSize(self) -> int\nC++: int GetSize() override;\n\n"},
  {"GetIsNull", PyvtkPPainterCommunicator_GetIsNull, METH_VARARGS,
   "GetIsNull(self) -> bool\nC++: bool GetIsNull() override;\n\n"},
  {"GetWorldRank", PyvtkPPainterCommunicator_GetWorldRank, METH_VARARGS,
   "GetWorldRank(self) -> int\nC++: int GetWorldRank() override;\n\nQuery MPI for information about the world communicator.\n"},
  {"GetWorldSize", PyvtkPPainterCommunicator_GetWorldSize, METH_VARARGS,
   "GetWorldSize(self) -> int\nC++: int GetWorldSize() override;\n\n"},
  {"GetMPIInitialized", PyvtkPPainterCommunicator_GetMPIInitialized, METH_VARARGS,
   "GetMPIInitialized(self) -> bool\nC++: bool GetMPIInitialized() override;\n\nQuery MPI state.\n"},
  {"GetMPIFinalized", PyvtkPPainterCommunicator_GetMPIFinalized, METH_VARARGS,
   "GetMPIFinalized(self) -> bool\nC++: bool GetMPIFinalized() override;\n\n"},
  {"MPIInitialized", PyvtkPPainterCommunicator_MPIInitialized, METH_VARARGS,
   "MPIInitialized() -> bool\nC++: static bool MPIInitialized()\n\n"},
  {"MPIFinalized", PyvtkPPainterCommunicator_MPIFinalized, METH_VARARGS,
   "MPIFinalized() -> bool\nC++: static bool MPIFinalized()\n\n"},
  {"SetCommunicator", PyvtkPPainterCommunicator_SetCommunicator, METH_VARARGS,
   "SetCommunicator(self, comm:vtkMPICommunicatorOpaqueComm) -> None\nC++: void SetCommunicator(vtkMPICommunicatorOpaqueComm *comm)\n\nSet/Get the communicator. Ownership is not assumed thus caller\nmust keep the commuicator alive while this class is in use and\nfree the communicator when finished.\n"},
  {"GetCommunicator", PyvtkPPainterCommunicator_GetCommunicator, METH_VARARGS,
   "GetCommunicator(self, comm:vtkMPICommunicatorOpaqueComm) -> None\nC++: void GetCommunicator(vtkMPICommunicatorOpaqueComm *comm)\nGetCommunicator(self) -> Pointer\nC++: void *GetCommunicator()\n\n"},
  {"SubsetCommunicator", PyvtkPPainterCommunicator_SubsetCommunicator, METH_VARARGS,
   "SubsetCommunicator(self, comm:vtkMPICommunicatorOpaqueComm,\n    include:int) -> None\nC++: void SubsetCommunicator(vtkMPICommunicatorOpaqueComm *comm,\n    int include)\n\nCreates a new communicator with/without the calling processes as\nindicated by the passed in flag, if not 0 the calling process is\nincluded in the new communicator. The new communicator is\naccessed via GetCommunicator. In parallel this call is mpi\ncollective on the world communicator. In serial this is a no-op.\n"},
  {"GetGlobalCommunicator", PyvtkPPainterCommunicator_GetGlobalCommunicator, METH_VARARGS,
   "GetGlobalCommunicator() -> vtkMPICommunicatorOpaqueComm\nC++: static vtkMPICommunicatorOpaqueComm *GetGlobalCommunicator()\n\nGet VTK's world communicator. Return's a null communictor if MPI\nwas not yet initialized.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPPainterCommunicator_GetSets[] = {
  {
    /*name=*/pystr("communicator"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPPainterCommunicator_SetCommunicator(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPPainterCommunicator_SetCommunicator(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCommunicator\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("rank"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPPainterCommunicator_GetRank(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRank\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPPainterCommunicator_GetSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("is_null"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPPainterCommunicator_GetIsNull(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetIsNull\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("world_rank"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPPainterCommunicator_GetWorldRank(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetWorldRank\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("world_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPPainterCommunicator_GetWorldSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetWorldSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("mpi_initialized"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPPainterCommunicator_GetMPIInitialized(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMPIInitialized\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("mpi_finalized"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPPainterCommunicator_GetMPIFinalized(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMPIFinalized\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("communicator"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPPainterCommunicator_GetCommunicator(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetCommunicator\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("global_communicator"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPPainterCommunicator_GetGlobalCommunicator(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetGlobalCommunicator\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};

static PyObject *
PyvtkPPainterCommunicator_vtkPPainterCommunicator_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkPPainterCommunicator");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkPPainterCommunicator *op = new vtkPPainterCommunicator();

    result = PyVTKSpecialObject_New("vtkPPainterCommunicator", op);
  }

  return result;
}

static PyObject *
PyvtkPPainterCommunicator_vtkPPainterCommunicator_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkPPainterCommunicator");

  vtkPPainterCommunicator *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkPPainterCommunicator"))
  {
    vtkPPainterCommunicator *op = new vtkPPainterCommunicator(*temp0);

    result = PyVTKSpecialObject_New("vtkPPainterCommunicator", op);
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyMethodDef PyvtkPPainterCommunicator_vtkPPainterCommunicator_Methods[] = {
  {"vtkPPainterCommunicator", PyvtkPPainterCommunicator_vtkPPainterCommunicator_s2, METH_VARARGS,
   "@W vtkPPainterCommunicator"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkPPainterCommunicator_vtkPPainterCommunicator(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 0:
      return PyvtkPPainterCommunicator_vtkPPainterCommunicator_s1(self, args);
    case 1:
      return PyvtkPPainterCommunicator_vtkPPainterCommunicator_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "vtkPPainterCommunicator");
  return nullptr;
}


static const char *PyvtkPPainterCommunicator_Doc =

  "vtkPPainterCommunicator() -> vtkPPainterCommunicator\nC++: vtkPPainterCommunicator()\nvtkPPainterCommunicator(other:vtkPPainterCommunicator)\n    -> vtkPPainterCommunicator\nC++: vtkPPainterCommunicator(const vtkPPainterCommunicator &other)\n""\n"
  "vtkPPainterCommunicator - no description provided.\n\n"
  "Superclass: vtkPainterCommunicator\n\n"
;

static PyObject *
PyvtkPPainterCommunicator_New(PyTypeObject *, PyObject *args, PyObject *kwds)
{
  if (kwds && PyDict_Size(kwds))
  {
    PyErr_SetString(PyExc_TypeError,
                    "this function takes no keyword arguments");
    return nullptr;
  }

  return PyvtkPPainterCommunicator_vtkPPainterCommunicator(nullptr, args);
}

static void PyvtkPPainterCommunicator_Delete(PyObject *self)
{
  PyVTKSpecialObject *obj = (PyVTKSpecialObject *)self;
  delete static_cast<vtkPPainterCommunicator *>(obj->vtk_ptr);
  PyObject_Del(self);
}

static Py_hash_t PyvtkPPainterCommunicator_Hash(PyObject *self)
{
  return PyObject_HashNotImplemented(self);
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPPainterCommunicator_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingParallelLIC.vtkPPainterCommunicator", // tp_name
  sizeof(PyVTKSpecialObject), // tp_basicsize
  0, // tp_itemsize
  PyvtkPPainterCommunicator_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKSpecialObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  PyvtkPPainterCommunicator_Hash, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT, // tp_flags
  PyvtkPPainterCommunicator_Doc, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  PyvtkPPainterCommunicator_New, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static void *PyvtkPPainterCommunicator_CCopy(const void *obj)
{
  if (obj)
  {
    return new vtkPPainterCommunicator(*static_cast<const vtkPPainterCommunicator*>(obj));
  }
  return nullptr;
}

#ifndef DECLARED_PyvtkPPainterCommunicator_TypeNew
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPPainterCommunicator_TypeNew(); }
#define DECLARED_PyvtkPPainterCommunicator_TypeNew
#endif

PyObject *PyvtkPPainterCommunicator_TypeNew()
{
  PyTypeObject *pytype = PyVTKSpecialType_Add(
    &PyvtkPPainterCommunicator_Type,
    PyvtkPPainterCommunicator_Methods,
    PyvtkPPainterCommunicator_GetSets,
    PyvtkPPainterCommunicator_vtkPPainterCommunicator_Methods,
    &PyvtkPPainterCommunicator_CCopy);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindSpecialTypeObject("vtkPainterCommunicator");

  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPPainterCommunicator(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPPainterCommunicator_TypeNew();

  if (o && PyDict_SetItemString(dict, "vtkPPainterCommunicator", o) != 0)
  {
    Py_DECREF(o);
  }

}

