// python wrapper for vtkOSPRayRendererNode
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkOSPRayRendererNode.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkOSPRayRendererNode(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkOSPRayRendererNode_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkOSPRayRendererNode_BackgroundMode_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingRayTracing.vtkOSPRayRendererNode.BackgroundMode", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkOSPRayRendererNode_BackgroundMode_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkOSPRayRendererNode_BackgroundMode_Type, static_cast<int>(val));
}


static PyObject *
PyvtkOSPRayRendererNode_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkOSPRayRendererNode::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayRendererNode *op = static_cast<vtkOSPRayRendererNode *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkOSPRayRendererNode::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkOSPRayRendererNode *tempr = vtkOSPRayRendererNode::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayRendererNode *op = static_cast<vtkOSPRayRendererNode *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkOSPRayRendererNode *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkOSPRayRendererNode::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkOSPRayRendererNode::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayRendererNode *op = static_cast<vtkOSPRayRendererNode *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkOSPRayRendererNode::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_Build(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Build");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayRendererNode *op = static_cast<vtkOSPRayRendererNode *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Build(temp0);
    }
    else
    {
      op->vtkOSPRayRendererNode::Build(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_Render(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Render");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayRendererNode *op = static_cast<vtkOSPRayRendererNode *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Render(temp0);
    }
    else
    {
      op->vtkOSPRayRendererNode::Render(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_Invalidate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Invalidate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayRendererNode *op = static_cast<vtkOSPRayRendererNode *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Invalidate(temp0);
    }
    else
    {
      op->vtkOSPRayRendererNode::Invalidate(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_WriteLayer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteLayer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayRendererNode *op = static_cast<vtkOSPRayRendererNode *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<unsigned char> store0(2*size0);
  unsigned char *temp0 = store0.Data();
  unsigned char *save0 = (size0 == 0 ? nullptr : temp0 + size0);
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<float> store1(2*size1);
  float *temp1 = store1.Data();
  float *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  int temp2;
  int temp3;
  int temp4;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetArray(temp0, size0) &&
      ap.GetArray(temp1, size1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    vtkPythonArgs::Save(temp0, save0, size0);
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->WriteLayer(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkOSPRayRendererNode::WriteLayer(temp0, temp1, temp2, temp3, temp4);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_SAMPLES_PER_PIXEL(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SAMPLES_PER_PIXEL");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationIntegerKey *tempr = vtkOSPRayRendererNode::SAMPLES_PER_PIXEL();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_SetSamplesPerPixel(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetSamplesPerPixel");

  int temp0;
  vtkRenderer *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkRenderer"))
  {
    vtkOSPRayRendererNode::SetSamplesPerPixel(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_GetSamplesPerPixel(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetSamplesPerPixel");

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    int tempr = vtkOSPRayRendererNode::GetSamplesPerPixel(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_MAX_CONTRIBUTION(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "MAX_CONTRIBUTION");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationDoubleKey *tempr = vtkOSPRayRendererNode::MAX_CONTRIBUTION();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_SetMaxContribution(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetMaxContribution");

  double temp0;
  vtkRenderer *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkRenderer"))
  {
    vtkOSPRayRendererNode::SetMaxContribution(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_GetMaxContribution(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetMaxContribution");

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    double tempr = vtkOSPRayRendererNode::GetMaxContribution(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_MAX_DEPTH(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "MAX_DEPTH");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationIntegerKey *tempr = vtkOSPRayRendererNode::MAX_DEPTH();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_SetMaxDepth(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetMaxDepth");

  int temp0;
  vtkRenderer *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkRenderer"))
  {
    vtkOSPRayRendererNode::SetMaxDepth(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_GetMaxDepth(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetMaxDepth");

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    int tempr = vtkOSPRayRendererNode::GetMaxDepth(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_MIN_CONTRIBUTION(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "MIN_CONTRIBUTION");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationDoubleKey *tempr = vtkOSPRayRendererNode::MIN_CONTRIBUTION();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_SetMinContribution(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetMinContribution");

  double temp0;
  vtkRenderer *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkRenderer"))
  {
    vtkOSPRayRendererNode::SetMinContribution(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_GetMinContribution(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetMinContribution");

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    double tempr = vtkOSPRayRendererNode::GetMinContribution(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_ROULETTE_DEPTH(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "ROULETTE_DEPTH");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationIntegerKey *tempr = vtkOSPRayRendererNode::ROULETTE_DEPTH();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_SetRouletteDepth(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetRouletteDepth");

  int temp0;
  vtkRenderer *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkRenderer"))
  {
    vtkOSPRayRendererNode::SetRouletteDepth(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_GetRouletteDepth(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetRouletteDepth");

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    int tempr = vtkOSPRayRendererNode::GetRouletteDepth(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_VARIANCE_THRESHOLD(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "VARIANCE_THRESHOLD");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationDoubleKey *tempr = vtkOSPRayRendererNode::VARIANCE_THRESHOLD();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_SetVarianceThreshold(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetVarianceThreshold");

  double temp0;
  vtkRenderer *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkRenderer"))
  {
    vtkOSPRayRendererNode::SetVarianceThreshold(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_GetVarianceThreshold(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetVarianceThreshold");

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    double tempr = vtkOSPRayRendererNode::GetVarianceThreshold(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_MAX_FRAMES(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "MAX_FRAMES");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationIntegerKey *tempr = vtkOSPRayRendererNode::MAX_FRAMES();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_SetMaxFrames(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetMaxFrames");

  int temp0;
  vtkRenderer *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkRenderer"))
  {
    vtkOSPRayRendererNode::SetMaxFrames(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_GetMaxFrames(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetMaxFrames");

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    int tempr = vtkOSPRayRendererNode::GetMaxFrames(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_RENDERER_TYPE(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RENDERER_TYPE");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationStringKey *tempr = vtkOSPRayRendererNode::RENDERER_TYPE();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_SetRendererType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetRendererType");

  std::string temp0;
  vtkRenderer *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkRenderer"))
  {
    vtkOSPRayRendererNode::SetRendererType(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_GetRendererType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetRendererType");

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    std::string tempr = vtkOSPRayRendererNode::GetRendererType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_AMBIENT_SAMPLES(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "AMBIENT_SAMPLES");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationIntegerKey *tempr = vtkOSPRayRendererNode::AMBIENT_SAMPLES();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_SetAmbientSamples(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetAmbientSamples");

  int temp0;
  vtkRenderer *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkRenderer"))
  {
    vtkOSPRayRendererNode::SetAmbientSamples(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_GetAmbientSamples(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetAmbientSamples");

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    int tempr = vtkOSPRayRendererNode::GetAmbientSamples(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_VOLUME_SAMPLING_RATE(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "VOLUME_SAMPLING_RATE");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationDoubleKey *tempr = vtkOSPRayRendererNode::VOLUME_SAMPLING_RATE();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_SetVolumeSamplingRate(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetVolumeSamplingRate");

  double temp0;
  vtkRenderer *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkRenderer"))
  {
    vtkOSPRayRendererNode::SetVolumeSamplingRate(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_GetVolumeSamplingRate(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetVolumeSamplingRate");

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    double tempr = vtkOSPRayRendererNode::GetVolumeSamplingRate(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_COMPOSITE_ON_GL(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "COMPOSITE_ON_GL");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationIntegerKey *tempr = vtkOSPRayRendererNode::COMPOSITE_ON_GL();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_SetCompositeOnGL(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetCompositeOnGL");

  int temp0;
  vtkRenderer *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkRenderer"))
  {
    vtkOSPRayRendererNode::SetCompositeOnGL(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_GetCompositeOnGL(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetCompositeOnGL");

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    int tempr = vtkOSPRayRendererNode::GetCompositeOnGL(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_NORTH_POLE(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "NORTH_POLE");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationDoubleVectorKey *tempr = vtkOSPRayRendererNode::NORTH_POLE();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_SetNorthPole(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetNorthPole");

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<double> store0(2*size0);
  double *temp0 = store0.Data();
  double *save0 = (size0 == 0 ? nullptr : temp0 + size0);
  vtkRenderer *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetVTKObject(temp1, "vtkRenderer"))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    vtkOSPRayRendererNode::SetNorthPole(temp0, temp1);

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_GetNorthPole(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNorthPole");

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    double *tempr = vtkOSPRayRendererNode::GetNorthPole(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_EAST_POLE(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "EAST_POLE");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationDoubleVectorKey *tempr = vtkOSPRayRendererNode::EAST_POLE();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_SetEastPole(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetEastPole");

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<double> store0(2*size0);
  double *temp0 = store0.Data();
  double *save0 = (size0 == 0 ? nullptr : temp0 + size0);
  vtkRenderer *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetVTKObject(temp1, "vtkRenderer"))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    vtkOSPRayRendererNode::SetEastPole(temp0, temp1);

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_GetEastPole(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetEastPole");

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    double *tempr = vtkOSPRayRendererNode::GetEastPole(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_MATERIAL_LIBRARY(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "MATERIAL_LIBRARY");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationObjectBaseKey *tempr = vtkOSPRayRendererNode::MATERIAL_LIBRARY();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_SetMaterialLibrary(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetMaterialLibrary");

  vtkOSPRayMaterialLibrary *temp0 = nullptr;
  vtkRenderer *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkOSPRayMaterialLibrary") &&
      ap.GetVTKObject(temp1, "vtkRenderer"))
  {
    vtkOSPRayRendererNode::SetMaterialLibrary(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_GetMaterialLibrary(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetMaterialLibrary");

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    vtkOSPRayMaterialLibrary *tempr = vtkOSPRayRendererNode::GetMaterialLibrary(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_VIEW_TIME(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "VIEW_TIME");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationDoubleKey *tempr = vtkOSPRayRendererNode::VIEW_TIME();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_SetViewTime(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetViewTime");

  double temp0;
  vtkRenderer *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkRenderer"))
  {
    vtkOSPRayRendererNode::SetViewTime(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_GetViewTime(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetViewTime");

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    double tempr = vtkOSPRayRendererNode::GetViewTime(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_TIME_CACHE_SIZE(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "TIME_CACHE_SIZE");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationIntegerKey *tempr = vtkOSPRayRendererNode::TIME_CACHE_SIZE();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_SetTimeCacheSize(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetTimeCacheSize");

  int temp0;
  vtkRenderer *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkRenderer"))
  {
    vtkOSPRayRendererNode::SetTimeCacheSize(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_GetTimeCacheSize(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetTimeCacheSize");

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    int tempr = vtkOSPRayRendererNode::GetTimeCacheSize(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_GetBuffer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBuffer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayRendererNode *op = static_cast<vtkOSPRayRendererNode *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    void  *tempr = (ap.IsBound() ?
      op->GetBuffer() :
      op->vtkOSPRayRendererNode::GetBuffer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_GetZBuffer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetZBuffer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayRendererNode *op = static_cast<vtkOSPRayRendererNode *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float *tempr = (ap.IsBound() ?
      op->GetZBuffer() :
      op->vtkOSPRayRendererNode::GetZBuffer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_GetColorBufferTextureGL(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetColorBufferTextureGL");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayRendererNode *op = static_cast<vtkOSPRayRendererNode *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetColorBufferTextureGL() :
      op->vtkOSPRayRendererNode::GetColorBufferTextureGL());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_GetDepthBufferTextureGL(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDepthBufferTextureGL");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayRendererNode *op = static_cast<vtkOSPRayRendererNode *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDepthBufferTextureGL() :
      op->vtkOSPRayRendererNode::GetDepthBufferTextureGL());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_Traverse(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Traverse");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayRendererNode *op = static_cast<vtkOSPRayRendererNode *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Traverse(temp0);
    }
    else
    {
      op->vtkOSPRayRendererNode::Traverse(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_GetRendererNode(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetRendererNode");

  vtkViewNode *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkViewNode"))
  {
    vtkOSPRayRendererNode *tempr = vtkOSPRayRendererNode::GetRendererNode(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_GetRenderer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRenderer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayRendererNode *op = static_cast<vtkOSPRayRendererNode *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkRenderer *tempr = (ap.IsBound() ?
      op->GetRenderer() :
      op->vtkOSPRayRendererNode::GetRenderer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_DENOISER_THRESHOLD(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "DENOISER_THRESHOLD");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationIntegerKey *tempr = vtkOSPRayRendererNode::DENOISER_THRESHOLD();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_SetDenoiserThreshold(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetDenoiserThreshold");

  int temp0;
  vtkRenderer *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkRenderer"))
  {
    vtkOSPRayRendererNode::SetDenoiserThreshold(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_GetDenoiserThreshold(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetDenoiserThreshold");

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    int tempr = vtkOSPRayRendererNode::GetDenoiserThreshold(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_ENABLE_DENOISER(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "ENABLE_DENOISER");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationIntegerKey *tempr = vtkOSPRayRendererNode::ENABLE_DENOISER();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_SetEnableDenoiser(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetEnableDenoiser");

  int temp0;
  vtkRenderer *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkRenderer"))
  {
    vtkOSPRayRendererNode::SetEnableDenoiser(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_GetEnableDenoiser(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetEnableDenoiser");

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    int tempr = vtkOSPRayRendererNode::GetEnableDenoiser(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_BACKGROUND_MODE(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "BACKGROUND_MODE");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationIntegerKey *tempr = vtkOSPRayRendererNode::BACKGROUND_MODE();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_SetBackgroundMode(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetBackgroundMode");

  typedef vtkOSPRayRendererNode::BackgroundMode temp0_type;
  temp0_type temp0;
  vtkRenderer *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetEnumValue(temp0, "vtkOSPRayRendererNode.BackgroundMode") &&
      ap.GetVTKObject(temp1, "vtkRenderer"))
  {
    vtkOSPRayRendererNode::SetBackgroundMode(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayRendererNode_GetBackgroundMode(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetBackgroundMode");

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    typedef vtkOSPRayRendererNode::BackgroundMode tempr_type;
  tempr_type tempr = vtkOSPRayRendererNode::GetBackgroundMode(temp0);

    if (!ap.ErrorOccurred())
    {
      result = PyvtkOSPRayRendererNode_BackgroundMode_FromEnum(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkOSPRayRendererNode_Methods[] = {
  {"IsTypeOf", PyvtkOSPRayRendererNode_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkOSPRayRendererNode_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkOSPRayRendererNode_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkOSPRayRendererNode\nC++: static vtkOSPRayRendererNode *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkOSPRayRendererNode_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkOSPRayRendererNode\nC++: vtkOSPRayRendererNode *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkOSPRayRendererNode_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkOSPRayRendererNode_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Build", PyvtkOSPRayRendererNode_Build, METH_VARARGS,
   "Build(self, prepass:bool) -> None\nC++: void Build(bool prepass) override;\n\nBuilds myself.\n"},
  {"Render", PyvtkOSPRayRendererNode_Render, METH_VARARGS,
   "Render(self, prepass:bool) -> None\nC++: void Render(bool prepass) override;\n\nTraverse graph in ospray's preferred order and render\n"},
  {"Invalidate", PyvtkOSPRayRendererNode_Invalidate, METH_VARARGS,
   "Invalidate(self, prepass:bool) -> None\nC++: void Invalidate(bool prepass) override;\n\nInvalidates cached rendering data.\n"},
  {"WriteLayer", PyvtkOSPRayRendererNode_WriteLayer, METH_VARARGS,
   "WriteLayer(self, buffer:[int, ...], zbuffer:[float, ...],\n    buffx:int, buffy:int, layer:int) -> None\nC++: virtual void WriteLayer(unsigned char *buffer,\n    float *zbuffer, int buffx, int buffy, int layer)\n\nPut my results into the correct place in the provided pixel\nbuffer.\n"},
  {"SAMPLES_PER_PIXEL", PyvtkOSPRayRendererNode_SAMPLES_PER_PIXEL, METH_VARARGS,
   "SAMPLES_PER_PIXEL() -> vtkInformationIntegerKey\nC++: static vtkInformationIntegerKey *SAMPLES_PER_PIXEL()\n\nWhen present on renderer, controls the number of primary rays\nshot per pixel default is 1\\ingroup InformationKeys\n"},
  {"SetSamplesPerPixel", PyvtkOSPRayRendererNode_SetSamplesPerPixel, METH_VARARGS,
   "SetSamplesPerPixel(__a:int, renderer:vtkRenderer) -> None\nC++: static void SetSamplesPerPixel(int, vtkRenderer *renderer)\n\nConvenience method to set/get SAMPLES_PER_PIXEL on a vtkRenderer.\n"},
  {"GetSamplesPerPixel", PyvtkOSPRayRendererNode_GetSamplesPerPixel, METH_VARARGS,
   "GetSamplesPerPixel(renderer:vtkRenderer) -> int\nC++: static int GetSamplesPerPixel(vtkRenderer *renderer)\n\n"},
  {"MAX_CONTRIBUTION", PyvtkOSPRayRendererNode_MAX_CONTRIBUTION, METH_VARARGS,
   "MAX_CONTRIBUTION() -> vtkInformationDoubleKey\nC++: static vtkInformationDoubleKey *MAX_CONTRIBUTION()\n\nWhen present on renderer, samples are clamped to this value\nbefore they are accumulated into the framebuffer default is\n2.0\\ingroup InformationKeys\n"},
  {"SetMaxContribution", PyvtkOSPRayRendererNode_SetMaxContribution, METH_VARARGS,
   "SetMaxContribution(__a:float, renderer:vtkRenderer) -> None\nC++: static void SetMaxContribution(double, vtkRenderer *renderer)\n\nConvenience method to set/get MAX_CONTRIBUTION on a vtkRenderer.\n"},
  {"GetMaxContribution", PyvtkOSPRayRendererNode_GetMaxContribution, METH_VARARGS,
   "GetMaxContribution(renderer:vtkRenderer) -> float\nC++: static double GetMaxContribution(vtkRenderer *renderer)\n\n"},
  {"MAX_DEPTH", PyvtkOSPRayRendererNode_MAX_DEPTH, METH_VARARGS,
   "MAX_DEPTH() -> vtkInformationIntegerKey\nC++: static vtkInformationIntegerKey *MAX_DEPTH()\n\nWhen present on renderer, controls the maximum ray recursion\ndepth default is 20\\ingroup InformationKeys\n"},
  {"SetMaxDepth", PyvtkOSPRayRendererNode_SetMaxDepth, METH_VARARGS,
   "SetMaxDepth(__a:int, renderer:vtkRenderer) -> None\nC++: static void SetMaxDepth(int, vtkRenderer *renderer)\n\nConvenience method to set/get MAX_DEPTH on a vtkRenderer.\n"},
  {"GetMaxDepth", PyvtkOSPRayRendererNode_GetMaxDepth, METH_VARARGS,
   "GetMaxDepth(renderer:vtkRenderer) -> int\nC++: static int GetMaxDepth(vtkRenderer *renderer)\n\n"},
  {"MIN_CONTRIBUTION", PyvtkOSPRayRendererNode_MIN_CONTRIBUTION, METH_VARARGS,
   "MIN_CONTRIBUTION() -> vtkInformationDoubleKey\nC++: static vtkInformationDoubleKey *MIN_CONTRIBUTION()\n\nWhen present on renderer, sample contributions below this value\nwill be neglected to speedup rendering default is 0.01\\ingroup\nInformationKeys\n"},
  {"SetMinContribution", PyvtkOSPRayRendererNode_SetMinContribution, METH_VARARGS,
   "SetMinContribution(__a:float, renderer:vtkRenderer) -> None\nC++: static void SetMinContribution(double, vtkRenderer *renderer)\n\nConvenience method to set/get MIN_CONTRIBUTION on a vtkRenderer.\n"},
  {"GetMinContribution", PyvtkOSPRayRendererNode_GetMinContribution, METH_VARARGS,
   "GetMinContribution(renderer:vtkRenderer) -> float\nC++: static double GetMinContribution(vtkRenderer *renderer)\n\n"},
  {"ROULETTE_DEPTH", PyvtkOSPRayRendererNode_ROULETTE_DEPTH, METH_VARARGS,
   "ROULETTE_DEPTH() -> vtkInformationIntegerKey\nC++: static vtkInformationIntegerKey *ROULETTE_DEPTH()\n\nWhen present on renderer, controls the ray recursion depth at\nwhich to start Russian roulette termination default is 5\\ingroup\nInformationKeys\n"},
  {"SetRouletteDepth", PyvtkOSPRayRendererNode_SetRouletteDepth, METH_VARARGS,
   "SetRouletteDepth(__a:int, renderer:vtkRenderer) -> None\nC++: static void SetRouletteDepth(int, vtkRenderer *renderer)\n\nConvenience method to set/get ROULETTE_DEPTH on a vtkRenderer.\n"},
  {"GetRouletteDepth", PyvtkOSPRayRendererNode_GetRouletteDepth, METH_VARARGS,
   "GetRouletteDepth(renderer:vtkRenderer) -> int\nC++: static int GetRouletteDepth(vtkRenderer *renderer)\n\n"},
  {"VARIANCE_THRESHOLD", PyvtkOSPRayRendererNode_VARIANCE_THRESHOLD, METH_VARARGS,
   "VARIANCE_THRESHOLD() -> vtkInformationDoubleKey\nC++: static vtkInformationDoubleKey *VARIANCE_THRESHOLD()\n\nWhen present on renderer, controls the threshold for adaptive\naccumulation default is 0.3\\ingroup InformationKeys\n"},
  {"SetVarianceThreshold", PyvtkOSPRayRendererNode_SetVarianceThreshold, METH_VARARGS,
   "SetVarianceThreshold(__a:float, renderer:vtkRenderer) -> None\nC++: static void SetVarianceThreshold(double,\n    vtkRenderer *renderer)\n\nConvenience method to set/get VARIANCE_THRESHOLD on a\nvtkRenderer.\n"},
  {"GetVarianceThreshold", PyvtkOSPRayRendererNode_GetVarianceThreshold, METH_VARARGS,
   "GetVarianceThreshold(renderer:vtkRenderer) -> float\nC++: static double GetVarianceThreshold(vtkRenderer *renderer)\n\n"},
  {"MAX_FRAMES", PyvtkOSPRayRendererNode_MAX_FRAMES, METH_VARARGS,
   "MAX_FRAMES() -> vtkInformationIntegerKey\nC++: static vtkInformationIntegerKey *MAX_FRAMES()\n\nWhen present on renderer, controls the number of ospray render\ncalls for each refresh. default is 1\\ingroup InformationKeys\n"},
  {"SetMaxFrames", PyvtkOSPRayRendererNode_SetMaxFrames, METH_VARARGS,
   "SetMaxFrames(__a:int, renderer:vtkRenderer) -> None\nC++: static void SetMaxFrames(int, vtkRenderer *renderer)\n\nWhen present on renderer, controls the number of ospray render\ncalls for each refresh. default is 1\n"},
  {"GetMaxFrames", PyvtkOSPRayRendererNode_GetMaxFrames, METH_VARARGS,
   "GetMaxFrames(renderer:vtkRenderer) -> int\nC++: static int GetMaxFrames(vtkRenderer *renderer)\n\n"},
  {"RENDERER_TYPE", PyvtkOSPRayRendererNode_RENDERER_TYPE, METH_VARARGS,
   "RENDERER_TYPE() -> vtkInformationStringKey\nC++: static vtkInformationStringKey *RENDERER_TYPE()\n\nSet the OSPRay renderer type to use (e.g. scivis vs. pathtracer)\ndefault is scivis\\ingroup InformationKeys\n"},
  {"SetRendererType", PyvtkOSPRayRendererNode_SetRendererType, METH_VARARGS,
   "SetRendererType(name:str, renderer:vtkRenderer) -> None\nC++: static void SetRendererType(std::string name,\n    vtkRenderer *renderer)\n\nSet the OSPRay renderer type to use (e.g. scivis vs. pathtracer)\ndefault is scivis\n"},
  {"GetRendererType", PyvtkOSPRayRendererNode_GetRendererType, METH_VARARGS,
   "GetRendererType(renderer:vtkRenderer) -> str\nC++: static std::string GetRendererType(vtkRenderer *renderer)\n\n"},
  {"AMBIENT_SAMPLES", PyvtkOSPRayRendererNode_AMBIENT_SAMPLES, METH_VARARGS,
   "AMBIENT_SAMPLES() -> vtkInformationIntegerKey\nC++: static vtkInformationIntegerKey *AMBIENT_SAMPLES()\n\nWhen present on renderer, controls the number of ambient\nocclusion samples shot per hit. default is 4\\ingroup\nInformationKeys\n"},
  {"SetAmbientSamples", PyvtkOSPRayRendererNode_SetAmbientSamples, METH_VARARGS,
   "SetAmbientSamples(__a:int, renderer:vtkRenderer) -> None\nC++: static void SetAmbientSamples(int, vtkRenderer *renderer)\n\nConvenience method to set/get AMBIENT_SAMPLES on a vtkRenderer.\n"},
  {"GetAmbientSamples", PyvtkOSPRayRendererNode_GetAmbientSamples, METH_VARARGS,
   "GetAmbientSamples(renderer:vtkRenderer) -> int\nC++: static int GetAmbientSamples(vtkRenderer *renderer)\n\n"},
  {"VOLUME_SAMPLING_RATE", PyvtkOSPRayRendererNode_VOLUME_SAMPLING_RATE, METH_VARARGS,
   "VOLUME_SAMPLING_RATE() -> vtkInformationDoubleKey\nC++: static vtkInformationDoubleKey *VOLUME_SAMPLING_RATE()\n\nthe rate of sampling for volumes, higher numbers increase the\nnumber of samples.  Defaults to 1.0.\\ingroup InformationKeys\n"},
  {"SetVolumeSamplingRate", PyvtkOSPRayRendererNode_SetVolumeSamplingRate, METH_VARARGS,
   "SetVolumeSamplingRate(__a:float, renderer:vtkRenderer) -> None\nC++: static void SetVolumeSamplingRate(double,\n    vtkRenderer *renderer)\n\nConvenience method VOLUME_SAMPLING_RATE on a vtkRenderer.\n"},
  {"GetVolumeSamplingRate", PyvtkOSPRayRendererNode_GetVolumeSamplingRate, METH_VARARGS,
   "GetVolumeSamplingRate(renderer:vtkRenderer) -> float\nC++: static double GetVolumeSamplingRate(vtkRenderer *renderer)\n\n"},
  {"COMPOSITE_ON_GL", PyvtkOSPRayRendererNode_COMPOSITE_ON_GL, METH_VARARGS,
   "COMPOSITE_ON_GL() -> vtkInformationIntegerKey\nC++: static vtkInformationIntegerKey *COMPOSITE_ON_GL()\n\nused to make the renderer add ospray's content onto GL rendered\ncontent on the window\\ingroup InformationKeys\n"},
  {"SetCompositeOnGL", PyvtkOSPRayRendererNode_SetCompositeOnGL, METH_VARARGS,
   "SetCompositeOnGL(__a:int, renderer:vtkRenderer) -> None\nC++: static void SetCompositeOnGL(int, vtkRenderer *renderer)\n\nConvenience method to set/get COMPOSITE_ON_GL on a vtkRenderer.\n"},
  {"GetCompositeOnGL", PyvtkOSPRayRendererNode_GetCompositeOnGL, METH_VARARGS,
   "GetCompositeOnGL(renderer:vtkRenderer) -> int\nC++: static int GetCompositeOnGL(vtkRenderer *renderer)\n\n"},
  {"NORTH_POLE", PyvtkOSPRayRendererNode_NORTH_POLE, METH_VARARGS,
   "NORTH_POLE() -> vtkInformationDoubleVectorKey\nC++: static vtkInformationDoubleVectorKey *NORTH_POLE()\n\nWorld space direction of north pole for gradient and texture\nbackground.\\ingroup InformationKeys\n"},
  {"SetNorthPole", PyvtkOSPRayRendererNode_SetNorthPole, METH_VARARGS,
   "SetNorthPole(__a:[float, ...], renderer:vtkRenderer) -> None\nC++: static void SetNorthPole(double *, vtkRenderer *renderer)\n\nConvenience method to set/get NORTH_POLE on a vtkRenderer.\n"},
  {"GetNorthPole", PyvtkOSPRayRendererNode_GetNorthPole, METH_VARARGS,
   "GetNorthPole(renderer:vtkRenderer) -> Pointer\nC++: static double *GetNorthPole(vtkRenderer *renderer)\n\n"},
  {"EAST_POLE", PyvtkOSPRayRendererNode_EAST_POLE, METH_VARARGS,
   "EAST_POLE() -> vtkInformationDoubleVectorKey\nC++: static vtkInformationDoubleVectorKey *EAST_POLE()\n\nWorld space direction of east pole for texture\nbackground.\\ingroup InformationKeys\n"},
  {"SetEastPole", PyvtkOSPRayRendererNode_SetEastPole, METH_VARARGS,
   "SetEastPole(__a:[float, ...], renderer:vtkRenderer) -> None\nC++: static void SetEastPole(double *, vtkRenderer *renderer)\n\nConvenience method to set/get EAST_POLE on a vtkRenderer.\n"},
  {"GetEastPole", PyvtkOSPRayRendererNode_GetEastPole, METH_VARARGS,
   "GetEastPole(renderer:vtkRenderer) -> Pointer\nC++: static double *GetEastPole(vtkRenderer *renderer)\n\n"},
  {"MATERIAL_LIBRARY", PyvtkOSPRayRendererNode_MATERIAL_LIBRARY, METH_VARARGS,
   "MATERIAL_LIBRARY() -> vtkInformationObjectBaseKey\nC++: static vtkInformationObjectBaseKey *MATERIAL_LIBRARY()\n\nMaterial Library attached to the renderer.\\ingroup\nInformationKeys\n"},
  {"SetMaterialLibrary", PyvtkOSPRayRendererNode_SetMaterialLibrary, METH_VARARGS,
   "SetMaterialLibrary(__a:vtkOSPRayMaterialLibrary,\n    renderer:vtkRenderer) -> None\nC++: static void SetMaterialLibrary(vtkOSPRayMaterialLibrary *,\n    vtkRenderer *renderer)\n\nConvenience method to set/get Material library on a renderer.\n"},
  {"GetMaterialLibrary", PyvtkOSPRayRendererNode_GetMaterialLibrary, METH_VARARGS,
   "GetMaterialLibrary(renderer:vtkRenderer)\n    -> vtkOSPRayMaterialLibrary\nC++: static vtkOSPRayMaterialLibrary *GetMaterialLibrary(\n    vtkRenderer *renderer)\n\n"},
  {"VIEW_TIME", PyvtkOSPRayRendererNode_VIEW_TIME, METH_VARARGS,
   "VIEW_TIME() -> vtkInformationDoubleKey\nC++: static vtkInformationDoubleKey *VIEW_TIME()\n\nRequested time to show in a renderer and to lookup in a temporal\ncache.\\ingroup InformationKeys\n"},
  {"SetViewTime", PyvtkOSPRayRendererNode_SetViewTime, METH_VARARGS,
   "SetViewTime(__a:float, renderer:vtkRenderer) -> None\nC++: static void SetViewTime(double, vtkRenderer *renderer)\n\nConvenience method to set/get VIEW_TIME on a vtkRenderer.\n"},
  {"GetViewTime", PyvtkOSPRayRendererNode_GetViewTime, METH_VARARGS,
   "GetViewTime(renderer:vtkRenderer) -> float\nC++: static double GetViewTime(vtkRenderer *renderer)\n\n"},
  {"TIME_CACHE_SIZE", PyvtkOSPRayRendererNode_TIME_CACHE_SIZE, METH_VARARGS,
   "TIME_CACHE_SIZE() -> vtkInformationIntegerKey\nC++: static vtkInformationIntegerKey *TIME_CACHE_SIZE()\n\nTemporal cache size.\\ingroup InformationKeys\n"},
  {"SetTimeCacheSize", PyvtkOSPRayRendererNode_SetTimeCacheSize, METH_VARARGS,
   "SetTimeCacheSize(__a:int, renderer:vtkRenderer) -> None\nC++: static void SetTimeCacheSize(int, vtkRenderer *renderer)\n\nConvenience method to set/get TIME_CACHE_SIZE on a vtkRenderer.\n"},
  {"GetTimeCacheSize", PyvtkOSPRayRendererNode_GetTimeCacheSize, METH_VARARGS,
   "GetTimeCacheSize(renderer:vtkRenderer) -> int\nC++: static int GetTimeCacheSize(vtkRenderer *renderer)\n\n"},
  {"GetBuffer", PyvtkOSPRayRendererNode_GetBuffer, METH_VARARGS,
   "GetBuffer(self) -> Pointer\nC++: virtual void *GetBuffer()\n\nGet the last rendered ColorBuffer\n"},
  {"GetZBuffer", PyvtkOSPRayRendererNode_GetZBuffer, METH_VARARGS,
   "GetZBuffer(self) -> Pointer\nC++: virtual float *GetZBuffer()\n\nGet the last rendered ZBuffer\n"},
  {"GetColorBufferTextureGL", PyvtkOSPRayRendererNode_GetColorBufferTextureGL, METH_VARARGS,
   "GetColorBufferTextureGL(self) -> int\nC++: virtual int GetColorBufferTextureGL()\n\n"},
  {"GetDepthBufferTextureGL", PyvtkOSPRayRendererNode_GetDepthBufferTextureGL, METH_VARARGS,
   "GetDepthBufferTextureGL(self) -> int\nC++: virtual int GetDepthBufferTextureGL()\n\n"},
  {"Traverse", PyvtkOSPRayRendererNode_Traverse, METH_VARARGS,
   "Traverse(self, operation:int) -> None\nC++: void Traverse(int operation) override;\n\n"},
  {"GetRendererNode", PyvtkOSPRayRendererNode_GetRendererNode, METH_VARARGS,
   "GetRendererNode(__a:vtkViewNode) -> vtkOSPRayRendererNode\nC++: static vtkOSPRayRendererNode *GetRendererNode(vtkViewNode *)\n\nConvenience method to get and downcast renderable.\n"},
  {"GetRenderer", PyvtkOSPRayRendererNode_GetRenderer, METH_VARARGS,
   "GetRenderer(self) -> vtkRenderer\nC++: vtkRenderer *GetRenderer()\n\n"},
  {"DENOISER_THRESHOLD", PyvtkOSPRayRendererNode_DENOISER_THRESHOLD, METH_VARARGS,
   "DENOISER_THRESHOLD() -> vtkInformationIntegerKey\nC++: static vtkInformationIntegerKey *DENOISER_THRESHOLD()\n\nAccumulation threshold when above which denoising kicks\nin.\\ingroup InformationKeys\n"},
  {"SetDenoiserThreshold", PyvtkOSPRayRendererNode_SetDenoiserThreshold, METH_VARARGS,
   "SetDenoiserThreshold(__a:int, renderer:vtkRenderer) -> None\nC++: static void SetDenoiserThreshold(int, vtkRenderer *renderer)\n\nConvenience method to set/get DENOISER_THRESHOLD on a\nvtkRenderer.\n"},
  {"GetDenoiserThreshold", PyvtkOSPRayRendererNode_GetDenoiserThreshold, METH_VARARGS,
   "GetDenoiserThreshold(renderer:vtkRenderer) -> int\nC++: static int GetDenoiserThreshold(vtkRenderer *renderer)\n\n"},
  {"ENABLE_DENOISER", PyvtkOSPRayRendererNode_ENABLE_DENOISER, METH_VARARGS,
   "ENABLE_DENOISER() -> vtkInformationIntegerKey\nC++: static vtkInformationIntegerKey *ENABLE_DENOISER()\n\nEnable denoising (if supported).\\ingroup InformationKeys\n"},
  {"SetEnableDenoiser", PyvtkOSPRayRendererNode_SetEnableDenoiser, METH_VARARGS,
   "SetEnableDenoiser(__a:int, renderer:vtkRenderer) -> None\nC++: static void SetEnableDenoiser(int, vtkRenderer *renderer)\n\nConvenience method to set/get ENABLE_DENOISER on a vtkRenderer.\n"},
  {"GetEnableDenoiser", PyvtkOSPRayRendererNode_GetEnableDenoiser, METH_VARARGS,
   "GetEnableDenoiser(renderer:vtkRenderer) -> int\nC++: static int GetEnableDenoiser(vtkRenderer *renderer)\n\n"},
  {"BACKGROUND_MODE", PyvtkOSPRayRendererNode_BACKGROUND_MODE, METH_VARARGS,
   "BACKGROUND_MODE() -> vtkInformationIntegerKey\nC++: static vtkInformationIntegerKey *BACKGROUND_MODE()\n\nControl use of the path tracer backplate and environmental\nbackground. 0 means neither is shown, 1 means only backplate is\nshown, 2 (the default) means only environment is shown, 3 means\nthat both are enabled and therefore backblate shows on screen but\nactors acquire color from the environment.\n"},
  {"SetBackgroundMode", PyvtkOSPRayRendererNode_SetBackgroundMode, METH_VARARGS,
   "SetBackgroundMode(__a:BackgroundMode, renderer:vtkRenderer)\n    -> None\nC++: static void SetBackgroundMode(BackgroundMode,\n    vtkRenderer *renderer)\n\n"},
  {"GetBackgroundMode", PyvtkOSPRayRendererNode_GetBackgroundMode, METH_VARARGS,
   "GetBackgroundMode(renderer:vtkRenderer) -> BackgroundMode\nC++: static BackgroundMode GetBackgroundMode(\n    vtkRenderer *renderer)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkOSPRayRendererNode_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("buffer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOSPRayRendererNode_GetBuffer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetBuffer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("z_buffer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOSPRayRendererNode_GetZBuffer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetZBuffer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("color_buffer_texture_gl"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOSPRayRendererNode_GetColorBufferTextureGL(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetColorBufferTextureGL\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("depth_buffer_texture_gl"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOSPRayRendererNode_GetDepthBufferTextureGL(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDepthBufferTextureGL\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("renderer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOSPRayRendererNode_GetRenderer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRenderer\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkOSPRayRendererNode_Doc =
  "vtkOSPRayRendererNode - links vtkRenderers to OSPRay\n\n"
  "Superclass: vtkRendererNode\n\n"
  "Translates vtkRenderer state into OSPRay rendering calls\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkOSPRayRendererNode_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingRayTracing.vtkOSPRayRendererNode", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkOSPRayRendererNode_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkOSPRayRendererNode_StaticNew()
{
  return vtkOSPRayRendererNode::New();
}

PyObject *PyvtkOSPRayRendererNode_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkOSPRayRendererNode_Type, PyvtkOSPRayRendererNode_Methods,
    "vtkOSPRayRendererNode",
 &PyvtkOSPRayRendererNode_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkRendererNode");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkOSPRayRendererNode_BackgroundMode_Type);
  PyVTKEnum_Add(&PyvtkOSPRayRendererNode_BackgroundMode_Type, "vtkOSPRayRendererNode.BackgroundMode");

  o = (PyObject *)&PyvtkOSPRayRendererNode_BackgroundMode_Type;
  if (PyDict_SetItemString(d, "BackgroundMode", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 5; c++)
  {
    typedef vtkOSPRayRendererNode::BackgroundMode cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[5] = {
        { "None_", vtkOSPRayRendererNode::None },
        { "Backplate", vtkOSPRayRendererNode::Backplate },
        { "Environment", vtkOSPRayRendererNode::Environment },
        { "Both", vtkOSPRayRendererNode::Both },
        { "NumberOfMode", vtkOSPRayRendererNode::NumberOfMode },
      };

    o = PyvtkOSPRayRendererNode_BackgroundMode_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkOSPRayRendererNode_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkOSPRayRendererNode(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkOSPRayRendererNode_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkOSPRayRendererNode", o) != 0)
  {
    Py_DECREF(o);
  }

}

