// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause

// Object factories should never have deprecation warnings.
// NOLINTNEXTLINE(modernize-macro-to-enum)
#define VTK_DEPRECATION_LEVEL 0

#include "vtkRenderingMatplotlibObjectFactory.h"
#include "vtkVersion.h"

// Include all of the classes we want to create overrides for.
#include "vtkMatplotlibMathTextUtilities.h"


VTK_ABI_NAMESPACE_BEGIN

vtkStandardNewMacro(vtkRenderingMatplotlibObjectFactory);

// Now create the functions to create overrides with.
VTK_CREATE_CREATE_FUNCTION(vtkMatplotlibMathTextUtilities)


vtkRenderingMatplotlibObjectFactory::vtkRenderingMatplotlibObjectFactory()
{
this->RegisterOverride("vtkMathTextUtilities", "vtkMatplotlibMathTextUtilities", "Override for VTK::RenderingMatplotlib module", 1, vtkObjectFactoryCreatevtkMatplotlibMathTextUtilities);

}

const char * vtkRenderingMatplotlibObjectFactory::GetVTKSourceVersion() VTK_FUTURE_CONST
{
  return VTK_SOURCE_VERSION;
}

void vtkRenderingMatplotlibObjectFactory::PrintSelf(ostream &os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os, indent);
}

// Registration of object factories.
static unsigned int vtkRenderingMatplotlibCount = 0;

VTKRENDERINGMATPLOTLIB_EXPORT void vtkRenderingMatplotlib_AutoInit_Construct()
{
  if(++vtkRenderingMatplotlibCount == 1)
  {


    vtkRenderingMatplotlibObjectFactory* factory = vtkRenderingMatplotlibObjectFactory::New();
    if (factory)
    {
      // vtkObjectFactory keeps a reference to the "factory",
      vtkObjectFactory::RegisterFactory(factory);
      factory->Delete();
    }
  }
}
VTK_ABI_NAMESPACE_END
