// java wrapper for vtkVariantArray object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkVariantArray.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkAbstractArray_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkVariantArray_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkVariantArray",dType)) { return me; }
  if ((res= vtkAbstractArray_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVariantArray_ExtendedNew_10(JNIEnv* env, jobject obj)
{
  vtkVariantArray * temp20;

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ExtendedNew();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVariantArray_IsTypeOf_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVariantArray_IsA_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVariantArray_GetNumberOfGenerationsFromBaseType_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVariantArray_GetNumberOfGenerationsFromBase_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVariantArray_Allocate_15(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Allocate(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVariantArray_Initialize_16(JNIEnv* env, jobject obj)
{

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVariantArray_GetDataType_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataType();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVariantArray_GetDataTypeSize_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataTypeSize();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVariantArray_GetElementComponentSize_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementComponentSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVariantArray_SetNumberOfTuples_110(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfTuples(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVariantArray_SetTuple_111(JNIEnv* env, jobject obj,jlong id0,jlong id1,jobject id2)
{
  long long   temp0;
  long long   temp1;
  vtkAbstractArray * temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTuple(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVariantArray_InsertTuple_112(JNIEnv* env, jobject obj,jlong id0,jlong id1,jobject id2)
{
  long long   temp0;
  long long   temp1;
  vtkAbstractArray * temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertTuple(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVariantArray_InsertTuples_113(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkIdList * temp0;
  vtkIdList * temp1;
  vtkAbstractArray * temp2;
  temp0 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertTuples(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVariantArray_InsertTuplesStartingAt_114(JNIEnv* env, jobject obj,jlong id0,jobject id1,jobject id2)
{
  long long   temp0;
  vtkIdList * temp1;
  vtkAbstractArray * temp2;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertTuplesStartingAt(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVariantArray_InsertTuples_115(JNIEnv* env, jobject obj,jlong id0,jlong id1,jlong id2,jobject id3)
{
  long long   temp0;
  long long   temp1;
  long long   temp2;
  vtkAbstractArray * temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id3));

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertTuples(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVariantArray_InsertNextTuple_116(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkAbstractArray * temp1;
  long long   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextTuple(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVariantArray_DeepCopy_117(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractArray * temp0;
  temp0 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVariantArray_InterpolateTuple_118(JNIEnv* env, jobject obj,jlong id0,jlong id1,jobject id2,jlong id3,jobject id4,jdouble id5)
{
  long long   temp0;
  long long   temp1;
  vtkAbstractArray * temp2;
  long long   temp3;
  vtkAbstractArray * temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = id3;
  temp4 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = id5;

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolateTuple(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVariantArray_Squeeze_119(JNIEnv* env, jobject obj)
{

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->Squeeze();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVariantArray_Resize_120(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  int   temp20;
  temp0 = id0;

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Resize(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVariantArray_GetActualMemorySize_121(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySize();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVariantArray_IsNumeric_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsNumeric();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVariantArray_NewIterator_123(JNIEnv* env, jobject obj)
{
  vtkArrayIterator * temp20;

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NewIterator();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVariantArray_GetNumberOfValues_124(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfValues();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVariantArray_DataChanged_125(JNIEnv* env, jobject obj)
{

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->DataChanged();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVariantArray_DataElementChanged_126(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->DataElementChanged(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVariantArray_ClearLookup_127(JNIEnv* env, jobject obj)
{

  vtkVariantArray* op = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearLookup();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkVariantArray_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkVariantArray::New());
}
