// java wrapper for vtkBezierWedge object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkBezierWedge.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkHigherOrderWedge_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkBezierWedge_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkBezierWedge",dType)) { return me; }
  if ((res= vtkHigherOrderWedge_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBezierWedge_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBezierWedge* op = static_cast<vtkBezierWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBezierWedge_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBezierWedge* op = static_cast<vtkBezierWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBezierWedge_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBezierWedge* op = static_cast<vtkBezierWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBezierWedge_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkBezierWedge* op = static_cast<vtkBezierWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkBezierWedge_GetCellType_14(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkBezierWedge* op = static_cast<vtkBezierWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellType();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBezierWedge_GetEdge_15(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkBezierWedge* op = static_cast<vtkBezierWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdge(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBezierWedge_GetFace_16(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkBezierWedge* op = static_cast<vtkBezierWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFace(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkBezierWedge_SetRationalWeightsFromPointData_17(JNIEnv* env, jobject obj,jobject id0,jlong id1)
{
  vtkPointData * temp0;
  long long   temp1;
  temp0 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkBezierWedge* op = static_cast<vtkBezierWedge*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRationalWeightsFromPointData(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBezierWedge_GetBoundaryQuad_18(JNIEnv* env, jobject obj)
{
  vtkHigherOrderQuadrilateral * temp20;

  vtkBezierWedge* op = static_cast<vtkBezierWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBoundaryQuad();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBezierWedge_GetBoundaryTri_19(JNIEnv* env, jobject obj)
{
  vtkHigherOrderTriangle * temp20;

  vtkBezierWedge* op = static_cast<vtkBezierWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBoundaryTri();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBezierWedge_GetEdgeCell_110(JNIEnv* env, jobject obj)
{
  vtkHigherOrderCurve * temp20;

  vtkBezierWedge* op = static_cast<vtkBezierWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeCell();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBezierWedge_GetInterpolation_111(JNIEnv* env, jobject obj)
{
  vtkHigherOrderInterpolation * temp20;

  vtkBezierWedge* op = static_cast<vtkBezierWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolation();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkBezierWedge_GetRationalWeights_112(JNIEnv* env, jobject obj)
{
  vtkDoubleArray * temp20;

  vtkBezierWedge* op = static_cast<vtkBezierWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRationalWeights();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkBezierWedge_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkBezierWedge::New());
}
