// java wrapper for vtkDataSetAttributes object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkDataSetAttributes.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkFieldData_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkDataSetAttributes_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkDataSetAttributes",dType)) { return me; }
  if ((res= vtkFieldData_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetAttributes_ExtendedNew_10(JNIEnv* env, jobject obj)
{
  vtkDataSetAttributes * temp20;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ExtendedNew();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_IsTypeOf_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_IsA_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetAttributes_GetNumberOfGenerationsFromBaseType_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetAttributes_GetNumberOfGenerationsFromBase_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_Initialize_15(JNIEnv* env, jobject obj)
{

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_Update_16(JNIEnv* env, jobject obj)
{

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->Update();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_DeepCopy_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkFieldData * temp0;
  temp0 = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_ShallowCopy_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkFieldData * temp0;
  temp0 = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataSetAttributes_GhostArrayName_19(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GhostArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_SetScalars_110(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  int   temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetScalars(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_SetActiveScalars_111(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetActiveScalars(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetAttributes_GetScalars_112(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalars();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_SetVectors_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  int   temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetVectors(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_SetActiveVectors_114(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetActiveVectors(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetAttributes_GetVectors_115(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVectors();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_SetNormals_116(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  int   temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetNormals(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_SetActiveNormals_117(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetActiveNormals(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetAttributes_GetNormals_118(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNormals();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_SetTangents_119(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  int   temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetTangents(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_SetActiveTangents_120(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetActiveTangents(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetAttributes_GetTangents_121(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTangents();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_SetTCoords_122(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  int   temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetTCoords(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_SetActiveTCoords_123(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetActiveTCoords(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetAttributes_GetTCoords_124(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTCoords();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_SetTensors_125(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  int   temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetTensors(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_SetActiveTensors_126(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetActiveTensors(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetAttributes_GetTensors_127(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTensors();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_SetGlobalIds_128(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  int   temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetGlobalIds(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_SetActiveGlobalIds_129(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetActiveGlobalIds(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetAttributes_GetGlobalIds_130(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlobalIds();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_SetPedigreeIds_131(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractArray * temp0;
  int   temp20;
  temp0 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetPedigreeIds(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_SetActivePedigreeIds_132(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetActivePedigreeIds(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetAttributes_GetPedigreeIds_133(JNIEnv* env, jobject obj)
{
  vtkAbstractArray * temp20;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPedigreeIds();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_SetRationalWeights_134(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  int   temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetRationalWeights(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_SetActiveRationalWeights_135(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetActiveRationalWeights(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetAttributes_GetRationalWeights_136(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRationalWeights();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_SetHigherOrderDegrees_137(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  int   temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetHigherOrderDegrees(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_SetActiveHigherOrderDegrees_138(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetActiveHigherOrderDegrees(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetAttributes_GetHigherOrderDegrees_139(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHigherOrderDegrees();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_SetProcessIds_140(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  int   temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetProcessIds(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_SetActiveProcessIds_141(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetActiveProcessIds(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetAttributes_GetProcessIds_142(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProcessIds();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetAttributes_GetScalars_143(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  vtkDataArray * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalars(temp0);
  delete[] temp0;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetAttributes_GetVectors_144(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  vtkDataArray * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVectors(temp0);
  delete[] temp0;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetAttributes_GetNormals_145(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  vtkDataArray * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNormals(temp0);
  delete[] temp0;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetAttributes_GetTangents_146(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  vtkDataArray * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTangents(temp0);
  delete[] temp0;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetAttributes_GetTCoords_147(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  vtkDataArray * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTCoords(temp0);
  delete[] temp0;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetAttributes_GetTensors_148(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  vtkDataArray * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTensors(temp0);
  delete[] temp0;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetAttributes_GetGlobalIds_149(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  vtkDataArray * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlobalIds(temp0);
  delete[] temp0;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetAttributes_GetPedigreeIds_150(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  vtkAbstractArray * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPedigreeIds(temp0);
  delete[] temp0;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetAttributes_GetRationalWeights_151(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  vtkDataArray * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRationalWeights(temp0);
  delete[] temp0;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetAttributes_GetHigherOrderDegrees_152(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  vtkDataArray * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHigherOrderDegrees(temp0);
  delete[] temp0;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetAttributes_GetProcessIds_153(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  vtkDataArray * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProcessIds(temp0);
  delete[] temp0;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_SetActiveAttribute_154(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetActiveAttribute(temp0,temp1);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_SetActiveAttribute_155(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetActiveAttribute(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_IsArrayAnAttribute_156(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsArrayAnAttribute(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_SetAttribute_157(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkAbstractArray * temp0;
  int   temp1;
  int   temp20;
  temp0 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetAttribute(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetAttributes_GetAttribute_158(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkDataArray * temp20;
  temp0 = id0;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAttribute(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataSetAttributes_GetAbstractAttribute_159(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkAbstractArray * temp20;
  temp0 = id0;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAbstractAttribute(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_RemoveArray_160(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveArray(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataSetAttributes_GetAttributeTypeAsString_161(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAttributeTypeAsString(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataSetAttributes_GetLongAttributeTypeAsString_162(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLongAttributeTypeAsString(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_SetCopyAttribute_163(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCopyAttribute(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_GetCopyAttribute_164(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCopyAttribute(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_SetCopyScalars_165(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCopyScalars(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_GetCopyScalars_166(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCopyScalars(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyScalarsOn_167(JNIEnv* env, jobject obj)
{

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyScalarsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyScalarsOff_168(JNIEnv* env, jobject obj)
{

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyScalarsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_SetCopyVectors_169(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCopyVectors(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_GetCopyVectors_170(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCopyVectors(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyVectorsOn_171(JNIEnv* env, jobject obj)
{

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyVectorsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyVectorsOff_172(JNIEnv* env, jobject obj)
{

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyVectorsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_SetCopyNormals_173(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCopyNormals(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_GetCopyNormals_174(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCopyNormals(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyNormalsOn_175(JNIEnv* env, jobject obj)
{

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyNormalsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyNormalsOff_176(JNIEnv* env, jobject obj)
{

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyNormalsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_SetCopyTangents_177(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCopyTangents(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_GetCopyTangents_178(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCopyTangents(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyTangentsOn_179(JNIEnv* env, jobject obj)
{

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyTangentsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyTangentsOff_180(JNIEnv* env, jobject obj)
{

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyTangentsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_SetCopyTCoords_181(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCopyTCoords(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_GetCopyTCoords_182(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCopyTCoords(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyTCoordsOn_183(JNIEnv* env, jobject obj)
{

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyTCoordsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyTCoordsOff_184(JNIEnv* env, jobject obj)
{

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyTCoordsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_SetCopyTensors_185(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCopyTensors(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_GetCopyTensors_186(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCopyTensors(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyTensorsOn_187(JNIEnv* env, jobject obj)
{

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyTensorsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyTensorsOff_188(JNIEnv* env, jobject obj)
{

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyTensorsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_SetCopyGlobalIds_189(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCopyGlobalIds(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_GetCopyGlobalIds_190(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCopyGlobalIds(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyGlobalIdsOn_191(JNIEnv* env, jobject obj)
{

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyGlobalIdsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyGlobalIdsOff_192(JNIEnv* env, jobject obj)
{

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyGlobalIdsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_SetCopyPedigreeIds_193(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCopyPedigreeIds(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_GetCopyPedigreeIds_194(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCopyPedigreeIds(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyPedigreeIdsOn_195(JNIEnv* env, jobject obj)
{

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyPedigreeIdsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyPedigreeIdsOff_196(JNIEnv* env, jobject obj)
{

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyPedigreeIdsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_SetCopyRationalWeights_197(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCopyRationalWeights(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_GetCopyRationalWeights_198(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCopyRationalWeights(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyRationalWeightsOn_199(JNIEnv* env, jobject obj)
{

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyRationalWeightsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyRationalWeightsOff_1100(JNIEnv* env, jobject obj)
{

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyRationalWeightsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_SetCopyHigherOrderDegrees_1101(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCopyHigherOrderDegrees(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_GetCopyHigherOrderDegrees_1102(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCopyHigherOrderDegrees(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyHigherOrderDegreesOn_1103(JNIEnv* env, jobject obj)
{

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyHigherOrderDegreesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyHigherOrderDegreesOff_1104(JNIEnv* env, jobject obj)
{

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyHigherOrderDegreesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_SetCopyProcessIds_1105(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCopyProcessIds(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataSetAttributes_GetCopyProcessIds_1106(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCopyProcessIds(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyProcessIdsOn_1107(JNIEnv* env, jobject obj)
{

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyProcessIdsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyProcessIdsOff_1108(JNIEnv* env, jobject obj)
{

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyProcessIdsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyAllOn_1109(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyAllOn(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyAllOff_1110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyAllOff(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_PassData_1111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkFieldData * temp0;
  temp0 = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->PassData(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyAllocate_1112(JNIEnv* env, jobject obj,jobject id0,jlong id1,jlong id2)
{
  vtkDataSetAttributes * temp0;
  long long   temp1;
  long long   temp2;
  temp0 = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyAllocate(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyAllocate_1113(JNIEnv* env, jobject obj,jobject id0,jlong id1,jlong id2,jint id3)
{
  vtkDataSetAttributes * temp0;
  long long   temp1;
  long long   temp2;
  int   temp3;
  temp0 = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyAllocate(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_SetupForCopy_1114(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataSetAttributes * temp0;
  temp0 = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetupForCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyData_1115(JNIEnv* env, jobject obj,jobject id0,jlong id1,jlong id2)
{
  vtkDataSetAttributes * temp0;
  long long   temp1;
  long long   temp2;
  temp0 = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyData(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyData_1116(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkDataSetAttributes * temp0;
  vtkIdList * temp1;
  vtkIdList * temp2;
  temp0 = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyData(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyData_1117(JNIEnv* env, jobject obj,jobject id0,jobject id1,jlong id2)
{
  vtkDataSetAttributes * temp0;
  vtkIdList * temp1;
  long long   temp2;
  temp0 = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyData(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyData_1118(JNIEnv* env, jobject obj,jobject id0,jlong id1,jlong id2,jlong id3)
{
  vtkDataSetAttributes * temp0;
  long long   temp1;
  long long   temp2;
  long long   temp3;
  temp0 = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyData(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyTuple_1119(JNIEnv* env, jobject obj,jobject id0,jobject id1,jlong id2,jlong id3)
{
  vtkAbstractArray * temp0;
  vtkAbstractArray * temp1;
  long long   temp2;
  long long   temp3;
  temp0 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;
  temp3 = id3;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyTuple(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyTuples_1120(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2,jobject id3)
{
  vtkAbstractArray * temp0;
  vtkAbstractArray * temp1;
  vtkIdList * temp2;
  vtkIdList * temp3;
  temp0 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id3));

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyTuples(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_CopyTuples_1121(JNIEnv* env, jobject obj,jobject id0,jobject id1,jlong id2,jlong id3,jlong id4)
{
  vtkAbstractArray * temp0;
  vtkAbstractArray * temp1;
  long long   temp2;
  long long   temp3;
  long long   temp4;
  temp0 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyTuples(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_InterpolateAllocate_1122(JNIEnv* env, jobject obj,jobject id0,jlong id1,jlong id2)
{
  vtkDataSetAttributes * temp0;
  long long   temp1;
  long long   temp2;
  temp0 = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolateAllocate(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_InterpolateAllocate_1123(JNIEnv* env, jobject obj,jobject id0,jlong id1,jlong id2,jint id3)
{
  vtkDataSetAttributes * temp0;
  long long   temp1;
  long long   temp2;
  int   temp3;
  temp0 = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolateAllocate(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_InterpolateEdge_1124(JNIEnv* env, jobject obj,jobject id0,jlong id1,jlong id2,jlong id3,jdouble id4)
{
  vtkDataSetAttributes * temp0;
  long long   temp1;
  long long   temp2;
  long long   temp3;
  double   temp4;
  temp0 = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolateEdge(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_InterpolateTime_1125(JNIEnv* env, jobject obj,jobject id0,jobject id1,jlong id2,jdouble id3)
{
  vtkDataSetAttributes * temp0;
  vtkDataSetAttributes * temp1;
  long long   temp2;
  double   temp3;
  temp0 = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;
  temp3 = id3;

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->InterpolateTime(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataSetAttributes_RemoveArray_1126(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataSetAttributes* op = static_cast<vtkDataSetAttributes*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveArray(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkDataSetAttributes_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkDataSetAttributes::New());
}
