// java wrapper for vtkTubeFilter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkTubeFilter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPolyDataAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkTubeFilter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkTubeFilter",dType)) { return me; }
  if ((res= vtkPolyDataAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTubeFilter_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTubeFilter_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTubeFilter_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTubeFilter_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_SetRadius_14(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRadius(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTubeFilter_GetRadiusMinValue_15(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadiusMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTubeFilter_GetRadiusMaxValue_16(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadiusMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTubeFilter_GetRadius_17(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadius();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_SetVaryRadius_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVaryRadius(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTubeFilter_GetVaryRadiusMinValue_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVaryRadiusMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTubeFilter_GetVaryRadiusMaxValue_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVaryRadiusMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTubeFilter_GetVaryRadius_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVaryRadius();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_SetVaryRadiusToVaryRadiusOff_112(JNIEnv* env, jobject obj)
{

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVaryRadiusToVaryRadiusOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_SetVaryRadiusToVaryRadiusByScalar_113(JNIEnv* env, jobject obj)
{

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVaryRadiusToVaryRadiusByScalar();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_SetVaryRadiusToVaryRadiusByVector_114(JNIEnv* env, jobject obj)
{

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVaryRadiusToVaryRadiusByVector();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_SetVaryRadiusToVaryRadiusByVectorNorm_115(JNIEnv* env, jobject obj)
{

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVaryRadiusToVaryRadiusByVectorNorm();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_SetVaryRadiusToVaryRadiusByAbsoluteScalar_116(JNIEnv* env, jobject obj)
{

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVaryRadiusToVaryRadiusByAbsoluteScalar();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkTubeFilter_GetVaryRadiusAsString_117(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVaryRadiusAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_SetNumberOfSides_118(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfSides(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTubeFilter_GetNumberOfSidesMinValue_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfSidesMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTubeFilter_GetNumberOfSidesMaxValue_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfSidesMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTubeFilter_GetNumberOfSides_121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfSides();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_SetRadiusFactor_122(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRadiusFactor(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTubeFilter_GetRadiusFactor_123(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadiusFactor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_SetDefaultNormal_124(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDefaultNormal(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_SetDefaultNormal_125(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDefaultNormal(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkTubeFilter_GetDefaultNormal_126(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDefaultNormal();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_SetUseDefaultNormal_127(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseDefaultNormal(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTubeFilter_GetUseDefaultNormal_128(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseDefaultNormal();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_UseDefaultNormalOn_129(JNIEnv* env, jobject obj)
{

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseDefaultNormalOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_UseDefaultNormalOff_130(JNIEnv* env, jobject obj)
{

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseDefaultNormalOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_SetSidesShareVertices_131(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSidesShareVertices(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTubeFilter_GetSidesShareVertices_132(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSidesShareVertices();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_SidesShareVerticesOn_133(JNIEnv* env, jobject obj)
{

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SidesShareVerticesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_SidesShareVerticesOff_134(JNIEnv* env, jobject obj)
{

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SidesShareVerticesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_SetCapping_135(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCapping(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTubeFilter_GetCapping_136(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCapping();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_CappingOn_137(JNIEnv* env, jobject obj)
{

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->CappingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_CappingOff_138(JNIEnv* env, jobject obj)
{

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->CappingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_SetOnRatio_139(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOnRatio(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTubeFilter_GetOnRatioMinValue_140(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOnRatioMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTubeFilter_GetOnRatioMaxValue_141(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOnRatioMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTubeFilter_GetOnRatio_142(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOnRatio();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_SetOffset_143(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOffset(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTubeFilter_GetOffsetMinValue_144(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOffsetMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTubeFilter_GetOffsetMaxValue_145(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOffsetMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTubeFilter_GetOffset_146(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOffset();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_SetGenerateTCoords_147(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateTCoords(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTubeFilter_GetGenerateTCoordsMinValue_148(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateTCoordsMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTubeFilter_GetGenerateTCoordsMaxValue_149(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateTCoordsMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTubeFilter_GetGenerateTCoords_150(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateTCoords();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_SetGenerateTCoordsToOff_151(JNIEnv* env, jobject obj)
{

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateTCoordsToOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_SetGenerateTCoordsToNormalizedLength_152(JNIEnv* env, jobject obj)
{

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateTCoordsToNormalizedLength();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_SetGenerateTCoordsToUseLength_153(JNIEnv* env, jobject obj)
{

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateTCoordsToUseLength();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_SetGenerateTCoordsToUseScalars_154(JNIEnv* env, jobject obj)
{

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateTCoordsToUseScalars();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkTubeFilter_GetGenerateTCoordsAsString_155(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateTCoordsAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_SetTextureLength_156(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextureLength(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTubeFilter_GetTextureLengthMinValue_157(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextureLengthMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTubeFilter_GetTextureLengthMaxValue_158(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextureLengthMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTubeFilter_GetTextureLength_159(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextureLength();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTubeFilter_SetOutputPointsPrecision_160(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputPointsPrecision(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTubeFilter_GetOutputPointsPrecision_161(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTubeFilter* op = static_cast<vtkTubeFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputPointsPrecision();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkTubeFilter_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkTubeFilter::New());
}
