// java wrapper for vtkPIOReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPIOReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkMultiBlockDataSetAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPIOReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPIOReader",dType)) { return me; }
  if ((res= vtkMultiBlockDataSetAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPIOReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPIOReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPIOReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPIOReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPIOReader_SetFileName_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPIOReader_GetFileName_15(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPIOReader_SetCurrentTimeStep_16(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCurrentTimeStep(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPIOReader_GetCurrentTimeStep_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCurrentTimeStep();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPIOReader_GetHyperTreeGrid_18(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHyperTreeGrid();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPIOReader_SetHyperTreeGrid_19(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHyperTreeGrid(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPIOReader_SetTracers_110(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTracers(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPIOReader_GetTracers_111(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTracers();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPIOReader_SetFloat64_112(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFloat64(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPIOReader_GetFloat64_113(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFloat64();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPIOReader_GetOutput_114(JNIEnv* env, jobject obj)
{
  vtkMultiBlockDataSet * temp20;

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPIOReader_GetOutput_115(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkMultiBlockDataSet * temp20;
  temp0 = id0;

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutput(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPIOReader_GetNumberOfCellArrays_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCellArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPIOReader_GetCellArrayName_117(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPIOReader_GetCellArrayStatus_118(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPIOReader_SetCellArrayStatus_119(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPIOReader_DisableAllCellArrays_120(JNIEnv* env, jobject obj)
{

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableAllCellArrays();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPIOReader_EnableAllCellArrays_121(JNIEnv* env, jobject obj)
{

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableAllCellArrays();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPIOReader_GetCellDataArraySelection_122(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellDataArraySelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPIOReader_GetNumberOfTimeDataArrays_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfTimeDataArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPIOReader_GetTimeDataArray_124(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeDataArray(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPIOReader_GetTimeDataStringArray_125(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeDataStringArray();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPIOReader_GetActiveTimeDataArrayName_126(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActiveTimeDataArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPIOReader_SetActiveTimeDataArrayName_127(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPIOReader* op = static_cast<vtkPIOReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetActiveTimeDataArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPIOReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPIOReader::New());
}
