// java wrapper for vtkVoxelModeller object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkVoxelModeller.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkVoxelModeller_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkVoxelModeller",dType)) { return me; }
  if ((res= vtkImageAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVoxelModeller_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVoxelModeller_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVoxelModeller_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVoxelModeller_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVoxelModeller_ComputeModelBounds_14(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeModelBounds(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelModeller_SetSampleDimensions_15(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSampleDimensions(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelModeller_SetSampleDimensions_16(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSampleDimensions(temp0);
  env->SetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkVoxelModeller_GetSampleDimensions_17(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSampleDimensions();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelModeller_SetMaximumDistance_18(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumDistance(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVoxelModeller_GetMaximumDistanceMinValue_19(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumDistanceMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVoxelModeller_GetMaximumDistanceMaxValue_110(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumDistanceMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVoxelModeller_GetMaximumDistance_111(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumDistance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelModeller_SetModelBounds_112(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetModelBounds(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelModeller_SetModelBounds_113(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetModelBounds(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkVoxelModeller_GetModelBounds_114(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetModelBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelModeller_SetScalarType_115(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarType(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelModeller_SetScalarTypeToFloat_116(JNIEnv* env, jobject obj)
{

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarTypeToFloat();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelModeller_SetScalarTypeToDouble_117(JNIEnv* env, jobject obj)
{

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarTypeToDouble();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelModeller_SetScalarTypeToInt_118(JNIEnv* env, jobject obj)
{

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarTypeToInt();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelModeller_SetScalarTypeToUnsignedInt_119(JNIEnv* env, jobject obj)
{

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarTypeToUnsignedInt();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelModeller_SetScalarTypeToLong_120(JNIEnv* env, jobject obj)
{

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarTypeToLong();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelModeller_SetScalarTypeToUnsignedLong_121(JNIEnv* env, jobject obj)
{

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarTypeToUnsignedLong();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelModeller_SetScalarTypeToShort_122(JNIEnv* env, jobject obj)
{

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarTypeToShort();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelModeller_SetScalarTypeToUnsignedShort_123(JNIEnv* env, jobject obj)
{

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarTypeToUnsignedShort();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelModeller_SetScalarTypeToUnsignedChar_124(JNIEnv* env, jobject obj)
{

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarTypeToUnsignedChar();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelModeller_SetScalarTypeToChar_125(JNIEnv* env, jobject obj)
{

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarTypeToChar();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelModeller_SetScalarTypeToBit_126(JNIEnv* env, jobject obj)
{

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarTypeToBit();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVoxelModeller_GetScalarType_127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelModeller_SetForegroundValue_128(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetForegroundValue(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVoxelModeller_GetForegroundValue_129(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetForegroundValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVoxelModeller_SetBackgroundValue_130(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackgroundValue(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVoxelModeller_GetBackgroundValue_131(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkVoxelModeller* op = static_cast<vtkVoxelModeller*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBackgroundValue();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkVoxelModeller_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkVoxelModeller::New());
}
