// java wrapper for vtkVRRenderWindowInteractor object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkVRRenderWindowInteractor.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkRenderWindowInteractor3D_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkVRRenderWindowInteractor_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkVRRenderWindowInteractor",dType)) { return me; }
  if ((res= vtkRenderWindowInteractor3D_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVRRenderWindowInteractor_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVRRenderWindowInteractor* op = static_cast<vtkVRRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVRRenderWindowInteractor_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVRRenderWindowInteractor* op = static_cast<vtkVRRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVRRenderWindowInteractor_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVRRenderWindowInteractor* op = static_cast<vtkVRRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVRRenderWindowInteractor_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVRRenderWindowInteractor* op = static_cast<vtkVRRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindowInteractor_Initialize_14(JNIEnv* env, jobject obj)
{

  vtkVRRenderWindowInteractor* op = static_cast<vtkVRRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindowInteractor_ProcessEvents_15(JNIEnv* env, jobject obj)
{

  vtkVRRenderWindowInteractor* op = static_cast<vtkVRRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ProcessEvents();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindowInteractor_DoOneEvent_16(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkVRRenderWindow * temp0;
  vtkRenderer * temp1;
  temp0 = static_cast<vtkVRRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id1));

  vtkVRRenderWindowInteractor* op = static_cast<vtkVRRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DoOneEvent(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindowInteractor_SetClassExitMethod_17(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1)
{
  vtkJavaVoidFuncArg* fstruct = new vtkJavaVoidFuncArg;
  env->GetJavaVM(&(fstruct->vm));
  fstruct->uobj = env->NewGlobalRef(id0);
  char* handler = vtkJavaUTF8ToChars(env ,id1, len1);
  fstruct->mid = env->GetMethodID(env->GetObjectClass(id0), handler, "()V");
  delete[] handler;

  vtkVRRenderWindowInteractor* op = static_cast<vtkVRRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetClassExitMethod(vtkJavaVoidFunc,fstruct);
  op->SetClassExitMethodArgDelete(vtkJavaVoidFuncArgDelete);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindowInteractor_ExitCallback_18(JNIEnv* env, jobject obj)
{

  vtkVRRenderWindowInteractor* op = static_cast<vtkVRRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ExitCallback();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindowInteractor_SetPhysicalViewDirection_19(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkVRRenderWindowInteractor* op = static_cast<vtkVRRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPhysicalViewDirection(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindowInteractor_SetPhysicalViewUp_110(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkVRRenderWindowInteractor* op = static_cast<vtkVRRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPhysicalViewUp(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindowInteractor_SetPhysicalTranslation_111(JNIEnv* env, jobject obj,jobject id0,jdouble id1,jdouble id2,jdouble id3)
{
  vtkCamera * temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkVRRenderWindowInteractor* op = static_cast<vtkVRRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPhysicalTranslation(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindowInteractor_SetPhysicalScale_112(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkVRRenderWindowInteractor* op = static_cast<vtkVRRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPhysicalScale(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVRRenderWindowInteractor_GetPhysicalScale_113(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkVRRenderWindowInteractor* op = static_cast<vtkVRRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPhysicalScale();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindowInteractor_ConvertPoseToWorldCoordinates_114(JNIEnv* env, jobject obj,jobject id0,jdoubleArray id1,jdoubleArray id2,jdoubleArray id3,jdoubleArray id4)
{
  vtkMatrix4x4 * temp0;
  double temp1[3];
  double temp2[4];
  double temp3[3];
  double temp4[3];
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 4, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  env->GetDoubleArrayRegion(id4, 0, 3, &temp4[0]);

  vtkVRRenderWindowInteractor* op = static_cast<vtkVRRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ConvertPoseToWorldCoordinates(temp0,temp1,temp2,temp3,temp4);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->SetDoubleArrayRegion(id2, 0, 4, &temp2[0]);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  env->SetDoubleArrayRegion(id4, 0, 3, &temp4[0]);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkVRRenderWindowInteractor_GetActionManifestFileName_115(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkVRRenderWindowInteractor* op = static_cast<vtkVRRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActionManifestFileName();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindowInteractor_SetActionManifestFileName_116(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string   temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkVRRenderWindowInteractor* op = static_cast<vtkVRRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetActionManifestFileName(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkVRRenderWindowInteractor_GetActionManifestDirectory_117(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkVRRenderWindowInteractor* op = static_cast<vtkVRRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActionManifestDirectory();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindowInteractor_SetActionManifestDirectory_118(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string   temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkVRRenderWindowInteractor* op = static_cast<vtkVRRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetActionManifestDirectory(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkVRRenderWindowInteractor_GetActionSetName_119(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkVRRenderWindowInteractor* op = static_cast<vtkVRRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActionSetName();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindowInteractor_SetActionSetName_120(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string   temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkVRRenderWindowInteractor* op = static_cast<vtkVRRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetActionSetName(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindowInteractor_HandleComplexGestureEvents_121(JNIEnv* env, jobject obj,jobject id0)
{
  vtkEventData * temp0;
  temp0 = static_cast<vtkEventData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkVRRenderWindowInteractor* op = static_cast<vtkVRRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->HandleComplexGestureEvents(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVRRenderWindowInteractor_RecognizeComplexGesture_122(JNIEnv* env, jobject obj,jobject id0)
{
  vtkEventDataDevice3D * temp0;
  temp0 = static_cast<vtkEventDataDevice3D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkVRRenderWindowInteractor* op = static_cast<vtkVRRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, obj));
  op->RecognizeComplexGesture(temp0);

}
