/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Calculate normalized cross correlation using FFTs.


This filter calculates the normalized cross correlation (NCC) of two
images using FFTs instead of spatial correlation. It is much faster
than spatial correlation for reasonably large structuring elements.
This filter is a subclass of the more general MaskedFFTNormalizedCorrelationImageFilter and operates by essentially setting the masks in that algorithm to
images of ones. As described in detail in the references below, there
is no computational overhead to utilizing the more general masked
algorithm because the FFTs of the images of ones are still necessary
for the computations.

Inputs: Two images are required as inputs, fixedImage and movingImage.
In the context of correlation, inputs are often defined as: "image"
and "template". In this filter, the fixedImage plays the role of the
image, and the movingImage plays the role of the template. However,
this filter is capable of correlating any two images and is not
restricted to small movingImages (templates).

Optional parameters: The RequiredNumberOfOverlappingPixels enables the
user to specify how many voxels of the two images must overlap; any
location in the correlation map that results from fewer than this
number of voxels will be set to zero. Larger values zero-out pixels on
a larger border around the correlation image. Thus, larger values
remove less stable computations but also limit the capture range. If
RequiredNumberOfOverlappingPixels is set to 0, the default, no zeroing
will take place.

Image size: fixedImage and movingImage need not be the same size.
Furthermore, whereas some algorithms require that the "template" be
smaller than the "image" because of errors in the regions where the
two are not fully overlapping, this filter has no such restriction.

Image spacing: Since the computations are done in the pixel domain, all
input images must have the same spacing.

Outputs; The output is an image of RealPixelType that is the NCC of
the two images and its values range from -1.0 to 1.0. The size of this
NCC image is, by definition, size(fixedImage) + size(movingImage) - 1.

Example filter usage:


WARNING:
The pixel type of the output image must be of real type (float or
double). ConceptChecking is used to enforce the output pixel type. You
will get a compilation error if the pixel type of the output image is
not float or double.
 References: 1) D. Padfield. "Masked object registration in the
Fourier domain." Transactions on Image Processing. 2) D. Padfield. "Masked FFT registration". In Proc.
Computer Vision and Pattern Recognition, 2010.


: Dirk Padfield, GE Global Research, padfield@research.ge.com

See:
 itk::simple::FFTNormalizedCorrelation for the procedural interface

 itk::FFTNormalizedCorrelationImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkFFTNormalizedCorrelationImageFilter.h
*/
public class FFTNormalizedCorrelationImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected FFTNormalizedCorrelationImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.FFTNormalizedCorrelationImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(FFTNormalizedCorrelationImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(FFTNormalizedCorrelationImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::FFTNormalizedCorrelationImageFilter::~FFTNormalizedCorrelationImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_FFTNormalizedCorrelationImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::FFTNormalizedCorrelationImageFilter::FFTNormalizedCorrelationImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  FFTNormalizedCorrelationImageFilter() {
    this(SimpleITKJNI.new_FFTNormalizedCorrelationImageFilter(), true);
  }

  /**
Self&amp; itk::simple::FFTNormalizedCorrelationImageFilter::SetRequiredNumberOfOverlappingPixels(uint64_t RequiredNumberOfOverlappingPixels)

Set and get the required number of overlapping pixels

*/
public  void setRequiredNumberOfOverlappingPixels(java.math.BigInteger RequiredNumberOfOverlappingPixels) {
    SimpleITKJNI.FFTNormalizedCorrelationImageFilter_setRequiredNumberOfOverlappingPixels(swigCPtr, this, RequiredNumberOfOverlappingPixels);
  }

  /**
uint64_t itk::simple::FFTNormalizedCorrelationImageFilter::GetRequiredNumberOfOverlappingPixels() const

Set and get the required number of overlapping pixels

*/
public  java.math.BigInteger getRequiredNumberOfOverlappingPixels() {
    return SimpleITKJNI.FFTNormalizedCorrelationImageFilter_getRequiredNumberOfOverlappingPixels(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FFTNormalizedCorrelationImageFilter::SetRequiredFractionOfOverlappingPixels(double RequiredFractionOfOverlappingPixels)

Set and get the required fraction of overlapping pixels

*/
public  void setRequiredFractionOfOverlappingPixels(double RequiredFractionOfOverlappingPixels) {
    SimpleITKJNI.FFTNormalizedCorrelationImageFilter_setRequiredFractionOfOverlappingPixels(swigCPtr, this, RequiredFractionOfOverlappingPixels);
  }

  /**
double itk::simple::FFTNormalizedCorrelationImageFilter::GetRequiredFractionOfOverlappingPixels() const

Set and get the required fraction of overlapping pixels

*/
public  double getRequiredFractionOfOverlappingPixels() {
    return SimpleITKJNI.FFTNormalizedCorrelationImageFilter_getRequiredFractionOfOverlappingPixels(swigCPtr, this);
  }

  /**
std::string itk::simple::FFTNormalizedCorrelationImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.FFTNormalizedCorrelationImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::FFTNormalizedCorrelationImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.FFTNormalizedCorrelationImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::FFTNormalizedCorrelationImageFilter::Execute(const Image &amp;fixedImage, const Image &amp;movingImage)

Execute the filter on the input image

*/
public  Image execute(Image fixedImage, Image movingImage) {
    return new Image(SimpleITKJNI.FFTNormalizedCorrelationImageFilter_execute(swigCPtr, this, Image.getCPtr(fixedImage), fixedImage, Image.getCPtr(movingImage), movingImage), true);
  }

}
