/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Threshold an image using the Shanbhag Threshold.


This filter creates a binary thresholded image that separates an image
into foreground and background components. The filter computes the
threshold using the ShanbhagThresholdCalculator and applies that threshold to the input image using the BinaryThresholdImageFilter .


Richard Beare. Department of Medicine, Monash University, Melbourne,
Australia.

Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/efycla


See:
 HistogramThresholdImageFilter

 itk::simple::ShanbhagThreshold for the procedural interface

 itk::ShanbhagThresholdImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkShanbhagThresholdImageFilter.h
*/
public class ShanbhagThresholdImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ShanbhagThresholdImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ShanbhagThresholdImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ShanbhagThresholdImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ShanbhagThresholdImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ShanbhagThresholdImageFilter::~ShanbhagThresholdImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ShanbhagThresholdImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ShanbhagThresholdImageFilter::ShanbhagThresholdImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ShanbhagThresholdImageFilter() {
    this(SimpleITKJNI.new_ShanbhagThresholdImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ShanbhagThresholdImageFilter::SetInsideValue(uint8_t InsideValue)

Set the "inside" pixel value.

*/
public  void setInsideValue(short InsideValue) {
    SimpleITKJNI.ShanbhagThresholdImageFilter_setInsideValue(swigCPtr, this, InsideValue);
  }

  /**
uint8_t itk::simple::ShanbhagThresholdImageFilter::GetInsideValue() const

Get the "inside" pixel value.

*/
public  short getInsideValue() {
    return SimpleITKJNI.ShanbhagThresholdImageFilter_getInsideValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ShanbhagThresholdImageFilter::SetOutsideValue(uint8_t OutsideValue)

Set the "outside" pixel value. The default value NumericTraits&lt;OutputPixelType&gt;::Zero.

*/
public  void setOutsideValue(short OutsideValue) {
    SimpleITKJNI.ShanbhagThresholdImageFilter_setOutsideValue(swigCPtr, this, OutsideValue);
  }

  /**
uint8_t itk::simple::ShanbhagThresholdImageFilter::GetOutsideValue() const

Get the "outside" pixel value.

*/
public  short getOutsideValue() {
    return SimpleITKJNI.ShanbhagThresholdImageFilter_getOutsideValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ShanbhagThresholdImageFilter::SetNumberOfHistogramBins(uint32_t NumberOfHistogramBins)

Set/Get the number of histogram bins.

*/
public  void setNumberOfHistogramBins(long NumberOfHistogramBins) {
    SimpleITKJNI.ShanbhagThresholdImageFilter_setNumberOfHistogramBins(swigCPtr, this, NumberOfHistogramBins);
  }

  /**
uint32_t itk::simple::ShanbhagThresholdImageFilter::GetNumberOfHistogramBins() const
*/
public  long getNumberOfHistogramBins() {
    return SimpleITKJNI.ShanbhagThresholdImageFilter_getNumberOfHistogramBins(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ShanbhagThresholdImageFilter::SetMaskOutput(bool MaskOutput)

Do you want the output to be masked by the mask used in histogram
construction. Only relevant if masking is in use.

*/
public  void setMaskOutput(boolean MaskOutput) {
    SimpleITKJNI.ShanbhagThresholdImageFilter_setMaskOutput(swigCPtr, this, MaskOutput);
  }

  /**
Self&amp; itk::simple::ShanbhagThresholdImageFilter::MaskOutputOn()

Set the value of MaskOutput to true or false respectfully.

*/
public  void maskOutputOn() {
    SimpleITKJNI.ShanbhagThresholdImageFilter_maskOutputOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ShanbhagThresholdImageFilter::MaskOutputOff()
*/
public  void maskOutputOff() {
    SimpleITKJNI.ShanbhagThresholdImageFilter_maskOutputOff(swigCPtr, this);
  }

  /**
bool itk::simple::ShanbhagThresholdImageFilter::GetMaskOutput() const
*/
public  boolean getMaskOutput() {
    return SimpleITKJNI.ShanbhagThresholdImageFilter_getMaskOutput(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ShanbhagThresholdImageFilter::SetMaskValue(uint8_t MaskValue)

The value in the mask image, if used, indicating voxels that should be
included. Default is the max of pixel type, as in the
MaskedImageToHistogramFilter

*/
public  void setMaskValue(short MaskValue) {
    SimpleITKJNI.ShanbhagThresholdImageFilter_setMaskValue(swigCPtr, this, MaskValue);
  }

  /**
uint8_t itk::simple::ShanbhagThresholdImageFilter::GetMaskValue() const
*/
public  short getMaskValue() {
    return SimpleITKJNI.ShanbhagThresholdImageFilter_getMaskValue(swigCPtr, this);
  }

  /**
double itk::simple::ShanbhagThresholdImageFilter::GetThreshold() const

Get the computed threshold.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getThreshold() {
    return SimpleITKJNI.ShanbhagThresholdImageFilter_getThreshold(swigCPtr, this);
  }

  /**
std::string itk::simple::ShanbhagThresholdImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ShanbhagThresholdImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ShanbhagThresholdImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ShanbhagThresholdImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ShanbhagThresholdImageFilter::Execute(const Image &amp;image, const Image &amp;maskImage)

Execute the filter on the input image

*/
public  Image execute(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.ShanbhagThresholdImageFilter_execute__SWIG_0(swigCPtr, this, Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

  /**
Image itk::simple::ShanbhagThresholdImageFilter::Execute(const Image &amp;image, const Image &amp;maskImage)

Execute the filter on the input image

*/
public  Image execute(Image image) {
    return new Image(SimpleITKJNI.ShanbhagThresholdImageFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(image), image), true);
  }

}
