/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, qtgui, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_qtgui_freq_sink_f = R"doc(A graphical sink to display multiple signals in frequency.

This is a QT-based graphical sink the takes set of a floating point streams and plots the PSD. Each signal is plotted with a different color, and the  and  functions can be used to change the label and color for a given input number.


The sink supports plotting streaming float data or messages. The message port is named \"in\". The two modes cannot be used simultaneously, and  should be set to 0 when using the message mode. GRC handles this issue by providing the \"Float Message\" type that removes the streaming port(s).


This sink can plot messages that contain either uniform vectors of float 32 values (pmt::is_f32vector) or PDUs where the data is a uniform vector of float 32 values.


Message Ports:

Constructor Specific Documentation:

Build a floating point PSD sink.

Args:
    fftsize : size of the FFT to compute and display. If using the PDU message port to plot samples, the length of each PDU must be a multiple of the FFT size.
    wintype : type of window to apply (see gr::fft::window::win_type). By setting bit 16 to one, this block will normalize the window before applying it. This allows switching between windows without sacrificing signal power due to tapering, but it will also amplify some samples. See also set_fft_window_normalized().
    fc : center frequency of signal (use for x-axis labels)
    bw : bandwidth of signal (used to set x-axis labels)
    name : title for the plot
    nconnections : number of signals to be connected to the sink. The PDU message port is always available for a connection, and this value must be set to 0 if only the PDU message port is being used.
    parent : a QWidget parent object, if any)doc";


static const char* __doc_gr_qtgui_freq_sink_f_freq_sink_f_0 = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_freq_sink_f_1 = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_make = R"doc(A graphical sink to display multiple signals in frequency.

This is a QT-based graphical sink the takes set of a floating point streams and plots the PSD. Each signal is plotted with a different color, and the  and  functions can be used to change the label and color for a given input number.


The sink supports plotting streaming float data or messages. The message port is named \"in\". The two modes cannot be used simultaneously, and  should be set to 0 when using the message mode. GRC handles this issue by providing the \"Float Message\" type that removes the streaming port(s).


This sink can plot messages that contain either uniform vectors of float 32 values (pmt::is_f32vector) or PDUs where the data is a uniform vector of float 32 values.


Message Ports:

Constructor Specific Documentation:

Build a floating point PSD sink.

Args:
    fftsize : size of the FFT to compute and display. If using the PDU message port to plot samples, the length of each PDU must be a multiple of the FFT size.
    wintype : type of window to apply (see gr::fft::window::win_type). By setting bit 16 to one, this block will normalize the window before applying it. This allows switching between windows without sacrificing signal power due to tapering, but it will also amplify some samples. See also set_fft_window_normalized().
    fc : center frequency of signal (use for x-axis labels)
    bw : bandwidth of signal (used to set x-axis labels)
    name : title for the plot
    nconnections : number of signals to be connected to the sink. The PDU message port is always available for a connection, and this value must be set to 0 if only the PDU message port is being used.
    parent : a QWidget parent object, if any)doc";


static const char* __doc_gr_qtgui_freq_sink_f_exec_ = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_qwidget = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_set_fft_size = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_fft_size = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_set_fft_average = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_fft_average = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_set_fft_window = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_fft_window = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_set_fft_window_normalized = R"doc(If true, normalize window to unit power.)doc";


static const char* __doc_gr_qtgui_freq_sink_f_set_frequency_range = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_set_y_axis = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_set_update_time = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_set_title = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_set_y_label = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_set_line_label = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_set_line_color = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_set_line_width = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_set_line_style = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_set_line_marker = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_set_line_alpha = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_set_plot_pos_half = R"doc(Pass \"true\" to this function to only show the positive half of the spectrum. By default, this plotter shows the full spectrum (positive and negative halves).)doc";


static const char* __doc_gr_qtgui_freq_sink_f_set_trigger_mode = R"doc(Set up a trigger for the sink to know when to start plotting. Useful to isolate events and avoid noise.


The trigger modes are Free, Auto, Normal, and Tag (see gr::qtgui::trigger_mode). The first three are like a normal trigger function. Free means free running with no trigger, auto will trigger if the trigger event is seen, but will still plot otherwise, and normal will hold until the trigger event is observed. The Tag trigger mode allows us to trigger off a specific stream tag. The tag trigger is based only on the name of the tag, so when a tag of the given name is seen, the trigger is activated.


In auto and normal mode, we look to see if the magnitude of the any FFT point is over the set level.)doc";


static const char* __doc_gr_qtgui_freq_sink_f_title = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_line_label = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_line_color = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_line_width = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_line_style = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_line_marker = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_line_alpha = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_set_size = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_enable_menu = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_enable_grid = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_enable_autoscale = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_enable_control_panel = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_enable_max_hold = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_enable_min_hold = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_clear_max_hold = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_clear_min_hold = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_disable_legend = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_reset = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_f_enable_axis_labels = R"doc()doc";
