{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Used by list widgets to represent the headers they display.
-- 
-- @GtkListHeader@ objects are managed just like t'GI.Gtk.Objects.ListItem.ListItem'
-- objects via their factory, but provide a different set of properties suitable
-- for managing the header instead of individual items.
-- 
-- /Since: 4.12/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.ListHeader
    ( 

-- * Exported types
    ListHeader(..)                          ,
    IsListHeader                            ,
    toListHeader                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getChild]("GI.Gtk.Objects.ListHeader#g:method:getChild"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getEnd]("GI.Gtk.Objects.ListHeader#g:method:getEnd"), [getItem]("GI.Gtk.Objects.ListHeader#g:method:getItem"), [getNItems]("GI.Gtk.Objects.ListHeader#g:method:getNItems"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getStart]("GI.Gtk.Objects.ListHeader#g:method:getStart").
-- 
-- ==== Setters
-- [setChild]("GI.Gtk.Objects.ListHeader#g:method:setChild"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveListHeaderMethod                 ,
#endif

-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    ListHeaderGetChildMethodInfo            ,
#endif
    listHeaderGetChild                      ,


-- ** getEnd #method:getEnd#

#if defined(ENABLE_OVERLOADING)
    ListHeaderGetEndMethodInfo              ,
#endif
    listHeaderGetEnd                        ,


-- ** getItem #method:getItem#

#if defined(ENABLE_OVERLOADING)
    ListHeaderGetItemMethodInfo             ,
#endif
    listHeaderGetItem                       ,


-- ** getNItems #method:getNItems#

#if defined(ENABLE_OVERLOADING)
    ListHeaderGetNItemsMethodInfo           ,
#endif
    listHeaderGetNItems                     ,


-- ** getStart #method:getStart#

#if defined(ENABLE_OVERLOADING)
    ListHeaderGetStartMethodInfo            ,
#endif
    listHeaderGetStart                      ,


-- ** setChild #method:setChild#

#if defined(ENABLE_OVERLOADING)
    ListHeaderSetChildMethodInfo            ,
#endif
    listHeaderSetChild                      ,




 -- * Properties


-- ** child #attr:child#
-- | Widget used for display.
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    ListHeaderChildPropertyInfo             ,
#endif
    clearListHeaderChild                    ,
    constructListHeaderChild                ,
    getListHeaderChild                      ,
#if defined(ENABLE_OVERLOADING)
    listHeaderChild                         ,
#endif
    setListHeaderChild                      ,


-- ** end #attr:end#
-- | The first position no longer part of this section.
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    ListHeaderEndPropertyInfo               ,
#endif
    getListHeaderEnd                        ,
#if defined(ENABLE_OVERLOADING)
    listHeaderEnd                           ,
#endif


-- ** item #attr:item#
-- | The item at the start of the section.
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    ListHeaderItemPropertyInfo              ,
#endif
    getListHeaderItem                       ,
#if defined(ENABLE_OVERLOADING)
    listHeaderItem                          ,
#endif


-- ** nItems #attr:nItems#
-- | Number of items in this section.
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    ListHeaderNItemsPropertyInfo            ,
#endif
    getListHeaderNItems                     ,
#if defined(ENABLE_OVERLOADING)
    listHeaderNItems                        ,
#endif


-- ** start #attr:start#
-- | First position of items in this section.
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    ListHeaderStartPropertyInfo             ,
#endif
    getListHeaderStart                      ,
#if defined(ENABLE_OVERLOADING)
    listHeaderStart                         ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype ListHeader = ListHeader (SP.ManagedPtr ListHeader)
    deriving (Eq)

instance SP.ManagedPtrNewtype ListHeader where
    toManagedPtr (ListHeader p) = p

foreign import ccall "gtk_list_header_get_type"
    c_gtk_list_header_get_type :: IO B.Types.GType

instance B.Types.TypedObject ListHeader where
    glibType = c_gtk_list_header_get_type

instance B.Types.GObject ListHeader

-- | Type class for types which can be safely cast to t'ListHeader', for instance with `toListHeader`.
class (SP.GObject o, O.IsDescendantOf ListHeader o) => IsListHeader o
instance (SP.GObject o, O.IsDescendantOf ListHeader o) => IsListHeader o

instance O.HasParentTypes ListHeader
type instance O.ParentTypes ListHeader = '[GObject.Object.Object]

-- | Cast to t'ListHeader', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toListHeader :: (MIO.MonadIO m, IsListHeader o) => o -> m ListHeader
toListHeader = MIO.liftIO . B.ManagedPtr.unsafeCastTo ListHeader

-- | Convert t'ListHeader' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ListHeader) where
    gvalueGType_ = c_gtk_list_header_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ListHeader)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ListHeader)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ListHeader ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveListHeaderMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveListHeaderMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveListHeaderMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveListHeaderMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveListHeaderMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveListHeaderMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveListHeaderMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveListHeaderMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveListHeaderMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveListHeaderMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveListHeaderMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveListHeaderMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveListHeaderMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveListHeaderMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveListHeaderMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveListHeaderMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveListHeaderMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveListHeaderMethod "getChild" o = ListHeaderGetChildMethodInfo
    ResolveListHeaderMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveListHeaderMethod "getEnd" o = ListHeaderGetEndMethodInfo
    ResolveListHeaderMethod "getItem" o = ListHeaderGetItemMethodInfo
    ResolveListHeaderMethod "getNItems" o = ListHeaderGetNItemsMethodInfo
    ResolveListHeaderMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveListHeaderMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveListHeaderMethod "getStart" o = ListHeaderGetStartMethodInfo
    ResolveListHeaderMethod "setChild" o = ListHeaderSetChildMethodInfo
    ResolveListHeaderMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveListHeaderMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveListHeaderMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveListHeaderMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveListHeaderMethod t ListHeader, O.OverloadedMethod info ListHeader p) => OL.IsLabel t (ListHeader -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveListHeaderMethod t ListHeader, O.OverloadedMethod info ListHeader p, R.HasField t ListHeader p) => R.HasField t ListHeader p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveListHeaderMethod t ListHeader, O.OverloadedMethodInfo info ListHeader) => OL.IsLabel t (O.MethodProxy info ListHeader) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "child"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' listHeader #child
-- @
getListHeaderChild :: (MonadIO m, IsListHeader o) => o -> m (Maybe Gtk.Widget.Widget)
getListHeaderChild obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "child" Gtk.Widget.Widget

-- | Set the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' listHeader [ #child 'Data.GI.Base.Attributes.:=' value ]
-- @
setListHeaderChild :: (MonadIO m, IsListHeader o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setListHeaderChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "child" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructListHeaderChild :: (IsListHeader o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructListHeaderChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "child" (P.Just val)

-- | Set the value of the “@child@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #child
-- @
clearListHeaderChild :: (MonadIO m, IsListHeader o) => o -> m ()
clearListHeaderChild obj = liftIO $ B.Properties.setObjectPropertyObject obj "child" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data ListHeaderChildPropertyInfo
instance AttrInfo ListHeaderChildPropertyInfo where
    type AttrAllowedOps ListHeaderChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ListHeaderChildPropertyInfo = IsListHeader
    type AttrSetTypeConstraint ListHeaderChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint ListHeaderChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType ListHeaderChildPropertyInfo = Gtk.Widget.Widget
    type AttrGetType ListHeaderChildPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel ListHeaderChildPropertyInfo = "child"
    type AttrOrigin ListHeaderChildPropertyInfo = ListHeader
    attrGet = getListHeaderChild
    attrSet = setListHeaderChild
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructListHeaderChild
    attrClear = clearListHeaderChild
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListHeader.child"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListHeader.html#g:attr:child"
        })
#endif

-- VVV Prop "end"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@end@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' listHeader #end
-- @
getListHeaderEnd :: (MonadIO m, IsListHeader o) => o -> m Word32
getListHeaderEnd obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "end"

#if defined(ENABLE_OVERLOADING)
data ListHeaderEndPropertyInfo
instance AttrInfo ListHeaderEndPropertyInfo where
    type AttrAllowedOps ListHeaderEndPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint ListHeaderEndPropertyInfo = IsListHeader
    type AttrSetTypeConstraint ListHeaderEndPropertyInfo = (~) ()
    type AttrTransferTypeConstraint ListHeaderEndPropertyInfo = (~) ()
    type AttrTransferType ListHeaderEndPropertyInfo = ()
    type AttrGetType ListHeaderEndPropertyInfo = Word32
    type AttrLabel ListHeaderEndPropertyInfo = "end"
    type AttrOrigin ListHeaderEndPropertyInfo = ListHeader
    attrGet = getListHeaderEnd
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListHeader.end"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListHeader.html#g:attr:end"
        })
#endif

-- VVV Prop "item"
   -- Type: TInterface (Name {namespace = "GObject", name = "Object"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@item@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' listHeader #item
-- @
getListHeaderItem :: (MonadIO m, IsListHeader o) => o -> m (Maybe GObject.Object.Object)
getListHeaderItem obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "item" GObject.Object.Object

#if defined(ENABLE_OVERLOADING)
data ListHeaderItemPropertyInfo
instance AttrInfo ListHeaderItemPropertyInfo where
    type AttrAllowedOps ListHeaderItemPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ListHeaderItemPropertyInfo = IsListHeader
    type AttrSetTypeConstraint ListHeaderItemPropertyInfo = (~) ()
    type AttrTransferTypeConstraint ListHeaderItemPropertyInfo = (~) ()
    type AttrTransferType ListHeaderItemPropertyInfo = ()
    type AttrGetType ListHeaderItemPropertyInfo = (Maybe GObject.Object.Object)
    type AttrLabel ListHeaderItemPropertyInfo = "item"
    type AttrOrigin ListHeaderItemPropertyInfo = ListHeader
    attrGet = getListHeaderItem
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListHeader.item"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListHeader.html#g:attr:item"
        })
#endif

-- VVV Prop "n-items"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@n-items@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' listHeader #nItems
-- @
getListHeaderNItems :: (MonadIO m, IsListHeader o) => o -> m Word32
getListHeaderNItems obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "n-items"

#if defined(ENABLE_OVERLOADING)
data ListHeaderNItemsPropertyInfo
instance AttrInfo ListHeaderNItemsPropertyInfo where
    type AttrAllowedOps ListHeaderNItemsPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint ListHeaderNItemsPropertyInfo = IsListHeader
    type AttrSetTypeConstraint ListHeaderNItemsPropertyInfo = (~) ()
    type AttrTransferTypeConstraint ListHeaderNItemsPropertyInfo = (~) ()
    type AttrTransferType ListHeaderNItemsPropertyInfo = ()
    type AttrGetType ListHeaderNItemsPropertyInfo = Word32
    type AttrLabel ListHeaderNItemsPropertyInfo = "n-items"
    type AttrOrigin ListHeaderNItemsPropertyInfo = ListHeader
    attrGet = getListHeaderNItems
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListHeader.nItems"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListHeader.html#g:attr:nItems"
        })
#endif

-- VVV Prop "start"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@start@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' listHeader #start
-- @
getListHeaderStart :: (MonadIO m, IsListHeader o) => o -> m Word32
getListHeaderStart obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "start"

#if defined(ENABLE_OVERLOADING)
data ListHeaderStartPropertyInfo
instance AttrInfo ListHeaderStartPropertyInfo where
    type AttrAllowedOps ListHeaderStartPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint ListHeaderStartPropertyInfo = IsListHeader
    type AttrSetTypeConstraint ListHeaderStartPropertyInfo = (~) ()
    type AttrTransferTypeConstraint ListHeaderStartPropertyInfo = (~) ()
    type AttrTransferType ListHeaderStartPropertyInfo = ()
    type AttrGetType ListHeaderStartPropertyInfo = Word32
    type AttrLabel ListHeaderStartPropertyInfo = "start"
    type AttrOrigin ListHeaderStartPropertyInfo = ListHeader
    attrGet = getListHeaderStart
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListHeader.start"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListHeader.html#g:attr:start"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ListHeader
type instance O.AttributeList ListHeader = ListHeaderAttributeList
type ListHeaderAttributeList = ('[ '("child", ListHeaderChildPropertyInfo), '("end", ListHeaderEndPropertyInfo), '("item", ListHeaderItemPropertyInfo), '("nItems", ListHeaderNItemsPropertyInfo), '("start", ListHeaderStartPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
listHeaderChild :: AttrLabelProxy "child"
listHeaderChild = AttrLabelProxy

listHeaderEnd :: AttrLabelProxy "end"
listHeaderEnd = AttrLabelProxy

listHeaderItem :: AttrLabelProxy "item"
listHeaderItem = AttrLabelProxy

listHeaderNItems :: AttrLabelProxy "nItems"
listHeaderNItems = AttrLabelProxy

listHeaderStart :: AttrLabelProxy "start"
listHeaderStart = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ListHeader = ListHeaderSignalList
type ListHeaderSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method ListHeader::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListHeader" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListHeader`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_header_get_child" gtk_list_header_get_child :: 
    Ptr ListHeader ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ListHeader"})
    IO (Ptr Gtk.Widget.Widget)

-- | Gets the child previously set via 'GI.Gtk.Objects.ListHeader.listHeaderSetChild' or
-- 'P.Nothing' if none was set.
-- 
-- /Since: 4.12/
listHeaderGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsListHeader a) =>
    a
    -- ^ /@self@/: a @GtkListHeader@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ The child
listHeaderGetChild self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_list_header_get_child self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ListHeaderGetChildMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsListHeader a) => O.OverloadedMethod ListHeaderGetChildMethodInfo a signature where
    overloadedMethod = listHeaderGetChild

instance O.OverloadedMethodInfo ListHeaderGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListHeader.listHeaderGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListHeader.html#v:listHeaderGetChild"
        })


#endif

-- method ListHeader::get_end
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListHeader" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListHeader`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_header_get_end" gtk_list_header_get_end :: 
    Ptr ListHeader ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ListHeader"})
    IO Word32

-- | Gets the end position in the model of the section that /@self@/ is
-- currently the header for.
-- 
-- If /@self@/ is unbound, 'GI.Gtk.Constants.INVALID_LIST_POSITION' is returned.
-- 
-- /Since: 4.12/
listHeaderGetEnd ::
    (B.CallStack.HasCallStack, MonadIO m, IsListHeader a) =>
    a
    -- ^ /@self@/: a @GtkListHeader@
    -> m Word32
    -- ^ __Returns:__ The end position of the section
listHeaderGetEnd self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_list_header_get_end self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data ListHeaderGetEndMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsListHeader a) => O.OverloadedMethod ListHeaderGetEndMethodInfo a signature where
    overloadedMethod = listHeaderGetEnd

instance O.OverloadedMethodInfo ListHeaderGetEndMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListHeader.listHeaderGetEnd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListHeader.html#v:listHeaderGetEnd"
        })


#endif

-- method ListHeader::get_item
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListHeader" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListHeader`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GObject" , name = "Object" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_header_get_item" gtk_list_header_get_item :: 
    Ptr ListHeader ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ListHeader"})
    IO (Ptr GObject.Object.Object)

-- | Gets the model item at the start of the section.
-- This is the item that occupies the list model at position
-- [ListHeader:start]("GI.Gtk.Objects.ListHeader#g:attr:start").
-- 
-- If /@self@/ is unbound, this function returns 'P.Nothing'.
-- 
-- /Since: 4.12/
listHeaderGetItem ::
    (B.CallStack.HasCallStack, MonadIO m, IsListHeader a) =>
    a
    -- ^ /@self@/: a @GtkListHeader@
    -> m (Maybe GObject.Object.Object)
    -- ^ __Returns:__ The item displayed
listHeaderGetItem self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_list_header_get_item self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject GObject.Object.Object) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ListHeaderGetItemMethodInfo
instance (signature ~ (m (Maybe GObject.Object.Object)), MonadIO m, IsListHeader a) => O.OverloadedMethod ListHeaderGetItemMethodInfo a signature where
    overloadedMethod = listHeaderGetItem

instance O.OverloadedMethodInfo ListHeaderGetItemMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListHeader.listHeaderGetItem",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListHeader.html#v:listHeaderGetItem"
        })


#endif

-- method ListHeader::get_n_items
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListHeader" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListHeader`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_header_get_n_items" gtk_list_header_get_n_items :: 
    Ptr ListHeader ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ListHeader"})
    IO Word32

-- | Gets the the number of items in the section.
-- 
-- If /@self@/ is unbound, 0 is returned.
-- 
-- /Since: 4.12/
listHeaderGetNItems ::
    (B.CallStack.HasCallStack, MonadIO m, IsListHeader a) =>
    a
    -- ^ /@self@/: a @GtkListHeader@
    -> m Word32
    -- ^ __Returns:__ The number of items in the section
listHeaderGetNItems self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_list_header_get_n_items self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data ListHeaderGetNItemsMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsListHeader a) => O.OverloadedMethod ListHeaderGetNItemsMethodInfo a signature where
    overloadedMethod = listHeaderGetNItems

instance O.OverloadedMethodInfo ListHeaderGetNItemsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListHeader.listHeaderGetNItems",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListHeader.html#v:listHeaderGetNItems"
        })


#endif

-- method ListHeader::get_start
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListHeader" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListHeader`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_header_get_start" gtk_list_header_get_start :: 
    Ptr ListHeader ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ListHeader"})
    IO Word32

-- | Gets the start position in the model of the section that /@self@/ is
-- currently the header for.
-- 
-- If /@self@/ is unbound, 'GI.Gtk.Constants.INVALID_LIST_POSITION' is returned.
-- 
-- /Since: 4.12/
listHeaderGetStart ::
    (B.CallStack.HasCallStack, MonadIO m, IsListHeader a) =>
    a
    -- ^ /@self@/: a @GtkListHeader@
    -> m Word32
    -- ^ __Returns:__ The start position of the section
listHeaderGetStart self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_list_header_get_start self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data ListHeaderGetStartMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsListHeader a) => O.OverloadedMethod ListHeaderGetStartMethodInfo a signature where
    overloadedMethod = listHeaderGetStart

instance O.OverloadedMethodInfo ListHeaderGetStartMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListHeader.listHeaderGetStart",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListHeader.html#v:listHeaderGetStart"
        })


#endif

-- method ListHeader::set_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListHeader" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListHeader`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The list item's child or %NULL to unset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_header_set_child" gtk_list_header_set_child :: 
    Ptr ListHeader ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ListHeader"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the child to be used for this listitem.
-- 
-- This function is typically called by applications when
-- setting up a header so that the widget can be reused when
-- binding it multiple times.
-- 
-- /Since: 4.12/
listHeaderSetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsListHeader a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@self@/: a @GtkListHeader@
    -> Maybe (b)
    -- ^ /@child@/: The list item\'s child or 'P.Nothing' to unset
    -> m ()
listHeaderSetChild self child = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeChild <- case child of
        Nothing -> return FP.nullPtr
        Just jChild -> do
            jChild' <- unsafeManagedPtrCastPtr jChild
            return jChild'
    gtk_list_header_set_child self' maybeChild
    touchManagedPtr self
    whenJust child touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ListHeaderSetChildMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsListHeader a, Gtk.Widget.IsWidget b) => O.OverloadedMethod ListHeaderSetChildMethodInfo a signature where
    overloadedMethod = listHeaderSetChild

instance O.OverloadedMethodInfo ListHeaderSetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListHeader.listHeaderSetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListHeader.html#v:listHeaderSetChild"
        })


#endif


