/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.threadpool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.Version;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.SizeValue;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.common.util.concurrent.OpenSearchThreadPoolExecutor;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.util.concurrent.XRejectedExecutionHandler;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.opensearch.core.service.ReportingService;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.node.Node;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.FixedExecutorBuilder;
import org.opensearch.threadpool.ResizableExecutorBuilder;
import org.opensearch.threadpool.RunnableTaskExecutionListener;
import org.opensearch.threadpool.ScalingExecutorBuilder;
import org.opensearch.threadpool.ScheduledCancellableAdapter;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPoolInfo;
import org.opensearch.threadpool.ThreadPoolStats;

@PublicApi(since="1.0.0")
public class ThreadPool
implements ReportingService<ThreadPoolInfo>,
Scheduler {
    private static final Logger logger = LogManager.getLogger(ThreadPool.class);
    static Set<String> scalingThreadPoolKeys = new HashSet<String>(Arrays.asList("max", "core"));
    static Set<String> fixedThreadPoolKeys = new HashSet<String>(Arrays.asList("size"));
    public static final Map<String, ThreadPoolType> THREAD_POOL_TYPES;
    private final Map<String, ExecutorHolder> executors;
    private final ThreadPoolInfo threadPoolInfo;
    private final CachedTimeThread cachedTimeThread;
    static final ExecutorService DIRECT_EXECUTOR;
    private final ThreadContext threadContext;
    private final Map<String, ExecutorBuilder> builders;
    private final ScheduledThreadPoolExecutor scheduler;
    public static Setting<TimeValue> ESTIMATED_TIME_INTERVAL_SETTING;
    public static final Setting<Settings> CLUSTER_THREAD_POOL_SIZE_SETTING;

    public Collection<ExecutorBuilder> builders() {
        return Collections.unmodifiableCollection(this.builders.values());
    }

    public ThreadPool(Settings settings, ExecutorBuilder<?> ... customBuilders) {
        this(settings, (AtomicReference<RunnableTaskExecutionListener>)null, customBuilders);
    }

    public ThreadPool(Settings settings, AtomicReference<RunnableTaskExecutionListener> runnableTaskListener, ExecutorBuilder<?> ... customBuilders) {
        assert (Node.NODE_NAME_SETTING.exists(settings));
        HashMap builders = new HashMap();
        int allocatedProcessors = OpenSearchExecutors.allocatedProcessors(settings);
        int halfProc = ThreadPool.halfAllocatedProcessors(allocatedProcessors);
        int halfProcMaxAt5 = ThreadPool.halfAllocatedProcessorsMaxFive(allocatedProcessors);
        int halfProcMaxAt10 = ThreadPool.halfAllocatedProcessorsMaxTen(allocatedProcessors);
        int genericThreadPoolMax = ThreadPool.boundedBy(4 * allocatedProcessors, 128, 512);
        int snapshotDeletionPoolMax = ThreadPool.boundedBy(4 * allocatedProcessors, 64, 256);
        builders.put("generic", new ScalingExecutorBuilder("generic", 4, genericThreadPoolMax, TimeValue.timeValueSeconds((long)30L)));
        builders.put("write", new FixedExecutorBuilder(settings, "write", allocatedProcessors, 10000));
        builders.put("get", new FixedExecutorBuilder(settings, "get", allocatedProcessors, 1000));
        builders.put("analyze", new FixedExecutorBuilder(settings, "analyze", 1, 16));
        builders.put("search", new ResizableExecutorBuilder(settings, "search", ThreadPool.searchThreadPoolSize(allocatedProcessors), 1000, runnableTaskListener));
        builders.put("stream_search", new ResizableExecutorBuilder(settings, "stream_search", ThreadPool.searchThreadPoolSize(allocatedProcessors), 1000, runnableTaskListener));
        builders.put("search_throttled", new ResizableExecutorBuilder(settings, "search_throttled", 1, 100, runnableTaskListener));
        builders.put("management", new ScalingExecutorBuilder("management", 1, 5, TimeValue.timeValueMinutes((long)5L)));
        builders.put("listener", new FixedExecutorBuilder(settings, "listener", halfProcMaxAt10, -1, true));
        builders.put("flush", new ScalingExecutorBuilder("flush", 1, halfProcMaxAt5, TimeValue.timeValueMinutes((long)5L)));
        builders.put("refresh", new ScalingExecutorBuilder("refresh", 1, halfProcMaxAt10, TimeValue.timeValueMinutes((long)5L)));
        builders.put("warmer", new ScalingExecutorBuilder("warmer", 1, halfProcMaxAt5, TimeValue.timeValueMinutes((long)5L)));
        builders.put("snapshot", new ScalingExecutorBuilder("snapshot", 1, halfProcMaxAt5, TimeValue.timeValueMinutes((long)5L)));
        builders.put("snapshot_deletion", new ScalingExecutorBuilder("snapshot_deletion", 1, snapshotDeletionPoolMax, TimeValue.timeValueMinutes((long)5L)));
        builders.put("fetch_shard_started", new ScalingExecutorBuilder("fetch_shard_started", 1, 2 * allocatedProcessors, TimeValue.timeValueMinutes((long)5L)));
        builders.put("force_merge", new FixedExecutorBuilder(settings, "force_merge", ThreadPool.oneEighthAllocatedProcessors(allocatedProcessors), -1));
        builders.put("fetch_shard_store", new ScalingExecutorBuilder("fetch_shard_store", 1, 2 * allocatedProcessors, TimeValue.timeValueMinutes((long)5L)));
        builders.put("system_read", new FixedExecutorBuilder(settings, "system_read", halfProcMaxAt5, 2000, false));
        builders.put("system_write", new FixedExecutorBuilder(settings, "system_write", halfProcMaxAt5, 1000, false));
        builders.put("translog_transfer", new ScalingExecutorBuilder("translog_transfer", 1, halfProc, TimeValue.timeValueMinutes((long)5L)));
        builders.put("translog_sync", new FixedExecutorBuilder(settings, "translog_sync", allocatedProcessors * 4, 10000));
        builders.put("remote_purge", new ScalingExecutorBuilder("remote_purge", 1, halfProc, TimeValue.timeValueMinutes((long)5L)));
        builders.put("remote_refresh_retry", new ScalingExecutorBuilder("remote_refresh_retry", 1, halfProc, TimeValue.timeValueMinutes((long)5L)));
        builders.put("remote_recovery", new ScalingExecutorBuilder("remote_recovery", 1, ThreadPool.twiceAllocatedProcessors(allocatedProcessors), TimeValue.timeValueMinutes((long)5L)));
        builders.put("remote_state_read", new FixedExecutorBuilder(settings, "remote_state_read", ThreadPool.boundedBy(4 * allocatedProcessors, 4, 32), 120000));
        builders.put("index_searcher", new ResizableExecutorBuilder(settings, "index_searcher", ThreadPool.twiceAllocatedProcessors(allocatedProcessors), 1000, runnableTaskListener));
        builders.put("remote_state_checksum", new FixedExecutorBuilder(settings, "remote_state_checksum", 11, 1000));
        for (ExecutorBuilder<?> builder : customBuilders) {
            if (builders.containsKey(builder.name())) {
                throw new IllegalArgumentException("builder with name [" + builder.name() + "] already exists");
            }
            builders.put(builder.name(), builder);
        }
        this.builders = Collections.unmodifiableMap(builders);
        this.threadContext = new ThreadContext(settings);
        HashMap<String, ExecutorHolder> executors = new HashMap<String, ExecutorHolder>();
        for (Map.Entry entry : builders.entrySet()) {
            Object executorSettings = ((ExecutorBuilder)entry.getValue()).getSettings(settings);
            ExecutorHolder executorHolder = ((ExecutorBuilder)entry.getValue()).build(executorSettings, this.threadContext);
            if (executors.containsKey(executorHolder.info.getName())) {
                throw new IllegalStateException("duplicate executors with name [" + executorHolder.info.getName() + "] registered");
            }
            logger.debug("created thread pool: {}", (Object)((ExecutorBuilder)entry.getValue()).formatInfo(executorHolder.info));
            executors.put((String)entry.getKey(), executorHolder);
        }
        executors.put("same", new ExecutorHolder(DIRECT_EXECUTOR, new Info("same", ThreadPoolType.DIRECT)));
        this.executors = Collections.unmodifiableMap(executors);
        List<Info> infos = executors.values().stream().filter(holder -> !holder.info.getName().equals("same")).map(holder -> holder.info).collect(Collectors.toList());
        this.threadPoolInfo = new ThreadPoolInfo(infos);
        this.scheduler = Scheduler.initScheduler(settings);
        TimeValue estimatedTimeInterval = ESTIMATED_TIME_INTERVAL_SETTING.get(settings);
        this.cachedTimeThread = new CachedTimeThread(OpenSearchExecutors.threadName(settings, "[timer]"), estimatedTimeInterval.millis());
        this.cachedTimeThread.start();
    }

    public long relativeTimeInMillis() {
        return TimeValue.nsecToMSec((long)this.relativeTimeInNanos());
    }

    public long relativeTimeInNanos() {
        return this.cachedTimeThread.relativeTimeInNanos();
    }

    public long preciseRelativeTimeInNanos() {
        return System.nanoTime();
    }

    public long absoluteTimeInMillis() {
        return this.cachedTimeThread.absoluteTimeInMillis();
    }

    public ThreadPoolInfo info() {
        return this.threadPoolInfo;
    }

    public Info info(String name) {
        ExecutorHolder holder = this.executors.get(name);
        if (holder == null) {
            return null;
        }
        return holder.info;
    }

    public void registerClusterSettingsListeners(ClusterSettings clusterSettings) {
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_THREAD_POOL_SIZE_SETTING, this::setThreadPool, this::validateSetting);
    }

    private void validateSetting(Settings tpSettings) {
        Map<String, Settings> tpGroups = tpSettings.getAsGroups();
        for (Map.Entry<String, Settings> entry : tpGroups.entrySet()) {
            String tpName = entry.getKey();
            if (!THREAD_POOL_TYPES.containsKey(tpName)) {
                throw new IllegalArgumentException("illegal thread_pool name : " + tpName);
            }
            Settings tpGroup = entry.getValue();
            ExecutorHolder holder = this.executors.get(tpName);
            assert (holder.executor instanceof OpenSearchThreadPoolExecutor);
            OpenSearchThreadPoolExecutor threadPoolExecutor = (OpenSearchThreadPoolExecutor)holder.executor;
            if (holder.info.type == ThreadPoolType.SCALING) {
                if (!scalingThreadPoolKeys.containsAll(tpGroup.keySet())) {
                    throw new IllegalArgumentException("illegal thread_pool config : " + String.valueOf(tpGroup.keySet()) + " should only have " + String.valueOf(scalingThreadPoolKeys));
                }
                int max = tpGroup.getAsInt("max", threadPoolExecutor.getMaximumPoolSize());
                int core = tpGroup.getAsInt("core", threadPoolExecutor.getCorePoolSize());
                if (core < 1 || max < 1) {
                    throw new IllegalArgumentException("illegal value for [cluster.thread_pool." + tpName + "], has to be positive value");
                }
                if (core <= max) continue;
                throw new IllegalArgumentException("core threadpool size cannot be greater than max");
            }
            if (!fixedThreadPoolKeys.containsAll(tpGroup.keySet())) {
                throw new IllegalArgumentException("illegal thread_pool config : " + String.valueOf(tpGroup.keySet()) + " should only have " + String.valueOf(fixedThreadPoolKeys));
            }
            int size = tpGroup.getAsInt("size", threadPoolExecutor.getMaximumPoolSize());
            if (size >= 1) continue;
            throw new IllegalArgumentException("illegal value for [cluster.thread_pool." + tpName + "], has to be positive value");
        }
    }

    public void setThreadPool(Settings tpSettings) {
        Map<String, Settings> tpGroups = tpSettings.getAsGroups();
        for (Map.Entry<String, Settings> entry : tpGroups.entrySet()) {
            String tpName = entry.getKey();
            Settings tpGroup = entry.getValue();
            ExecutorHolder holder = this.executors.get(tpName);
            assert (holder.executor instanceof OpenSearchThreadPoolExecutor);
            OpenSearchThreadPoolExecutor executor = (OpenSearchThreadPoolExecutor)holder.executor;
            if (holder.info.type == ThreadPoolType.SCALING) {
                int max = tpGroup.getAsInt("max", executor.getMaximumPoolSize());
                int core = tpGroup.getAsInt("core", executor.getCorePoolSize());
                if (core < executor.getCorePoolSize()) {
                    executor.setCorePoolSize(core);
                    executor.setMaximumPoolSize(max);
                    continue;
                }
                executor.setMaximumPoolSize(max);
                executor.setCorePoolSize(core);
                continue;
            }
            int size = tpGroup.getAsInt("size", executor.getMaximumPoolSize());
            if (size < executor.getCorePoolSize()) {
                executor.setCorePoolSize(size);
                executor.setMaximumPoolSize(size);
                continue;
            }
            executor.setMaximumPoolSize(size);
            executor.setCorePoolSize(size);
        }
    }

    public ThreadPoolStats stats() {
        ArrayList<ThreadPoolStats.Stats> stats = new ArrayList<ThreadPoolStats.Stats>();
        for (ExecutorHolder holder : this.executors.values()) {
            String name = holder.info.getName();
            if ("same".equals(name)) continue;
            int threads = -1;
            int queue = -1;
            int active = -1;
            long rejected = -1L;
            int largest = -1;
            long completed = -1L;
            long waitTimeNanos = -1L;
            if (holder.executor() instanceof OpenSearchThreadPoolExecutor) {
                OpenSearchThreadPoolExecutor threadPoolExecutor = (OpenSearchThreadPoolExecutor)holder.executor();
                threads = threadPoolExecutor.getPoolSize();
                queue = threadPoolExecutor.getQueue().size();
                active = threadPoolExecutor.getActiveCount();
                largest = threadPoolExecutor.getLargestPoolSize();
                completed = threadPoolExecutor.getCompletedTaskCount();
                waitTimeNanos = threadPoolExecutor.getPoolWaitTimeNanos();
                RejectedExecutionHandler rejectedExecutionHandler = threadPoolExecutor.getRejectedExecutionHandler();
                if (rejectedExecutionHandler instanceof XRejectedExecutionHandler) {
                    rejected = ((XRejectedExecutionHandler)rejectedExecutionHandler).rejected();
                }
            }
            stats.add(new ThreadPoolStats.Stats(name, threads, queue, active, rejected, largest, completed, waitTimeNanos));
        }
        return new ThreadPoolStats(stats);
    }

    public ExecutorService generic() {
        return this.executor("generic");
    }

    public ExecutorService executor(String name) {
        ExecutorHolder holder = this.executors.get(name);
        if (holder == null) {
            throw new IllegalArgumentException("no executor service found for [" + name + "]");
        }
        return holder.executor();
    }

    @Override
    public Scheduler.ScheduledCancellable schedule(Runnable command, TimeValue delay, String executor) {
        command = this.threadContext.preserveContext(command);
        if (!"same".equals(executor)) {
            command = new ThreadedRunnable(this, command, this.executor(executor));
        }
        return new ScheduledCancellableAdapter(this.scheduler.schedule(command, delay.millis(), TimeUnit.MILLISECONDS));
    }

    public void scheduleUnlessShuttingDown(TimeValue delay, String executor, Runnable command) {
        try {
            this.schedule(command, delay, executor);
        }
        catch (OpenSearchRejectedExecutionException e) {
            if (e.isExecutorShutdown()) {
                logger.debug((Message)new ParameterizedMessage("could not schedule execution of [{}] after [{}] on [{}] as executor is shut down", new Object[]{command, delay, executor}), (Throwable)e);
            }
            throw e;
        }
    }

    @Override
    public Scheduler.Cancellable scheduleWithFixedDelay(Runnable command, TimeValue interval, String executor) {
        return new Scheduler.ReschedulingRunnable(command, interval, executor, this, e -> {
            if (logger.isDebugEnabled()) {
                logger.debug(() -> new ParameterizedMessage("scheduled task [{}] was rejected on thread pool [{}]", (Object)command, (Object)executor), (Throwable)e);
            }
        }, e -> logger.warn(() -> new ParameterizedMessage("failed to run scheduled task [{}] on thread pool [{}]", (Object)command, (Object)executor), (Throwable)e));
    }

    protected final void stopCachedTimeThread() {
        this.cachedTimeThread.running = false;
        this.cachedTimeThread.interrupt();
    }

    public void shutdown() {
        this.stopCachedTimeThread();
        this.scheduler.shutdown();
        for (ExecutorHolder executor : this.executors.values()) {
            if (!(executor.executor() instanceof ThreadPoolExecutor)) continue;
            executor.executor().shutdown();
        }
    }

    public void shutdownNow() {
        this.stopCachedTimeThread();
        this.scheduler.shutdownNow();
        for (ExecutorHolder executor : this.executors.values()) {
            if (!(executor.executor() instanceof ThreadPoolExecutor)) continue;
            executor.executor().shutdownNow();
        }
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        boolean result = this.scheduler.awaitTermination(timeout, unit);
        for (ExecutorHolder executor : this.executors.values()) {
            if (!(executor.executor() instanceof ThreadPoolExecutor)) continue;
            result &= executor.executor().awaitTermination(timeout, unit);
        }
        this.cachedTimeThread.join(unit.toMillis(timeout));
        return result;
    }

    public ScheduledExecutorService scheduler() {
        return this.scheduler;
    }

    static int boundedBy(int value, int min, int max) {
        return Math.min(max, Math.max(min, value));
    }

    static int oneEighthAllocatedProcessors(int allocatedProcessors) {
        return ThreadPool.boundedBy(allocatedProcessors / 8, 1, Integer.MAX_VALUE);
    }

    static int halfAllocatedProcessors(int allocatedProcessors) {
        return (allocatedProcessors + 1) / 2;
    }

    static int halfAllocatedProcessorsMaxFive(int allocatedProcessors) {
        return ThreadPool.boundedBy((allocatedProcessors + 1) / 2, 1, 5);
    }

    static int halfAllocatedProcessorsMaxTen(int allocatedProcessors) {
        return ThreadPool.boundedBy((allocatedProcessors + 1) / 2, 1, 10);
    }

    static int twiceAllocatedProcessors(int allocatedProcessors) {
        return ThreadPool.boundedBy(2 * allocatedProcessors, 2, Integer.MAX_VALUE);
    }

    public static int searchThreadPoolSize(int allocatedProcessors) {
        return allocatedProcessors * 3 / 2 + 1;
    }

    public static boolean terminate(ExecutorService service, long timeout, TimeUnit timeUnit) {
        if (service != null) {
            service.shutdown();
            if (ThreadPool.awaitTermination(service, timeout, timeUnit)) {
                return true;
            }
            service.shutdownNow();
            return ThreadPool.awaitTermination(service, timeout, timeUnit);
        }
        return false;
    }

    private static boolean awaitTermination(ExecutorService service, long timeout, TimeUnit timeUnit) {
        try {
            if (service.awaitTermination(timeout, timeUnit)) {
                return true;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return false;
    }

    public static boolean terminate(ThreadPool pool, long timeout, TimeUnit timeUnit) {
        if (pool != null) {
            pool.shutdown();
            if (ThreadPool.awaitTermination(pool, timeout, timeUnit)) {
                return true;
            }
            pool.shutdownNow();
            return ThreadPool.awaitTermination(pool, timeout, timeUnit);
        }
        return false;
    }

    private static boolean awaitTermination(ThreadPool threadPool, long timeout, TimeUnit timeUnit) {
        try {
            if (threadPool.awaitTermination(timeout, timeUnit)) {
                return true;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return false;
    }

    public ThreadContext getThreadContext() {
        return this.threadContext;
    }

    public static boolean assertNotScheduleThread(String reason) {
        assert (!Thread.currentThread().getName().contains("scheduler")) : "Expected current thread [" + String.valueOf(Thread.currentThread()) + "] to not be the scheduler thread. Reason: [" + reason + "]";
        return true;
    }

    public static boolean assertCurrentMethodIsNotCalledRecursively() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        assert (stackTraceElements.length >= 3) : stackTraceElements.length;
        assert (stackTraceElements[0].getMethodName().equals("getStackTrace")) : stackTraceElements[0];
        assert (stackTraceElements[1].getMethodName().equals("assertCurrentMethodIsNotCalledRecursively")) : stackTraceElements[1];
        StackTraceElement testingMethod = stackTraceElements[2];
        for (int i = 3; i < stackTraceElements.length; ++i) {
            assert (!stackTraceElements[i].getClassName().equals(testingMethod.getClassName()) || !stackTraceElements[i].getMethodName().equals(testingMethod.getMethodName())) : testingMethod.getClassName() + "#" + testingMethod.getMethodName() + " is called recursively";
        }
        return true;
    }

    static {
        HashMap<String, ThreadPoolType> map = new HashMap<String, ThreadPoolType>();
        map.put("same", ThreadPoolType.DIRECT);
        map.put("generic", ThreadPoolType.SCALING);
        map.put("listener", ThreadPoolType.FIXED);
        map.put("get", ThreadPoolType.FIXED);
        map.put("analyze", ThreadPoolType.FIXED);
        map.put("write", ThreadPoolType.FIXED);
        map.put("search", ThreadPoolType.RESIZABLE);
        map.put("stream_search", ThreadPoolType.RESIZABLE);
        map.put("management", ThreadPoolType.SCALING);
        map.put("flush", ThreadPoolType.SCALING);
        map.put("refresh", ThreadPoolType.SCALING);
        map.put("warmer", ThreadPoolType.SCALING);
        map.put("snapshot", ThreadPoolType.SCALING);
        map.put("snapshot_deletion", ThreadPoolType.SCALING);
        map.put("force_merge", ThreadPoolType.FIXED);
        map.put("fetch_shard_started", ThreadPoolType.SCALING);
        map.put("fetch_shard_store", ThreadPoolType.SCALING);
        map.put("search_throttled", ThreadPoolType.RESIZABLE);
        map.put("system_read", ThreadPoolType.FIXED);
        map.put("system_write", ThreadPoolType.FIXED);
        map.put("translog_transfer", ThreadPoolType.SCALING);
        map.put("translog_sync", ThreadPoolType.FIXED);
        map.put("remote_purge", ThreadPoolType.SCALING);
        map.put("remote_refresh_retry", ThreadPoolType.SCALING);
        map.put("remote_recovery", ThreadPoolType.SCALING);
        map.put("remote_state_read", ThreadPoolType.FIXED);
        map.put("index_searcher", ThreadPoolType.RESIZABLE);
        map.put("remote_state_checksum", ThreadPoolType.FIXED);
        THREAD_POOL_TYPES = Collections.unmodifiableMap(map);
        DIRECT_EXECUTOR = OpenSearchExecutors.newDirectExecutorService();
        ESTIMATED_TIME_INTERVAL_SETTING = Setting.timeSetting("thread_pool.estimated_time_interval", TimeValue.timeValueMillis((long)200L), TimeValue.ZERO, Setting.Property.NodeScope);
        CLUSTER_THREAD_POOL_SIZE_SETTING = Setting.groupSetting("cluster.thread_pool.", Setting.Property.Dynamic, Setting.Property.NodeScope);
    }

    public static class Names {
        public static final String SAME = "same";
        public static final String GENERIC = "generic";
        @Deprecated
        public static final String LISTENER = "listener";
        public static final String GET = "get";
        public static final String ANALYZE = "analyze";
        public static final String WRITE = "write";
        public static final String SEARCH = "search";
        public static final String STREAM_SEARCH = "stream_search";
        public static final String SEARCH_THROTTLED = "search_throttled";
        public static final String MANAGEMENT = "management";
        public static final String FLUSH = "flush";
        public static final String REFRESH = "refresh";
        public static final String WARMER = "warmer";
        public static final String SNAPSHOT = "snapshot";
        public static final String SNAPSHOT_DELETION = "snapshot_deletion";
        public static final String FORCE_MERGE = "force_merge";
        public static final String FETCH_SHARD_STARTED = "fetch_shard_started";
        public static final String FETCH_SHARD_STORE = "fetch_shard_store";
        public static final String SYSTEM_READ = "system_read";
        public static final String SYSTEM_WRITE = "system_write";
        public static final String TRANSLOG_TRANSFER = "translog_transfer";
        public static final String TRANSLOG_SYNC = "translog_sync";
        public static final String REMOTE_PURGE = "remote_purge";
        public static final String REMOTE_REFRESH_RETRY = "remote_refresh_retry";
        public static final String REMOTE_RECOVERY = "remote_recovery";
        public static final String REMOTE_STATE_READ = "remote_state_read";
        public static final String INDEX_SEARCHER = "index_searcher";
        public static final String REMOTE_STATE_CHECKSUM = "remote_state_checksum";
    }

    static class ExecutorHolder {
        private final ExecutorService executor;
        public final Info info;

        ExecutorHolder(ExecutorService executor, Info info) {
            assert (executor instanceof OpenSearchThreadPoolExecutor || executor == DIRECT_EXECUTOR);
            this.executor = executor;
            this.info = info;
        }

        ExecutorService executor() {
            return this.executor;
        }
    }

    @PublicApi(since="1.0.0")
    public static class Info
    implements Writeable,
    ToXContentFragment {
        private final String name;
        private final ThreadPoolType type;
        private final int min;
        private final int max;
        private final TimeValue keepAlive;
        private final SizeValue queueSize;

        public Info(String name, ThreadPoolType type) {
            this(name, type, -1);
        }

        public Info(String name, ThreadPoolType type, int size) {
            this(name, type, size, size, null, null);
        }

        public Info(String name, ThreadPoolType type, int min, int max, @Nullable TimeValue keepAlive, @Nullable SizeValue queueSize) {
            this.name = name;
            this.type = type;
            this.min = min;
            this.max = max;
            this.keepAlive = keepAlive;
            this.queueSize = queueSize;
        }

        public Info(StreamInput in) throws IOException {
            this.name = in.readString();
            String typeStr = in.readString();
            this.type = typeStr.equalsIgnoreCase("fixed_auto_queue_size") ? ThreadPoolType.RESIZABLE : ThreadPoolType.fromType(typeStr);
            this.min = in.readInt();
            this.max = in.readInt();
            this.keepAlive = in.readOptionalTimeValue();
            this.queueSize = (SizeValue)in.readOptionalWriteable(SizeValue::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            if (this.type == ThreadPoolType.RESIZABLE && out.getVersion().before(Version.V_3_0_0)) {
                out.writeString(ThreadPoolType.FIXED.getType());
            } else {
                out.writeString(this.type.getType());
            }
            out.writeInt(this.min);
            out.writeInt(this.max);
            out.writeOptionalTimeValue(this.keepAlive);
            out.writeOptionalWriteable((Writeable)this.queueSize);
        }

        public String getName() {
            return this.name;
        }

        public ThreadPoolType getThreadPoolType() {
            return this.type;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        @Nullable
        public TimeValue getKeepAlive() {
            return this.keepAlive;
        }

        @Nullable
        public SizeValue getQueueSize() {
            return this.queueSize;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.name);
            builder.field("type", this.type.getType());
            if (this.type == ThreadPoolType.SCALING) {
                assert (this.min != -1);
                builder.field("core", this.min);
                assert (this.max != -1);
                builder.field("max", this.max);
            } else {
                assert (this.max != -1);
                builder.field("size", this.max);
            }
            if (this.keepAlive != null) {
                builder.field("keep_alive", this.keepAlive.toString());
            }
            if (this.queueSize == null) {
                builder.field("queue_size", -1);
            } else {
                builder.field("queue_size", this.queueSize.singles());
            }
            builder.endObject();
            return builder;
        }
    }

    @PublicApi(since="1.0.0")
    public static enum ThreadPoolType {
        DIRECT("direct"),
        FIXED("fixed"),
        RESIZABLE("resizable"),
        SCALING("scaling");

        private final String type;
        private static final Map<String, ThreadPoolType> TYPE_MAP;

        public String getType() {
            return this.type;
        }

        private ThreadPoolType(String type) {
            this.type = type;
        }

        public static ThreadPoolType fromType(String type) {
            ThreadPoolType threadPoolType = TYPE_MAP.get(type);
            if (threadPoolType == null) {
                throw new IllegalArgumentException("no ThreadPoolType for " + type);
            }
            return threadPoolType;
        }

        static {
            HashMap<String, ThreadPoolType> typeMap = new HashMap<String, ThreadPoolType>();
            for (ThreadPoolType threadPoolType : ThreadPoolType.values()) {
                typeMap.put(threadPoolType.getType(), threadPoolType);
            }
            TYPE_MAP = Collections.unmodifiableMap(typeMap);
        }
    }

    static class CachedTimeThread
    extends Thread {
        final long interval;
        volatile boolean running = true;
        volatile long relativeNanos;
        volatile long absoluteMillis;

        CachedTimeThread(String name, long interval) {
            super(name);
            this.interval = interval;
            this.relativeNanos = System.nanoTime();
            this.absoluteMillis = System.currentTimeMillis();
            this.setDaemon(true);
        }

        long relativeTimeInNanos() {
            if (0L < this.interval) {
                return this.relativeNanos;
            }
            return System.nanoTime();
        }

        long absoluteTimeInMillis() {
            if (0L < this.interval) {
                return this.absoluteMillis;
            }
            return System.currentTimeMillis();
        }

        @Override
        public void run() {
            while (this.running && 0L < this.interval) {
                this.relativeNanos = System.nanoTime();
                this.absoluteMillis = System.currentTimeMillis();
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException e) {
                    this.running = false;
                    return;
                }
            }
        }
    }

    class ThreadedRunnable
    implements Runnable {
        private final Runnable runnable;
        private final Executor executor;

        ThreadedRunnable(ThreadPool this$0, Runnable runnable, Executor executor) {
            this.runnable = runnable;
            this.executor = executor;
        }

        @Override
        public void run() {
            try {
                this.executor.execute(this.runnable);
            }
            catch (OpenSearchRejectedExecutionException e) {
                if (e.isExecutorShutdown()) {
                    logger.debug((Message)new ParameterizedMessage("could not schedule execution of [{}] on [{}] as executor is shut down", (Object)this.runnable, (Object)this.executor), (Throwable)e);
                }
                throw e;
            }
        }

        public int hashCode() {
            return this.runnable.hashCode();
        }

        public boolean equals(Object obj) {
            return this.runnable.equals(obj);
        }

        public String toString() {
            return "[threaded] " + this.runnable.toString();
        }
    }

    class LoggingRunnable
    implements Runnable {
        private final Runnable runnable;

        LoggingRunnable(ThreadPool this$0, Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Exception e) {
                logger.warn(() -> new ParameterizedMessage("failed to run {}", (Object)this.runnable.toString()), (Throwable)e);
                throw e;
            }
        }

        public int hashCode() {
            return this.runnable.hashCode();
        }

        public boolean equals(Object obj) {
            return this.runnable.equals(obj);
        }

        public String toString() {
            return "[threaded] " + this.runnable.toString();
        }
    }
}

