/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.analysis.Analyzer;
import org.opensearch.client.opensearch._types.analysis.AnalyzerVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class StandardAnalyzer
implements AnalyzerVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, StandardAnalyzer> {
    @Nullable
    private final Integer maxTokenLength;
    @Nonnull
    private final List<String> stopwords;
    public static final JsonpDeserializer<StandardAnalyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StandardAnalyzer::setupStandardAnalyzerDeserializer);

    private StandardAnalyzer(Builder builder) {
        this.maxTokenLength = builder.maxTokenLength;
        this.stopwords = ApiTypeHelper.unmodifiable(builder.stopwords);
    }

    public static StandardAnalyzer of(Function<Builder, ObjectBuilder<StandardAnalyzer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Analyzer.Kind _analyzerKind() {
        return Analyzer.Kind.Standard;
    }

    @Nullable
    public final Integer maxTokenLength() {
        return this.maxTokenLength;
    }

    @Nonnull
    public final List<String> stopwords() {
        return this.stopwords;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "standard");
        if (this.maxTokenLength != null) {
            generator.writeKey("max_token_length");
            generator.write(this.maxTokenLength.intValue());
        }
        if (ApiTypeHelper.isDefined(this.stopwords)) {
            generator.writeKey("stopwords");
            generator.writeStartArray();
            for (String item0 : this.stopwords) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupStandardAnalyzerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxTokenLength, JsonpDeserializer.integerDeserializer(), "max_token_length");
        op.add(Builder::stopwords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stopwords");
        op.ignore("type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.maxTokenLength);
        result = 31 * result + Objects.hashCode(this.stopwords);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StandardAnalyzer other = (StandardAnalyzer)o;
        return Objects.equals(this.maxTokenLength, other.maxTokenLength) && Objects.equals(this.stopwords, other.stopwords);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, StandardAnalyzer> {
        @Nullable
        private Integer maxTokenLength;
        @Nullable
        private List<String> stopwords;

        public Builder() {
        }

        private Builder(StandardAnalyzer o) {
            this.maxTokenLength = o.maxTokenLength;
            this.stopwords = Builder._listCopy(o.stopwords);
        }

        private Builder(Builder o) {
            this.maxTokenLength = o.maxTokenLength;
            this.stopwords = Builder._listCopy(o.stopwords);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder maxTokenLength(@Nullable Integer value) {
            this.maxTokenLength = value;
            return this;
        }

        @Nonnull
        public final Builder stopwords(List<String> list) {
            this.stopwords = Builder._listAddAll(this.stopwords, list);
            return this;
        }

        @Nonnull
        public final Builder stopwords(String value, String ... values) {
            this.stopwords = Builder._listAdd(this.stopwords, value, values);
            return this;
        }

        @Override
        @Nonnull
        public StandardAnalyzer build() {
            this._checkSingleUse();
            return new StandardAnalyzer(this);
        }
    }
}

