/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ui.StatusText;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.ui.frame.CommitDetailsLoader;
import com.intellij.vcs.log.ui.frame.VcsLogChangesBrowser;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.awt.event.ActionEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0000\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u00020\n2\u0010\u0010\f\u001a\f\u0012\b\u0012\u00060\u000ej\u0002`\u000f0\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDiff;", "Lcom/intellij/vcs/log/ui/frame/CommitDetailsLoader$Listener;", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "changesLoadingPane", "Lcom/intellij/ui/components/JBLoadingPanel;", "changesBrowser", "Lcom/intellij/vcs/log/ui/frame/VcsLogChangesBrowser;", "<init>", "(Lcom/intellij/ui/components/JBLoadingPanel;Lcom/intellij/vcs/log/ui/frame/VcsLogChangesBrowser;)V", "onEmptySelection", "", "onDetailsLoaded", "commitIds", "", "", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "details", "onSelection", "onLoadingStarted", "onLoadingStopped", "onError", "error", "", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
public class VcsLogCommitSelectionListenerForDiff
implements CommitDetailsLoader.Listener<VcsFullCommitDetails> {
    @NotNull
    private final JBLoadingPanel changesLoadingPane;
    @NotNull
    private final VcsLogChangesBrowser changesBrowser;

    public VcsLogCommitSelectionListenerForDiff(@NotNull JBLoadingPanel changesLoadingPane, @NotNull VcsLogChangesBrowser changesBrowser) {
        Intrinsics.checkNotNullParameter((Object)changesLoadingPane, (String)"changesLoadingPane");
        Intrinsics.checkNotNullParameter((Object)((Object)changesBrowser), (String)"changesBrowser");
        this.changesLoadingPane = changesLoadingPane;
        this.changesBrowser = changesBrowser;
    }

    @Override
    public void onEmptySelection() {
        this.changesBrowser.setSelectedDetails(CollectionsKt.emptyList());
    }

    @Override
    public void onDetailsLoaded(@NotNull List<Integer> commitIds2, @NotNull List<? extends VcsFullCommitDetails> details) {
        Intrinsics.checkNotNullParameter(commitIds2, (String)"commitIds");
        Intrinsics.checkNotNullParameter(details, (String)"details");
        int maxSize = VcsLogUtil.getMaxSize(details);
        if (maxSize > VcsLogUtil.getShownChangesLimit()) {
            String string = VcsLogUtil.getSizeText(maxSize);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSizeText(...)");
            String sizeText = string;
            this.changesBrowser.setEmptyWithText(arg_0 -> VcsLogCommitSelectionListenerForDiff.onDetailsLoaded$lambda$2(arg_0 -> VcsLogCommitSelectionListenerForDiff.onDetailsLoaded$lambda$1(details, sizeText, this, arg_0), arg_0));
        } else {
            this.changesBrowser.setSelectedDetails(details);
        }
    }

    @Override
    public void onSelection() {
        this.changesBrowser.setEmpty();
    }

    @Override
    public void onLoadingStarted() {
        this.changesLoadingPane.startLoading();
    }

    @Override
    public void onLoadingStopped() {
        this.changesLoadingPane.stopLoading();
    }

    @Override
    public void onError(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.changesBrowser.setEmptyWithText(arg_0 -> VcsLogCommitSelectionListenerForDiff.onError$lambda$4(VcsLogCommitSelectionListenerForDiff::onError$lambda$3, arg_0));
    }

    private static final void onDetailsLoaded$lambda$1$lambda$0(VcsLogCommitSelectionListenerForDiff this$0, List $details, ActionEvent it) {
        this$0.changesBrowser.setSelectedDetails($details);
    }

    private static final Unit onDetailsLoaded$lambda$1(List $details, String $sizeText, VcsLogCommitSelectionListenerForDiff this$0, StatusText statusText2) {
        Intrinsics.checkNotNullParameter((Object)statusText2, (String)"statusText");
        Object[] objectArray = new Object[]{$details.size(), $sizeText};
        statusText2.setText(VcsLogBundle.message("vcs.log.changes.too.many.status", objectArray));
        statusText2.appendSecondaryText(VcsLogBundle.message("vcs.log.changes.too.many.show.anyway.status.action", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, arg_0 -> VcsLogCommitSelectionListenerForDiff.onDetailsLoaded$lambda$1$lambda$0(this$0, $details, arg_0));
        return Unit.INSTANCE;
    }

    private static final void onDetailsLoaded$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit onError$lambda$3(StatusText statusText2) {
        Intrinsics.checkNotNullParameter((Object)statusText2, (String)"statusText");
        statusText2.setText(VcsLogBundle.message("vcs.log.error.loading.changes.status", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final void onError$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

