/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.framework;

import com.jetbrains.rd.framework.AbstractBuffer;
import java.io.Closeable;
import java.lang.reflect.Field;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0017\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0019\u0018\u0000 l2\u00020\u00012\u00020\u0002:\u0001lB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\b\u0010\u001f\u001a\u00020\u001dH\u0016J\b\u0010 \u001a\u00020\u001dH\u0004J\b\u0010!\u001a\u00020\u0007H\u0016J:\u0010\"\u001a\u0002H#\"\u0006\b\u0000\u0010#\u0018\u00012\u0006\u0010\u0018\u001a\u00020\u00042\u001a\u0010$\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010&\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H#0%H\u0082\b\u00a2\u0006\u0002\u0010'J:\u0010(\u001a\u0002H#\"\u0006\b\u0000\u0010#\u0018\u00012\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u000b2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H#0,H\u0082\b\u00a2\u0006\u0002\u0010-J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u00020\u0007H\u0016J\u0010\u00105\u001a\u00020\u001d2\u0006\u00106\u001a\u00020\u0007H\u0016J\b\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u00020\u0010H\u0016J\b\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u00020AH\u0016J\b\u0010B\u001a\u00020\u000bH\u0016J\b\u0010C\u001a\u00020DH\u0016J\b\u0010E\u001a\u00020\u0004H\u0016J\b\u0010F\u001a\u00020GH\u0016J\n\u0010H\u001a\u0004\u0018\u00010IH\u0016J\b\u0010J\u001a\u00020KH\u0016J\b\u0010L\u001a\u00020MH\u0016J\u0010\u0010N\u001a\u00020\u001d2\u0006\u0010O\u001a\u00020\u0004H\u0002J\u0010\u0010P\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\b\u0010Q\u001a\u00020\u001dH\u0016JH\u0010R\u001a\u00020\u001d\"\u0006\b\u0000\u0010#\u0018\u00012\u0006\u0010\u0018\u001a\u00020\u00042 \u0010S\u001a\u001c\u0012\u0006\u0012\u0004\u0018\u00010&\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H#\u0012\u0004\u0012\u00020\u001d0T2\u0006\u0010\u0013\u001a\u0002H#H\u0082\b\u00a2\u0006\u0002\u0010UJ)\u0010V\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u000b2\u0006\u00106\u001a\u00020&2\u0006\u0010W\u001a\u00020\u000bH\u0082\bJ\u0010\u0010X\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020/H\u0016J\u0010\u0010Y\u001a\u00020\u001d2\u0006\u00106\u001a\u000201H\u0016J\u0010\u0010Z\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u000203H\u0016J\u0010\u0010[\u001a\u00020\u001d2\u0006\u00106\u001a\u00020\u0007H\u0016J\u001f\u0010\\\u001a\u00020\u001d2\u0006\u00106\u001a\u00020\u00072\b\u0010]\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010^J\u0010\u0010_\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u000208H\u0016J\u0010\u0010`\u001a\u00020\u001d2\u0006\u00106\u001a\u00020\u0010H\u0016J\u0010\u0010a\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020;H\u0016J\u0010\u0010b\u001a\u00020\u001d2\u0006\u00106\u001a\u00020=H\u0016J\u0010\u0010c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020?H\u0016J\u0010\u0010d\u001a\u00020\u001d2\u0006\u00106\u001a\u00020AH\u0016J\u0010\u0010e\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u0010\u0010f\u001a\u00020\u001d2\u0006\u00106\u001a\u00020DH\u0016J\u0010\u0010g\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J\u0010\u0010h\u001a\u00020\u001d2\u0006\u00106\u001a\u00020GH\u0016J\u0012\u0010i\u001a\u00020\u001d2\b\u0010\u0013\u001a\u0004\u0018\u00010IH\u0016J\u0010\u0010j\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020KH\u0016J\u0010\u0010k\u001a\u00020\u001d2\u0006\u00106\u001a\u00020MH\u0016R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\r\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\b\u001b\u00a8\u0006m"}, d2={"Lcom/jetbrains/rd/framework/UnsafeBuffer;", "Lcom/jetbrains/rd/framework/AbstractBuffer;", "Ljava/io/Closeable;", "initialSize", "", "(J)V", "byteArray", "", "([B)V", "()V", "allocated", "", "getAllocated", "()I", "byteBufferMemoryBase", "charArray", "", "memory", "offset", "value", "position", "getPosition", "setPosition", "(I)V", "size", "unsafe", "Lsun/misc/Unsafe;", "unsafe$1", "checkAvailable", "", "moreSize", "close", "finalize", "getArray", "read", "T", "reader", "Lkotlin/Function2;", "", "(JLkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "readArray", "arrayBase", "arrayStride", "arrayCtor", "Lkotlin/Function1;", "(IILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "readBoolean", "", "readBooleanArray", "", "readByte", "", "readByteArray", "readByteArrayRaw", "array", "readChar", "", "readCharArray", "readDouble", "", "readDoubleArray", "", "readFloat", "", "readFloatArray", "", "readInt", "readIntArray", "", "readLong", "readLongArray", "", "readNullableString", "", "readShort", "", "readShortArray", "", "reallocateMemory", "newSize", "requireAvailable", "reset", "write", "writer", "Lkotlin/Function3;", "(JLkotlin/jvm/functions/Function3;Ljava/lang/Object;)V", "writeArray", "len", "writeBoolean", "writeBooleanArray", "writeByte", "writeByteArray", "writeByteArrayRaw", "count", "([BLjava/lang/Integer;)V", "writeChar", "writeCharArray", "writeDouble", "writeDoubleArray", "writeFloat", "writeFloatArray", "writeInt", "writeIntArray", "writeLong", "writeLongArray", "writeNullableString", "writeShort", "writeShortArray", "Companion", "rd-framework"})
@SourceDebugExtension(value={"SMAP\nUnsafeBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnsafeBuffer.kt\ncom/jetbrains/rd/framework/UnsafeBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,458:1\n1#2:459\n*E\n"})
public final class UnsafeBuffer
extends AbstractBuffer
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private byte[] byteBufferMemoryBase;
    private long memory;
    private long offset;
    private long size;
    @NotNull
    private final Unsafe unsafe$1;
    @NotNull
    private char[] charArray;
    @NotNull
    private static final Unsafe unsafe;
    private static final int maximumSizeBeforeShrink = 0x100000;

    private UnsafeBuffer() {
        this.unsafe$1 = unsafe;
        this.charArray = new char[0];
    }

    @Override
    public int getPosition() {
        return (int)this.offset;
    }

    @Override
    public void setPosition(int value2) {
        this.offset = value2;
    }

    public final int getAllocated() {
        return (int)this.size;
    }

    public UnsafeBuffer(long initialSize) {
        this();
        this.memory = this.unsafe$1.allocateMemory(initialSize);
        this.byteBufferMemoryBase = null;
        this.size = initialSize;
    }

    public UnsafeBuffer(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        this();
        this.byteBufferMemoryBase = byteArray;
        this.memory = Unsafe.ARRAY_BYTE_BASE_OFFSET;
        this.size = byteArray.length;
    }

    @Override
    public void checkAvailable(int moreSize) {
        if (this.offset + (long)moreSize > this.size) {
            throw new IndexOutOfBoundsException("Expected " + moreSize + " bytes in buffer, only " + (this.size - this.offset) + " available");
        }
    }

    @Override
    @NotNull
    public byte[] getArray() {
        if (this.byteBufferMemoryBase == null) {
            throw new IllegalStateException("This unsafe buffer is on top of unsafe memory".toString());
        }
        return this.byteBufferMemoryBase;
    }

    private final void requireAvailable(long moreSize) {
        if (this.offset + moreSize > this.size) {
            long newSize = Math.max(this.size * (long)2, this.offset + moreSize);
            this.reallocateMemory(newSize);
        }
    }

    private final void reallocateMemory(long newSize) {
        if (this.byteBufferMemoryBase == null) {
            this.memory = this.unsafe$1.reallocateMemory(this.memory, newSize);
        } else {
            this.byteBufferMemoryBase = Arrays.copyOf(this.byteBufferMemoryBase, (int)newSize);
        }
        this.size = newSize;
    }

    private final /* synthetic */ <T> T read(long size, Function2<Object, ? super Long, ? extends T> reader) {
        boolean $i$f$read = false;
        this.checkAvailable((int)size);
        Object result = reader.invoke((Object)this.byteBufferMemoryBase, (Object)(this.memory + this.offset));
        this.offset += size;
        return (T)result;
    }

    private final /* synthetic */ <T> void write(long size, Function3<Object, ? super Long, ? super T, Unit> writer, T value2) {
        boolean $i$f$write = false;
        this.requireAvailable(size);
        writer.invoke((Object)this.byteBufferMemoryBase, (Object)(this.memory + this.offset), value2);
        this.offset += size;
    }

    private final /* synthetic */ <T> T readArray(int arrayBase, int arrayStride, Function1<? super Integer, ? extends T> arrayCtor) {
        boolean $i$f$readArray = false;
        int len = this.readInt();
        this.checkAvailable(len * arrayStride);
        Object arr = arrayCtor.invoke((Object)len);
        this.unsafe$1.copyMemory(this.byteBufferMemoryBase, this.memory + this.offset, arr, arrayBase, (long)len * (long)arrayStride);
        this.offset += (long)len * (long)arrayStride;
        return (T)arr;
    }

    private final void writeArray(int arrayBase, int arrayStride, Object array2, int len) {
        boolean $i$f$writeArray = false;
        this.writeInt(len);
        this.requireAvailable((long)len * (long)arrayStride);
        this.unsafe$1.copyMemory(array2, arrayBase, this.byteBufferMemoryBase, this.memory + this.offset, (long)len * (long)arrayStride);
        this.offset += (long)len * (long)arrayStride;
    }

    @Override
    @NotNull
    public byte[] readByteArray() {
        int length = this.readInt();
        byte[] storage = new byte[length];
        this.checkAvailable(length);
        this.unsafe$1.copyMemory(this.byteBufferMemoryBase, this.memory + this.offset, storage, Unsafe.ARRAY_BYTE_BASE_OFFSET, length);
        this.offset += (long)length;
        return storage;
    }

    @Override
    public void readByteArrayRaw(@NotNull byte[] array2) {
        Intrinsics.checkNotNullParameter((Object)array2, (String)"array");
        this.checkAvailable(array2.length);
        this.unsafe$1.copyMemory(this.byteBufferMemoryBase, this.memory + this.offset, array2, Unsafe.ARRAY_BYTE_BASE_OFFSET, array2.length);
        this.offset += (long)array2.length;
    }

    @Override
    public void writeByteArray(@NotNull byte[] array2) {
        Intrinsics.checkNotNullParameter((Object)array2, (String)"array");
        this.requireAvailable(4L + (long)array2.length);
        this.unsafe$1.putInt(this.byteBufferMemoryBase, this.memory + this.offset, array2.length);
        this.unsafe$1.copyMemory(array2, Unsafe.ARRAY_BYTE_BASE_OFFSET, this.byteBufferMemoryBase, this.offset + this.memory + (long)4, array2.length);
        this.offset += (long)(4 + array2.length);
    }

    @Override
    public void writeByteArrayRaw(@NotNull byte[] array2, @Nullable Integer count) {
        Intrinsics.checkNotNullParameter((Object)array2, (String)"array");
        Integer n = count;
        int sz = n != null ? n : array2.length - 0;
        if (!(sz >= 0 && sz <= array2.length)) {
            boolean bl = false;
            String string2 = "sz >= 0 && sz <= array.size, sz = " + sz + ", array.size=" + array2.length;
            throw new IllegalArgumentException(string2.toString());
        }
        this.requireAvailable(sz);
        this.unsafe$1.copyMemory(array2, Unsafe.ARRAY_BYTE_BASE_OFFSET, this.byteBufferMemoryBase, this.offset + this.memory, sz);
        this.offset += (long)sz;
    }

    @Override
    @Nullable
    public String readNullableString() {
        this.checkAvailable(4);
        int len = this.unsafe$1.getInt(this.byteBufferMemoryBase, this.memory + this.offset);
        this.offset += (long)4;
        if (len < 0) {
            return null;
        }
        this.checkAvailable(len * 2);
        if (this.charArray.length < len) {
            this.charArray = new char[len * 2];
        }
        char[] chars = this.charArray;
        this.unsafe$1.copyMemory(this.byteBufferMemoryBase, this.memory + this.offset, chars, Unsafe.ARRAY_CHAR_BASE_OFFSET, (long)len * 2L);
        this.offset += (long)(len * 2);
        return new String(chars, 0, len);
    }

    @Override
    public void writeNullableString(@Nullable String value2) {
        if (value2 == null) {
            this.writeInt(-1);
            return;
        }
        int len = value2.length();
        this.requireAvailable((long)4 + (long)len * 2L);
        this.unsafe$1.putInt(this.byteBufferMemoryBase, this.memory + this.offset, len);
        this.offset += (long)4;
        if (this.charArray.length < len) {
            this.charArray = new char[len * 2];
        }
        char[] chars = this.charArray;
        String string2 = value2;
        int n = 0;
        int n2 = 0;
        int n3 = string2.length();
        string2.getChars(n2, n3, chars, n);
        this.unsafe$1.copyMemory(chars, Unsafe.ARRAY_CHAR_BASE_OFFSET, this.byteBufferMemoryBase, this.memory + this.offset, (long)len * 2L);
        this.offset += (long)(len * 2);
    }

    @Override
    public void reset() {
        this.offset = 0L;
        if (this.size > 0x100000L) {
            this.reallocateMemory(0x100000L);
        }
    }

    @Override
    public void close() {
        if (this.byteBufferMemoryBase == null) {
            this.unsafe$1.freeMemory(this.memory);
        } else {
            this.byteBufferMemoryBase = null;
        }
        this.memory = 0L;
    }

    protected final void finalize() {
        this.close();
    }

    @Override
    public void writeByte(byte value2) {
        this.requireAvailable(1L);
        this.unsafe$1.putByte(this.byteBufferMemoryBase, this.memory + this.offset, value2);
        ++this.offset;
    }

    @Override
    public byte readByte() {
        this.checkAvailable(1);
        byte result = this.unsafe$1.getByte(this.byteBufferMemoryBase, this.memory + this.offset);
        ++this.offset;
        return result;
    }

    @Override
    public void writeShort(short value2) {
        this.requireAvailable(2L);
        this.unsafe$1.putShort(this.byteBufferMemoryBase, this.memory + this.offset, value2);
        this.offset += (long)2;
    }

    @Override
    public short readShort() {
        this.checkAvailable(2);
        short result = this.unsafe$1.getShort(this.byteBufferMemoryBase, this.memory + this.offset);
        this.offset += (long)2;
        return result;
    }

    @Override
    public void writeInt(int value2) {
        this.requireAvailable(4L);
        this.unsafe$1.putInt(this.byteBufferMemoryBase, this.memory + this.offset, value2);
        this.offset += (long)4;
    }

    @Override
    public int readInt() {
        this.checkAvailable(4);
        int result = this.unsafe$1.getInt(this.byteBufferMemoryBase, this.memory + this.offset);
        this.offset += (long)4;
        return result;
    }

    @Override
    public void writeLong(long value2) {
        this.requireAvailable(8L);
        this.unsafe$1.putLong(this.byteBufferMemoryBase, this.memory + this.offset, value2);
        this.offset += (long)8;
    }

    @Override
    public long readLong() {
        this.checkAvailable(8);
        long result = this.unsafe$1.getLong(this.byteBufferMemoryBase, this.memory + this.offset);
        this.offset += (long)8;
        return result;
    }

    @Override
    public void writeFloat(float value2) {
        this.requireAvailable(4L);
        this.unsafe$1.putFloat(this.byteBufferMemoryBase, this.memory + this.offset, value2);
        this.offset += (long)4;
    }

    @Override
    public float readFloat() {
        this.checkAvailable(4);
        float result = this.unsafe$1.getFloat(this.byteBufferMemoryBase, this.memory + this.offset);
        this.offset += (long)4;
        return result;
    }

    @Override
    public void writeDouble(double value2) {
        this.requireAvailable(8L);
        this.unsafe$1.putDouble(this.byteBufferMemoryBase, this.memory + this.offset, value2);
        this.offset += (long)8;
    }

    @Override
    public double readDouble() {
        this.checkAvailable(8);
        double result = this.unsafe$1.getDouble(this.byteBufferMemoryBase, this.memory + this.offset);
        this.offset += (long)8;
        return result;
    }

    @Override
    public void writeBoolean(boolean value2) {
        this.writeByte(value2 ? (byte)1 : 0);
    }

    @Override
    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    @Override
    public void writeChar(char value2) {
        this.requireAvailable(2L);
        this.unsafe$1.putChar(this.byteBufferMemoryBase, this.memory + this.offset, value2);
        this.offset += (long)2;
    }

    @Override
    public char readChar() {
        this.checkAvailable(2);
        char result = this.unsafe$1.getChar(this.byteBufferMemoryBase, this.memory + this.offset);
        this.offset += (long)2;
        return result;
    }

    @Override
    @NotNull
    public char[] readCharArray() {
        int len = this.readInt();
        this.checkAvailable(len * Unsafe.ARRAY_CHAR_INDEX_SCALE);
        char[] arr = new char[len];
        this.unsafe$1.copyMemory(this.byteBufferMemoryBase, this.memory + this.offset, arr, Unsafe.ARRAY_CHAR_BASE_OFFSET, (long)len * (long)Unsafe.ARRAY_CHAR_INDEX_SCALE);
        this.offset += (long)len * (long)Unsafe.ARRAY_CHAR_INDEX_SCALE;
        return arr;
    }

    @Override
    public void writeCharArray(@NotNull char[] array2) {
        Intrinsics.checkNotNullParameter((Object)array2, (String)"array");
        this.writeInt(array2.length);
        this.requireAvailable((long)array2.length * (long)Unsafe.ARRAY_CHAR_INDEX_SCALE);
        this.unsafe$1.copyMemory(array2, Unsafe.ARRAY_CHAR_BASE_OFFSET, this.byteBufferMemoryBase, this.memory + this.offset, (long)array2.length * (long)Unsafe.ARRAY_CHAR_INDEX_SCALE);
        this.offset += (long)array2.length * (long)Unsafe.ARRAY_CHAR_INDEX_SCALE;
    }

    @Override
    @NotNull
    public short[] readShortArray() {
        int len = this.readInt();
        this.checkAvailable(len * Unsafe.ARRAY_SHORT_INDEX_SCALE);
        short[] arr = new short[len];
        this.unsafe$1.copyMemory(this.byteBufferMemoryBase, this.memory + this.offset, arr, Unsafe.ARRAY_SHORT_BASE_OFFSET, (long)len * (long)Unsafe.ARRAY_SHORT_INDEX_SCALE);
        this.offset += (long)len * (long)Unsafe.ARRAY_SHORT_INDEX_SCALE;
        return arr;
    }

    @Override
    public void writeShortArray(@NotNull short[] array2) {
        Intrinsics.checkNotNullParameter((Object)array2, (String)"array");
        this.writeInt(array2.length);
        this.requireAvailable((long)array2.length * (long)Unsafe.ARRAY_SHORT_INDEX_SCALE);
        this.unsafe$1.copyMemory(array2, Unsafe.ARRAY_SHORT_BASE_OFFSET, this.byteBufferMemoryBase, this.memory + this.offset, (long)array2.length * (long)Unsafe.ARRAY_SHORT_INDEX_SCALE);
        this.offset += (long)array2.length * (long)Unsafe.ARRAY_SHORT_INDEX_SCALE;
    }

    @Override
    @NotNull
    public int[] readIntArray() {
        int len = this.readInt();
        this.checkAvailable(len * Unsafe.ARRAY_INT_INDEX_SCALE);
        int[] arr = new int[len];
        this.unsafe$1.copyMemory(this.byteBufferMemoryBase, this.memory + this.offset, arr, Unsafe.ARRAY_INT_BASE_OFFSET, (long)len * (long)Unsafe.ARRAY_INT_INDEX_SCALE);
        this.offset += (long)len * (long)Unsafe.ARRAY_INT_INDEX_SCALE;
        return arr;
    }

    @Override
    public void writeIntArray(@NotNull int[] array2) {
        Intrinsics.checkNotNullParameter((Object)array2, (String)"array");
        this.writeInt(array2.length);
        this.requireAvailable((long)array2.length * (long)Unsafe.ARRAY_INT_INDEX_SCALE);
        this.unsafe$1.copyMemory(array2, Unsafe.ARRAY_INT_BASE_OFFSET, this.byteBufferMemoryBase, this.memory + this.offset, (long)array2.length * (long)Unsafe.ARRAY_INT_INDEX_SCALE);
        this.offset += (long)array2.length * (long)Unsafe.ARRAY_INT_INDEX_SCALE;
    }

    @Override
    @NotNull
    public long[] readLongArray() {
        int len = this.readInt();
        this.checkAvailable(len * Unsafe.ARRAY_LONG_INDEX_SCALE);
        long[] arr = new long[len];
        this.unsafe$1.copyMemory(this.byteBufferMemoryBase, this.memory + this.offset, arr, Unsafe.ARRAY_LONG_BASE_OFFSET, (long)len * (long)Unsafe.ARRAY_LONG_INDEX_SCALE);
        this.offset += (long)len * (long)Unsafe.ARRAY_LONG_INDEX_SCALE;
        return arr;
    }

    @Override
    public void writeLongArray(@NotNull long[] array2) {
        Intrinsics.checkNotNullParameter((Object)array2, (String)"array");
        this.writeInt(array2.length);
        this.requireAvailable((long)array2.length * (long)Unsafe.ARRAY_LONG_INDEX_SCALE);
        this.unsafe$1.copyMemory(array2, Unsafe.ARRAY_LONG_BASE_OFFSET, this.byteBufferMemoryBase, this.memory + this.offset, (long)array2.length * (long)Unsafe.ARRAY_LONG_INDEX_SCALE);
        this.offset += (long)array2.length * (long)Unsafe.ARRAY_LONG_INDEX_SCALE;
    }

    @Override
    @NotNull
    public float[] readFloatArray() {
        int len = this.readInt();
        this.checkAvailable(len * Unsafe.ARRAY_FLOAT_INDEX_SCALE);
        float[] arr = new float[len];
        this.unsafe$1.copyMemory(this.byteBufferMemoryBase, this.memory + this.offset, arr, Unsafe.ARRAY_FLOAT_BASE_OFFSET, (long)len * (long)Unsafe.ARRAY_FLOAT_INDEX_SCALE);
        this.offset += (long)len * (long)Unsafe.ARRAY_FLOAT_INDEX_SCALE;
        return arr;
    }

    @Override
    public void writeFloatArray(@NotNull float[] array2) {
        Intrinsics.checkNotNullParameter((Object)array2, (String)"array");
        this.writeInt(array2.length);
        this.requireAvailable((long)array2.length * (long)Unsafe.ARRAY_FLOAT_INDEX_SCALE);
        this.unsafe$1.copyMemory(array2, Unsafe.ARRAY_FLOAT_BASE_OFFSET, this.byteBufferMemoryBase, this.memory + this.offset, (long)array2.length * (long)Unsafe.ARRAY_FLOAT_INDEX_SCALE);
        this.offset += (long)array2.length * (long)Unsafe.ARRAY_FLOAT_INDEX_SCALE;
    }

    @Override
    @NotNull
    public double[] readDoubleArray() {
        int len = this.readInt();
        this.checkAvailable(len * Unsafe.ARRAY_DOUBLE_INDEX_SCALE);
        double[] arr = new double[len];
        this.unsafe$1.copyMemory(this.byteBufferMemoryBase, this.memory + this.offset, arr, Unsafe.ARRAY_DOUBLE_BASE_OFFSET, (long)len * (long)Unsafe.ARRAY_DOUBLE_INDEX_SCALE);
        this.offset += (long)len * (long)Unsafe.ARRAY_DOUBLE_INDEX_SCALE;
        return arr;
    }

    @Override
    public void writeDoubleArray(@NotNull double[] array2) {
        Intrinsics.checkNotNullParameter((Object)array2, (String)"array");
        this.writeInt(array2.length);
        this.requireAvailable((long)array2.length * (long)Unsafe.ARRAY_DOUBLE_INDEX_SCALE);
        this.unsafe$1.copyMemory(array2, Unsafe.ARRAY_DOUBLE_BASE_OFFSET, this.byteBufferMemoryBase, this.memory + this.offset, (long)array2.length * (long)Unsafe.ARRAY_DOUBLE_INDEX_SCALE);
        this.offset += (long)array2.length * (long)Unsafe.ARRAY_DOUBLE_INDEX_SCALE;
    }

    @Override
    @NotNull
    public boolean[] readBooleanArray() {
        int len = this.readInt();
        this.checkAvailable(len * Unsafe.ARRAY_BOOLEAN_INDEX_SCALE);
        boolean[] arr = new boolean[len];
        this.unsafe$1.copyMemory(this.byteBufferMemoryBase, this.memory + this.offset, arr, Unsafe.ARRAY_BOOLEAN_BASE_OFFSET, (long)len * (long)Unsafe.ARRAY_BOOLEAN_INDEX_SCALE);
        this.offset += (long)len * (long)Unsafe.ARRAY_BOOLEAN_INDEX_SCALE;
        return arr;
    }

    @Override
    public void writeBooleanArray(@NotNull boolean[] array2) {
        Intrinsics.checkNotNullParameter((Object)array2, (String)"array");
        this.writeInt(array2.length);
        this.requireAvailable((long)array2.length * (long)Unsafe.ARRAY_BOOLEAN_INDEX_SCALE);
        this.unsafe$1.copyMemory(array2, Unsafe.ARRAY_BOOLEAN_BASE_OFFSET, this.byteBufferMemoryBase, this.memory + this.offset, (long)array2.length * (long)Unsafe.ARRAY_BOOLEAN_INDEX_SCALE);
        this.offset += (long)array2.length * (long)Unsafe.ARRAY_BOOLEAN_INDEX_SCALE;
    }

    static {
        Field field = Unsafe.class.getDeclaredField("theUnsafe");
        field.setAccessible(true);
        Object object = field.get(null);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type sun.misc.Unsafe");
        unsafe = (Unsafe)object;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rd/framework/UnsafeBuffer$Companion;", "", "()V", "maximumSizeBeforeShrink", "", "unsafe", "Lsun/misc/Unsafe;", "rd-framework"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

