/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="csv-format")
public class PersistentCsvFormat {
    @Attribute(value="name")
    public String name;
    @Attribute(value="id")
    public String id;
    @Tag(value="data")
    public Record data;
    @Tag(value="header")
    public Record header;
    @Attribute(value="row-numbers")
    public boolean rowNumbers;

    public PersistentCsvFormat() {
        this("");
    }

    public PersistentCsvFormat(@NotNull CsvFormat format) {
        if (format == null) {
            PersistentCsvFormat.$$$reportNull$$$0(0);
        }
        this(format.id, format.name, format);
    }

    public PersistentCsvFormat(@NotNull String id, @NotNull String name, @NotNull CsvFormat format) {
        if (id == null) {
            PersistentCsvFormat.$$$reportNull$$$0(1);
        }
        if (name == null) {
            PersistentCsvFormat.$$$reportNull$$$0(2);
        }
        if (format == null) {
            PersistentCsvFormat.$$$reportNull$$$0(3);
        }
        this(name);
        this.id = id;
        this.data = new Record(format.dataRecord);
        this.header = format.headerRecord != null ? new Record(format.headerRecord) : null;
        this.rowNumbers = format.rowNumbers;
    }

    private PersistentCsvFormat(@NotNull String name) {
        if (name == null) {
            PersistentCsvFormat.$$$reportNull$$$0(4);
        }
        this.id = UUID.randomUUID().toString();
        this.name = name;
    }

    @Nullable
    public CsvFormat immutable() {
        if (!this.isValid()) {
            return null;
        }
        String name = Objects.requireNonNull(this.name);
        CsvRecordFormat dataFormat = Objects.requireNonNull(this.data.immutable());
        CsvRecordFormat header = this.header != null ? Objects.requireNonNull(this.header.immutable()) : null;
        return new CsvFormat(name, dataFormat, header, this.id, this.rowNumbers);
    }

    private boolean isValid() {
        return this.name != null && this.data != null && this.data.isValid() && (this.header == null || this.header.isValid());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "format";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "id";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/csv/PersistentCsvFormat";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @Tag(value="record-format")
    public static class Record {
        private static final String QUOTATION_POLICY_NEVER = "never";
        private static final String QUOTATION_POLICY_ALWAYS = "always";
        private static final String QUOTATION_POLICY_AS_NEEDED = "as needed";
        @Attribute(value="prefix")
        public String prefix;
        @Attribute(value="suffix")
        public String suffix;
        @Attribute(value="nullText")
        public String nullText;
        @Attribute(value="quotationPolicy")
        public String quotationPolicy;
        @Attribute(value="valueSeparator")
        public String valueSeparator;
        @Attribute(value="recordSeparator")
        public String recordSeparator;
        @Attribute(value="trimWhitespace")
        public boolean trimWhitespace;
        @XCollection(propertyElementName="quotation")
        public List<Quotes> quotes;

        public Record() {
            this.quotes = new ArrayList<Quotes>();
        }

        public Record(@NotNull CsvRecordFormat record) {
            if (record == null) {
                Record.$$$reportNull$$$0(0);
            }
            this.quotes = new ArrayList<Quotes>();
            this.prefix = record.prefix;
            this.suffix = record.suffix;
            this.nullText = record.nullText;
            this.quotationPolicy = Record.valueOfQuotationPolicy(record.quotationPolicy);
            this.valueSeparator = record.valueSeparator;
            this.recordSeparator = record.recordSeparator;
            this.trimWhitespace = record.trimWhitespace;
            this.quotes = ContainerUtil.map(record.quotes, quotes1 -> new Quotes((CsvRecordFormat.Quotes)quotes1));
        }

        @NotNull
        private CsvRecordFormat immutable() {
            CsvRecordFormat.QuotationPolicy qp = Objects.requireNonNull(Record.quotationPolicy(this.quotationPolicy));
            List immutableQuotes = ContainerUtil.map(this.quotes, quotes1 -> new CsvRecordFormat.Quotes(quotes1.left, quotes1.right, quotes1.leftEscaped, quotes1.rightEscaped));
            return new CsvRecordFormat(this.prefix, this.suffix, this.nullText, immutableQuotes, qp, this.valueSeparator, this.recordSeparator, this.trimWhitespace);
        }

        private boolean isValid() {
            return this.prefix != null && this.suffix != null && Record.quotationPolicy(this.quotationPolicy) != null && this.valueSeparator != null && this.recordSeparator != null && this.quotes != null && ContainerUtil.find(this.quotes, quotes1 -> quotes1 == null || !quotes1.isValid()) == null;
        }

        @Nullable
        private static CsvRecordFormat.QuotationPolicy quotationPolicy(@NotNull String qp) {
            if (qp == null) {
                Record.$$$reportNull$$$0(1);
            }
            return QUOTATION_POLICY_AS_NEEDED.equals(qp) ? CsvRecordFormat.QuotationPolicy.AS_NEEDED : (QUOTATION_POLICY_ALWAYS.equals(qp) ? CsvRecordFormat.QuotationPolicy.ALWAYS : (QUOTATION_POLICY_NEVER.equals(qp) ? CsvRecordFormat.QuotationPolicy.NEVER : null));
        }

        @NotNull
        private static String valueOfQuotationPolicy(@NotNull CsvRecordFormat.QuotationPolicy policy) {
            if (policy == null) {
                Record.$$$reportNull$$$0(2);
            }
            return switch (policy) {
                default -> throw new IncompatibleClassChangeError();
                case CsvRecordFormat.QuotationPolicy.ALWAYS -> QUOTATION_POLICY_ALWAYS;
                case CsvRecordFormat.QuotationPolicy.AS_NEEDED -> QUOTATION_POLICY_AS_NEEDED;
                case CsvRecordFormat.QuotationPolicy.NEVER -> QUOTATION_POLICY_NEVER;
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "record";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qp";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "policy";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/csv/PersistentCsvFormat$Record";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "quotationPolicy";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "valueOfQuotationPolicy";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @Tag(value="quotes")
    public static class Quotes {
        @Attribute(value="left")
        public String left;
        @Attribute(value="right")
        public String right;
        @Attribute(value="leftEscaped")
        public String leftEscaped;
        @Attribute(value="rightEscaped")
        public String rightEscaped;

        public Quotes() {
        }

        public Quotes(@NotNull CsvRecordFormat.Quotes quotes) {
            if (quotes == null) {
                Quotes.$$$reportNull$$$0(0);
            }
            this.left = quotes.leftQuote;
            this.right = quotes.rightQuote;
            this.leftEscaped = quotes.leftQuoteEscaped;
            this.rightEscaped = quotes.rightQuoteEscaped;
        }

        private boolean isValid() {
            return this.left != null && this.right != null && this.leftEscaped != null && this.rightEscaped != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotes", "com/intellij/database/csv/PersistentCsvFormat$Quotes", "<init>"));
        }
    }
}

