#ifndef WRITEODFOFFICE_H
#define WRITEODFOFFICE_H
#include "writeodf.h"
namespace writeodf {
class office_body : public OdfWriter {
public:
    office_body(OdfWriter* x) :OdfWriter(x, "office:body", true) {
    }
    office_body(KoXmlWriter* x) :OdfWriter(x, "office:body", true) {
    }
    office_chart add_office_chart();
    office_database add_office_database();
    office_drawing add_office_drawing();
    office_image add_office_image();
    office_presentation add_office_presentation();
    office_spreadsheet add_office_spreadsheet();
    office_text add_office_text();
};
class office_document_content : public OdfWriter, public group_office_automatic_styles, public group_office_body, public group_office_document_common_attrs, public group_office_font_face_decls, public group_office_scripts {
public:
    office_document_content(OdfWriter* x) :OdfWriter(x, "office:document-content", true), group_office_automatic_styles(*static_cast<OdfWriter*>(this)), group_office_body(*static_cast<OdfWriter*>(this)), group_office_document_common_attrs(*static_cast<OdfWriter*>(this)), group_office_font_face_decls(*static_cast<OdfWriter*>(this)), group_office_scripts(*static_cast<OdfWriter*>(this)) {
    }
    office_document_content(KoXmlWriter* x) :OdfWriter(x, "office:document-content", true), group_office_automatic_styles(*static_cast<OdfWriter*>(this)), group_office_body(*static_cast<OdfWriter*>(this)), group_office_document_common_attrs(*static_cast<OdfWriter*>(this)), group_office_font_face_decls(*static_cast<OdfWriter*>(this)), group_office_scripts(*static_cast<OdfWriter*>(this)) {
    }
};
class office_font_face_decls : public OdfWriter {
public:
    office_font_face_decls(OdfWriter* x) :OdfWriter(x, "office:font-face-decls", true) {
    }
    office_font_face_decls(KoXmlWriter* x) :OdfWriter(x, "office:font-face-decls", true) {
    }
    style_font_face add_style_font_face(const QString& style_name);
};
class office_script : public OdfWriter {
public:
    office_script(OdfWriter* x, const QString& script_language) :OdfWriter(x, "office:script", false) {
        addAttribute("script:language", script_language);
    }
    office_script(KoXmlWriter* x, const QString& script_language) :OdfWriter(x, "office:script", false) {
        addAttribute("script:language", script_language);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class office_binary_data : public OdfWriter {
public:
    office_binary_data(OdfWriter* x) :OdfWriter(x, "office:binary-data", false) {
    }
    office_binary_data(KoXmlWriter* x) :OdfWriter(x, "office:binary-data", false) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class office_document_styles : public OdfWriter, public group_office_automatic_styles, public group_office_document_common_attrs, public group_office_font_face_decls, public group_office_master_styles, public group_office_styles {
public:
    office_document_styles(OdfWriter* x) :OdfWriter(x, "office:document-styles", true), group_office_automatic_styles(*static_cast<OdfWriter*>(this)), group_office_document_common_attrs(*static_cast<OdfWriter*>(this)), group_office_font_face_decls(*static_cast<OdfWriter*>(this)), group_office_master_styles(*static_cast<OdfWriter*>(this)), group_office_styles(*static_cast<OdfWriter*>(this)) {
    }
    office_document_styles(KoXmlWriter* x) :OdfWriter(x, "office:document-styles", true), group_office_automatic_styles(*static_cast<OdfWriter*>(this)), group_office_document_common_attrs(*static_cast<OdfWriter*>(this)), group_office_font_face_decls(*static_cast<OdfWriter*>(this)), group_office_master_styles(*static_cast<OdfWriter*>(this)), group_office_styles(*static_cast<OdfWriter*>(this)) {
    }
};
class office_event_listeners : public OdfWriter {
public:
    office_event_listeners(OdfWriter* x) :OdfWriter(x, "office:event-listeners", true) {
    }
    office_event_listeners(KoXmlWriter* x) :OdfWriter(x, "office:event-listeners", true) {
    }
    presentation_event_listener add_presentation_event_listener(const QString& presentation_action, const QString& script_event_name);
    script_event_listener add_script_event_listener(const QString& script_event_name, const QString& script_language);
};
class office_dde_source : public OdfWriter, public group_common_dde_connection_decl_attlist {
public:
    office_dde_source(OdfWriter* x, const QString& office_dde_application, const QString& office_dde_item, const QString& office_dde_topic) :OdfWriter(x, "office:dde-source", false), group_common_dde_connection_decl_attlist(*static_cast<OdfWriter*>(this), office_dde_application, office_dde_item, office_dde_topic) {
    }
    office_dde_source(KoXmlWriter* x, const QString& office_dde_application, const QString& office_dde_item, const QString& office_dde_topic) :OdfWriter(x, "office:dde-source", false), group_common_dde_connection_decl_attlist(*static_cast<OdfWriter*>(this), office_dde_application, office_dde_item, office_dde_topic) {
    }
    template<class T>
    void set_office_conversion_mode(const T& value) {
        addAttribute("office:conversion-mode", value);
    }
    void set_office_name(const QString& value) {
        addAttribute("office:name", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class office_image : public OdfWriter, public group_draw_frame {
public:
    office_image(OdfWriter* x) :OdfWriter(x, "office:image", true), group_draw_frame(*static_cast<OdfWriter*>(this)) {
    }
    office_image(KoXmlWriter* x) :OdfWriter(x, "office:image", true), group_draw_frame(*static_cast<OdfWriter*>(this)) {
    }
};
class office_meta : public OdfWriter, public group_dc_creator, public group_dc_date {
public:
    office_meta(OdfWriter* x) :OdfWriter(x, "office:meta", true), group_dc_creator(*static_cast<OdfWriter*>(this)), group_dc_date(*static_cast<OdfWriter*>(this)) {
    }
    office_meta(KoXmlWriter* x) :OdfWriter(x, "office:meta", true), group_dc_creator(*static_cast<OdfWriter*>(this)), group_dc_date(*static_cast<OdfWriter*>(this)) {
    }
    dc_description add_dc_description();
    dc_language add_dc_language();
    dc_subject add_dc_subject();
    dc_title add_dc_title();
    meta_auto_reload add_meta_auto_reload();
    meta_creation_date add_meta_creation_date();
    meta_document_statistic add_meta_document_statistic();
    meta_editing_cycles add_meta_editing_cycles();
    meta_editing_duration add_meta_editing_duration();
    meta_generator add_meta_generator();
    meta_hyperlink_behaviour add_meta_hyperlink_behaviour();
    meta_initial_creator add_meta_initial_creator();
    meta_keyword add_meta_keyword();
    meta_print_date add_meta_print_date();
    meta_printed_by add_meta_printed_by();
    meta_template add_meta_template(const QUrl& xlink_href);
    meta_user_defined add_meta_user_defined(const QString& meta_name);
};
class office_scripts : public OdfWriter, public group_office_event_listeners {
public:
    office_scripts(OdfWriter* x) :OdfWriter(x, "office:scripts", true), group_office_event_listeners(*static_cast<OdfWriter*>(this)) {
    }
    office_scripts(KoXmlWriter* x) :OdfWriter(x, "office:scripts", true), group_office_event_listeners(*static_cast<OdfWriter*>(this)) {
    }
    office_script add_office_script(const QString& script_language);
};
class office_automatic_styles : public OdfWriter, public group_styles {
public:
    office_automatic_styles(OdfWriter* x) :OdfWriter(x, "office:automatic-styles", true), group_styles(*static_cast<OdfWriter*>(this)) {
    }
    office_automatic_styles(KoXmlWriter* x) :OdfWriter(x, "office:automatic-styles", true), group_styles(*static_cast<OdfWriter*>(this)) {
    }
    style_page_layout add_style_page_layout(const QString& style_name);
};
class office_document : public OdfWriter, public group_office_automatic_styles, public group_office_body, public group_office_document_common_attrs, public group_office_font_face_decls, public group_office_master_styles, public group_office_meta, public group_office_scripts, public group_office_settings, public group_office_styles {
public:
    office_document(OdfWriter* x, const QString& office_mimetype) :OdfWriter(x, "office:document", true), group_office_automatic_styles(*static_cast<OdfWriter*>(this)), group_office_body(*static_cast<OdfWriter*>(this)), group_office_document_common_attrs(*static_cast<OdfWriter*>(this)), group_office_font_face_decls(*static_cast<OdfWriter*>(this)), group_office_master_styles(*static_cast<OdfWriter*>(this)), group_office_meta(*static_cast<OdfWriter*>(this)), group_office_scripts(*static_cast<OdfWriter*>(this)), group_office_settings(*static_cast<OdfWriter*>(this)), group_office_styles(*static_cast<OdfWriter*>(this)) {
        addAttribute("office:mimetype", office_mimetype);
    }
    office_document(KoXmlWriter* x, const QString& office_mimetype) :OdfWriter(x, "office:document", true), group_office_automatic_styles(*static_cast<OdfWriter*>(this)), group_office_body(*static_cast<OdfWriter*>(this)), group_office_document_common_attrs(*static_cast<OdfWriter*>(this)), group_office_font_face_decls(*static_cast<OdfWriter*>(this)), group_office_master_styles(*static_cast<OdfWriter*>(this)), group_office_meta(*static_cast<OdfWriter*>(this)), group_office_scripts(*static_cast<OdfWriter*>(this)), group_office_settings(*static_cast<OdfWriter*>(this)), group_office_styles(*static_cast<OdfWriter*>(this)) {
        addAttribute("office:mimetype", office_mimetype);
    }
};
class office_document_settings : public OdfWriter, public group_office_document_common_attrs, public group_office_settings {
public:
    office_document_settings(OdfWriter* x) :OdfWriter(x, "office:document-settings", true), group_office_document_common_attrs(*static_cast<OdfWriter*>(this)), group_office_settings(*static_cast<OdfWriter*>(this)) {
    }
    office_document_settings(KoXmlWriter* x) :OdfWriter(x, "office:document-settings", true), group_office_document_common_attrs(*static_cast<OdfWriter*>(this)), group_office_settings(*static_cast<OdfWriter*>(this)) {
    }
};
class office_forms : public OdfWriter, public group_form_form {
public:
    office_forms(OdfWriter* x) :OdfWriter(x, "office:forms", true), group_form_form(*static_cast<OdfWriter*>(this)) {
    }
    office_forms(KoXmlWriter* x) :OdfWriter(x, "office:forms", true), group_form_form(*static_cast<OdfWriter*>(this)) {
    }
    xforms_model add_xforms_model();
    template<class T>
    void set_form_apply_design_mode(const T& value) {
        addAttribute("form:apply-design-mode", value);
    }
    template<class T>
    void set_form_automatic_focus(const T& value) {
        addAttribute("form:automatic-focus", value);
    }
};
class office_change_info : public OdfWriter, public group_dc_creator, public group_dc_date, public group_text_p {
public:
    office_change_info(OdfWriter* x) :OdfWriter(x, "office:change-info", true), group_dc_creator(*static_cast<OdfWriter*>(this)), group_dc_date(*static_cast<OdfWriter*>(this)), group_text_p(*static_cast<OdfWriter*>(this)) {
    }
    office_change_info(KoXmlWriter* x) :OdfWriter(x, "office:change-info", true), group_dc_creator(*static_cast<OdfWriter*>(this)), group_dc_date(*static_cast<OdfWriter*>(this)), group_text_p(*static_cast<OdfWriter*>(this)) {
    }
};
class office_database : public OdfWriter {
public:
    office_database(OdfWriter* x) :OdfWriter(x, "office:database", true) {
    }
    office_database(KoXmlWriter* x) :OdfWriter(x, "office:database", true) {
    }
    db_data_source add_db_data_source();
    db_forms add_db_forms();
    db_queries add_db_queries();
    db_reports add_db_reports();
    db_schema_definition add_db_schema_definition();
    db_table_representations add_db_table_representations();
};
class office_drawing : public OdfWriter, public group_draw_page, public group_table_decls, public group_table_functions, public group_text_decls {
public:
    office_drawing(OdfWriter* x) :OdfWriter(x, "office:drawing", true), group_draw_page(*static_cast<OdfWriter*>(this)), group_table_decls(*static_cast<OdfWriter*>(this)), group_table_functions(*static_cast<OdfWriter*>(this)), group_text_decls(*static_cast<OdfWriter*>(this)) {
    }
    office_drawing(KoXmlWriter* x) :OdfWriter(x, "office:drawing", true), group_draw_page(*static_cast<OdfWriter*>(this)), group_table_decls(*static_cast<OdfWriter*>(this)), group_table_functions(*static_cast<OdfWriter*>(this)), group_text_decls(*static_cast<OdfWriter*>(this)) {
    }
};
class office_presentation : public OdfWriter, public group_draw_page, public group_table_decls, public group_table_functions, public group_text_decls {
public:
    office_presentation(OdfWriter* x) :OdfWriter(x, "office:presentation", true), group_draw_page(*static_cast<OdfWriter*>(this)), group_table_decls(*static_cast<OdfWriter*>(this)), group_table_functions(*static_cast<OdfWriter*>(this)), group_text_decls(*static_cast<OdfWriter*>(this)) {
    }
    office_presentation(KoXmlWriter* x) :OdfWriter(x, "office:presentation", true), group_draw_page(*static_cast<OdfWriter*>(this)), group_table_decls(*static_cast<OdfWriter*>(this)), group_table_functions(*static_cast<OdfWriter*>(this)), group_text_decls(*static_cast<OdfWriter*>(this)) {
    }
    presentation_date_time_decl add_presentation_date_time_decl(const QString& presentation_name, const QString& presentation_source);
    presentation_footer_decl add_presentation_footer_decl(const QString& presentation_name);
    presentation_header_decl add_presentation_header_decl(const QString& presentation_name);
    presentation_settings add_presentation_settings();
};
class office_spreadsheet : public OdfWriter, public group_table_decls, public group_table_functions, public group_table_table, public group_text_decls {
public:
    office_spreadsheet(OdfWriter* x) :OdfWriter(x, "office:spreadsheet", true), group_table_decls(*static_cast<OdfWriter*>(this)), group_table_functions(*static_cast<OdfWriter*>(this)), group_table_table(*static_cast<OdfWriter*>(this)), group_text_decls(*static_cast<OdfWriter*>(this)) {
    }
    office_spreadsheet(KoXmlWriter* x) :OdfWriter(x, "office:spreadsheet", true), group_table_decls(*static_cast<OdfWriter*>(this)), group_table_functions(*static_cast<OdfWriter*>(this)), group_table_table(*static_cast<OdfWriter*>(this)), group_text_decls(*static_cast<OdfWriter*>(this)) {
    }
    table_tracked_changes add_table_tracked_changes();
    void set_table_protection_key(const QString& value) {
        addAttribute("table:protection-key", value);
    }
    void set_table_protection_key_digest_algorithm(const QUrl& value) {
        addAttribute("table:protection-key-digest-algorithm", value);
    }
    template<class T>
    void set_table_structure_protected(const T& value) {
        addAttribute("table:structure-protected", value);
    }
};
class office_annotation_end : public OdfWriter, public group_common_office_annotation_name_attlist {
public:
    office_annotation_end(OdfWriter* x, const QString& office_name) :OdfWriter(x, "office:annotation-end", false), group_common_office_annotation_name_attlist(*static_cast<OdfWriter*>(this), office_name) {
    }
    office_annotation_end(KoXmlWriter* x, const QString& office_name) :OdfWriter(x, "office:annotation-end", false), group_common_office_annotation_name_attlist(*static_cast<OdfWriter*>(this), office_name) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class office_document_meta : public OdfWriter, public group_office_document_common_attrs, public group_office_meta {
public:
    office_document_meta(OdfWriter* x) :OdfWriter(x, "office:document-meta", true), group_office_document_common_attrs(*static_cast<OdfWriter*>(this)), group_office_meta(*static_cast<OdfWriter*>(this)) {
    }
    office_document_meta(KoXmlWriter* x) :OdfWriter(x, "office:document-meta", true), group_office_document_common_attrs(*static_cast<OdfWriter*>(this)), group_office_meta(*static_cast<OdfWriter*>(this)) {
    }
};
class office_settings : public OdfWriter, public group_config_config_item_set {
public:
    office_settings(OdfWriter* x) :OdfWriter(x, "office:settings", true), group_config_config_item_set(*static_cast<OdfWriter*>(this)) {
    }
    office_settings(KoXmlWriter* x) :OdfWriter(x, "office:settings", true), group_config_config_item_set(*static_cast<OdfWriter*>(this)) {
    }
};
class office_chart : public OdfWriter, public group_table_decls, public group_table_functions, public group_text_decls {
public:
    office_chart(OdfWriter* x) :OdfWriter(x, "office:chart", true), group_table_decls(*static_cast<OdfWriter*>(this)), group_table_functions(*static_cast<OdfWriter*>(this)), group_text_decls(*static_cast<OdfWriter*>(this)) {
    }
    office_chart(KoXmlWriter* x) :OdfWriter(x, "office:chart", true), group_table_decls(*static_cast<OdfWriter*>(this)), group_table_functions(*static_cast<OdfWriter*>(this)), group_text_decls(*static_cast<OdfWriter*>(this)) {
    }
    chart_chart add_chart_chart(const QString& chart_class);
};
class office_styles : public OdfWriter, public group_styles, public group_text_notes_configuration {
public:
    office_styles(OdfWriter* x) :OdfWriter(x, "office:styles", true), group_styles(*static_cast<OdfWriter*>(this)), group_text_notes_configuration(*static_cast<OdfWriter*>(this)) {
    }
    office_styles(KoXmlWriter* x) :OdfWriter(x, "office:styles", true), group_styles(*static_cast<OdfWriter*>(this)), group_text_notes_configuration(*static_cast<OdfWriter*>(this)) {
    }
    draw_fill_image add_draw_fill_image(const QString& draw_name, const QUrl& xlink_href);
    draw_gradient add_draw_gradient(const QString& draw_style);
    draw_hatch add_draw_hatch(const QString& draw_name, const QString& draw_style);
    draw_marker add_draw_marker(const QString& draw_name, const QString& svg_d, const QString& svg_viewBox);
    draw_opacity add_draw_opacity(const QString& draw_style);
    draw_stroke_dash add_draw_stroke_dash(const QString& draw_name);
    style_default_page_layout add_style_default_page_layout();
    style_default_style add_style_default_style();
    style_presentation_page_layout add_style_presentation_page_layout(const QString& style_name);
    svg_linearGradient add_svg_linearGradient(const QString& draw_name);
    svg_radialGradient add_svg_radialGradient(const QString& draw_name);
    table_table_template add_table_table_template(const QString& table_first_row_end_column, const QString& table_first_row_start_column, const QString& table_last_row_end_column, const QString& table_last_row_start_column, const QString& table_name);
    text_bibliography_configuration add_text_bibliography_configuration();
    text_linenumbering_configuration add_text_linenumbering_configuration();
    text_outline_style add_text_outline_style(const QString& style_name);
};
class office_master_styles : public OdfWriter, public group_draw_layer_set {
public:
    office_master_styles(OdfWriter* x) :OdfWriter(x, "office:master-styles", true), group_draw_layer_set(*static_cast<OdfWriter*>(this)) {
    }
    office_master_styles(KoXmlWriter* x) :OdfWriter(x, "office:master-styles", true), group_draw_layer_set(*static_cast<OdfWriter*>(this)) {
    }
    style_handout_master add_style_handout_master(const QString& style_page_layout_name);
    style_master_page add_style_master_page(const QString& style_name, const QString& style_page_layout_name);
};
class office_annotation : public OdfWriter, public group_common_draw_position_attlist, public group_common_draw_shape_with_text_and_styles_attlist, public group_common_draw_size_attlist, public group_common_office_annotation_name_attlist, public group_dc_creator, public group_dc_date, public group_draw_caption_attlist, public group_text_list, public group_text_p {
public:
    office_annotation(OdfWriter* x) :OdfWriter(x, "office:annotation", true), group_common_draw_position_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_common_office_annotation_name_attlist(*static_cast<OdfWriter*>(this)), group_dc_creator(*static_cast<OdfWriter*>(this)), group_dc_date(*static_cast<OdfWriter*>(this)), group_draw_caption_attlist(*static_cast<OdfWriter*>(this)), group_text_list(*static_cast<OdfWriter*>(this)), group_text_p(*static_cast<OdfWriter*>(this)) {
    }
    office_annotation(KoXmlWriter* x) :OdfWriter(x, "office:annotation", true), group_common_draw_position_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_common_office_annotation_name_attlist(*static_cast<OdfWriter*>(this)), group_dc_creator(*static_cast<OdfWriter*>(this)), group_dc_date(*static_cast<OdfWriter*>(this)), group_draw_caption_attlist(*static_cast<OdfWriter*>(this)), group_text_list(*static_cast<OdfWriter*>(this)), group_text_p(*static_cast<OdfWriter*>(this)) {
    }
    meta_date_string add_meta_date_string();
    template<class T>
    void set_office_display(const T& value) {
        addAttribute("office:display", value);
    }
};
class office_text : public OdfWriter, public group_office_forms, public group_table_decls, public group_table_functions, public group_text_content, public group_text_decls, public group_text_tracked_changes {
public:
    office_text(OdfWriter* x) :OdfWriter(x, "office:text", true), group_office_forms(*static_cast<OdfWriter*>(this)), group_table_decls(*static_cast<OdfWriter*>(this)), group_table_functions(*static_cast<OdfWriter*>(this)), group_text_content(*static_cast<OdfWriter*>(this)), group_text_decls(*static_cast<OdfWriter*>(this)), group_text_tracked_changes(*static_cast<OdfWriter*>(this)) {
    }
    office_text(KoXmlWriter* x) :OdfWriter(x, "office:text", true), group_office_forms(*static_cast<OdfWriter*>(this)), group_table_decls(*static_cast<OdfWriter*>(this)), group_table_functions(*static_cast<OdfWriter*>(this)), group_text_content(*static_cast<OdfWriter*>(this)), group_text_decls(*static_cast<OdfWriter*>(this)), group_text_tracked_changes(*static_cast<OdfWriter*>(this)) {
    }
    text_page_sequence add_text_page_sequence();
    template<class T>
    void set_text_global(const T& value) {
        addAttribute("text:global", value);
    }
    template<class T>
    void set_text_use_soft_page_breaks(const T& value) {
        addAttribute("text:use-soft-page-breaks", value);
    }
};
}
inline writeodf::office_automatic_styles
writeodf::group_office_automatic_styles::add_office_automatic_styles() {
    return writeodf::office_automatic_styles(&xml);
}
inline writeodf::office_body
writeodf::group_office_body::add_office_body() {
    return writeodf::office_body(&xml);
}
inline writeodf::office_dde_source
writeodf::group_office_dde_source::add_office_dde_source(const QString& office_dde_application, const QString& office_dde_item, const QString& office_dde_topic) {
    return writeodf::office_dde_source(&xml, office_dde_application, office_dde_item, office_dde_topic);
}
inline writeodf::office_font_face_decls
writeodf::group_office_font_face_decls::add_office_font_face_decls() {
    return writeodf::office_font_face_decls(&xml);
}
inline writeodf::office_master_styles
writeodf::group_office_master_styles::add_office_master_styles() {
    return writeodf::office_master_styles(&xml);
}
inline writeodf::office_scripts
writeodf::group_office_scripts::add_office_scripts() {
    return writeodf::office_scripts(&xml);
}
inline writeodf::office_styles
writeodf::group_office_styles::add_office_styles() {
    return writeodf::office_styles(&xml);
}
inline writeodf::office_chart
writeodf::office_body::add_office_chart() {
    return writeodf::office_chart(this);
}
inline writeodf::office_database
writeodf::office_body::add_office_database() {
    return writeodf::office_database(this);
}
inline writeodf::office_drawing
writeodf::office_body::add_office_drawing() {
    return writeodf::office_drawing(this);
}
inline writeodf::office_image
writeodf::office_body::add_office_image() {
    return writeodf::office_image(this);
}
inline writeodf::office_presentation
writeodf::office_body::add_office_presentation() {
    return writeodf::office_presentation(this);
}
inline writeodf::office_spreadsheet
writeodf::office_body::add_office_spreadsheet() {
    return writeodf::office_spreadsheet(this);
}
inline writeodf::office_text
writeodf::office_body::add_office_text() {
    return writeodf::office_text(this);
}
inline writeodf::office_binary_data
writeodf::group_office_binary_data::add_office_binary_data() {
    return writeodf::office_binary_data(&xml);
}
inline writeodf::office_document
writeodf::group_office_document::add_office_document(const QString& office_mimetype) {
    return writeodf::office_document(&xml, office_mimetype);
}
inline writeodf::office_forms
writeodf::group_office_forms::add_office_forms() {
    return writeodf::office_forms(&xml);
}
inline writeodf::office_settings
writeodf::group_office_settings::add_office_settings() {
    return writeodf::office_settings(&xml);
}
inline writeodf::office_annotation
writeodf::group_office_annotation::add_office_annotation() {
    return writeodf::office_annotation(&xml);
}
inline writeodf::office_event_listeners
writeodf::group_office_event_listeners::add_office_event_listeners() {
    return writeodf::office_event_listeners(&xml);
}
inline writeodf::office_script
writeodf::office_scripts::add_office_script(const QString& script_language) {
    return writeodf::office_script(this, script_language);
}
inline writeodf::office_meta
writeodf::group_office_meta::add_office_meta() {
    return writeodf::office_meta(&xml);
}
inline writeodf::office_annotation_end
writeodf::group_paragraph_content::add_office_annotation_end(const QString& office_name) {
    return writeodf::office_annotation_end(&xml, office_name);
}
inline writeodf::office_change_info
writeodf::group_office_change_info::add_office_change_info() {
    return writeodf::office_change_info(&xml);
}
#endif
