
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kguiaddons_python.h"

// main header
#include "kcursorsaver_wrapper.h"

// Argument includes
#include <kcursorsaver.h>
#include <qnamespace.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KCursorSaver_Type = nullptr;
static PyTypeObject *Sbk_KCursorSaver_TypeF(void)
{
    return _Sbk_KCursorSaver_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KCursorSaver_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KCursorSaver >()))
        return -1;

    ::KCursorSaver *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "KCursorSaver", 1, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KCursorSaver::KCursorSaver(Qt::CursorShape)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_CursorShape_IDX])))->converter, (pyArgs[0])))) {
        overloadId = 0; // KCursorSaver(Qt::CursorShape)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKGuiAddonsTypeStructs[SBK_KCursorSaver_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKGuiAddonsTypeStructs[SBK_KCursorSaver_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        ::Qt::CursorShape cppArg0{Qt::ArrowCursor};
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KCursorSaver(Qt::CursorShape)
            cptr = new ::KCursorSaver(cppArg0);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::KCursorSaver >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKGuiAddonsTypeStructs[SBK_KCursorSaver_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KCursorSaverFunc_restoreCursor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCursorSaver *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KCursorSaver_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // restoreCursor()
        cppSelf->restoreCursor();
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KCursorSaver_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KCursorSaver_methods[] = {
    {"restoreCursor", reinterpret_cast<PyCFunction>(Sbk_KCursorSaverFunc_restoreCursor), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KCursorSaver_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KCursorSaver_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KCursorSaver_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KCursorSaver_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KCursorSaver_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KCursorSaver_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KCursorSaver_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KCursorSaver_spec = {
    "1:KGuiAddons.KCursorSaver",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KCursorSaver_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KCursorSaver_PythonToCpp_KCursorSaver_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KCursorSaver_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KCursorSaver_PythonToCpp_KCursorSaver_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KCursorSaver_TypeF()))
        return KCursorSaver_PythonToCpp_KCursorSaver_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KCursorSaver_PTR_CppToPython_KCursorSaver(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KCursorSaver_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KCursorSaver_TypeF(), const_cast<void *>(cppIn), false);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KCursorSaver_SignatureStrings[] = {
    "KGuiAddons.KCursorSaver(self,shape:PySide6.QtCore.Qt.CursorShape)",
    "KGuiAddons.KCursorSaver.restoreCursor(self)",
    nullptr}; // Sentinel
#else
static constexpr size_t KCursorSaver_SignatureByteSize = 82;
static constexpr uint8_t KCursorSaver_SignatureBytes[82] = {
    0x78, 0xda, 0xf3, 0x76, 0x2f, 0xcd, 0x74, 0x4c, 0x49, 0xc9, 0xcf, 0x2b, 0xd6, 0xf3, 0x76, 0x2e,
    0x2d, 0x2a, 0xce, 0x2f, 0x0a, 0x4e, 0x2c, 0x4b, 0x2d, 0xd2, 0x28, 0x4e, 0xcd, 0x49, 0xd3, 0x29,
    0xce, 0x48, 0x2c, 0x48, 0xb5, 0x0a, 0xa8, 0x0c, 0xce, 0x4c, 0x49, 0x35, 0xd3, 0x0b, 0x2c, 0x71,
    0xce, 0x2f, 0x4a, 0x05, 0x52, 0x7a, 0x50, 0x85, 0x20, 0x59, 0x4d, 0x2e, 0x6f, 0xec, 0x26, 0xe8,
    0x15, 0xa5, 0x16, 0x97, 0x00, 0xd5, 0x43, 0x84, 0xc0, 0xe6, 0x69, 0x72, 0x01, 0x00, 0xbc, 0x20,
    0x28, 0x44
};
#endif

PyTypeObject *init_KCursorSaver(PyObject *module)
{
    if (SbkKGuiAddonsTypeStructs[SBK_KCursorSaver_IDX].type != nullptr)
        return SbkKGuiAddonsTypeStructs[SBK_KCursorSaver_IDX].type;

    Shiboken::AutoDecRef Sbk_KCursorSaver_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KCursorSaver_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KCursorSaver",
        "KCursorSaver*",
        &Sbk_KCursorSaver_spec,
        &Shiboken::callCppDestructor< ::KCursorSaver >,
        Sbk_KCursorSaver_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KCursorSaver_Type; // references _Sbk_KCursorSaver_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KCursorSaver_SignatureStrings);
#else
    InitSignatureBytes(pyType, KCursorSaver_SignatureBytes, KCursorSaver_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KCursorSaver_PropertyStrings);
    SbkKGuiAddonsTypeStructs[SBK_KCursorSaver_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KCursorSaver_PythonToCpp_KCursorSaver_PTR,
        is_KCursorSaver_PythonToCpp_KCursorSaver_PTR_Convertible,
        KCursorSaver_PTR_CppToPython_KCursorSaver);

    Shiboken::Conversions::registerConverterName(converter, "KCursorSaver");
    Shiboken::Conversions::registerConverterName(converter, "KCursorSaver*");
    Shiboken::Conversions::registerConverterName(converter, "KCursorSaver&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KCursorSaver).name());

    qRegisterMetaType< ::KCursorSaver *>();

    return pyType;
}
