/**
 * Qt6 Common library
 *
 * The Qt6 Common library is auto-generated and available to users under the same license as the Qt which it is used with or built with. See available licenses below. 
 * SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#include "qoaihttpfileelement.h"

#include <QtCore/qdebug.h>
#include <QtCore/qfile.h>
#include <QtCore/qfileinfo.h>
#include <QtCore/qjsondocument.h>
#include <QtCore/qjsonobject.h>
#include <QtCore/qjsonvalue.h>
#include <QtCore/qstring.h>

QT_BEGIN_NAMESPACE

namespace QtOpenApiCommon {

class QOAIHttpFileElementPrivate : public QSharedData
{
public:
    explicit QOAIHttpFileElementPrivate(const QString &localFilename)
        : m_localFilename(localFilename) {}
    ~QOAIHttpFileElementPrivate();

    QString m_variableName;
    const QString m_localFilename;
    QString m_mimeType;
    bool m_temporary = false;
};

QOAIHttpFileElementPrivate::~QOAIHttpFileElementPrivate()
{
    // Cleanup temporary file when last reference is destroyed
    if (m_temporary && !m_localFilename.isEmpty() && QFile::exists(m_localFilename))
        QFile::remove(m_localFilename);
}

QOAIHttpFileElement::QOAIHttpFileElement()
    : d(new QOAIHttpFileElementPrivate({}))
{}

QOAIHttpFileElement::QOAIHttpFileElement(const QString &localFilename)
    : d(new QOAIHttpFileElementPrivate(localFilename))
{}

QOAIHttpFileElement::QOAIHttpFileElement(const QOAIHttpFileElement &other)
    : d(other.d)
{}

QOAIHttpFileElement::QOAIHttpFileElement(QOAIHttpFileElement &&other) noexcept
    = default;

QOAIHttpFileElement &QOAIHttpFileElement::operator=(const QOAIHttpFileElement &other)
{
    if (this != &other)
        d = other.d;
    return *this;
}

QOAIHttpFileElement &QOAIHttpFileElement::operator=(QOAIHttpFileElement &&other) noexcept
{
    swap(other);
    return *this;
}

QOAIHttpFileElement::~QOAIHttpFileElement() = default;

void QOAIHttpFileElement::swap(QOAIHttpFileElement &other) noexcept
{
    d.swap(other.d);
}

void QOAIHttpFileElement::setMimeType(const QString &mime)
{
    d.detach();
    d->m_mimeType = mime;
}

void QOAIHttpFileElement::setVariableName(const QString &name)
{
    d.detach();
    d->m_variableName = name;
}

void QOAIHttpFileElement::setTemporary(bool temp)
{
    d.detach();
    d->m_temporary = temp;
}

QString QOAIHttpFileElement::mimeType() const
{
    return d->m_mimeType;
}

QString QOAIHttpFileElement::filename() const
{
    return d->m_localFilename;
}

QString QOAIHttpFileElement::variableName() const
{
    return d->m_variableName;
}

QString QOAIHttpFileElement::requestFilename() const
{
    return QFileInfo(d->m_localFilename).fileName();
}


bool QOAIHttpFileElement::isTemporary() const
{
    return d->m_temporary;
}

bool QOAIHttpFileElement::isSet() const {
    return !d->m_localFilename.isEmpty();
}

/*!
    \internal

    Returns the content of the local file as QString.
*/
QString QOAIHttpFileElement::asJson() const
{
    const QByteArray data = loadFromLocalFile();
    return QString::fromUtf8(data);
}

/*!
    \internal

    Returns the content of the local file as QJsonValue.
*/
QJsonValue QOAIHttpFileElement::asJsonValue() const
{
    const QByteArray data = loadFromLocalFile();
    const QJsonObject object = QJsonDocument::fromJson(data).object();
    return QJsonValue(object);
}

/*!
    \internal

    Writes the string \a instr to the file with filename m_localFilename,
    creating or overwriting it.
*/
bool QOAIHttpFileElement::fromStringValue(const QString &instr)
{
    return saveToLocalFile(instr.toUtf8());
}

/*!
    \internal

    Writes the json value \a jval to the file with filename m_localFilename,
    creating or overwriting it.
*/
bool QOAIHttpFileElement::fromJsonValue(const QJsonValue &jval)
{
    const QByteArray content = QJsonDocument(jval.toObject()).toJson(QJsonDocument::Compact);
    return saveToLocalFile(content);
}

/*!
    \internal

    Creates or overwrites a file with filename m_localFilename,
    with \a bytes content.
*/
bool QOAIHttpFileElement::saveToLocalFile(const QByteArray &bytes)
{
    if (d->m_localFilename.isEmpty()) {
        qDebug() << "Local filename is empty, skipping save.";
        return false;
    }
    QFile file(d->m_localFilename);
    bool result = file.open(QIODevice::WriteOnly | QIODevice::Truncate);
    if (result) {
        const qint64 written = file.write(bytes);
        file.close();
        result = (written == bytes.size());
        if (!result)
            qDebug() << "Failed to write data to the file" << d->m_localFilename;
    } else {
        qDebug() << "Failed to create the file" << d->m_localFilename;
    }
    return result;
}

/*!
    \internal

    Reads the content of the file with filename m_localFilename.
*/
QByteArray QOAIHttpFileElement::loadFromLocalFile() const
{
    QByteArray bArray;

    if (d->m_localFilename.isEmpty()) {
        qDebug() << "Local filename is empty, skipping reading.";
        return bArray;
    }

    QFile file(d->m_localFilename);
    if (file.exists() && file.open(QIODevice::ReadOnly)) {
        bArray = file.readAll();
        file.close();
    } else {
        qDebug("Failed to open the file %s", qPrintable(d->m_localFilename));
    }
    return bArray;
}

bool
comparesEqual(const QOAIHttpFileElement &lhs, const QOAIHttpFileElement &rhs) noexcept
{
    return lhs.d->m_variableName == rhs.d->m_variableName
        && lhs.d->m_localFilename == rhs.d->m_localFilename
        && lhs.d->m_mimeType == rhs.d->m_mimeType
        && lhs.d->m_temporary == rhs.d->m_temporary;
}

} // namespace QtOpenApiCommon

QT_END_NAMESPACE
