// components/attribution_reporting/registration_header_error.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/attribution_reporting/registration_header_error.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/attribution_reporting/registration_header_error.mojom-params-data.h"
namespace attribution_reporting {
namespace mojom {

namespace internal {
// static
bool RegistrationHeaderErrorDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const RegistrationHeaderErrorDetails_Data* object = static_cast<const RegistrationHeaderErrorDetails_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case RegistrationHeaderErrorDetails_Tag::kSourceError: {


      if (!::attribution_reporting::mojom::internal::SourceRegistrationError_Data
            ::Validate(object->data.f_source_error, validation_context))
        return false;
      return true;
    }
    case RegistrationHeaderErrorDetails_Tag::kTriggerError: {


      if (!::attribution_reporting::mojom::internal::TriggerRegistrationError_Data
            ::Validate(object->data.f_trigger_error, validation_context))
        return false;
      return true;
    }
    case RegistrationHeaderErrorDetails_Tag::kOsSourceError: {


      if (!::attribution_reporting::mojom::internal::OsRegistrationError_Data
            ::Validate(object->data.f_os_source_error, validation_context))
        return false;
      return true;
    }
    case RegistrationHeaderErrorDetails_Tag::kOsTriggerError: {


      if (!::attribution_reporting::mojom::internal::OsRegistrationError_Data
            ::Validate(object->data.f_os_trigger_error, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in RegistrationHeaderErrorDetails");
      return false;
    }
  }
}


// static
bool RegistrationHeaderError_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RegistrationHeaderError_Data* object =
      static_cast<const RegistrationHeaderError_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->header_value, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& header_value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->header_value, validation_context,
                                         &header_value_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->error_details, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->error_details, validation_context))
    return false;

  return true;
}

RegistrationHeaderError_Data::RegistrationHeaderError_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace attribution_reporting