// components/digital_goods/mojom/digital_goods.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_DIGITAL_GOODS_MOJOM_DIGITAL_GOODS_MOJOM_SHARED_H_
#define COMPONENTS_DIGITAL_GOODS_MOJOM_DIGITAL_GOODS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/digital_goods/mojom/digital_goods.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "components/payments/mojom/payment_request_data.mojom-shared.h"







namespace payments::mojom {
class ItemDetailsDataView;

class PurchaseReferenceDataView;



}  // payments::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::payments::mojom::ItemDetailsDataView> {
  using Data = ::payments::mojom::internal::ItemDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::PurchaseReferenceDataView> {
  using Data = ::payments::mojom::internal::PurchaseReference_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace payments::mojom {


enum class BillingResponseCode : int32_t {
  
  kOk = 0,
  
  kError = 1,
  
  kItemAlreadyOwned = 2,
  
  kItemNotOwned = 3,
  
  kItemUnavailable = 4,
  
  kClientAppUnavailable = 5,
  
  kClientAppError = 6,
  kMinValue = 0,
  kMaxValue = 6,
  kDefaultValue = 1
};

 std::ostream& operator<<(std::ostream& os, BillingResponseCode value);
inline bool IsKnownEnumValue(BillingResponseCode value) {
  return internal::BillingResponseCode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline BillingResponseCode ToKnownEnumValue(BillingResponseCode value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return BillingResponseCode::kDefaultValue;
}


enum class ItemType : int32_t {
  
  kUnknown = 0,
  
  kProduct = 1,
  
  kSubscription = 2,
  kMinValue = 0,
  kMaxValue = 2,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, ItemType value);
inline bool IsKnownEnumValue(ItemType value) {
  return internal::ItemType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline ItemType ToKnownEnumValue(ItemType value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return ItemType::kDefaultValue;
}


enum class CreateDigitalGoodsResponseCode : int32_t {
  
  kOk = 0,
  
  kError = 1,
  
  kUnsupportedPaymentMethod = 2,
  
  kUnsupportedContext = 3,
  kMinValue = 0,
  kMaxValue = 3,
  kDefaultValue = 1
};

 std::ostream& operator<<(std::ostream& os, CreateDigitalGoodsResponseCode value);
inline bool IsKnownEnumValue(CreateDigitalGoodsResponseCode value) {
  return internal::CreateDigitalGoodsResponseCode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline CreateDigitalGoodsResponseCode ToKnownEnumValue(CreateDigitalGoodsResponseCode value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return CreateDigitalGoodsResponseCode::kDefaultValue;
}


class ItemDetailsDataView {
 public:
  ItemDetailsDataView() = default;

  ItemDetailsDataView(
      internal::ItemDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetItemIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadItemId(UserType* output) {
    
    auto* pointer = data_->item_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDescriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPriceDataView(
      ::payments::mojom::PaymentCurrencyAmountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrice(UserType* output) {
    
    auto* pointer = data_->price.Get();
    return mojo::internal::Deserialize<::payments::mojom::PaymentCurrencyAmountDataView>(
        pointer, output, message_);
  }
  inline void GetSubscriptionPeriodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubscriptionPeriod(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `subscription_period` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSubscriptionPeriod` instead "
    "of `ReadSubscriptionPeriod if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->subscription_period.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFreeTrialPeriodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFreeTrialPeriod(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `free_trial_period` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFreeTrialPeriod` instead "
    "of `ReadFreeTrialPeriod if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->free_trial_period.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetIntroductoryPriceDataView(
      ::payments::mojom::PaymentCurrencyAmountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIntroductoryPrice(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::payments::mojom::PaymentCurrencyAmountDataView, UserType>(),
    "Attempting to read the optional `introductory_price` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIntroductoryPrice` instead "
    "of `ReadIntroductoryPrice if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->introductory_price.Get();
    return mojo::internal::Deserialize<::payments::mojom::PaymentCurrencyAmountDataView>(
        pointer, output, message_);
  }
  inline void GetIntroductoryPricePeriodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIntroductoryPricePeriod(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `introductory_price_period` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIntroductoryPricePeriod` instead "
    "of `ReadIntroductoryPricePeriod if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->introductory_price_period.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t introductory_price_cycles() const {
    if (data_->header_.version < 1)
      return uint32_t{};
    return data_->introductory_price_cycles;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->header_.version >= 1
                      ? data_->type : 0;
    return mojo::internal::Deserialize<::payments::mojom::ItemType>(
        data_value, output);
  }
  ItemType type() const {
    if (data_->header_.version < 1)
      return ItemType{};
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::payments::mojom::ItemType>(data_->type));
  }
  inline void GetIconUrlsDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIconUrls(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::url::mojom::UrlDataView>, UserType>(),
    "Attempting to read the optional `icon_urls` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIconUrls` instead "
    "of `ReadIconUrls if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 1
                    ? data_->icon_urls.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ItemDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PurchaseReferenceDataView {
 public:
  PurchaseReferenceDataView() = default;

  PurchaseReferenceDataView(
      internal::PurchaseReference_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetItemIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadItemId(UserType* output) {
    
    auto* pointer = data_->item_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPurchaseTokenDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPurchaseToken(UserType* output) {
    
    auto* pointer = data_->purchase_token.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PurchaseReference_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // payments::mojom

namespace std {

template <>
struct hash<::payments::mojom::BillingResponseCode>
    : public mojo::internal::EnumHashImpl<::payments::mojom::BillingResponseCode> {};

template <>
struct hash<::payments::mojom::ItemType>
    : public mojo::internal::EnumHashImpl<::payments::mojom::ItemType> {};

template <>
struct hash<::payments::mojom::CreateDigitalGoodsResponseCode>
    : public mojo::internal::EnumHashImpl<::payments::mojom::CreateDigitalGoodsResponseCode> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::BillingResponseCode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::payments::mojom::BillingResponseCode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::payments::mojom::BillingResponseCode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::ItemType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::payments::mojom::ItemType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::payments::mojom::ItemType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::CreateDigitalGoodsResponseCode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::payments::mojom::CreateDigitalGoodsResponseCode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::payments::mojom::CreateDigitalGoodsResponseCode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::ItemDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::ItemDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::ItemDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::item_id(input)) in_item_id = Traits::item_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->item_id)::BaseType> item_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_item_id, item_id_fragment);
    fragment->item_id.Set(
        item_id_fragment.is_null() ? nullptr : item_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->item_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null item_id in ItemDetails struct");
    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_title, title_fragment);
    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->title.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in ItemDetails struct");
    decltype(Traits::description(input)) in_description = Traits::description(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description)::BaseType> description_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_description, description_fragment);
    fragment->description.Set(
        description_fragment.is_null() ? nullptr : description_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->description.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null description in ItemDetails struct");
    decltype(Traits::price(input)) in_price = Traits::price(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->price)::BaseType> price_fragment(
            fragment.message());
    mojo::internal::Serialize<::payments::mojom::PaymentCurrencyAmountDataView>(
        in_price, price_fragment);
    fragment->price.Set(
        price_fragment.is_null() ? nullptr : price_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->price.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null price in ItemDetails struct");
    decltype(Traits::subscription_period(input)) in_subscription_period = Traits::subscription_period(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->subscription_period)::BaseType> subscription_period_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_subscription_period, subscription_period_fragment);
    fragment->subscription_period.Set(
        subscription_period_fragment.is_null() ? nullptr : subscription_period_fragment.data());
    decltype(Traits::free_trial_period(input)) in_free_trial_period = Traits::free_trial_period(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->free_trial_period)::BaseType> free_trial_period_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_free_trial_period, free_trial_period_fragment);
    fragment->free_trial_period.Set(
        free_trial_period_fragment.is_null() ? nullptr : free_trial_period_fragment.data());
    decltype(Traits::introductory_price(input)) in_introductory_price = Traits::introductory_price(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->introductory_price)::BaseType> introductory_price_fragment(
            fragment.message());
    mojo::internal::Serialize<::payments::mojom::PaymentCurrencyAmountDataView>(
        in_introductory_price, introductory_price_fragment);
    fragment->introductory_price.Set(
        introductory_price_fragment.is_null() ? nullptr : introductory_price_fragment.data());
    decltype(Traits::introductory_price_period(input)) in_introductory_price_period = Traits::introductory_price_period(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->introductory_price_period)::BaseType> introductory_price_period_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_introductory_price_period, introductory_price_period_fragment);
    fragment->introductory_price_period.Set(
        introductory_price_period_fragment.is_null() ? nullptr : introductory_price_period_fragment.data());
    fragment->introductory_price_cycles = Traits::introductory_price_cycles(input);
    mojo::internal::Serialize<::payments::mojom::ItemType>(
        Traits::type(input), &fragment->type);
    decltype(Traits::icon_urls(input)) in_icon_urls = Traits::icon_urls(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icon_urls)::BaseType>
        icon_urls_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& icon_urls_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        in_icon_urls, icon_urls_fragment, &icon_urls_validate_params);
    fragment->icon_urls.Set(
        icon_urls_fragment.is_null() ? nullptr : icon_urls_fragment.data());
  }

  static bool Deserialize(::payments::mojom::internal::ItemDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::ItemDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PurchaseReferenceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PurchaseReferenceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PurchaseReference_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::item_id(input)) in_item_id = Traits::item_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->item_id)::BaseType> item_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_item_id, item_id_fragment);
    fragment->item_id.Set(
        item_id_fragment.is_null() ? nullptr : item_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->item_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null item_id in PurchaseReference struct");
    decltype(Traits::purchase_token(input)) in_purchase_token = Traits::purchase_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->purchase_token)::BaseType> purchase_token_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_purchase_token, purchase_token_fragment);
    fragment->purchase_token.Set(
        purchase_token_fragment.is_null() ? nullptr : purchase_token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->purchase_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null purchase_token in PurchaseReference struct");
  }

  static bool Deserialize(::payments::mojom::internal::PurchaseReference_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::PurchaseReferenceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace payments::mojom {

inline void ItemDetailsDataView::GetItemIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->item_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ItemDetailsDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ItemDetailsDataView::GetDescriptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->description.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ItemDetailsDataView::GetPriceDataView(
    ::payments::mojom::PaymentCurrencyAmountDataView* output) {
  auto pointer = data_->price.Get();
  *output = ::payments::mojom::PaymentCurrencyAmountDataView(pointer, message_);
}
inline void ItemDetailsDataView::GetSubscriptionPeriodDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->subscription_period.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ItemDetailsDataView::GetFreeTrialPeriodDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->free_trial_period.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ItemDetailsDataView::GetIntroductoryPriceDataView(
    ::payments::mojom::PaymentCurrencyAmountDataView* output) {
  auto pointer = data_->introductory_price.Get();
  *output = ::payments::mojom::PaymentCurrencyAmountDataView(pointer, message_);
}
inline void ItemDetailsDataView::GetIntroductoryPricePeriodDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->introductory_price_period.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ItemDetailsDataView::GetIconUrlsDataView(
    mojo::ArrayDataView<::url::mojom::UrlDataView>* output) {
  auto pointer = data_->header_.version >= 1
                 ? data_->icon_urls.Get() : nullptr;
  *output = mojo::ArrayDataView<::url::mojom::UrlDataView>(pointer, message_);
}


inline void PurchaseReferenceDataView::GetItemIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->item_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PurchaseReferenceDataView::GetPurchaseTokenDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->purchase_token.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // payments::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::payments::mojom::BillingResponseCode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::payments::mojom::BillingResponseCode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::payments::mojom::ItemType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::payments::mojom::ItemType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::payments::mojom::CreateDigitalGoodsResponseCode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::payments::mojom::CreateDigitalGoodsResponseCode value);
};

} // namespace perfetto

#endif  // COMPONENTS_DIGITAL_GOODS_MOJOM_DIGITAL_GOODS_MOJOM_SHARED_H_