// components/services/filesystem/public/mojom/types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_TYPES_MOJOM_SHARED_H_
#define COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/filesystem/public/mojom/types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/safe_base_name.mojom-shared.h"







namespace filesystem::mojom {
class TimespecOrNowDataView;

class FileInformationDataView;

class DirectoryEntryDataView;



}  // filesystem::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::filesystem::mojom::TimespecOrNowDataView> {
  using Data = ::filesystem::mojom::internal::TimespecOrNow_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::filesystem::mojom::FileInformationDataView> {
  using Data = ::filesystem::mojom::internal::FileInformation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::filesystem::mojom::DirectoryEntryDataView> {
  using Data = ::filesystem::mojom::internal::DirectoryEntry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace filesystem::mojom {


enum class Whence : int32_t {
  
  FROM_BEGIN = 0,
  
  FROM_CURRENT = 1,
  
  FROM_END = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, Whence value);
inline bool IsKnownEnumValue(Whence value) {
  return internal::Whence_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FsFileType : int32_t {
  
  UNKNOWN = 0,
  
  REGULAR_FILE = 1,
  
  DIRECTORY = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, FsFileType value);
inline bool IsKnownEnumValue(FsFileType value) {
  return internal::FsFileType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class TimespecOrNowDataView {
 public:
  TimespecOrNowDataView() = default;

  TimespecOrNowDataView(
      internal::TimespecOrNow_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool now() const {
    return data_->now;
  }
  double seconds() const {
    return data_->seconds;
  }
 private:
  internal::TimespecOrNow_Data* data_ = nullptr;
};


class FileInformationDataView {
 public:
  FileInformationDataView() = default;

  FileInformationDataView(
      internal::FileInformation_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::filesystem::mojom::FsFileType>(
        data_value, output);
  }
  FsFileType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::filesystem::mojom::FsFileType>(data_->type));
  }
  int64_t size() const {
    return data_->size;
  }
  double atime() const {
    return data_->atime;
  }
  double mtime() const {
    return data_->mtime;
  }
  double ctime() const {
    return data_->ctime;
  }
 private:
  internal::FileInformation_Data* data_ = nullptr;
};


class DirectoryEntryDataView {
 public:
  DirectoryEntryDataView() = default;

  DirectoryEntryDataView(
      internal::DirectoryEntry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      ::mojo_base::mojom::SafeBaseNameDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::SafeBaseNameDataView>(
        pointer, output, message_);
  }
  inline void GetDisplayNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayName(UserType* output) {
    
    auto* pointer = data_->display_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::filesystem::mojom::FsFileType>(
        data_value, output);
  }
  FsFileType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::filesystem::mojom::FsFileType>(data_->type));
  }
 private:
  internal::DirectoryEntry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // filesystem::mojom

namespace std {

template <>
struct hash<::filesystem::mojom::Whence>
    : public mojo::internal::EnumHashImpl<::filesystem::mojom::Whence> {};

template <>
struct hash<::filesystem::mojom::FsFileType>
    : public mojo::internal::EnumHashImpl<::filesystem::mojom::FsFileType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::filesystem::mojom::Whence, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::filesystem::mojom::Whence, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::filesystem::mojom::Whence>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::filesystem::mojom::FsFileType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::filesystem::mojom::FsFileType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::filesystem::mojom::FsFileType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::filesystem::mojom::TimespecOrNowDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::filesystem::mojom::TimespecOrNowDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::filesystem::mojom::internal::TimespecOrNow_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->now = Traits::now(input);
    fragment->seconds = Traits::seconds(input);
  }

  static bool Deserialize(::filesystem::mojom::internal::TimespecOrNow_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::filesystem::mojom::TimespecOrNowDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::filesystem::mojom::FileInformationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::filesystem::mojom::FileInformationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::filesystem::mojom::internal::FileInformation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::filesystem::mojom::FsFileType>(
        Traits::type(input), &fragment->type);
    fragment->size = Traits::size(input);
    fragment->atime = Traits::atime(input);
    fragment->mtime = Traits::mtime(input);
    fragment->ctime = Traits::ctime(input);
  }

  static bool Deserialize(::filesystem::mojom::internal::FileInformation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::filesystem::mojom::FileInformationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::filesystem::mojom::DirectoryEntryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::filesystem::mojom::DirectoryEntryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::filesystem::mojom::internal::DirectoryEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::SafeBaseNameDataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in DirectoryEntry struct");
    decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_name)::BaseType> display_name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_display_name, display_name_fragment);
    fragment->display_name.Set(
        display_name_fragment.is_null() ? nullptr : display_name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->display_name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null display_name in DirectoryEntry struct");
    mojo::internal::Serialize<::filesystem::mojom::FsFileType>(
        Traits::type(input), &fragment->type);
  }

  static bool Deserialize(::filesystem::mojom::internal::DirectoryEntry_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::filesystem::mojom::DirectoryEntryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace filesystem::mojom {





inline void DirectoryEntryDataView::GetNameDataView(
    ::mojo_base::mojom::SafeBaseNameDataView* output) {
  auto pointer = data_->name.Get();
  *output = ::mojo_base::mojom::SafeBaseNameDataView(pointer, message_);
}
inline void DirectoryEntryDataView::GetDisplayNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->display_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // filesystem::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::filesystem::mojom::Whence> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::filesystem::mojom::Whence value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::filesystem::mojom::FsFileType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::filesystem::mojom::FsFileType value);
};

} // namespace perfetto

#endif  // COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_TYPES_MOJOM_SHARED_H_