// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_Audits_h
#define content_protocol_Audits_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "content/browser/devtools/protocol/network.h"

namespace content {
namespace protocol {
namespace Audits {
class AffectedCookie;
class AffectedRequest;
class AffectedFrame;
using CookieExclusionReason = String;
using CookieWarningReason = String;
using CookieOperation = String;
using InsightType = String;
class CookieIssueInsight;
class CookieIssueDetails;
using MixedContentResolutionStatus = String;
using MixedContentResourceType = String;
class MixedContentIssueDetails;
using BlockedByResponseReason = String;
class BlockedByResponseIssueDetails;
using HeavyAdResolutionStatus = String;
using HeavyAdReason = String;
class HeavyAdIssueDetails;
using ContentSecurityPolicyViolationType = String;
class SourceCodeLocation;
class ContentSecurityPolicyIssueDetails;
using SharedArrayBufferIssueType = String;
class SharedArrayBufferIssueDetails;
class LowTextContrastIssueDetails;
class CorsIssueDetails;
using AttributionReportingIssueType = String;
using SharedDictionaryError = String;
class AttributionReportingIssueDetails;
class QuirksModeIssueDetails;
class NavigatorUserAgentIssueDetails;
class SharedDictionaryIssueDetails;
using GenericIssueErrorType = String;
class GenericIssueDetails;
class DeprecationIssueDetails;
class BounceTrackingIssueDetails;
class CookieDeprecationMetadataIssueDetails;
using ClientHintIssueReason = String;
class FederatedAuthRequestIssueDetails;
using FederatedAuthRequestIssueReason = String;
class FederatedAuthUserInfoRequestIssueDetails;
using FederatedAuthUserInfoRequestIssueReason = String;
class ClientHintIssueDetails;
class FailedRequestInfo;
using SelectElementAccessibilityIssueReason = String;
class SelectElementAccessibilityIssueDetails;
using StyleSheetLoadingIssueReason = String;
class StylesheetLoadingIssueDetails;
using PropertyRuleIssueReason = String;
class PropertyRuleIssueDetails;
using InspectorIssueCode = String;
class InspectorIssueDetails;
using IssueId = String;
class InspectorIssue;

// ------------- Forward and enum declarations.

namespace CookieExclusionReasonEnum {
CONTENT_EXPORT extern const char ExcludeSameSiteUnspecifiedTreatedAsLax[];
CONTENT_EXPORT extern const char ExcludeSameSiteNoneInsecure[];
CONTENT_EXPORT extern const char ExcludeSameSiteLax[];
CONTENT_EXPORT extern const char ExcludeSameSiteStrict[];
CONTENT_EXPORT extern const char ExcludeInvalidSameParty[];
CONTENT_EXPORT extern const char ExcludeSamePartyCrossPartyContext[];
CONTENT_EXPORT extern const char ExcludeDomainNonASCII[];
CONTENT_EXPORT extern const char ExcludeThirdPartyCookieBlockedInFirstPartySet[];
CONTENT_EXPORT extern const char ExcludeThirdPartyPhaseout[];
CONTENT_EXPORT extern const char ExcludePortMismatch[];
CONTENT_EXPORT extern const char ExcludeSchemeMismatch[];
} // namespace CookieExclusionReasonEnum

namespace CookieWarningReasonEnum {
CONTENT_EXPORT extern const char WarnSameSiteUnspecifiedCrossSiteContext[];
CONTENT_EXPORT extern const char WarnSameSiteNoneInsecure[];
CONTENT_EXPORT extern const char WarnSameSiteUnspecifiedLaxAllowUnsafe[];
CONTENT_EXPORT extern const char WarnSameSiteStrictLaxDowngradeStrict[];
CONTENT_EXPORT extern const char WarnSameSiteStrictCrossDowngradeStrict[];
CONTENT_EXPORT extern const char WarnSameSiteStrictCrossDowngradeLax[];
CONTENT_EXPORT extern const char WarnSameSiteLaxCrossDowngradeStrict[];
CONTENT_EXPORT extern const char WarnSameSiteLaxCrossDowngradeLax[];
CONTENT_EXPORT extern const char WarnAttributeValueExceedsMaxSize[];
CONTENT_EXPORT extern const char WarnDomainNonASCII[];
CONTENT_EXPORT extern const char WarnThirdPartyPhaseout[];
CONTENT_EXPORT extern const char WarnCrossSiteRedirectDowngradeChangesInclusion[];
CONTENT_EXPORT extern const char WarnDeprecationTrialMetadata[];
CONTENT_EXPORT extern const char WarnThirdPartyCookieHeuristic[];
} // namespace CookieWarningReasonEnum

namespace CookieOperationEnum {
CONTENT_EXPORT extern const char SetCookie[];
CONTENT_EXPORT extern const char ReadCookie[];
} // namespace CookieOperationEnum

namespace InsightTypeEnum {
CONTENT_EXPORT extern const char GitHubResource[];
CONTENT_EXPORT extern const char GracePeriod[];
CONTENT_EXPORT extern const char Heuristics[];
} // namespace InsightTypeEnum

namespace MixedContentResolutionStatusEnum {
CONTENT_EXPORT extern const char MixedContentBlocked[];
CONTENT_EXPORT extern const char MixedContentAutomaticallyUpgraded[];
CONTENT_EXPORT extern const char MixedContentWarning[];
} // namespace MixedContentResolutionStatusEnum

namespace MixedContentResourceTypeEnum {
CONTENT_EXPORT extern const char AttributionSrc[];
CONTENT_EXPORT extern const char Audio[];
CONTENT_EXPORT extern const char Beacon[];
CONTENT_EXPORT extern const char CSPReport[];
CONTENT_EXPORT extern const char Download[];
CONTENT_EXPORT extern const char EventSource[];
CONTENT_EXPORT extern const char Favicon[];
CONTENT_EXPORT extern const char Font[];
CONTENT_EXPORT extern const char Form[];
CONTENT_EXPORT extern const char Frame[];
CONTENT_EXPORT extern const char Image[];
CONTENT_EXPORT extern const char Import[];
CONTENT_EXPORT extern const char JSON[];
CONTENT_EXPORT extern const char Manifest[];
CONTENT_EXPORT extern const char Ping[];
CONTENT_EXPORT extern const char PluginData[];
CONTENT_EXPORT extern const char PluginResource[];
CONTENT_EXPORT extern const char Prefetch[];
CONTENT_EXPORT extern const char Resource[];
CONTENT_EXPORT extern const char Script[];
CONTENT_EXPORT extern const char ServiceWorker[];
CONTENT_EXPORT extern const char SharedWorker[];
CONTENT_EXPORT extern const char SpeculationRules[];
CONTENT_EXPORT extern const char Stylesheet[];
CONTENT_EXPORT extern const char Track[];
CONTENT_EXPORT extern const char Video[];
CONTENT_EXPORT extern const char Worker[];
CONTENT_EXPORT extern const char XMLHttpRequest[];
CONTENT_EXPORT extern const char XSLT[];
} // namespace MixedContentResourceTypeEnum

namespace BlockedByResponseReasonEnum {
CONTENT_EXPORT extern const char CoepFrameResourceNeedsCoepHeader[];
CONTENT_EXPORT extern const char CoopSandboxedIFrameCannotNavigateToCoopPage[];
CONTENT_EXPORT extern const char CorpNotSameOrigin[];
CONTENT_EXPORT extern const char CorpNotSameOriginAfterDefaultedToSameOriginByCoep[];
CONTENT_EXPORT extern const char CorpNotSameOriginAfterDefaultedToSameOriginByDip[];
CONTENT_EXPORT extern const char CorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip[];
CONTENT_EXPORT extern const char CorpNotSameSite[];
CONTENT_EXPORT extern const char SRIMessageSignatureMismatch[];
} // namespace BlockedByResponseReasonEnum

namespace HeavyAdResolutionStatusEnum {
CONTENT_EXPORT extern const char HeavyAdBlocked[];
CONTENT_EXPORT extern const char HeavyAdWarning[];
} // namespace HeavyAdResolutionStatusEnum

namespace HeavyAdReasonEnum {
CONTENT_EXPORT extern const char NetworkTotalLimit[];
CONTENT_EXPORT extern const char CpuTotalLimit[];
CONTENT_EXPORT extern const char CpuPeakLimit[];
} // namespace HeavyAdReasonEnum

namespace ContentSecurityPolicyViolationTypeEnum {
CONTENT_EXPORT extern const char KInlineViolation[];
CONTENT_EXPORT extern const char KEvalViolation[];
CONTENT_EXPORT extern const char KURLViolation[];
CONTENT_EXPORT extern const char KTrustedTypesSinkViolation[];
CONTENT_EXPORT extern const char KTrustedTypesPolicyViolation[];
CONTENT_EXPORT extern const char KWasmEvalViolation[];
} // namespace ContentSecurityPolicyViolationTypeEnum

namespace SharedArrayBufferIssueTypeEnum {
CONTENT_EXPORT extern const char TransferIssue[];
CONTENT_EXPORT extern const char CreationIssue[];
} // namespace SharedArrayBufferIssueTypeEnum

namespace AttributionReportingIssueTypeEnum {
CONTENT_EXPORT extern const char PermissionPolicyDisabled[];
CONTENT_EXPORT extern const char UntrustworthyReportingOrigin[];
CONTENT_EXPORT extern const char InsecureContext[];
CONTENT_EXPORT extern const char InvalidHeader[];
CONTENT_EXPORT extern const char InvalidRegisterTriggerHeader[];
CONTENT_EXPORT extern const char SourceAndTriggerHeaders[];
CONTENT_EXPORT extern const char SourceIgnored[];
CONTENT_EXPORT extern const char TriggerIgnored[];
CONTENT_EXPORT extern const char OsSourceIgnored[];
CONTENT_EXPORT extern const char OsTriggerIgnored[];
CONTENT_EXPORT extern const char InvalidRegisterOsSourceHeader[];
CONTENT_EXPORT extern const char InvalidRegisterOsTriggerHeader[];
CONTENT_EXPORT extern const char WebAndOsHeaders[];
CONTENT_EXPORT extern const char NoWebOrOsSupport[];
CONTENT_EXPORT extern const char NavigationRegistrationWithoutTransientUserActivation[];
CONTENT_EXPORT extern const char InvalidInfoHeader[];
CONTENT_EXPORT extern const char NoRegisterSourceHeader[];
CONTENT_EXPORT extern const char NoRegisterTriggerHeader[];
CONTENT_EXPORT extern const char NoRegisterOsSourceHeader[];
CONTENT_EXPORT extern const char NoRegisterOsTriggerHeader[];
CONTENT_EXPORT extern const char NavigationRegistrationUniqueScopeAlreadySet[];
} // namespace AttributionReportingIssueTypeEnum

namespace SharedDictionaryErrorEnum {
CONTENT_EXPORT extern const char UseErrorCrossOriginNoCorsRequest[];
CONTENT_EXPORT extern const char UseErrorDictionaryLoadFailure[];
CONTENT_EXPORT extern const char UseErrorMatchingDictionaryNotUsed[];
CONTENT_EXPORT extern const char UseErrorUnexpectedContentDictionaryHeader[];
CONTENT_EXPORT extern const char WriteErrorCossOriginNoCorsRequest[];
CONTENT_EXPORT extern const char WriteErrorDisallowedBySettings[];
CONTENT_EXPORT extern const char WriteErrorExpiredResponse[];
CONTENT_EXPORT extern const char WriteErrorFeatureDisabled[];
CONTENT_EXPORT extern const char WriteErrorInsufficientResources[];
CONTENT_EXPORT extern const char WriteErrorInvalidMatchField[];
CONTENT_EXPORT extern const char WriteErrorInvalidStructuredHeader[];
CONTENT_EXPORT extern const char WriteErrorNavigationRequest[];
CONTENT_EXPORT extern const char WriteErrorNoMatchField[];
CONTENT_EXPORT extern const char WriteErrorNonListMatchDestField[];
CONTENT_EXPORT extern const char WriteErrorNonSecureContext[];
CONTENT_EXPORT extern const char WriteErrorNonStringIdField[];
CONTENT_EXPORT extern const char WriteErrorNonStringInMatchDestList[];
CONTENT_EXPORT extern const char WriteErrorNonStringMatchField[];
CONTENT_EXPORT extern const char WriteErrorNonTokenTypeField[];
CONTENT_EXPORT extern const char WriteErrorRequestAborted[];
CONTENT_EXPORT extern const char WriteErrorShuttingDown[];
CONTENT_EXPORT extern const char WriteErrorTooLongIdField[];
CONTENT_EXPORT extern const char WriteErrorUnsupportedType[];
} // namespace SharedDictionaryErrorEnum

namespace GenericIssueErrorTypeEnum {
CONTENT_EXPORT extern const char FormLabelForNameError[];
CONTENT_EXPORT extern const char FormDuplicateIdForInputError[];
CONTENT_EXPORT extern const char FormInputWithNoLabelError[];
CONTENT_EXPORT extern const char FormAutocompleteAttributeEmptyError[];
CONTENT_EXPORT extern const char FormEmptyIdAndNameAttributesForInputError[];
CONTENT_EXPORT extern const char FormAriaLabelledByToNonExistingId[];
CONTENT_EXPORT extern const char FormInputAssignedAutocompleteValueToIdOrNameAttributeError[];
CONTENT_EXPORT extern const char FormLabelHasNeitherForNorNestedInput[];
CONTENT_EXPORT extern const char FormLabelForMatchesNonExistingIdError[];
CONTENT_EXPORT extern const char FormInputHasWrongButWellIntendedAutocompleteValueError[];
CONTENT_EXPORT extern const char ResponseWasBlockedByORB[];
} // namespace GenericIssueErrorTypeEnum

namespace ClientHintIssueReasonEnum {
CONTENT_EXPORT extern const char MetaTagAllowListInvalidOrigin[];
CONTENT_EXPORT extern const char MetaTagModifiedHTML[];
} // namespace ClientHintIssueReasonEnum

namespace FederatedAuthRequestIssueReasonEnum {
CONTENT_EXPORT extern const char ShouldEmbargo[];
CONTENT_EXPORT extern const char TooManyRequests[];
CONTENT_EXPORT extern const char WellKnownHttpNotFound[];
CONTENT_EXPORT extern const char WellKnownNoResponse[];
CONTENT_EXPORT extern const char WellKnownInvalidResponse[];
CONTENT_EXPORT extern const char WellKnownListEmpty[];
CONTENT_EXPORT extern const char WellKnownInvalidContentType[];
CONTENT_EXPORT extern const char ConfigNotInWellKnown[];
CONTENT_EXPORT extern const char WellKnownTooBig[];
CONTENT_EXPORT extern const char ConfigHttpNotFound[];
CONTENT_EXPORT extern const char ConfigNoResponse[];
CONTENT_EXPORT extern const char ConfigInvalidResponse[];
CONTENT_EXPORT extern const char ConfigInvalidContentType[];
CONTENT_EXPORT extern const char ClientMetadataHttpNotFound[];
CONTENT_EXPORT extern const char ClientMetadataNoResponse[];
CONTENT_EXPORT extern const char ClientMetadataInvalidResponse[];
CONTENT_EXPORT extern const char ClientMetadataInvalidContentType[];
CONTENT_EXPORT extern const char IdpNotPotentiallyTrustworthy[];
CONTENT_EXPORT extern const char DisabledInSettings[];
CONTENT_EXPORT extern const char DisabledInFlags[];
CONTENT_EXPORT extern const char ErrorFetchingSignin[];
CONTENT_EXPORT extern const char InvalidSigninResponse[];
CONTENT_EXPORT extern const char AccountsHttpNotFound[];
CONTENT_EXPORT extern const char AccountsNoResponse[];
CONTENT_EXPORT extern const char AccountsInvalidResponse[];
CONTENT_EXPORT extern const char AccountsListEmpty[];
CONTENT_EXPORT extern const char AccountsInvalidContentType[];
CONTENT_EXPORT extern const char IdTokenHttpNotFound[];
CONTENT_EXPORT extern const char IdTokenNoResponse[];
CONTENT_EXPORT extern const char IdTokenInvalidResponse[];
CONTENT_EXPORT extern const char IdTokenIdpErrorResponse[];
CONTENT_EXPORT extern const char IdTokenCrossSiteIdpErrorResponse[];
CONTENT_EXPORT extern const char IdTokenInvalidRequest[];
CONTENT_EXPORT extern const char IdTokenInvalidContentType[];
CONTENT_EXPORT extern const char ErrorIdToken[];
CONTENT_EXPORT extern const char Canceled[];
CONTENT_EXPORT extern const char RpPageNotVisible[];
CONTENT_EXPORT extern const char SilentMediationFailure[];
CONTENT_EXPORT extern const char ThirdPartyCookiesBlocked[];
CONTENT_EXPORT extern const char NotSignedInWithIdp[];
CONTENT_EXPORT extern const char MissingTransientUserActivation[];
CONTENT_EXPORT extern const char ReplacedByActiveMode[];
CONTENT_EXPORT extern const char InvalidFieldsSpecified[];
CONTENT_EXPORT extern const char RelyingPartyOriginIsOpaque[];
CONTENT_EXPORT extern const char TypeNotMatching[];
CONTENT_EXPORT extern const char UiDismissedNoEmbargo[];
} // namespace FederatedAuthRequestIssueReasonEnum

namespace FederatedAuthUserInfoRequestIssueReasonEnum {
CONTENT_EXPORT extern const char NotSameOrigin[];
CONTENT_EXPORT extern const char NotIframe[];
CONTENT_EXPORT extern const char NotPotentiallyTrustworthy[];
CONTENT_EXPORT extern const char NoApiPermission[];
CONTENT_EXPORT extern const char NotSignedInWithIdp[];
CONTENT_EXPORT extern const char NoAccountSharingPermission[];
CONTENT_EXPORT extern const char InvalidConfigOrWellKnown[];
CONTENT_EXPORT extern const char InvalidAccountsResponse[];
CONTENT_EXPORT extern const char NoReturningUserFromFetchedAccounts[];
} // namespace FederatedAuthUserInfoRequestIssueReasonEnum

namespace SelectElementAccessibilityIssueReasonEnum {
CONTENT_EXPORT extern const char DisallowedSelectChild[];
CONTENT_EXPORT extern const char DisallowedOptGroupChild[];
CONTENT_EXPORT extern const char NonPhrasingContentOptionChild[];
CONTENT_EXPORT extern const char InteractiveContentOptionChild[];
CONTENT_EXPORT extern const char InteractiveContentLegendChild[];
} // namespace SelectElementAccessibilityIssueReasonEnum

namespace StyleSheetLoadingIssueReasonEnum {
CONTENT_EXPORT extern const char LateImportRule[];
CONTENT_EXPORT extern const char RequestFailed[];
} // namespace StyleSheetLoadingIssueReasonEnum

namespace PropertyRuleIssueReasonEnum {
CONTENT_EXPORT extern const char InvalidSyntax[];
CONTENT_EXPORT extern const char InvalidInitialValue[];
CONTENT_EXPORT extern const char InvalidInherits[];
CONTENT_EXPORT extern const char InvalidName[];
} // namespace PropertyRuleIssueReasonEnum

namespace InspectorIssueCodeEnum {
CONTENT_EXPORT extern const char CookieIssue[];
CONTENT_EXPORT extern const char MixedContentIssue[];
CONTENT_EXPORT extern const char BlockedByResponseIssue[];
CONTENT_EXPORT extern const char HeavyAdIssue[];
CONTENT_EXPORT extern const char ContentSecurityPolicyIssue[];
CONTENT_EXPORT extern const char SharedArrayBufferIssue[];
CONTENT_EXPORT extern const char LowTextContrastIssue[];
CONTENT_EXPORT extern const char CorsIssue[];
CONTENT_EXPORT extern const char AttributionReportingIssue[];
CONTENT_EXPORT extern const char QuirksModeIssue[];
CONTENT_EXPORT extern const char NavigatorUserAgentIssue[];
CONTENT_EXPORT extern const char GenericIssue[];
CONTENT_EXPORT extern const char DeprecationIssue[];
CONTENT_EXPORT extern const char ClientHintIssue[];
CONTENT_EXPORT extern const char FederatedAuthRequestIssue[];
CONTENT_EXPORT extern const char BounceTrackingIssue[];
CONTENT_EXPORT extern const char CookieDeprecationMetadataIssue[];
CONTENT_EXPORT extern const char StylesheetLoadingIssue[];
CONTENT_EXPORT extern const char FederatedAuthUserInfoRequestIssue[];
CONTENT_EXPORT extern const char PropertyRuleIssue[];
CONTENT_EXPORT extern const char SharedDictionaryIssue[];
CONTENT_EXPORT extern const char SelectElementAccessibilityIssue[];
} // namespace InspectorIssueCodeEnum

namespace GetEncodedResponse {
namespace EncodingEnum {
CONTENT_EXPORT extern const char* Webp;
CONTENT_EXPORT extern const char* Jpeg;
CONTENT_EXPORT extern const char* Png;
} // EncodingEnum
} // GetEncodedResponse

// ------------- Type and builder declarations.

class CONTENT_EXPORT AffectedCookie : public ::crdtp::ProtocolObject<AffectedCookie> {
public:
    ~AffectedCookie() override { }

    String GetName() { return m_name; }
    void SetName(const String& value) { m_name = value; }

    String GetPath() { return m_path; }
    void SetPath(const String& value) { m_path = value; }

    String GetDomain() { return m_domain; }
    void SetDomain(const String& value) { m_domain = value; }

    template<int STATE>
    class AffectedCookieBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            PathSet = 1 << 2,
            DomainSet = 1 << 3,
            AllFieldsSet = (NameSet | PathSet | DomainSet | 0)};


        AffectedCookieBuilder<STATE | NameSet>& SetName(const String& value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->SetName(value);
            return castState<NameSet>();
        }

        AffectedCookieBuilder<STATE | PathSet>& SetPath(const String& value)
        {
            static_assert(!(STATE & PathSet), "property path should not be set yet");
            m_result->SetPath(value);
            return castState<PathSet>();
        }

        AffectedCookieBuilder<STATE | DomainSet>& SetDomain(const String& value)
        {
            static_assert(!(STATE & DomainSet), "property domain should not be set yet");
            m_result->SetDomain(value);
            return castState<DomainSet>();
        }

        std::unique_ptr<AffectedCookie> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AffectedCookie;
        AffectedCookieBuilder() : m_result(new AffectedCookie()) { }

        template<int STEP> AffectedCookieBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AffectedCookieBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::AffectedCookie> m_result;
    };

    static AffectedCookieBuilder<0> Create()
    {
        return AffectedCookieBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AffectedCookie()
    {
    }

    String m_name;
    String m_path;
    String m_domain;
};


class CONTENT_EXPORT AffectedRequest : public ::crdtp::ProtocolObject<AffectedRequest> {
public:
    ~AffectedRequest() override { }

    bool HasRequestId() { return !!m_requestId; }
    String GetRequestId(const String& defaultValue) const {
       return m_requestId.value_or(defaultValue);
    }
    const std::optional<String>& GetRequestId() const {
       return m_requestId;
    }
    void SetRequestId(const String& value) { m_requestId = value; }

    String GetUrl() { return m_url; }
    void SetUrl(const String& value) { m_url = value; }

    template<int STATE>
    class AffectedRequestBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            AllFieldsSet = (UrlSet | 0)};


        AffectedRequestBuilder<STATE>& SetRequestId(const String& value)
        {
            m_result->SetRequestId(value);
            return *this;
        }

        AffectedRequestBuilder<STATE | UrlSet>& SetUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->SetUrl(value);
            return castState<UrlSet>();
        }

        std::unique_ptr<AffectedRequest> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AffectedRequest;
        AffectedRequestBuilder() : m_result(new AffectedRequest()) { }

        template<int STEP> AffectedRequestBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AffectedRequestBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::AffectedRequest> m_result;
    };

    static AffectedRequestBuilder<0> Create()
    {
        return AffectedRequestBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AffectedRequest()
    {
    }

    std::optional<String> m_requestId;
    String m_url;
};


class CONTENT_EXPORT AffectedFrame : public ::crdtp::ProtocolObject<AffectedFrame> {
public:
    ~AffectedFrame() override { }

    String GetFrameId() { return m_frameId; }
    void SetFrameId(const String& value) { m_frameId = value; }

    template<int STATE>
    class AffectedFrameBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FrameIdSet = 1 << 1,
            AllFieldsSet = (FrameIdSet | 0)};


        AffectedFrameBuilder<STATE | FrameIdSet>& SetFrameId(const String& value)
        {
            static_assert(!(STATE & FrameIdSet), "property frameId should not be set yet");
            m_result->SetFrameId(value);
            return castState<FrameIdSet>();
        }

        std::unique_ptr<AffectedFrame> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AffectedFrame;
        AffectedFrameBuilder() : m_result(new AffectedFrame()) { }

        template<int STEP> AffectedFrameBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AffectedFrameBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::AffectedFrame> m_result;
    };

    static AffectedFrameBuilder<0> Create()
    {
        return AffectedFrameBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AffectedFrame()
    {
    }

    String m_frameId;
};


class CONTENT_EXPORT CookieIssueInsight : public ::crdtp::ProtocolObject<CookieIssueInsight> {
public:
    ~CookieIssueInsight() override { }

    String GetType() { return m_type; }
    void SetType(const String& value) { m_type = value; }

    bool HasTableEntryUrl() { return !!m_tableEntryUrl; }
    String GetTableEntryUrl(const String& defaultValue) const {
       return m_tableEntryUrl.value_or(defaultValue);
    }
    const std::optional<String>& GetTableEntryUrl() const {
       return m_tableEntryUrl;
    }
    void SetTableEntryUrl(const String& value) { m_tableEntryUrl = value; }

    template<int STATE>
    class CookieIssueInsightBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            AllFieldsSet = (TypeSet | 0)};


        CookieIssueInsightBuilder<STATE | TypeSet>& SetType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->SetType(value);
            return castState<TypeSet>();
        }

        CookieIssueInsightBuilder<STATE>& SetTableEntryUrl(const String& value)
        {
            m_result->SetTableEntryUrl(value);
            return *this;
        }

        std::unique_ptr<CookieIssueInsight> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CookieIssueInsight;
        CookieIssueInsightBuilder() : m_result(new CookieIssueInsight()) { }

        template<int STEP> CookieIssueInsightBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CookieIssueInsightBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::CookieIssueInsight> m_result;
    };

    static CookieIssueInsightBuilder<0> Create()
    {
        return CookieIssueInsightBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CookieIssueInsight()
    {
    }

    String m_type;
    std::optional<String> m_tableEntryUrl;
};


class CONTENT_EXPORT CookieIssueDetails : public ::crdtp::ProtocolObject<CookieIssueDetails> {
public:
    ~CookieIssueDetails() override { }

    bool HasCookie() { return !!m_cookie; }
    protocol::Audits::AffectedCookie* GetCookie(protocol::Audits::AffectedCookie* defaultValue) {
       return m_cookie ? m_cookie.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedCookie>& GetCookie() const {
       return m_cookie;
    }
    void SetCookie(std::unique_ptr<protocol::Audits::AffectedCookie> value) { m_cookie = std::move(value); }

    bool HasRawCookieLine() { return !!m_rawCookieLine; }
    String GetRawCookieLine(const String& defaultValue) const {
       return m_rawCookieLine.value_or(defaultValue);
    }
    const std::optional<String>& GetRawCookieLine() const {
       return m_rawCookieLine;
    }
    void SetRawCookieLine(const String& value) { m_rawCookieLine = value; }

    protocol::Array<String>* GetCookieWarningReasons() { return m_cookieWarningReasons.get(); }
    void SetCookieWarningReasons(std::unique_ptr<protocol::Array<String>> value) { m_cookieWarningReasons = std::move(value); }

    protocol::Array<String>* GetCookieExclusionReasons() { return m_cookieExclusionReasons.get(); }
    void SetCookieExclusionReasons(std::unique_ptr<protocol::Array<String>> value) { m_cookieExclusionReasons = std::move(value); }

    String GetOperation() { return m_operation; }
    void SetOperation(const String& value) { m_operation = value; }

    bool HasSiteForCookies() { return !!m_siteForCookies; }
    String GetSiteForCookies(const String& defaultValue) const {
       return m_siteForCookies.value_or(defaultValue);
    }
    const std::optional<String>& GetSiteForCookies() const {
       return m_siteForCookies;
    }
    void SetSiteForCookies(const String& value) { m_siteForCookies = value; }

    bool HasCookieUrl() { return !!m_cookieUrl; }
    String GetCookieUrl(const String& defaultValue) const {
       return m_cookieUrl.value_or(defaultValue);
    }
    const std::optional<String>& GetCookieUrl() const {
       return m_cookieUrl;
    }
    void SetCookieUrl(const String& value) { m_cookieUrl = value; }

    bool HasRequest() { return !!m_request; }
    protocol::Audits::AffectedRequest* GetRequest(protocol::Audits::AffectedRequest* defaultValue) {
       return m_request ? m_request.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedRequest>& GetRequest() const {
       return m_request;
    }
    void SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

    bool HasInsight() { return !!m_insight; }
    protocol::Audits::CookieIssueInsight* GetInsight(protocol::Audits::CookieIssueInsight* defaultValue) {
       return m_insight ? m_insight.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::CookieIssueInsight>& GetInsight() const {
       return m_insight;
    }
    void SetInsight(std::unique_ptr<protocol::Audits::CookieIssueInsight> value) { m_insight = std::move(value); }

    template<int STATE>
    class CookieIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CookieWarningReasonsSet = 1 << 1,
            CookieExclusionReasonsSet = 1 << 2,
            OperationSet = 1 << 3,
            AllFieldsSet = (CookieWarningReasonsSet | CookieExclusionReasonsSet | OperationSet | 0)};


        CookieIssueDetailsBuilder<STATE>& SetCookie(std::unique_ptr<protocol::Audits::AffectedCookie> value)
        {
            m_result->SetCookie(std::move(value));
            return *this;
        }

        CookieIssueDetailsBuilder<STATE>& SetRawCookieLine(const String& value)
        {
            m_result->SetRawCookieLine(value);
            return *this;
        }

        CookieIssueDetailsBuilder<STATE | CookieWarningReasonsSet>& SetCookieWarningReasons(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & CookieWarningReasonsSet), "property cookieWarningReasons should not be set yet");
            m_result->SetCookieWarningReasons(std::move(value));
            return castState<CookieWarningReasonsSet>();
        }

        CookieIssueDetailsBuilder<STATE | CookieExclusionReasonsSet>& SetCookieExclusionReasons(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & CookieExclusionReasonsSet), "property cookieExclusionReasons should not be set yet");
            m_result->SetCookieExclusionReasons(std::move(value));
            return castState<CookieExclusionReasonsSet>();
        }

        CookieIssueDetailsBuilder<STATE | OperationSet>& SetOperation(const String& value)
        {
            static_assert(!(STATE & OperationSet), "property operation should not be set yet");
            m_result->SetOperation(value);
            return castState<OperationSet>();
        }

        CookieIssueDetailsBuilder<STATE>& SetSiteForCookies(const String& value)
        {
            m_result->SetSiteForCookies(value);
            return *this;
        }

        CookieIssueDetailsBuilder<STATE>& SetCookieUrl(const String& value)
        {
            m_result->SetCookieUrl(value);
            return *this;
        }

        CookieIssueDetailsBuilder<STATE>& SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value)
        {
            m_result->SetRequest(std::move(value));
            return *this;
        }

        CookieIssueDetailsBuilder<STATE>& SetInsight(std::unique_ptr<protocol::Audits::CookieIssueInsight> value)
        {
            m_result->SetInsight(std::move(value));
            return *this;
        }

        std::unique_ptr<CookieIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CookieIssueDetails;
        CookieIssueDetailsBuilder() : m_result(new CookieIssueDetails()) { }

        template<int STEP> CookieIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CookieIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::CookieIssueDetails> m_result;
    };

    static CookieIssueDetailsBuilder<0> Create()
    {
        return CookieIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CookieIssueDetails()
    {
    }

    std::unique_ptr<protocol::Audits::AffectedCookie> m_cookie;
    std::optional<String> m_rawCookieLine;
    std::unique_ptr<protocol::Array<String>> m_cookieWarningReasons;
    std::unique_ptr<protocol::Array<String>> m_cookieExclusionReasons;
    String m_operation;
    std::optional<String> m_siteForCookies;
    std::optional<String> m_cookieUrl;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
    std::unique_ptr<protocol::Audits::CookieIssueInsight> m_insight;
};


class CONTENT_EXPORT MixedContentIssueDetails : public ::crdtp::ProtocolObject<MixedContentIssueDetails> {
public:
    ~MixedContentIssueDetails() override { }

    bool HasResourceType() { return !!m_resourceType; }
    String GetResourceType(const String& defaultValue) const {
       return m_resourceType.value_or(defaultValue);
    }
    const std::optional<String>& GetResourceType() const {
       return m_resourceType;
    }
    void SetResourceType(const String& value) { m_resourceType = value; }

    String GetResolutionStatus() { return m_resolutionStatus; }
    void SetResolutionStatus(const String& value) { m_resolutionStatus = value; }

    String GetInsecureURL() { return m_insecureURL; }
    void SetInsecureURL(const String& value) { m_insecureURL = value; }

    String GetMainResourceURL() { return m_mainResourceURL; }
    void SetMainResourceURL(const String& value) { m_mainResourceURL = value; }

    bool HasRequest() { return !!m_request; }
    protocol::Audits::AffectedRequest* GetRequest(protocol::Audits::AffectedRequest* defaultValue) {
       return m_request ? m_request.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedRequest>& GetRequest() const {
       return m_request;
    }
    void SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

    bool HasFrame() { return !!m_frame; }
    protocol::Audits::AffectedFrame* GetFrame(protocol::Audits::AffectedFrame* defaultValue) {
       return m_frame ? m_frame.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedFrame>& GetFrame() const {
       return m_frame;
    }
    void SetFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_frame = std::move(value); }

    template<int STATE>
    class MixedContentIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ResolutionStatusSet = 1 << 1,
            InsecureURLSet = 1 << 2,
            MainResourceURLSet = 1 << 3,
            AllFieldsSet = (ResolutionStatusSet | InsecureURLSet | MainResourceURLSet | 0)};


        MixedContentIssueDetailsBuilder<STATE>& SetResourceType(const String& value)
        {
            m_result->SetResourceType(value);
            return *this;
        }

        MixedContentIssueDetailsBuilder<STATE | ResolutionStatusSet>& SetResolutionStatus(const String& value)
        {
            static_assert(!(STATE & ResolutionStatusSet), "property resolutionStatus should not be set yet");
            m_result->SetResolutionStatus(value);
            return castState<ResolutionStatusSet>();
        }

        MixedContentIssueDetailsBuilder<STATE | InsecureURLSet>& SetInsecureURL(const String& value)
        {
            static_assert(!(STATE & InsecureURLSet), "property insecureURL should not be set yet");
            m_result->SetInsecureURL(value);
            return castState<InsecureURLSet>();
        }

        MixedContentIssueDetailsBuilder<STATE | MainResourceURLSet>& SetMainResourceURL(const String& value)
        {
            static_assert(!(STATE & MainResourceURLSet), "property mainResourceURL should not be set yet");
            m_result->SetMainResourceURL(value);
            return castState<MainResourceURLSet>();
        }

        MixedContentIssueDetailsBuilder<STATE>& SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value)
        {
            m_result->SetRequest(std::move(value));
            return *this;
        }

        MixedContentIssueDetailsBuilder<STATE>& SetFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value)
        {
            m_result->SetFrame(std::move(value));
            return *this;
        }

        std::unique_ptr<MixedContentIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class MixedContentIssueDetails;
        MixedContentIssueDetailsBuilder() : m_result(new MixedContentIssueDetails()) { }

        template<int STEP> MixedContentIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<MixedContentIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::MixedContentIssueDetails> m_result;
    };

    static MixedContentIssueDetailsBuilder<0> Create()
    {
        return MixedContentIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    MixedContentIssueDetails()
    {
    }

    std::optional<String> m_resourceType;
    String m_resolutionStatus;
    String m_insecureURL;
    String m_mainResourceURL;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
    std::unique_ptr<protocol::Audits::AffectedFrame> m_frame;
};


class CONTENT_EXPORT BlockedByResponseIssueDetails : public ::crdtp::ProtocolObject<BlockedByResponseIssueDetails> {
public:
    ~BlockedByResponseIssueDetails() override { }

    protocol::Audits::AffectedRequest* GetRequest() { return m_request.get(); }
    void SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

    bool HasParentFrame() { return !!m_parentFrame; }
    protocol::Audits::AffectedFrame* GetParentFrame(protocol::Audits::AffectedFrame* defaultValue) {
       return m_parentFrame ? m_parentFrame.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedFrame>& GetParentFrame() const {
       return m_parentFrame;
    }
    void SetParentFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_parentFrame = std::move(value); }

    bool HasBlockedFrame() { return !!m_blockedFrame; }
    protocol::Audits::AffectedFrame* GetBlockedFrame(protocol::Audits::AffectedFrame* defaultValue) {
       return m_blockedFrame ? m_blockedFrame.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedFrame>& GetBlockedFrame() const {
       return m_blockedFrame;
    }
    void SetBlockedFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_blockedFrame = std::move(value); }

    String GetReason() { return m_reason; }
    void SetReason(const String& value) { m_reason = value; }

    template<int STATE>
    class BlockedByResponseIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RequestSet = 1 << 1,
            ReasonSet = 1 << 2,
            AllFieldsSet = (RequestSet | ReasonSet | 0)};


        BlockedByResponseIssueDetailsBuilder<STATE | RequestSet>& SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value)
        {
            static_assert(!(STATE & RequestSet), "property request should not be set yet");
            m_result->SetRequest(std::move(value));
            return castState<RequestSet>();
        }

        BlockedByResponseIssueDetailsBuilder<STATE>& SetParentFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value)
        {
            m_result->SetParentFrame(std::move(value));
            return *this;
        }

        BlockedByResponseIssueDetailsBuilder<STATE>& SetBlockedFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value)
        {
            m_result->SetBlockedFrame(std::move(value));
            return *this;
        }

        BlockedByResponseIssueDetailsBuilder<STATE | ReasonSet>& SetReason(const String& value)
        {
            static_assert(!(STATE & ReasonSet), "property reason should not be set yet");
            m_result->SetReason(value);
            return castState<ReasonSet>();
        }

        std::unique_ptr<BlockedByResponseIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class BlockedByResponseIssueDetails;
        BlockedByResponseIssueDetailsBuilder() : m_result(new BlockedByResponseIssueDetails()) { }

        template<int STEP> BlockedByResponseIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BlockedByResponseIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::BlockedByResponseIssueDetails> m_result;
    };

    static BlockedByResponseIssueDetailsBuilder<0> Create()
    {
        return BlockedByResponseIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    BlockedByResponseIssueDetails()
    {
    }

    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
    std::unique_ptr<protocol::Audits::AffectedFrame> m_parentFrame;
    std::unique_ptr<protocol::Audits::AffectedFrame> m_blockedFrame;
    String m_reason;
};


class CONTENT_EXPORT HeavyAdIssueDetails : public ::crdtp::ProtocolObject<HeavyAdIssueDetails> {
public:
    ~HeavyAdIssueDetails() override { }

    String GetResolution() { return m_resolution; }
    void SetResolution(const String& value) { m_resolution = value; }

    String GetReason() { return m_reason; }
    void SetReason(const String& value) { m_reason = value; }

    protocol::Audits::AffectedFrame* GetFrame() { return m_frame.get(); }
    void SetFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_frame = std::move(value); }

    template<int STATE>
    class HeavyAdIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ResolutionSet = 1 << 1,
            ReasonSet = 1 << 2,
            FrameSet = 1 << 3,
            AllFieldsSet = (ResolutionSet | ReasonSet | FrameSet | 0)};


        HeavyAdIssueDetailsBuilder<STATE | ResolutionSet>& SetResolution(const String& value)
        {
            static_assert(!(STATE & ResolutionSet), "property resolution should not be set yet");
            m_result->SetResolution(value);
            return castState<ResolutionSet>();
        }

        HeavyAdIssueDetailsBuilder<STATE | ReasonSet>& SetReason(const String& value)
        {
            static_assert(!(STATE & ReasonSet), "property reason should not be set yet");
            m_result->SetReason(value);
            return castState<ReasonSet>();
        }

        HeavyAdIssueDetailsBuilder<STATE | FrameSet>& SetFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value)
        {
            static_assert(!(STATE & FrameSet), "property frame should not be set yet");
            m_result->SetFrame(std::move(value));
            return castState<FrameSet>();
        }

        std::unique_ptr<HeavyAdIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class HeavyAdIssueDetails;
        HeavyAdIssueDetailsBuilder() : m_result(new HeavyAdIssueDetails()) { }

        template<int STEP> HeavyAdIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<HeavyAdIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::HeavyAdIssueDetails> m_result;
    };

    static HeavyAdIssueDetailsBuilder<0> Create()
    {
        return HeavyAdIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    HeavyAdIssueDetails()
    {
    }

    String m_resolution;
    String m_reason;
    std::unique_ptr<protocol::Audits::AffectedFrame> m_frame;
};


class CONTENT_EXPORT SourceCodeLocation : public ::crdtp::ProtocolObject<SourceCodeLocation> {
public:
    ~SourceCodeLocation() override { }

    bool HasScriptId() { return !!m_scriptId; }
    String GetScriptId(const String& defaultValue) const {
       return m_scriptId.value_or(defaultValue);
    }
    const std::optional<String>& GetScriptId() const {
       return m_scriptId;
    }
    void SetScriptId(const String& value) { m_scriptId = value; }

    String GetUrl() { return m_url; }
    void SetUrl(const String& value) { m_url = value; }

    int GetLineNumber() { return m_lineNumber; }
    void SetLineNumber(int value) { m_lineNumber = value; }

    int GetColumnNumber() { return m_columnNumber; }
    void SetColumnNumber(int value) { m_columnNumber = value; }

    template<int STATE>
    class SourceCodeLocationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            LineNumberSet = 1 << 2,
            ColumnNumberSet = 1 << 3,
            AllFieldsSet = (UrlSet | LineNumberSet | ColumnNumberSet | 0)};


        SourceCodeLocationBuilder<STATE>& SetScriptId(const String& value)
        {
            m_result->SetScriptId(value);
            return *this;
        }

        SourceCodeLocationBuilder<STATE | UrlSet>& SetUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->SetUrl(value);
            return castState<UrlSet>();
        }

        SourceCodeLocationBuilder<STATE | LineNumberSet>& SetLineNumber(int value)
        {
            static_assert(!(STATE & LineNumberSet), "property lineNumber should not be set yet");
            m_result->SetLineNumber(value);
            return castState<LineNumberSet>();
        }

        SourceCodeLocationBuilder<STATE | ColumnNumberSet>& SetColumnNumber(int value)
        {
            static_assert(!(STATE & ColumnNumberSet), "property columnNumber should not be set yet");
            m_result->SetColumnNumber(value);
            return castState<ColumnNumberSet>();
        }

        std::unique_ptr<SourceCodeLocation> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SourceCodeLocation;
        SourceCodeLocationBuilder() : m_result(new SourceCodeLocation()) { }

        template<int STEP> SourceCodeLocationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SourceCodeLocationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::SourceCodeLocation> m_result;
    };

    static SourceCodeLocationBuilder<0> Create()
    {
        return SourceCodeLocationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SourceCodeLocation()
    {
          m_lineNumber = 0;
          m_columnNumber = 0;
    }

    std::optional<String> m_scriptId;
    String m_url;
    int m_lineNumber;
    int m_columnNumber;
};


class CONTENT_EXPORT ContentSecurityPolicyIssueDetails : public ::crdtp::ProtocolObject<ContentSecurityPolicyIssueDetails> {
public:
    ~ContentSecurityPolicyIssueDetails() override { }

    bool HasBlockedURL() { return !!m_blockedURL; }
    String GetBlockedURL(const String& defaultValue) const {
       return m_blockedURL.value_or(defaultValue);
    }
    const std::optional<String>& GetBlockedURL() const {
       return m_blockedURL;
    }
    void SetBlockedURL(const String& value) { m_blockedURL = value; }

    String GetViolatedDirective() { return m_violatedDirective; }
    void SetViolatedDirective(const String& value) { m_violatedDirective = value; }

    bool GetIsReportOnly() { return m_isReportOnly; }
    void SetIsReportOnly(bool value) { m_isReportOnly = value; }

    String GetContentSecurityPolicyViolationType() { return m_contentSecurityPolicyViolationType; }
    void SetContentSecurityPolicyViolationType(const String& value) { m_contentSecurityPolicyViolationType = value; }

    bool HasFrameAncestor() { return !!m_frameAncestor; }
    protocol::Audits::AffectedFrame* GetFrameAncestor(protocol::Audits::AffectedFrame* defaultValue) {
       return m_frameAncestor ? m_frameAncestor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedFrame>& GetFrameAncestor() const {
       return m_frameAncestor;
    }
    void SetFrameAncestor(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_frameAncestor = std::move(value); }

    bool HasSourceCodeLocation() { return !!m_sourceCodeLocation; }
    protocol::Audits::SourceCodeLocation* GetSourceCodeLocation(protocol::Audits::SourceCodeLocation* defaultValue) {
       return m_sourceCodeLocation ? m_sourceCodeLocation.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::SourceCodeLocation>& GetSourceCodeLocation() const {
       return m_sourceCodeLocation;
    }
    void SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }

    bool HasViolatingNodeId() { return !!m_violatingNodeId; }
    int GetViolatingNodeId(int defaultValue) const {
       return m_violatingNodeId.value_or(defaultValue);
    }
    const std::optional<int>& GetViolatingNodeId() const {
       return m_violatingNodeId;
    }
    void SetViolatingNodeId(int value) { m_violatingNodeId = value; }

    template<int STATE>
    class ContentSecurityPolicyIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ViolatedDirectiveSet = 1 << 1,
            IsReportOnlySet = 1 << 2,
            ContentSecurityPolicyViolationTypeSet = 1 << 3,
            AllFieldsSet = (ViolatedDirectiveSet | IsReportOnlySet | ContentSecurityPolicyViolationTypeSet | 0)};


        ContentSecurityPolicyIssueDetailsBuilder<STATE>& SetBlockedURL(const String& value)
        {
            m_result->SetBlockedURL(value);
            return *this;
        }

        ContentSecurityPolicyIssueDetailsBuilder<STATE | ViolatedDirectiveSet>& SetViolatedDirective(const String& value)
        {
            static_assert(!(STATE & ViolatedDirectiveSet), "property violatedDirective should not be set yet");
            m_result->SetViolatedDirective(value);
            return castState<ViolatedDirectiveSet>();
        }

        ContentSecurityPolicyIssueDetailsBuilder<STATE | IsReportOnlySet>& SetIsReportOnly(bool value)
        {
            static_assert(!(STATE & IsReportOnlySet), "property isReportOnly should not be set yet");
            m_result->SetIsReportOnly(value);
            return castState<IsReportOnlySet>();
        }

        ContentSecurityPolicyIssueDetailsBuilder<STATE | ContentSecurityPolicyViolationTypeSet>& SetContentSecurityPolicyViolationType(const String& value)
        {
            static_assert(!(STATE & ContentSecurityPolicyViolationTypeSet), "property contentSecurityPolicyViolationType should not be set yet");
            m_result->SetContentSecurityPolicyViolationType(value);
            return castState<ContentSecurityPolicyViolationTypeSet>();
        }

        ContentSecurityPolicyIssueDetailsBuilder<STATE>& SetFrameAncestor(std::unique_ptr<protocol::Audits::AffectedFrame> value)
        {
            m_result->SetFrameAncestor(std::move(value));
            return *this;
        }

        ContentSecurityPolicyIssueDetailsBuilder<STATE>& SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value)
        {
            m_result->SetSourceCodeLocation(std::move(value));
            return *this;
        }

        ContentSecurityPolicyIssueDetailsBuilder<STATE>& SetViolatingNodeId(int value)
        {
            m_result->SetViolatingNodeId(value);
            return *this;
        }

        std::unique_ptr<ContentSecurityPolicyIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ContentSecurityPolicyIssueDetails;
        ContentSecurityPolicyIssueDetailsBuilder() : m_result(new ContentSecurityPolicyIssueDetails()) { }

        template<int STEP> ContentSecurityPolicyIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ContentSecurityPolicyIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::ContentSecurityPolicyIssueDetails> m_result;
    };

    static ContentSecurityPolicyIssueDetailsBuilder<0> Create()
    {
        return ContentSecurityPolicyIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ContentSecurityPolicyIssueDetails()
    {
          m_isReportOnly = false;
    }

    std::optional<String> m_blockedURL;
    String m_violatedDirective;
    bool m_isReportOnly;
    String m_contentSecurityPolicyViolationType;
    std::unique_ptr<protocol::Audits::AffectedFrame> m_frameAncestor;
    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
    std::optional<int> m_violatingNodeId;
};


class CONTENT_EXPORT SharedArrayBufferIssueDetails : public ::crdtp::ProtocolObject<SharedArrayBufferIssueDetails> {
public:
    ~SharedArrayBufferIssueDetails() override { }

    protocol::Audits::SourceCodeLocation* GetSourceCodeLocation() { return m_sourceCodeLocation.get(); }
    void SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }

    bool GetIsWarning() { return m_isWarning; }
    void SetIsWarning(bool value) { m_isWarning = value; }

    String GetType() { return m_type; }
    void SetType(const String& value) { m_type = value; }

    template<int STATE>
    class SharedArrayBufferIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SourceCodeLocationSet = 1 << 1,
            IsWarningSet = 1 << 2,
            TypeSet = 1 << 3,
            AllFieldsSet = (SourceCodeLocationSet | IsWarningSet | TypeSet | 0)};


        SharedArrayBufferIssueDetailsBuilder<STATE | SourceCodeLocationSet>& SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value)
        {
            static_assert(!(STATE & SourceCodeLocationSet), "property sourceCodeLocation should not be set yet");
            m_result->SetSourceCodeLocation(std::move(value));
            return castState<SourceCodeLocationSet>();
        }

        SharedArrayBufferIssueDetailsBuilder<STATE | IsWarningSet>& SetIsWarning(bool value)
        {
            static_assert(!(STATE & IsWarningSet), "property isWarning should not be set yet");
            m_result->SetIsWarning(value);
            return castState<IsWarningSet>();
        }

        SharedArrayBufferIssueDetailsBuilder<STATE | TypeSet>& SetType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->SetType(value);
            return castState<TypeSet>();
        }

        std::unique_ptr<SharedArrayBufferIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SharedArrayBufferIssueDetails;
        SharedArrayBufferIssueDetailsBuilder() : m_result(new SharedArrayBufferIssueDetails()) { }

        template<int STEP> SharedArrayBufferIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SharedArrayBufferIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::SharedArrayBufferIssueDetails> m_result;
    };

    static SharedArrayBufferIssueDetailsBuilder<0> Create()
    {
        return SharedArrayBufferIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SharedArrayBufferIssueDetails()
    {
          m_isWarning = false;
    }

    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
    bool m_isWarning;
    String m_type;
};


class CONTENT_EXPORT LowTextContrastIssueDetails : public ::crdtp::ProtocolObject<LowTextContrastIssueDetails> {
public:
    ~LowTextContrastIssueDetails() override { }

    int GetViolatingNodeId() { return m_violatingNodeId; }
    void SetViolatingNodeId(int value) { m_violatingNodeId = value; }

    String GetViolatingNodeSelector() { return m_violatingNodeSelector; }
    void SetViolatingNodeSelector(const String& value) { m_violatingNodeSelector = value; }

    double GetContrastRatio() { return m_contrastRatio; }
    void SetContrastRatio(double value) { m_contrastRatio = value; }

    double GetThresholdAA() { return m_thresholdAA; }
    void SetThresholdAA(double value) { m_thresholdAA = value; }

    double GetThresholdAAA() { return m_thresholdAAA; }
    void SetThresholdAAA(double value) { m_thresholdAAA = value; }

    String GetFontSize() { return m_fontSize; }
    void SetFontSize(const String& value) { m_fontSize = value; }

    String GetFontWeight() { return m_fontWeight; }
    void SetFontWeight(const String& value) { m_fontWeight = value; }

    template<int STATE>
    class LowTextContrastIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ViolatingNodeIdSet = 1 << 1,
            ViolatingNodeSelectorSet = 1 << 2,
            ContrastRatioSet = 1 << 3,
            ThresholdAASet = 1 << 4,
            ThresholdAAASet = 1 << 5,
            FontSizeSet = 1 << 6,
            FontWeightSet = 1 << 7,
            AllFieldsSet = (ViolatingNodeIdSet | ViolatingNodeSelectorSet | ContrastRatioSet | ThresholdAASet | ThresholdAAASet | FontSizeSet | FontWeightSet | 0)};


        LowTextContrastIssueDetailsBuilder<STATE | ViolatingNodeIdSet>& SetViolatingNodeId(int value)
        {
            static_assert(!(STATE & ViolatingNodeIdSet), "property violatingNodeId should not be set yet");
            m_result->SetViolatingNodeId(value);
            return castState<ViolatingNodeIdSet>();
        }

        LowTextContrastIssueDetailsBuilder<STATE | ViolatingNodeSelectorSet>& SetViolatingNodeSelector(const String& value)
        {
            static_assert(!(STATE & ViolatingNodeSelectorSet), "property violatingNodeSelector should not be set yet");
            m_result->SetViolatingNodeSelector(value);
            return castState<ViolatingNodeSelectorSet>();
        }

        LowTextContrastIssueDetailsBuilder<STATE | ContrastRatioSet>& SetContrastRatio(double value)
        {
            static_assert(!(STATE & ContrastRatioSet), "property contrastRatio should not be set yet");
            m_result->SetContrastRatio(value);
            return castState<ContrastRatioSet>();
        }

        LowTextContrastIssueDetailsBuilder<STATE | ThresholdAASet>& SetThresholdAA(double value)
        {
            static_assert(!(STATE & ThresholdAASet), "property thresholdAA should not be set yet");
            m_result->SetThresholdAA(value);
            return castState<ThresholdAASet>();
        }

        LowTextContrastIssueDetailsBuilder<STATE | ThresholdAAASet>& SetThresholdAAA(double value)
        {
            static_assert(!(STATE & ThresholdAAASet), "property thresholdAAA should not be set yet");
            m_result->SetThresholdAAA(value);
            return castState<ThresholdAAASet>();
        }

        LowTextContrastIssueDetailsBuilder<STATE | FontSizeSet>& SetFontSize(const String& value)
        {
            static_assert(!(STATE & FontSizeSet), "property fontSize should not be set yet");
            m_result->SetFontSize(value);
            return castState<FontSizeSet>();
        }

        LowTextContrastIssueDetailsBuilder<STATE | FontWeightSet>& SetFontWeight(const String& value)
        {
            static_assert(!(STATE & FontWeightSet), "property fontWeight should not be set yet");
            m_result->SetFontWeight(value);
            return castState<FontWeightSet>();
        }

        std::unique_ptr<LowTextContrastIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class LowTextContrastIssueDetails;
        LowTextContrastIssueDetailsBuilder() : m_result(new LowTextContrastIssueDetails()) { }

        template<int STEP> LowTextContrastIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<LowTextContrastIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::LowTextContrastIssueDetails> m_result;
    };

    static LowTextContrastIssueDetailsBuilder<0> Create()
    {
        return LowTextContrastIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    LowTextContrastIssueDetails()
    {
          m_violatingNodeId = 0;
          m_contrastRatio = 0;
          m_thresholdAA = 0;
          m_thresholdAAA = 0;
    }

    int m_violatingNodeId;
    String m_violatingNodeSelector;
    double m_contrastRatio;
    double m_thresholdAA;
    double m_thresholdAAA;
    String m_fontSize;
    String m_fontWeight;
};


class CONTENT_EXPORT CorsIssueDetails : public ::crdtp::ProtocolObject<CorsIssueDetails> {
public:
    ~CorsIssueDetails() override { }

    protocol::Network::CorsErrorStatus* GetCorsErrorStatus() { return m_corsErrorStatus.get(); }
    void SetCorsErrorStatus(std::unique_ptr<protocol::Network::CorsErrorStatus> value) { m_corsErrorStatus = std::move(value); }

    bool GetIsWarning() { return m_isWarning; }
    void SetIsWarning(bool value) { m_isWarning = value; }

    protocol::Audits::AffectedRequest* GetRequest() { return m_request.get(); }
    void SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

    bool HasLocation() { return !!m_location; }
    protocol::Audits::SourceCodeLocation* GetLocation(protocol::Audits::SourceCodeLocation* defaultValue) {
       return m_location ? m_location.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::SourceCodeLocation>& GetLocation() const {
       return m_location;
    }
    void SetLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_location = std::move(value); }

    bool HasInitiatorOrigin() { return !!m_initiatorOrigin; }
    String GetInitiatorOrigin(const String& defaultValue) const {
       return m_initiatorOrigin.value_or(defaultValue);
    }
    const std::optional<String>& GetInitiatorOrigin() const {
       return m_initiatorOrigin;
    }
    void SetInitiatorOrigin(const String& value) { m_initiatorOrigin = value; }

    bool HasResourceIPAddressSpace() { return !!m_resourceIPAddressSpace; }
    String GetResourceIPAddressSpace(const String& defaultValue) const {
       return m_resourceIPAddressSpace.value_or(defaultValue);
    }
    const std::optional<String>& GetResourceIPAddressSpace() const {
       return m_resourceIPAddressSpace;
    }
    void SetResourceIPAddressSpace(const String& value) { m_resourceIPAddressSpace = value; }

    bool HasClientSecurityState() { return !!m_clientSecurityState; }
    protocol::Network::ClientSecurityState* GetClientSecurityState(protocol::Network::ClientSecurityState* defaultValue) {
       return m_clientSecurityState ? m_clientSecurityState.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::ClientSecurityState>& GetClientSecurityState() const {
       return m_clientSecurityState;
    }
    void SetClientSecurityState(std::unique_ptr<protocol::Network::ClientSecurityState> value) { m_clientSecurityState = std::move(value); }

    template<int STATE>
    class CorsIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CorsErrorStatusSet = 1 << 1,
            IsWarningSet = 1 << 2,
            RequestSet = 1 << 3,
            AllFieldsSet = (CorsErrorStatusSet | IsWarningSet | RequestSet | 0)};


        CorsIssueDetailsBuilder<STATE | CorsErrorStatusSet>& SetCorsErrorStatus(std::unique_ptr<protocol::Network::CorsErrorStatus> value)
        {
            static_assert(!(STATE & CorsErrorStatusSet), "property corsErrorStatus should not be set yet");
            m_result->SetCorsErrorStatus(std::move(value));
            return castState<CorsErrorStatusSet>();
        }

        CorsIssueDetailsBuilder<STATE | IsWarningSet>& SetIsWarning(bool value)
        {
            static_assert(!(STATE & IsWarningSet), "property isWarning should not be set yet");
            m_result->SetIsWarning(value);
            return castState<IsWarningSet>();
        }

        CorsIssueDetailsBuilder<STATE | RequestSet>& SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value)
        {
            static_assert(!(STATE & RequestSet), "property request should not be set yet");
            m_result->SetRequest(std::move(value));
            return castState<RequestSet>();
        }

        CorsIssueDetailsBuilder<STATE>& SetLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value)
        {
            m_result->SetLocation(std::move(value));
            return *this;
        }

        CorsIssueDetailsBuilder<STATE>& SetInitiatorOrigin(const String& value)
        {
            m_result->SetInitiatorOrigin(value);
            return *this;
        }

        CorsIssueDetailsBuilder<STATE>& SetResourceIPAddressSpace(const String& value)
        {
            m_result->SetResourceIPAddressSpace(value);
            return *this;
        }

        CorsIssueDetailsBuilder<STATE>& SetClientSecurityState(std::unique_ptr<protocol::Network::ClientSecurityState> value)
        {
            m_result->SetClientSecurityState(std::move(value));
            return *this;
        }

        std::unique_ptr<CorsIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CorsIssueDetails;
        CorsIssueDetailsBuilder() : m_result(new CorsIssueDetails()) { }

        template<int STEP> CorsIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CorsIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::CorsIssueDetails> m_result;
    };

    static CorsIssueDetailsBuilder<0> Create()
    {
        return CorsIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CorsIssueDetails()
    {
          m_isWarning = false;
    }

    std::unique_ptr<protocol::Network::CorsErrorStatus> m_corsErrorStatus;
    bool m_isWarning;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_location;
    std::optional<String> m_initiatorOrigin;
    std::optional<String> m_resourceIPAddressSpace;
    std::unique_ptr<protocol::Network::ClientSecurityState> m_clientSecurityState;
};


class CONTENT_EXPORT AttributionReportingIssueDetails : public ::crdtp::ProtocolObject<AttributionReportingIssueDetails> {
public:
    ~AttributionReportingIssueDetails() override { }

    String GetViolationType() { return m_violationType; }
    void SetViolationType(const String& value) { m_violationType = value; }

    bool HasRequest() { return !!m_request; }
    protocol::Audits::AffectedRequest* GetRequest(protocol::Audits::AffectedRequest* defaultValue) {
       return m_request ? m_request.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedRequest>& GetRequest() const {
       return m_request;
    }
    void SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

    bool HasViolatingNodeId() { return !!m_violatingNodeId; }
    int GetViolatingNodeId(int defaultValue) const {
       return m_violatingNodeId.value_or(defaultValue);
    }
    const std::optional<int>& GetViolatingNodeId() const {
       return m_violatingNodeId;
    }
    void SetViolatingNodeId(int value) { m_violatingNodeId = value; }

    bool HasInvalidParameter() { return !!m_invalidParameter; }
    String GetInvalidParameter(const String& defaultValue) const {
       return m_invalidParameter.value_or(defaultValue);
    }
    const std::optional<String>& GetInvalidParameter() const {
       return m_invalidParameter;
    }
    void SetInvalidParameter(const String& value) { m_invalidParameter = value; }

    template<int STATE>
    class AttributionReportingIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ViolationTypeSet = 1 << 1,
            AllFieldsSet = (ViolationTypeSet | 0)};


        AttributionReportingIssueDetailsBuilder<STATE | ViolationTypeSet>& SetViolationType(const String& value)
        {
            static_assert(!(STATE & ViolationTypeSet), "property violationType should not be set yet");
            m_result->SetViolationType(value);
            return castState<ViolationTypeSet>();
        }

        AttributionReportingIssueDetailsBuilder<STATE>& SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value)
        {
            m_result->SetRequest(std::move(value));
            return *this;
        }

        AttributionReportingIssueDetailsBuilder<STATE>& SetViolatingNodeId(int value)
        {
            m_result->SetViolatingNodeId(value);
            return *this;
        }

        AttributionReportingIssueDetailsBuilder<STATE>& SetInvalidParameter(const String& value)
        {
            m_result->SetInvalidParameter(value);
            return *this;
        }

        std::unique_ptr<AttributionReportingIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingIssueDetails;
        AttributionReportingIssueDetailsBuilder() : m_result(new AttributionReportingIssueDetails()) { }

        template<int STEP> AttributionReportingIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::AttributionReportingIssueDetails> m_result;
    };

    static AttributionReportingIssueDetailsBuilder<0> Create()
    {
        return AttributionReportingIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingIssueDetails()
    {
    }

    String m_violationType;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
    std::optional<int> m_violatingNodeId;
    std::optional<String> m_invalidParameter;
};


class CONTENT_EXPORT QuirksModeIssueDetails : public ::crdtp::ProtocolObject<QuirksModeIssueDetails> {
public:
    ~QuirksModeIssueDetails() override { }

    bool GetIsLimitedQuirksMode() { return m_isLimitedQuirksMode; }
    void SetIsLimitedQuirksMode(bool value) { m_isLimitedQuirksMode = value; }

    int GetDocumentNodeId() { return m_documentNodeId; }
    void SetDocumentNodeId(int value) { m_documentNodeId = value; }

    String GetUrl() { return m_url; }
    void SetUrl(const String& value) { m_url = value; }

    String GetFrameId() { return m_frameId; }
    void SetFrameId(const String& value) { m_frameId = value; }

    String GetLoaderId() { return m_loaderId; }
    void SetLoaderId(const String& value) { m_loaderId = value; }

    template<int STATE>
    class QuirksModeIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            IsLimitedQuirksModeSet = 1 << 1,
            DocumentNodeIdSet = 1 << 2,
            UrlSet = 1 << 3,
            FrameIdSet = 1 << 4,
            LoaderIdSet = 1 << 5,
            AllFieldsSet = (IsLimitedQuirksModeSet | DocumentNodeIdSet | UrlSet | FrameIdSet | LoaderIdSet | 0)};


        QuirksModeIssueDetailsBuilder<STATE | IsLimitedQuirksModeSet>& SetIsLimitedQuirksMode(bool value)
        {
            static_assert(!(STATE & IsLimitedQuirksModeSet), "property isLimitedQuirksMode should not be set yet");
            m_result->SetIsLimitedQuirksMode(value);
            return castState<IsLimitedQuirksModeSet>();
        }

        QuirksModeIssueDetailsBuilder<STATE | DocumentNodeIdSet>& SetDocumentNodeId(int value)
        {
            static_assert(!(STATE & DocumentNodeIdSet), "property documentNodeId should not be set yet");
            m_result->SetDocumentNodeId(value);
            return castState<DocumentNodeIdSet>();
        }

        QuirksModeIssueDetailsBuilder<STATE | UrlSet>& SetUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->SetUrl(value);
            return castState<UrlSet>();
        }

        QuirksModeIssueDetailsBuilder<STATE | FrameIdSet>& SetFrameId(const String& value)
        {
            static_assert(!(STATE & FrameIdSet), "property frameId should not be set yet");
            m_result->SetFrameId(value);
            return castState<FrameIdSet>();
        }

        QuirksModeIssueDetailsBuilder<STATE | LoaderIdSet>& SetLoaderId(const String& value)
        {
            static_assert(!(STATE & LoaderIdSet), "property loaderId should not be set yet");
            m_result->SetLoaderId(value);
            return castState<LoaderIdSet>();
        }

        std::unique_ptr<QuirksModeIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class QuirksModeIssueDetails;
        QuirksModeIssueDetailsBuilder() : m_result(new QuirksModeIssueDetails()) { }

        template<int STEP> QuirksModeIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<QuirksModeIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::QuirksModeIssueDetails> m_result;
    };

    static QuirksModeIssueDetailsBuilder<0> Create()
    {
        return QuirksModeIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    QuirksModeIssueDetails()
    {
          m_isLimitedQuirksMode = false;
          m_documentNodeId = 0;
    }

    bool m_isLimitedQuirksMode;
    int m_documentNodeId;
    String m_url;
    String m_frameId;
    String m_loaderId;
};


class CONTENT_EXPORT NavigatorUserAgentIssueDetails : public ::crdtp::ProtocolObject<NavigatorUserAgentIssueDetails> {
public:
    ~NavigatorUserAgentIssueDetails() override { }

    String GetUrl() { return m_url; }
    void SetUrl(const String& value) { m_url = value; }

    bool HasLocation() { return !!m_location; }
    protocol::Audits::SourceCodeLocation* GetLocation(protocol::Audits::SourceCodeLocation* defaultValue) {
       return m_location ? m_location.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::SourceCodeLocation>& GetLocation() const {
       return m_location;
    }
    void SetLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_location = std::move(value); }

    template<int STATE>
    class NavigatorUserAgentIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            AllFieldsSet = (UrlSet | 0)};


        NavigatorUserAgentIssueDetailsBuilder<STATE | UrlSet>& SetUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->SetUrl(value);
            return castState<UrlSet>();
        }

        NavigatorUserAgentIssueDetailsBuilder<STATE>& SetLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value)
        {
            m_result->SetLocation(std::move(value));
            return *this;
        }

        std::unique_ptr<NavigatorUserAgentIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class NavigatorUserAgentIssueDetails;
        NavigatorUserAgentIssueDetailsBuilder() : m_result(new NavigatorUserAgentIssueDetails()) { }

        template<int STEP> NavigatorUserAgentIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<NavigatorUserAgentIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::NavigatorUserAgentIssueDetails> m_result;
    };

    static NavigatorUserAgentIssueDetailsBuilder<0> Create()
    {
        return NavigatorUserAgentIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    NavigatorUserAgentIssueDetails()
    {
    }

    String m_url;
    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_location;
};


class CONTENT_EXPORT SharedDictionaryIssueDetails : public ::crdtp::ProtocolObject<SharedDictionaryIssueDetails> {
public:
    ~SharedDictionaryIssueDetails() override { }

    String GetSharedDictionaryError() { return m_sharedDictionaryError; }
    void SetSharedDictionaryError(const String& value) { m_sharedDictionaryError = value; }

    protocol::Audits::AffectedRequest* GetRequest() { return m_request.get(); }
    void SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

    template<int STATE>
    class SharedDictionaryIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SharedDictionaryErrorSet = 1 << 1,
            RequestSet = 1 << 2,
            AllFieldsSet = (SharedDictionaryErrorSet | RequestSet | 0)};


        SharedDictionaryIssueDetailsBuilder<STATE | SharedDictionaryErrorSet>& SetSharedDictionaryError(const String& value)
        {
            static_assert(!(STATE & SharedDictionaryErrorSet), "property sharedDictionaryError should not be set yet");
            m_result->SetSharedDictionaryError(value);
            return castState<SharedDictionaryErrorSet>();
        }

        SharedDictionaryIssueDetailsBuilder<STATE | RequestSet>& SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value)
        {
            static_assert(!(STATE & RequestSet), "property request should not be set yet");
            m_result->SetRequest(std::move(value));
            return castState<RequestSet>();
        }

        std::unique_ptr<SharedDictionaryIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SharedDictionaryIssueDetails;
        SharedDictionaryIssueDetailsBuilder() : m_result(new SharedDictionaryIssueDetails()) { }

        template<int STEP> SharedDictionaryIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SharedDictionaryIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::SharedDictionaryIssueDetails> m_result;
    };

    static SharedDictionaryIssueDetailsBuilder<0> Create()
    {
        return SharedDictionaryIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SharedDictionaryIssueDetails()
    {
    }

    String m_sharedDictionaryError;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
};


class CONTENT_EXPORT GenericIssueDetails : public ::crdtp::ProtocolObject<GenericIssueDetails> {
public:
    ~GenericIssueDetails() override { }

    String GetErrorType() { return m_errorType; }
    void SetErrorType(const String& value) { m_errorType = value; }

    bool HasFrameId() { return !!m_frameId; }
    String GetFrameId(const String& defaultValue) const {
       return m_frameId.value_or(defaultValue);
    }
    const std::optional<String>& GetFrameId() const {
       return m_frameId;
    }
    void SetFrameId(const String& value) { m_frameId = value; }

    bool HasViolatingNodeId() { return !!m_violatingNodeId; }
    int GetViolatingNodeId(int defaultValue) const {
       return m_violatingNodeId.value_or(defaultValue);
    }
    const std::optional<int>& GetViolatingNodeId() const {
       return m_violatingNodeId;
    }
    void SetViolatingNodeId(int value) { m_violatingNodeId = value; }

    bool HasViolatingNodeAttribute() { return !!m_violatingNodeAttribute; }
    String GetViolatingNodeAttribute(const String& defaultValue) const {
       return m_violatingNodeAttribute.value_or(defaultValue);
    }
    const std::optional<String>& GetViolatingNodeAttribute() const {
       return m_violatingNodeAttribute;
    }
    void SetViolatingNodeAttribute(const String& value) { m_violatingNodeAttribute = value; }

    bool HasRequest() { return !!m_request; }
    protocol::Audits::AffectedRequest* GetRequest(protocol::Audits::AffectedRequest* defaultValue) {
       return m_request ? m_request.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedRequest>& GetRequest() const {
       return m_request;
    }
    void SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

    template<int STATE>
    class GenericIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ErrorTypeSet = 1 << 1,
            AllFieldsSet = (ErrorTypeSet | 0)};


        GenericIssueDetailsBuilder<STATE | ErrorTypeSet>& SetErrorType(const String& value)
        {
            static_assert(!(STATE & ErrorTypeSet), "property errorType should not be set yet");
            m_result->SetErrorType(value);
            return castState<ErrorTypeSet>();
        }

        GenericIssueDetailsBuilder<STATE>& SetFrameId(const String& value)
        {
            m_result->SetFrameId(value);
            return *this;
        }

        GenericIssueDetailsBuilder<STATE>& SetViolatingNodeId(int value)
        {
            m_result->SetViolatingNodeId(value);
            return *this;
        }

        GenericIssueDetailsBuilder<STATE>& SetViolatingNodeAttribute(const String& value)
        {
            m_result->SetViolatingNodeAttribute(value);
            return *this;
        }

        GenericIssueDetailsBuilder<STATE>& SetRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value)
        {
            m_result->SetRequest(std::move(value));
            return *this;
        }

        std::unique_ptr<GenericIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class GenericIssueDetails;
        GenericIssueDetailsBuilder() : m_result(new GenericIssueDetails()) { }

        template<int STEP> GenericIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<GenericIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::GenericIssueDetails> m_result;
    };

    static GenericIssueDetailsBuilder<0> Create()
    {
        return GenericIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    GenericIssueDetails()
    {
    }

    String m_errorType;
    std::optional<String> m_frameId;
    std::optional<int> m_violatingNodeId;
    std::optional<String> m_violatingNodeAttribute;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
};


class CONTENT_EXPORT DeprecationIssueDetails : public ::crdtp::ProtocolObject<DeprecationIssueDetails> {
public:
    ~DeprecationIssueDetails() override { }

    bool HasAffectedFrame() { return !!m_affectedFrame; }
    protocol::Audits::AffectedFrame* GetAffectedFrame(protocol::Audits::AffectedFrame* defaultValue) {
       return m_affectedFrame ? m_affectedFrame.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedFrame>& GetAffectedFrame() const {
       return m_affectedFrame;
    }
    void SetAffectedFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_affectedFrame = std::move(value); }

    protocol::Audits::SourceCodeLocation* GetSourceCodeLocation() { return m_sourceCodeLocation.get(); }
    void SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }

    String GetType() { return m_type; }
    void SetType(const String& value) { m_type = value; }

    template<int STATE>
    class DeprecationIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SourceCodeLocationSet = 1 << 1,
            TypeSet = 1 << 2,
            AllFieldsSet = (SourceCodeLocationSet | TypeSet | 0)};


        DeprecationIssueDetailsBuilder<STATE>& SetAffectedFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value)
        {
            m_result->SetAffectedFrame(std::move(value));
            return *this;
        }

        DeprecationIssueDetailsBuilder<STATE | SourceCodeLocationSet>& SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value)
        {
            static_assert(!(STATE & SourceCodeLocationSet), "property sourceCodeLocation should not be set yet");
            m_result->SetSourceCodeLocation(std::move(value));
            return castState<SourceCodeLocationSet>();
        }

        DeprecationIssueDetailsBuilder<STATE | TypeSet>& SetType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->SetType(value);
            return castState<TypeSet>();
        }

        std::unique_ptr<DeprecationIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class DeprecationIssueDetails;
        DeprecationIssueDetailsBuilder() : m_result(new DeprecationIssueDetails()) { }

        template<int STEP> DeprecationIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<DeprecationIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::DeprecationIssueDetails> m_result;
    };

    static DeprecationIssueDetailsBuilder<0> Create()
    {
        return DeprecationIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    DeprecationIssueDetails()
    {
    }

    std::unique_ptr<protocol::Audits::AffectedFrame> m_affectedFrame;
    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
    String m_type;
};


class CONTENT_EXPORT BounceTrackingIssueDetails : public ::crdtp::ProtocolObject<BounceTrackingIssueDetails> {
public:
    ~BounceTrackingIssueDetails() override { }

    protocol::Array<String>* GetTrackingSites() { return m_trackingSites.get(); }
    void SetTrackingSites(std::unique_ptr<protocol::Array<String>> value) { m_trackingSites = std::move(value); }

    template<int STATE>
    class BounceTrackingIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TrackingSitesSet = 1 << 1,
            AllFieldsSet = (TrackingSitesSet | 0)};


        BounceTrackingIssueDetailsBuilder<STATE | TrackingSitesSet>& SetTrackingSites(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & TrackingSitesSet), "property trackingSites should not be set yet");
            m_result->SetTrackingSites(std::move(value));
            return castState<TrackingSitesSet>();
        }

        std::unique_ptr<BounceTrackingIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class BounceTrackingIssueDetails;
        BounceTrackingIssueDetailsBuilder() : m_result(new BounceTrackingIssueDetails()) { }

        template<int STEP> BounceTrackingIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BounceTrackingIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::BounceTrackingIssueDetails> m_result;
    };

    static BounceTrackingIssueDetailsBuilder<0> Create()
    {
        return BounceTrackingIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    BounceTrackingIssueDetails()
    {
    }

    std::unique_ptr<protocol::Array<String>> m_trackingSites;
};


class CONTENT_EXPORT CookieDeprecationMetadataIssueDetails : public ::crdtp::ProtocolObject<CookieDeprecationMetadataIssueDetails> {
public:
    ~CookieDeprecationMetadataIssueDetails() override { }

    protocol::Array<String>* GetAllowedSites() { return m_allowedSites.get(); }
    void SetAllowedSites(std::unique_ptr<protocol::Array<String>> value) { m_allowedSites = std::move(value); }

    double GetOptOutPercentage() { return m_optOutPercentage; }
    void SetOptOutPercentage(double value) { m_optOutPercentage = value; }

    bool GetIsOptOutTopLevel() { return m_isOptOutTopLevel; }
    void SetIsOptOutTopLevel(bool value) { m_isOptOutTopLevel = value; }

    String GetOperation() { return m_operation; }
    void SetOperation(const String& value) { m_operation = value; }

    template<int STATE>
    class CookieDeprecationMetadataIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllowedSitesSet = 1 << 1,
            OptOutPercentageSet = 1 << 2,
            IsOptOutTopLevelSet = 1 << 3,
            OperationSet = 1 << 4,
            AllFieldsSet = (AllowedSitesSet | OptOutPercentageSet | IsOptOutTopLevelSet | OperationSet | 0)};


        CookieDeprecationMetadataIssueDetailsBuilder<STATE | AllowedSitesSet>& SetAllowedSites(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & AllowedSitesSet), "property allowedSites should not be set yet");
            m_result->SetAllowedSites(std::move(value));
            return castState<AllowedSitesSet>();
        }

        CookieDeprecationMetadataIssueDetailsBuilder<STATE | OptOutPercentageSet>& SetOptOutPercentage(double value)
        {
            static_assert(!(STATE & OptOutPercentageSet), "property optOutPercentage should not be set yet");
            m_result->SetOptOutPercentage(value);
            return castState<OptOutPercentageSet>();
        }

        CookieDeprecationMetadataIssueDetailsBuilder<STATE | IsOptOutTopLevelSet>& SetIsOptOutTopLevel(bool value)
        {
            static_assert(!(STATE & IsOptOutTopLevelSet), "property isOptOutTopLevel should not be set yet");
            m_result->SetIsOptOutTopLevel(value);
            return castState<IsOptOutTopLevelSet>();
        }

        CookieDeprecationMetadataIssueDetailsBuilder<STATE | OperationSet>& SetOperation(const String& value)
        {
            static_assert(!(STATE & OperationSet), "property operation should not be set yet");
            m_result->SetOperation(value);
            return castState<OperationSet>();
        }

        std::unique_ptr<CookieDeprecationMetadataIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CookieDeprecationMetadataIssueDetails;
        CookieDeprecationMetadataIssueDetailsBuilder() : m_result(new CookieDeprecationMetadataIssueDetails()) { }

        template<int STEP> CookieDeprecationMetadataIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CookieDeprecationMetadataIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::CookieDeprecationMetadataIssueDetails> m_result;
    };

    static CookieDeprecationMetadataIssueDetailsBuilder<0> Create()
    {
        return CookieDeprecationMetadataIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CookieDeprecationMetadataIssueDetails()
    {
          m_optOutPercentage = 0;
          m_isOptOutTopLevel = false;
    }

    std::unique_ptr<protocol::Array<String>> m_allowedSites;
    double m_optOutPercentage;
    bool m_isOptOutTopLevel;
    String m_operation;
};


class CONTENT_EXPORT FederatedAuthRequestIssueDetails : public ::crdtp::ProtocolObject<FederatedAuthRequestIssueDetails> {
public:
    ~FederatedAuthRequestIssueDetails() override { }

    String GetFederatedAuthRequestIssueReason() { return m_federatedAuthRequestIssueReason; }
    void SetFederatedAuthRequestIssueReason(const String& value) { m_federatedAuthRequestIssueReason = value; }

    template<int STATE>
    class FederatedAuthRequestIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FederatedAuthRequestIssueReasonSet = 1 << 1,
            AllFieldsSet = (FederatedAuthRequestIssueReasonSet | 0)};


        FederatedAuthRequestIssueDetailsBuilder<STATE | FederatedAuthRequestIssueReasonSet>& SetFederatedAuthRequestIssueReason(const String& value)
        {
            static_assert(!(STATE & FederatedAuthRequestIssueReasonSet), "property federatedAuthRequestIssueReason should not be set yet");
            m_result->SetFederatedAuthRequestIssueReason(value);
            return castState<FederatedAuthRequestIssueReasonSet>();
        }

        std::unique_ptr<FederatedAuthRequestIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FederatedAuthRequestIssueDetails;
        FederatedAuthRequestIssueDetailsBuilder() : m_result(new FederatedAuthRequestIssueDetails()) { }

        template<int STEP> FederatedAuthRequestIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FederatedAuthRequestIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::FederatedAuthRequestIssueDetails> m_result;
    };

    static FederatedAuthRequestIssueDetailsBuilder<0> Create()
    {
        return FederatedAuthRequestIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FederatedAuthRequestIssueDetails()
    {
    }

    String m_federatedAuthRequestIssueReason;
};


class CONTENT_EXPORT FederatedAuthUserInfoRequestIssueDetails : public ::crdtp::ProtocolObject<FederatedAuthUserInfoRequestIssueDetails> {
public:
    ~FederatedAuthUserInfoRequestIssueDetails() override { }

    String GetFederatedAuthUserInfoRequestIssueReason() { return m_federatedAuthUserInfoRequestIssueReason; }
    void SetFederatedAuthUserInfoRequestIssueReason(const String& value) { m_federatedAuthUserInfoRequestIssueReason = value; }

    template<int STATE>
    class FederatedAuthUserInfoRequestIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FederatedAuthUserInfoRequestIssueReasonSet = 1 << 1,
            AllFieldsSet = (FederatedAuthUserInfoRequestIssueReasonSet | 0)};


        FederatedAuthUserInfoRequestIssueDetailsBuilder<STATE | FederatedAuthUserInfoRequestIssueReasonSet>& SetFederatedAuthUserInfoRequestIssueReason(const String& value)
        {
            static_assert(!(STATE & FederatedAuthUserInfoRequestIssueReasonSet), "property federatedAuthUserInfoRequestIssueReason should not be set yet");
            m_result->SetFederatedAuthUserInfoRequestIssueReason(value);
            return castState<FederatedAuthUserInfoRequestIssueReasonSet>();
        }

        std::unique_ptr<FederatedAuthUserInfoRequestIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FederatedAuthUserInfoRequestIssueDetails;
        FederatedAuthUserInfoRequestIssueDetailsBuilder() : m_result(new FederatedAuthUserInfoRequestIssueDetails()) { }

        template<int STEP> FederatedAuthUserInfoRequestIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FederatedAuthUserInfoRequestIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::FederatedAuthUserInfoRequestIssueDetails> m_result;
    };

    static FederatedAuthUserInfoRequestIssueDetailsBuilder<0> Create()
    {
        return FederatedAuthUserInfoRequestIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FederatedAuthUserInfoRequestIssueDetails()
    {
    }

    String m_federatedAuthUserInfoRequestIssueReason;
};


class CONTENT_EXPORT ClientHintIssueDetails : public ::crdtp::ProtocolObject<ClientHintIssueDetails> {
public:
    ~ClientHintIssueDetails() override { }

    protocol::Audits::SourceCodeLocation* GetSourceCodeLocation() { return m_sourceCodeLocation.get(); }
    void SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }

    String GetClientHintIssueReason() { return m_clientHintIssueReason; }
    void SetClientHintIssueReason(const String& value) { m_clientHintIssueReason = value; }

    template<int STATE>
    class ClientHintIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SourceCodeLocationSet = 1 << 1,
            ClientHintIssueReasonSet = 1 << 2,
            AllFieldsSet = (SourceCodeLocationSet | ClientHintIssueReasonSet | 0)};


        ClientHintIssueDetailsBuilder<STATE | SourceCodeLocationSet>& SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value)
        {
            static_assert(!(STATE & SourceCodeLocationSet), "property sourceCodeLocation should not be set yet");
            m_result->SetSourceCodeLocation(std::move(value));
            return castState<SourceCodeLocationSet>();
        }

        ClientHintIssueDetailsBuilder<STATE | ClientHintIssueReasonSet>& SetClientHintIssueReason(const String& value)
        {
            static_assert(!(STATE & ClientHintIssueReasonSet), "property clientHintIssueReason should not be set yet");
            m_result->SetClientHintIssueReason(value);
            return castState<ClientHintIssueReasonSet>();
        }

        std::unique_ptr<ClientHintIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ClientHintIssueDetails;
        ClientHintIssueDetailsBuilder() : m_result(new ClientHintIssueDetails()) { }

        template<int STEP> ClientHintIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ClientHintIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::ClientHintIssueDetails> m_result;
    };

    static ClientHintIssueDetailsBuilder<0> Create()
    {
        return ClientHintIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ClientHintIssueDetails()
    {
    }

    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
    String m_clientHintIssueReason;
};


class CONTENT_EXPORT FailedRequestInfo : public ::crdtp::ProtocolObject<FailedRequestInfo> {
public:
    ~FailedRequestInfo() override { }

    String GetUrl() { return m_url; }
    void SetUrl(const String& value) { m_url = value; }

    String GetFailureMessage() { return m_failureMessage; }
    void SetFailureMessage(const String& value) { m_failureMessage = value; }

    bool HasRequestId() { return !!m_requestId; }
    String GetRequestId(const String& defaultValue) const {
       return m_requestId.value_or(defaultValue);
    }
    const std::optional<String>& GetRequestId() const {
       return m_requestId;
    }
    void SetRequestId(const String& value) { m_requestId = value; }

    template<int STATE>
    class FailedRequestInfoBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            FailureMessageSet = 1 << 2,
            AllFieldsSet = (UrlSet | FailureMessageSet | 0)};


        FailedRequestInfoBuilder<STATE | UrlSet>& SetUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->SetUrl(value);
            return castState<UrlSet>();
        }

        FailedRequestInfoBuilder<STATE | FailureMessageSet>& SetFailureMessage(const String& value)
        {
            static_assert(!(STATE & FailureMessageSet), "property failureMessage should not be set yet");
            m_result->SetFailureMessage(value);
            return castState<FailureMessageSet>();
        }

        FailedRequestInfoBuilder<STATE>& SetRequestId(const String& value)
        {
            m_result->SetRequestId(value);
            return *this;
        }

        std::unique_ptr<FailedRequestInfo> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FailedRequestInfo;
        FailedRequestInfoBuilder() : m_result(new FailedRequestInfo()) { }

        template<int STEP> FailedRequestInfoBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FailedRequestInfoBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::FailedRequestInfo> m_result;
    };

    static FailedRequestInfoBuilder<0> Create()
    {
        return FailedRequestInfoBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FailedRequestInfo()
    {
    }

    String m_url;
    String m_failureMessage;
    std::optional<String> m_requestId;
};


class CONTENT_EXPORT SelectElementAccessibilityIssueDetails : public ::crdtp::ProtocolObject<SelectElementAccessibilityIssueDetails> {
public:
    ~SelectElementAccessibilityIssueDetails() override { }

    int GetNodeId() { return m_nodeId; }
    void SetNodeId(int value) { m_nodeId = value; }

    String GetSelectElementAccessibilityIssueReason() { return m_selectElementAccessibilityIssueReason; }
    void SetSelectElementAccessibilityIssueReason(const String& value) { m_selectElementAccessibilityIssueReason = value; }

    bool GetHasDisallowedAttributes() { return m_hasDisallowedAttributes; }
    void SetHasDisallowedAttributes(bool value) { m_hasDisallowedAttributes = value; }

    template<int STATE>
    class SelectElementAccessibilityIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NodeIdSet = 1 << 1,
            SelectElementAccessibilityIssueReasonSet = 1 << 2,
            HasDisallowedAttributesSet = 1 << 3,
            AllFieldsSet = (NodeIdSet | SelectElementAccessibilityIssueReasonSet | HasDisallowedAttributesSet | 0)};


        SelectElementAccessibilityIssueDetailsBuilder<STATE | NodeIdSet>& SetNodeId(int value)
        {
            static_assert(!(STATE & NodeIdSet), "property nodeId should not be set yet");
            m_result->SetNodeId(value);
            return castState<NodeIdSet>();
        }

        SelectElementAccessibilityIssueDetailsBuilder<STATE | SelectElementAccessibilityIssueReasonSet>& SetSelectElementAccessibilityIssueReason(const String& value)
        {
            static_assert(!(STATE & SelectElementAccessibilityIssueReasonSet), "property selectElementAccessibilityIssueReason should not be set yet");
            m_result->SetSelectElementAccessibilityIssueReason(value);
            return castState<SelectElementAccessibilityIssueReasonSet>();
        }

        SelectElementAccessibilityIssueDetailsBuilder<STATE | HasDisallowedAttributesSet>& SetHasDisallowedAttributes(bool value)
        {
            static_assert(!(STATE & HasDisallowedAttributesSet), "property hasDisallowedAttributes should not be set yet");
            m_result->SetHasDisallowedAttributes(value);
            return castState<HasDisallowedAttributesSet>();
        }

        std::unique_ptr<SelectElementAccessibilityIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SelectElementAccessibilityIssueDetails;
        SelectElementAccessibilityIssueDetailsBuilder() : m_result(new SelectElementAccessibilityIssueDetails()) { }

        template<int STEP> SelectElementAccessibilityIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SelectElementAccessibilityIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::SelectElementAccessibilityIssueDetails> m_result;
    };

    static SelectElementAccessibilityIssueDetailsBuilder<0> Create()
    {
        return SelectElementAccessibilityIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SelectElementAccessibilityIssueDetails()
    {
          m_nodeId = 0;
          m_hasDisallowedAttributes = false;
    }

    int m_nodeId;
    String m_selectElementAccessibilityIssueReason;
    bool m_hasDisallowedAttributes;
};


class CONTENT_EXPORT StylesheetLoadingIssueDetails : public ::crdtp::ProtocolObject<StylesheetLoadingIssueDetails> {
public:
    ~StylesheetLoadingIssueDetails() override { }

    protocol::Audits::SourceCodeLocation* GetSourceCodeLocation() { return m_sourceCodeLocation.get(); }
    void SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }

    String GetStyleSheetLoadingIssueReason() { return m_styleSheetLoadingIssueReason; }
    void SetStyleSheetLoadingIssueReason(const String& value) { m_styleSheetLoadingIssueReason = value; }

    bool HasFailedRequestInfo() { return !!m_failedRequestInfo; }
    protocol::Audits::FailedRequestInfo* GetFailedRequestInfo(protocol::Audits::FailedRequestInfo* defaultValue) {
       return m_failedRequestInfo ? m_failedRequestInfo.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::FailedRequestInfo>& GetFailedRequestInfo() const {
       return m_failedRequestInfo;
    }
    void SetFailedRequestInfo(std::unique_ptr<protocol::Audits::FailedRequestInfo> value) { m_failedRequestInfo = std::move(value); }

    template<int STATE>
    class StylesheetLoadingIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SourceCodeLocationSet = 1 << 1,
            StyleSheetLoadingIssueReasonSet = 1 << 2,
            AllFieldsSet = (SourceCodeLocationSet | StyleSheetLoadingIssueReasonSet | 0)};


        StylesheetLoadingIssueDetailsBuilder<STATE | SourceCodeLocationSet>& SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value)
        {
            static_assert(!(STATE & SourceCodeLocationSet), "property sourceCodeLocation should not be set yet");
            m_result->SetSourceCodeLocation(std::move(value));
            return castState<SourceCodeLocationSet>();
        }

        StylesheetLoadingIssueDetailsBuilder<STATE | StyleSheetLoadingIssueReasonSet>& SetStyleSheetLoadingIssueReason(const String& value)
        {
            static_assert(!(STATE & StyleSheetLoadingIssueReasonSet), "property styleSheetLoadingIssueReason should not be set yet");
            m_result->SetStyleSheetLoadingIssueReason(value);
            return castState<StyleSheetLoadingIssueReasonSet>();
        }

        StylesheetLoadingIssueDetailsBuilder<STATE>& SetFailedRequestInfo(std::unique_ptr<protocol::Audits::FailedRequestInfo> value)
        {
            m_result->SetFailedRequestInfo(std::move(value));
            return *this;
        }

        std::unique_ptr<StylesheetLoadingIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class StylesheetLoadingIssueDetails;
        StylesheetLoadingIssueDetailsBuilder() : m_result(new StylesheetLoadingIssueDetails()) { }

        template<int STEP> StylesheetLoadingIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<StylesheetLoadingIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::StylesheetLoadingIssueDetails> m_result;
    };

    static StylesheetLoadingIssueDetailsBuilder<0> Create()
    {
        return StylesheetLoadingIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    StylesheetLoadingIssueDetails()
    {
    }

    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
    String m_styleSheetLoadingIssueReason;
    std::unique_ptr<protocol::Audits::FailedRequestInfo> m_failedRequestInfo;
};


class CONTENT_EXPORT PropertyRuleIssueDetails : public ::crdtp::ProtocolObject<PropertyRuleIssueDetails> {
public:
    ~PropertyRuleIssueDetails() override { }

    protocol::Audits::SourceCodeLocation* GetSourceCodeLocation() { return m_sourceCodeLocation.get(); }
    void SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }

    String GetPropertyRuleIssueReason() { return m_propertyRuleIssueReason; }
    void SetPropertyRuleIssueReason(const String& value) { m_propertyRuleIssueReason = value; }

    bool HasPropertyValue() { return !!m_propertyValue; }
    String GetPropertyValue(const String& defaultValue) const {
       return m_propertyValue.value_or(defaultValue);
    }
    const std::optional<String>& GetPropertyValue() const {
       return m_propertyValue;
    }
    void SetPropertyValue(const String& value) { m_propertyValue = value; }

    template<int STATE>
    class PropertyRuleIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SourceCodeLocationSet = 1 << 1,
            PropertyRuleIssueReasonSet = 1 << 2,
            AllFieldsSet = (SourceCodeLocationSet | PropertyRuleIssueReasonSet | 0)};


        PropertyRuleIssueDetailsBuilder<STATE | SourceCodeLocationSet>& SetSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value)
        {
            static_assert(!(STATE & SourceCodeLocationSet), "property sourceCodeLocation should not be set yet");
            m_result->SetSourceCodeLocation(std::move(value));
            return castState<SourceCodeLocationSet>();
        }

        PropertyRuleIssueDetailsBuilder<STATE | PropertyRuleIssueReasonSet>& SetPropertyRuleIssueReason(const String& value)
        {
            static_assert(!(STATE & PropertyRuleIssueReasonSet), "property propertyRuleIssueReason should not be set yet");
            m_result->SetPropertyRuleIssueReason(value);
            return castState<PropertyRuleIssueReasonSet>();
        }

        PropertyRuleIssueDetailsBuilder<STATE>& SetPropertyValue(const String& value)
        {
            m_result->SetPropertyValue(value);
            return *this;
        }

        std::unique_ptr<PropertyRuleIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PropertyRuleIssueDetails;
        PropertyRuleIssueDetailsBuilder() : m_result(new PropertyRuleIssueDetails()) { }

        template<int STEP> PropertyRuleIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PropertyRuleIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::PropertyRuleIssueDetails> m_result;
    };

    static PropertyRuleIssueDetailsBuilder<0> Create()
    {
        return PropertyRuleIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PropertyRuleIssueDetails()
    {
    }

    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
    String m_propertyRuleIssueReason;
    std::optional<String> m_propertyValue;
};


class CONTENT_EXPORT InspectorIssueDetails : public ::crdtp::ProtocolObject<InspectorIssueDetails> {
public:
    ~InspectorIssueDetails() override { }

    bool HasCookieIssueDetails() { return !!m_cookieIssueDetails; }
    protocol::Audits::CookieIssueDetails* GetCookieIssueDetails(protocol::Audits::CookieIssueDetails* defaultValue) {
       return m_cookieIssueDetails ? m_cookieIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::CookieIssueDetails>& GetCookieIssueDetails() const {
       return m_cookieIssueDetails;
    }
    void SetCookieIssueDetails(std::unique_ptr<protocol::Audits::CookieIssueDetails> value) { m_cookieIssueDetails = std::move(value); }

    bool HasMixedContentIssueDetails() { return !!m_mixedContentIssueDetails; }
    protocol::Audits::MixedContentIssueDetails* GetMixedContentIssueDetails(protocol::Audits::MixedContentIssueDetails* defaultValue) {
       return m_mixedContentIssueDetails ? m_mixedContentIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::MixedContentIssueDetails>& GetMixedContentIssueDetails() const {
       return m_mixedContentIssueDetails;
    }
    void SetMixedContentIssueDetails(std::unique_ptr<protocol::Audits::MixedContentIssueDetails> value) { m_mixedContentIssueDetails = std::move(value); }

    bool HasBlockedByResponseIssueDetails() { return !!m_blockedByResponseIssueDetails; }
    protocol::Audits::BlockedByResponseIssueDetails* GetBlockedByResponseIssueDetails(protocol::Audits::BlockedByResponseIssueDetails* defaultValue) {
       return m_blockedByResponseIssueDetails ? m_blockedByResponseIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::BlockedByResponseIssueDetails>& GetBlockedByResponseIssueDetails() const {
       return m_blockedByResponseIssueDetails;
    }
    void SetBlockedByResponseIssueDetails(std::unique_ptr<protocol::Audits::BlockedByResponseIssueDetails> value) { m_blockedByResponseIssueDetails = std::move(value); }

    bool HasHeavyAdIssueDetails() { return !!m_heavyAdIssueDetails; }
    protocol::Audits::HeavyAdIssueDetails* GetHeavyAdIssueDetails(protocol::Audits::HeavyAdIssueDetails* defaultValue) {
       return m_heavyAdIssueDetails ? m_heavyAdIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::HeavyAdIssueDetails>& GetHeavyAdIssueDetails() const {
       return m_heavyAdIssueDetails;
    }
    void SetHeavyAdIssueDetails(std::unique_ptr<protocol::Audits::HeavyAdIssueDetails> value) { m_heavyAdIssueDetails = std::move(value); }

    bool HasContentSecurityPolicyIssueDetails() { return !!m_contentSecurityPolicyIssueDetails; }
    protocol::Audits::ContentSecurityPolicyIssueDetails* GetContentSecurityPolicyIssueDetails(protocol::Audits::ContentSecurityPolicyIssueDetails* defaultValue) {
       return m_contentSecurityPolicyIssueDetails ? m_contentSecurityPolicyIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::ContentSecurityPolicyIssueDetails>& GetContentSecurityPolicyIssueDetails() const {
       return m_contentSecurityPolicyIssueDetails;
    }
    void SetContentSecurityPolicyIssueDetails(std::unique_ptr<protocol::Audits::ContentSecurityPolicyIssueDetails> value) { m_contentSecurityPolicyIssueDetails = std::move(value); }

    bool HasSharedArrayBufferIssueDetails() { return !!m_sharedArrayBufferIssueDetails; }
    protocol::Audits::SharedArrayBufferIssueDetails* GetSharedArrayBufferIssueDetails(protocol::Audits::SharedArrayBufferIssueDetails* defaultValue) {
       return m_sharedArrayBufferIssueDetails ? m_sharedArrayBufferIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::SharedArrayBufferIssueDetails>& GetSharedArrayBufferIssueDetails() const {
       return m_sharedArrayBufferIssueDetails;
    }
    void SetSharedArrayBufferIssueDetails(std::unique_ptr<protocol::Audits::SharedArrayBufferIssueDetails> value) { m_sharedArrayBufferIssueDetails = std::move(value); }

    bool HasLowTextContrastIssueDetails() { return !!m_lowTextContrastIssueDetails; }
    protocol::Audits::LowTextContrastIssueDetails* GetLowTextContrastIssueDetails(protocol::Audits::LowTextContrastIssueDetails* defaultValue) {
       return m_lowTextContrastIssueDetails ? m_lowTextContrastIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::LowTextContrastIssueDetails>& GetLowTextContrastIssueDetails() const {
       return m_lowTextContrastIssueDetails;
    }
    void SetLowTextContrastIssueDetails(std::unique_ptr<protocol::Audits::LowTextContrastIssueDetails> value) { m_lowTextContrastIssueDetails = std::move(value); }

    bool HasCorsIssueDetails() { return !!m_corsIssueDetails; }
    protocol::Audits::CorsIssueDetails* GetCorsIssueDetails(protocol::Audits::CorsIssueDetails* defaultValue) {
       return m_corsIssueDetails ? m_corsIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::CorsIssueDetails>& GetCorsIssueDetails() const {
       return m_corsIssueDetails;
    }
    void SetCorsIssueDetails(std::unique_ptr<protocol::Audits::CorsIssueDetails> value) { m_corsIssueDetails = std::move(value); }

    bool HasAttributionReportingIssueDetails() { return !!m_attributionReportingIssueDetails; }
    protocol::Audits::AttributionReportingIssueDetails* GetAttributionReportingIssueDetails(protocol::Audits::AttributionReportingIssueDetails* defaultValue) {
       return m_attributionReportingIssueDetails ? m_attributionReportingIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AttributionReportingIssueDetails>& GetAttributionReportingIssueDetails() const {
       return m_attributionReportingIssueDetails;
    }
    void SetAttributionReportingIssueDetails(std::unique_ptr<protocol::Audits::AttributionReportingIssueDetails> value) { m_attributionReportingIssueDetails = std::move(value); }

    bool HasQuirksModeIssueDetails() { return !!m_quirksModeIssueDetails; }
    protocol::Audits::QuirksModeIssueDetails* GetQuirksModeIssueDetails(protocol::Audits::QuirksModeIssueDetails* defaultValue) {
       return m_quirksModeIssueDetails ? m_quirksModeIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::QuirksModeIssueDetails>& GetQuirksModeIssueDetails() const {
       return m_quirksModeIssueDetails;
    }
    void SetQuirksModeIssueDetails(std::unique_ptr<protocol::Audits::QuirksModeIssueDetails> value) { m_quirksModeIssueDetails = std::move(value); }

    bool HasNavigatorUserAgentIssueDetails() { return !!m_navigatorUserAgentIssueDetails; }
    protocol::Audits::NavigatorUserAgentIssueDetails* GetNavigatorUserAgentIssueDetails(protocol::Audits::NavigatorUserAgentIssueDetails* defaultValue) {
       return m_navigatorUserAgentIssueDetails ? m_navigatorUserAgentIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::NavigatorUserAgentIssueDetails>& GetNavigatorUserAgentIssueDetails() const {
       return m_navigatorUserAgentIssueDetails;
    }
    void SetNavigatorUserAgentIssueDetails(std::unique_ptr<protocol::Audits::NavigatorUserAgentIssueDetails> value) { m_navigatorUserAgentIssueDetails = std::move(value); }

    bool HasGenericIssueDetails() { return !!m_genericIssueDetails; }
    protocol::Audits::GenericIssueDetails* GetGenericIssueDetails(protocol::Audits::GenericIssueDetails* defaultValue) {
       return m_genericIssueDetails ? m_genericIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::GenericIssueDetails>& GetGenericIssueDetails() const {
       return m_genericIssueDetails;
    }
    void SetGenericIssueDetails(std::unique_ptr<protocol::Audits::GenericIssueDetails> value) { m_genericIssueDetails = std::move(value); }

    bool HasDeprecationIssueDetails() { return !!m_deprecationIssueDetails; }
    protocol::Audits::DeprecationIssueDetails* GetDeprecationIssueDetails(protocol::Audits::DeprecationIssueDetails* defaultValue) {
       return m_deprecationIssueDetails ? m_deprecationIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::DeprecationIssueDetails>& GetDeprecationIssueDetails() const {
       return m_deprecationIssueDetails;
    }
    void SetDeprecationIssueDetails(std::unique_ptr<protocol::Audits::DeprecationIssueDetails> value) { m_deprecationIssueDetails = std::move(value); }

    bool HasClientHintIssueDetails() { return !!m_clientHintIssueDetails; }
    protocol::Audits::ClientHintIssueDetails* GetClientHintIssueDetails(protocol::Audits::ClientHintIssueDetails* defaultValue) {
       return m_clientHintIssueDetails ? m_clientHintIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::ClientHintIssueDetails>& GetClientHintIssueDetails() const {
       return m_clientHintIssueDetails;
    }
    void SetClientHintIssueDetails(std::unique_ptr<protocol::Audits::ClientHintIssueDetails> value) { m_clientHintIssueDetails = std::move(value); }

    bool HasFederatedAuthRequestIssueDetails() { return !!m_federatedAuthRequestIssueDetails; }
    protocol::Audits::FederatedAuthRequestIssueDetails* GetFederatedAuthRequestIssueDetails(protocol::Audits::FederatedAuthRequestIssueDetails* defaultValue) {
       return m_federatedAuthRequestIssueDetails ? m_federatedAuthRequestIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::FederatedAuthRequestIssueDetails>& GetFederatedAuthRequestIssueDetails() const {
       return m_federatedAuthRequestIssueDetails;
    }
    void SetFederatedAuthRequestIssueDetails(std::unique_ptr<protocol::Audits::FederatedAuthRequestIssueDetails> value) { m_federatedAuthRequestIssueDetails = std::move(value); }

    bool HasBounceTrackingIssueDetails() { return !!m_bounceTrackingIssueDetails; }
    protocol::Audits::BounceTrackingIssueDetails* GetBounceTrackingIssueDetails(protocol::Audits::BounceTrackingIssueDetails* defaultValue) {
       return m_bounceTrackingIssueDetails ? m_bounceTrackingIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::BounceTrackingIssueDetails>& GetBounceTrackingIssueDetails() const {
       return m_bounceTrackingIssueDetails;
    }
    void SetBounceTrackingIssueDetails(std::unique_ptr<protocol::Audits::BounceTrackingIssueDetails> value) { m_bounceTrackingIssueDetails = std::move(value); }

    bool HasCookieDeprecationMetadataIssueDetails() { return !!m_cookieDeprecationMetadataIssueDetails; }
    protocol::Audits::CookieDeprecationMetadataIssueDetails* GetCookieDeprecationMetadataIssueDetails(protocol::Audits::CookieDeprecationMetadataIssueDetails* defaultValue) {
       return m_cookieDeprecationMetadataIssueDetails ? m_cookieDeprecationMetadataIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::CookieDeprecationMetadataIssueDetails>& GetCookieDeprecationMetadataIssueDetails() const {
       return m_cookieDeprecationMetadataIssueDetails;
    }
    void SetCookieDeprecationMetadataIssueDetails(std::unique_ptr<protocol::Audits::CookieDeprecationMetadataIssueDetails> value) { m_cookieDeprecationMetadataIssueDetails = std::move(value); }

    bool HasStylesheetLoadingIssueDetails() { return !!m_stylesheetLoadingIssueDetails; }
    protocol::Audits::StylesheetLoadingIssueDetails* GetStylesheetLoadingIssueDetails(protocol::Audits::StylesheetLoadingIssueDetails* defaultValue) {
       return m_stylesheetLoadingIssueDetails ? m_stylesheetLoadingIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::StylesheetLoadingIssueDetails>& GetStylesheetLoadingIssueDetails() const {
       return m_stylesheetLoadingIssueDetails;
    }
    void SetStylesheetLoadingIssueDetails(std::unique_ptr<protocol::Audits::StylesheetLoadingIssueDetails> value) { m_stylesheetLoadingIssueDetails = std::move(value); }

    bool HasPropertyRuleIssueDetails() { return !!m_propertyRuleIssueDetails; }
    protocol::Audits::PropertyRuleIssueDetails* GetPropertyRuleIssueDetails(protocol::Audits::PropertyRuleIssueDetails* defaultValue) {
       return m_propertyRuleIssueDetails ? m_propertyRuleIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::PropertyRuleIssueDetails>& GetPropertyRuleIssueDetails() const {
       return m_propertyRuleIssueDetails;
    }
    void SetPropertyRuleIssueDetails(std::unique_ptr<protocol::Audits::PropertyRuleIssueDetails> value) { m_propertyRuleIssueDetails = std::move(value); }

    bool HasFederatedAuthUserInfoRequestIssueDetails() { return !!m_federatedAuthUserInfoRequestIssueDetails; }
    protocol::Audits::FederatedAuthUserInfoRequestIssueDetails* GetFederatedAuthUserInfoRequestIssueDetails(protocol::Audits::FederatedAuthUserInfoRequestIssueDetails* defaultValue) {
       return m_federatedAuthUserInfoRequestIssueDetails ? m_federatedAuthUserInfoRequestIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::FederatedAuthUserInfoRequestIssueDetails>& GetFederatedAuthUserInfoRequestIssueDetails() const {
       return m_federatedAuthUserInfoRequestIssueDetails;
    }
    void SetFederatedAuthUserInfoRequestIssueDetails(std::unique_ptr<protocol::Audits::FederatedAuthUserInfoRequestIssueDetails> value) { m_federatedAuthUserInfoRequestIssueDetails = std::move(value); }

    bool HasSharedDictionaryIssueDetails() { return !!m_sharedDictionaryIssueDetails; }
    protocol::Audits::SharedDictionaryIssueDetails* GetSharedDictionaryIssueDetails(protocol::Audits::SharedDictionaryIssueDetails* defaultValue) {
       return m_sharedDictionaryIssueDetails ? m_sharedDictionaryIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::SharedDictionaryIssueDetails>& GetSharedDictionaryIssueDetails() const {
       return m_sharedDictionaryIssueDetails;
    }
    void SetSharedDictionaryIssueDetails(std::unique_ptr<protocol::Audits::SharedDictionaryIssueDetails> value) { m_sharedDictionaryIssueDetails = std::move(value); }

    bool HasSelectElementAccessibilityIssueDetails() { return !!m_selectElementAccessibilityIssueDetails; }
    protocol::Audits::SelectElementAccessibilityIssueDetails* GetSelectElementAccessibilityIssueDetails(protocol::Audits::SelectElementAccessibilityIssueDetails* defaultValue) {
       return m_selectElementAccessibilityIssueDetails ? m_selectElementAccessibilityIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::SelectElementAccessibilityIssueDetails>& GetSelectElementAccessibilityIssueDetails() const {
       return m_selectElementAccessibilityIssueDetails;
    }
    void SetSelectElementAccessibilityIssueDetails(std::unique_ptr<protocol::Audits::SelectElementAccessibilityIssueDetails> value) { m_selectElementAccessibilityIssueDetails = std::move(value); }

    template<int STATE>
    class InspectorIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        InspectorIssueDetailsBuilder<STATE>& SetCookieIssueDetails(std::unique_ptr<protocol::Audits::CookieIssueDetails> value)
        {
            m_result->SetCookieIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& SetMixedContentIssueDetails(std::unique_ptr<protocol::Audits::MixedContentIssueDetails> value)
        {
            m_result->SetMixedContentIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& SetBlockedByResponseIssueDetails(std::unique_ptr<protocol::Audits::BlockedByResponseIssueDetails> value)
        {
            m_result->SetBlockedByResponseIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& SetHeavyAdIssueDetails(std::unique_ptr<protocol::Audits::HeavyAdIssueDetails> value)
        {
            m_result->SetHeavyAdIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& SetContentSecurityPolicyIssueDetails(std::unique_ptr<protocol::Audits::ContentSecurityPolicyIssueDetails> value)
        {
            m_result->SetContentSecurityPolicyIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& SetSharedArrayBufferIssueDetails(std::unique_ptr<protocol::Audits::SharedArrayBufferIssueDetails> value)
        {
            m_result->SetSharedArrayBufferIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& SetLowTextContrastIssueDetails(std::unique_ptr<protocol::Audits::LowTextContrastIssueDetails> value)
        {
            m_result->SetLowTextContrastIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& SetCorsIssueDetails(std::unique_ptr<protocol::Audits::CorsIssueDetails> value)
        {
            m_result->SetCorsIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& SetAttributionReportingIssueDetails(std::unique_ptr<protocol::Audits::AttributionReportingIssueDetails> value)
        {
            m_result->SetAttributionReportingIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& SetQuirksModeIssueDetails(std::unique_ptr<protocol::Audits::QuirksModeIssueDetails> value)
        {
            m_result->SetQuirksModeIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& SetNavigatorUserAgentIssueDetails(std::unique_ptr<protocol::Audits::NavigatorUserAgentIssueDetails> value)
        {
            m_result->SetNavigatorUserAgentIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& SetGenericIssueDetails(std::unique_ptr<protocol::Audits::GenericIssueDetails> value)
        {
            m_result->SetGenericIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& SetDeprecationIssueDetails(std::unique_ptr<protocol::Audits::DeprecationIssueDetails> value)
        {
            m_result->SetDeprecationIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& SetClientHintIssueDetails(std::unique_ptr<protocol::Audits::ClientHintIssueDetails> value)
        {
            m_result->SetClientHintIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& SetFederatedAuthRequestIssueDetails(std::unique_ptr<protocol::Audits::FederatedAuthRequestIssueDetails> value)
        {
            m_result->SetFederatedAuthRequestIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& SetBounceTrackingIssueDetails(std::unique_ptr<protocol::Audits::BounceTrackingIssueDetails> value)
        {
            m_result->SetBounceTrackingIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& SetCookieDeprecationMetadataIssueDetails(std::unique_ptr<protocol::Audits::CookieDeprecationMetadataIssueDetails> value)
        {
            m_result->SetCookieDeprecationMetadataIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& SetStylesheetLoadingIssueDetails(std::unique_ptr<protocol::Audits::StylesheetLoadingIssueDetails> value)
        {
            m_result->SetStylesheetLoadingIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& SetPropertyRuleIssueDetails(std::unique_ptr<protocol::Audits::PropertyRuleIssueDetails> value)
        {
            m_result->SetPropertyRuleIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& SetFederatedAuthUserInfoRequestIssueDetails(std::unique_ptr<protocol::Audits::FederatedAuthUserInfoRequestIssueDetails> value)
        {
            m_result->SetFederatedAuthUserInfoRequestIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& SetSharedDictionaryIssueDetails(std::unique_ptr<protocol::Audits::SharedDictionaryIssueDetails> value)
        {
            m_result->SetSharedDictionaryIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& SetSelectElementAccessibilityIssueDetails(std::unique_ptr<protocol::Audits::SelectElementAccessibilityIssueDetails> value)
        {
            m_result->SetSelectElementAccessibilityIssueDetails(std::move(value));
            return *this;
        }

        std::unique_ptr<InspectorIssueDetails> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class InspectorIssueDetails;
        InspectorIssueDetailsBuilder() : m_result(new InspectorIssueDetails()) { }

        template<int STEP> InspectorIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InspectorIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::InspectorIssueDetails> m_result;
    };

    static InspectorIssueDetailsBuilder<0> Create()
    {
        return InspectorIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    InspectorIssueDetails()
    {
    }

    std::unique_ptr<protocol::Audits::CookieIssueDetails> m_cookieIssueDetails;
    std::unique_ptr<protocol::Audits::MixedContentIssueDetails> m_mixedContentIssueDetails;
    std::unique_ptr<protocol::Audits::BlockedByResponseIssueDetails> m_blockedByResponseIssueDetails;
    std::unique_ptr<protocol::Audits::HeavyAdIssueDetails> m_heavyAdIssueDetails;
    std::unique_ptr<protocol::Audits::ContentSecurityPolicyIssueDetails> m_contentSecurityPolicyIssueDetails;
    std::unique_ptr<protocol::Audits::SharedArrayBufferIssueDetails> m_sharedArrayBufferIssueDetails;
    std::unique_ptr<protocol::Audits::LowTextContrastIssueDetails> m_lowTextContrastIssueDetails;
    std::unique_ptr<protocol::Audits::CorsIssueDetails> m_corsIssueDetails;
    std::unique_ptr<protocol::Audits::AttributionReportingIssueDetails> m_attributionReportingIssueDetails;
    std::unique_ptr<protocol::Audits::QuirksModeIssueDetails> m_quirksModeIssueDetails;
    std::unique_ptr<protocol::Audits::NavigatorUserAgentIssueDetails> m_navigatorUserAgentIssueDetails;
    std::unique_ptr<protocol::Audits::GenericIssueDetails> m_genericIssueDetails;
    std::unique_ptr<protocol::Audits::DeprecationIssueDetails> m_deprecationIssueDetails;
    std::unique_ptr<protocol::Audits::ClientHintIssueDetails> m_clientHintIssueDetails;
    std::unique_ptr<protocol::Audits::FederatedAuthRequestIssueDetails> m_federatedAuthRequestIssueDetails;
    std::unique_ptr<protocol::Audits::BounceTrackingIssueDetails> m_bounceTrackingIssueDetails;
    std::unique_ptr<protocol::Audits::CookieDeprecationMetadataIssueDetails> m_cookieDeprecationMetadataIssueDetails;
    std::unique_ptr<protocol::Audits::StylesheetLoadingIssueDetails> m_stylesheetLoadingIssueDetails;
    std::unique_ptr<protocol::Audits::PropertyRuleIssueDetails> m_propertyRuleIssueDetails;
    std::unique_ptr<protocol::Audits::FederatedAuthUserInfoRequestIssueDetails> m_federatedAuthUserInfoRequestIssueDetails;
    std::unique_ptr<protocol::Audits::SharedDictionaryIssueDetails> m_sharedDictionaryIssueDetails;
    std::unique_ptr<protocol::Audits::SelectElementAccessibilityIssueDetails> m_selectElementAccessibilityIssueDetails;
};


class CONTENT_EXPORT InspectorIssue : public ::crdtp::ProtocolObject<InspectorIssue> {
public:
    ~InspectorIssue() override { }

    String GetCode() { return m_code; }
    void SetCode(const String& value) { m_code = value; }

    protocol::Audits::InspectorIssueDetails* GetDetails() { return m_details.get(); }
    void SetDetails(std::unique_ptr<protocol::Audits::InspectorIssueDetails> value) { m_details = std::move(value); }

    bool HasIssueId() { return !!m_issueId; }
    String GetIssueId(const String& defaultValue) const {
       return m_issueId.value_or(defaultValue);
    }
    const std::optional<String>& GetIssueId() const {
       return m_issueId;
    }
    void SetIssueId(const String& value) { m_issueId = value; }

    template<int STATE>
    class InspectorIssueBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CodeSet = 1 << 1,
            DetailsSet = 1 << 2,
            AllFieldsSet = (CodeSet | DetailsSet | 0)};


        InspectorIssueBuilder<STATE | CodeSet>& SetCode(const String& value)
        {
            static_assert(!(STATE & CodeSet), "property code should not be set yet");
            m_result->SetCode(value);
            return castState<CodeSet>();
        }

        InspectorIssueBuilder<STATE | DetailsSet>& SetDetails(std::unique_ptr<protocol::Audits::InspectorIssueDetails> value)
        {
            static_assert(!(STATE & DetailsSet), "property details should not be set yet");
            m_result->SetDetails(std::move(value));
            return castState<DetailsSet>();
        }

        InspectorIssueBuilder<STATE>& SetIssueId(const String& value)
        {
            m_result->SetIssueId(value);
            return *this;
        }

        std::unique_ptr<InspectorIssue> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class InspectorIssue;
        InspectorIssueBuilder() : m_result(new InspectorIssue()) { }

        template<int STEP> InspectorIssueBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InspectorIssueBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::InspectorIssue> m_result;
    };

    static InspectorIssueBuilder<0> Create()
    {
        return InspectorIssueBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    InspectorIssue()
    {
    }

    String m_code;
    std::unique_ptr<protocol::Audits::InspectorIssueDetails> m_details;
    std::optional<String> m_issueId;
};


// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse Disable() = 0;
    virtual DispatchResponse Enable() = 0;

};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void IssueAdded(std::unique_ptr<protocol::Audits::InspectorIssue> issue);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Audits
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_Audits_h)
