// content/services/auction_worklet/public/mojom/bidder_worklet.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/services/auction_worklet/public/mojom/bidder_worklet.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/services/auction_worklet/public/mojom/bidder_worklet.mojom-params-data.h"
namespace auction_worklet {
namespace mojom {

NOINLINE static const char* KAnonymityBidModeToStringHelper(KAnonymityBidMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case KAnonymityBidMode::kNone:
      return "kNone";
    case KAnonymityBidMode::kSimulate:
      return "kSimulate";
    case KAnonymityBidMode::kEnforce:
      return "kEnforce";
    default:
      return nullptr;
  }
}

std::string KAnonymityBidModeToString(KAnonymityBidMode value) {
  const char *str = KAnonymityBidModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown KAnonymityBidMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, KAnonymityBidMode value) {
  return os << KAnonymityBidModeToString(value);
}

NOINLINE static const char* BidRoleToStringHelper(BidRole value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BidRole::kUnenforcedKAnon:
      return "kUnenforcedKAnon";
    case BidRole::kEnforcedKAnon:
      return "kEnforcedKAnon";
    case BidRole::kBothKAnonModes:
      return "kBothKAnonModes";
    default:
      return nullptr;
  }
}

std::string BidRoleToString(BidRole value) {
  const char *str = BidRoleToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BidRole value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BidRole value) {
  return os << BidRoleToString(value);
}

NOINLINE static const char* ReportingIdFieldToStringHelper(ReportingIdField value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ReportingIdField::kNone:
      return "kNone";
    case ReportingIdField::kInterestGroupName:
      return "kInterestGroupName";
    case ReportingIdField::kBuyerReportingId:
      return "kBuyerReportingId";
    case ReportingIdField::kBuyerAndSellerReportingId:
      return "kBuyerAndSellerReportingId";
    case ReportingIdField::kSelectedBuyerAndSellerReportingId:
      return "kSelectedBuyerAndSellerReportingId";
    default:
      return nullptr;
  }
}

std::string ReportingIdFieldToString(ReportingIdField value) {
  const char *str = ReportingIdFieldToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ReportingIdField value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ReportingIdField value) {
  return os << ReportingIdFieldToString(value);
}

namespace internal {


// static
bool KAnonKey_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const KAnonKey_Data* object =
      static_cast<const KAnonKey_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

KAnonKey_Data::KAnonKey_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BidderWorkletNonSharedParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 88, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BidderWorkletNonSharedParams_Data* object =
      static_cast<const BidderWorkletNonSharedParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::InterestGroup_TrustedBiddingSignalsSlotSizeMode_Data
        ::Validate(object->trusted_bidding_signals_slot_size_mode, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& priority_vector_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->priority_vector, validation_context,
                                         &priority_vector_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::InterestGroup_ExecutionMode_Data
        ::Validate(object->execution_mode, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->update_url, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& trusted_bidding_signals_keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->trusted_bidding_signals_keys, validation_context,
                                         &trusted_bidding_signals_keys_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& user_bidding_signals_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->user_bidding_signals, validation_context,
                                         &user_bidding_signals_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& ads_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ads, validation_context,
                                         &ads_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& ad_components_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ad_components, validation_context,
                                         &ad_components_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->kanon_keys, 12, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& kanon_keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->kanon_keys, validation_context,
                                         &kanon_keys_validate_params)) {
    return false;
  }

  return true;
}

BidderWorkletNonSharedParams_Data::BidderWorkletNonSharedParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BidderWorkletBid_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 88, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BidderWorkletBid_Data* object =
      static_cast<const BidderWorkletBid_Data*>(data);


  if (!::auction_worklet::mojom::internal::BidRole_Data
        ::Validate(object->bid_role, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ad, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& ad_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ad, validation_context,
                                         &ad_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->bid_currency, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ad_descriptor, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ad_descriptor, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& selected_buyer_and_seller_reporting_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->selected_buyer_and_seller_reporting_id, validation_context,
                                         &selected_buyer_and_seller_reporting_id_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& ad_component_descriptors_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ad_component_descriptors, validation_context,
                                         &ad_component_descriptors_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& aggregate_win_signals_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->aggregate_win_signals, validation_context,
                                         &aggregate_win_signals_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bid_duration, 13, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bid_duration, validation_context))
    return false;

  return true;
}

BidderWorkletBid_Data::BidderWorkletBid_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrioritySignalsDouble_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrioritySignalsDouble_Data* object =
      static_cast<const PrioritySignalsDouble_Data*>(data);

  return true;
}

PrioritySignalsDouble_Data::PrioritySignalsDouble_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GenerateBidDependencyLatencies_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GenerateBidDependencyLatencies_Data* object =
      static_cast<const GenerateBidDependencyLatencies_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->code_ready_latency, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->config_promises_latency, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->direct_from_seller_signals_latency, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->trusted_bidding_signals_latency, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->deps_wait_start_time, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->deps_wait_start_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->generate_bid_start_time, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->generate_bid_start_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->generate_bid_finish_time, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->generate_bid_finish_time, validation_context))
    return false;

  return true;
}

GenerateBidDependencyLatencies_Data::GenerateBidDependencyLatencies_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BidderTimingMetrics_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BidderTimingMetrics_Data* object =
      static_cast<const BidderTimingMetrics_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->js_fetch_latency, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->wasm_fetch_latency, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->script_latency, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->script_latency, validation_context))
    return false;

  return true;
}

BidderTimingMetrics_Data::BidderTimingMetrics_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GenerateBidClient_OnBiddingSignalsReceived_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GenerateBidClient_OnBiddingSignalsReceived_Params_Data* object =
      static_cast<const GenerateBidClient_OnBiddingSignalsReceived_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->priority_vector, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& priority_vector_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->priority_vector, validation_context,
                                         &priority_vector_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->trusted_signals_fetch_latency, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->trusted_signals_fetch_latency, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->update_if_older_than, validation_context))
    return false;

  return true;
}

GenerateBidClient_OnBiddingSignalsReceived_Params_Data::GenerateBidClient_OnBiddingSignalsReceived_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GenerateBidClient_OnBiddingSignalsReceived_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GenerateBidClient_OnBiddingSignalsReceived_ResponseParams_Data* object =
      static_cast<const GenerateBidClient_OnBiddingSignalsReceived_ResponseParams_Data*>(data);

  return true;
}

GenerateBidClient_OnBiddingSignalsReceived_ResponseParams_Data::GenerateBidClient_OnBiddingSignalsReceived_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GenerateBidClient_OnGenerateBidComplete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 112, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GenerateBidClient_OnGenerateBidComplete_Params_Data* object =
      static_cast<const GenerateBidClient_OnGenerateBidComplete_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& bids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->bids, validation_context,
                                         &bids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->debug_loss_report_url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->debug_win_report_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->update_priority_signals_overrides, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& update_priority_signals_overrides_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, true, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->update_priority_signals_overrides, validation_context,
                                         &update_priority_signals_overrides_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pa_requests, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& pa_requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->pa_requests, validation_context,
                                         &pa_requests_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->non_kanon_pa_requests, 10, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& non_kanon_pa_requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->non_kanon_pa_requests, validation_context,
                                         &non_kanon_pa_requests_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->real_time_contributions, 11, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& real_time_contributions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->real_time_contributions, validation_context,
                                         &real_time_contributions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->generate_bid_timing_metrics, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->generate_bid_timing_metrics, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->generate_bid_dependency_latencies, 13, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->generate_bid_dependency_latencies, validation_context))
    return false;


  if (!::auction_worklet::mojom::internal::RejectReason_Data
        ::Validate(object->reject_reason, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->errors, 15, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& errors_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->errors, validation_context,
                                         &errors_validate_params)) {
    return false;
  }

  return true;
}

GenerateBidClient_OnGenerateBidComplete_Params_Data::GenerateBidClient_OnGenerateBidComplete_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GenerateBidFinalizer_FinishGenerateBid_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GenerateBidFinalizer_FinishGenerateBid_Params_Data* object =
      static_cast<const GenerateBidFinalizer_FinishGenerateBid_Params_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& auction_signals_json_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->auction_signals_json, validation_context,
                                         &auction_signals_json_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& per_buyer_signals_json_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->per_buyer_signals_json, validation_context,
                                         &per_buyer_signals_json_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->per_buyer_timeout, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->expected_buyer_currency, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->direct_from_seller_per_buyer_signals, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& direct_from_seller_per_buyer_signals_header_ad_slot_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->direct_from_seller_per_buyer_signals_header_ad_slot, validation_context,
                                         &direct_from_seller_per_buyer_signals_header_ad_slot_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->direct_from_seller_auction_signals, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& direct_from_seller_auction_signals_header_ad_slot_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->direct_from_seller_auction_signals_header_ad_slot, validation_context,
                                         &direct_from_seller_auction_signals_header_ad_slot_validate_params)) {
    return false;
  }

  return true;
}

GenerateBidFinalizer_FinishGenerateBid_Params_Data::GenerateBidFinalizer_FinishGenerateBid_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BidderWorklet_BeginGenerateBid_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 128, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BidderWorklet_BeginGenerateBid_Params_Data* object =
      static_cast<const BidderWorklet_BeginGenerateBid_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bidder_worklet_non_shared_params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bidder_worklet_non_shared_params, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->key_value_signals_cache_key, validation_context))
    return false;


  if (!::auction_worklet::mojom::internal::KAnonymityBidMode_Data
        ::Validate(object->kanon_mode, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->interest_group_join_origin, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->interest_group_join_origin, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->direct_from_seller_per_buyer_signals, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->direct_from_seller_auction_signals, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->browser_signal_seller_origin, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->browser_signal_seller_origin, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->browser_signal_top_level_seller_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->browser_signal_recency, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->browser_signal_recency, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bidding_browser_signals, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bidding_browser_signals, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->auction_start_time, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->auction_start_time, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->requested_ad_size, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->generate_bid_client, 15, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->generate_bid_client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->bid_finalizer, 16, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->bid_finalizer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

BidderWorklet_BeginGenerateBid_Params_Data::BidderWorklet_BeginGenerateBid_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BidderWorklet_SendPendingSignalsRequests_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BidderWorklet_SendPendingSignalsRequests_Params_Data* object =
      static_cast<const BidderWorklet_SendPendingSignalsRequests_Params_Data*>(data);

  return true;
}

BidderWorklet_SendPendingSignalsRequests_Params_Data::BidderWorklet_SendPendingSignalsRequests_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BidderWorklet_ReportWin_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 200, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BidderWorklet_ReportWin_Params_Data* object =
      static_cast<const BidderWorklet_ReportWin_Params_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& interest_group_name_reporting_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->interest_group_name_reporting_id, validation_context,
                                         &interest_group_name_reporting_id_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& buyer_reporting_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->buyer_reporting_id, validation_context,
                                         &buyer_reporting_id_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& buyer_and_seller_reporting_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->buyer_and_seller_reporting_id, validation_context,
                                         &buyer_and_seller_reporting_id_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& selected_buyer_and_seller_reporting_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->selected_buyer_and_seller_reporting_id, validation_context,
                                         &selected_buyer_and_seller_reporting_id_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& auction_signals_json_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->auction_signals_json, validation_context,
                                         &auction_signals_json_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& per_buyer_signals_json_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->per_buyer_signals_json, validation_context,
                                         &per_buyer_signals_json_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->direct_from_seller_per_buyer_signals, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& direct_from_seller_per_buyer_signals_header_ad_slot_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->direct_from_seller_per_buyer_signals_header_ad_slot, validation_context,
                                         &direct_from_seller_per_buyer_signals_header_ad_slot_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->direct_from_seller_auction_signals, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& direct_from_seller_auction_signals_header_ad_slot_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->direct_from_seller_auction_signals_header_ad_slot, validation_context,
                                         &direct_from_seller_auction_signals_header_ad_slot_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->seller_signals_json, 12, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& seller_signals_json_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->seller_signals_json, validation_context,
                                         &seller_signals_json_validate_params)) {
    return false;
  }


  if (!::auction_worklet::mojom::internal::KAnonymityBidMode_Data
        ::Validate(object->kanon_mode, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->browser_signal_render_url, 15, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->browser_signal_render_url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->browser_signal_bid_currency, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->browser_signal_highest_scoring_other_bid_currency, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->browser_signal_seller_origin, 27, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->browser_signal_seller_origin, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->browser_signal_top_level_seller_origin, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->browser_signal_reporting_timeout, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& aggregate_win_signals_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->aggregate_win_signals, validation_context,
                                         &aggregate_win_signals_validate_params)) {
    return false;
  }

  return true;
}

BidderWorklet_ReportWin_Params_Data::BidderWorklet_ReportWin_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BidderWorklet_ReportWin_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BidderWorklet_ReportWin_ResponseParams_Data* object =
      static_cast<const BidderWorklet_ReportWin_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->report_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ad_beacon_map, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& ad_beacon_map_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->ad_beacon_map, validation_context,
                                         &ad_beacon_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ad_macro_map, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& ad_macro_map_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->ad_macro_map, validation_context,
                                         &ad_macro_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pa_requests, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& pa_requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->pa_requests, validation_context,
                                         &pa_requests_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timing_metrics, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timing_metrics, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->errors, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& errors_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->errors, validation_context,
                                         &errors_validate_params)) {
    return false;
  }

  return true;
}

BidderWorklet_ReportWin_ResponseParams_Data::BidderWorklet_ReportWin_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BidderWorklet_ConnectDevToolsAgent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BidderWorklet_ConnectDevToolsAgent_Params_Data* object =
      static_cast<const BidderWorklet_ConnectDevToolsAgent_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->agent, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->agent,
                                                 validation_context)) {
    return false;
  }

  return true;
}

BidderWorklet_ConnectDevToolsAgent_Params_Data::BidderWorklet_ConnectDevToolsAgent_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace auction_worklet

namespace perfetto {

// static
void TraceFormatTraits<::auction_worklet::mojom::KAnonymityBidMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::auction_worklet::mojom::KAnonymityBidMode value) {
  return std::move(context).WriteString(::auction_worklet::mojom::KAnonymityBidModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::auction_worklet::mojom::BidRole>::WriteIntoTrace(
   perfetto::TracedValue context, ::auction_worklet::mojom::BidRole value) {
  return std::move(context).WriteString(::auction_worklet::mojom::BidRoleToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::auction_worklet::mojom::ReportingIdField>::WriteIntoTrace(
   perfetto::TracedValue context, ::auction_worklet::mojom::ReportingIdField value) {
  return std::move(context).WriteString(::auction_worklet::mojom::ReportingIdFieldToString(value));
}

} // namespace perfetto