// extensions/common/mojom/code_injection.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "extensions/common/mojom/code_injection.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/code_injection.mojom-params-data.h"
#include "extensions/common/mojom/code_injection.mojom-shared-message-ids.h"

#include "extensions/common/mojom/code_injection.mojom-import-headers.h"
#include "extensions/common/mojom/code_injection.mojom-test-utils.h"


namespace extensions::mojom {
JSSource::JSSource()
    : code(),
      script_url() {}

JSSource::JSSource(
    const std::string& code_in,
    const ::GURL& script_url_in)
    : code(std::move(code_in)),
      script_url(std::move(script_url_in)) {}

JSSource::~JSSource() = default;

void JSSource::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "code"), this->code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_url"), this->script_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool JSSource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CSSSource::CSSSource()
    : code(),
      key() {}

CSSSource::CSSSource(
    const std::string& code_in,
    const std::optional<std::string>& key_in)
    : code(std::move(code_in)),
      key(std::move(key_in)) {}

CSSSource::~CSSSource() = default;

void CSSSource::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "code"), this->code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key"), this->key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CSSSource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
JSInjection::JSInjection()
    : sources(),
      world(),
      world_id(),
      wants_result(),
      user_gesture(),
      wait_for_promise() {}

JSInjection::JSInjection(
    std::vector<JSSourcePtr> sources_in,
    ::extensions::mojom::ExecutionWorld world_in,
    const std::optional<std::string>& world_id_in,
    ::blink::mojom::WantResultOption wants_result_in,
    ::blink::mojom::UserActivationOption user_gesture_in,
    ::blink::mojom::PromiseResultOption wait_for_promise_in)
    : sources(std::move(sources_in)),
      world(std::move(world_in)),
      world_id(std::move(world_id_in)),
      wants_result(std::move(wants_result_in)),
      user_gesture(std::move(user_gesture_in)),
      wait_for_promise(std::move(wait_for_promise_in)) {}

JSInjection::~JSInjection() = default;

void JSInjection::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sources"), this->sources,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<JSSourcePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "world"), this->world,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::extensions::mojom::ExecutionWorld>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "world_id"), this->world_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wants_result"), this->wants_result,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::WantResultOption>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_gesture"), this->user_gesture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::UserActivationOption>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wait_for_promise"), this->wait_for_promise,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::PromiseResultOption>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool JSInjection::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CSSInjection::CSSInjection()
    : sources(),
      css_origin(),
      operation() {}

CSSInjection::CSSInjection(
    std::vector<CSSSourcePtr> sources_in,
    ::extensions::mojom::CSSOrigin css_origin_in,
    CSSInjection::Operation operation_in)
    : sources(std::move(sources_in)),
      css_origin(std::move(css_origin_in)),
      operation(std::move(operation_in)) {}

CSSInjection::~CSSInjection() = default;

void CSSInjection::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sources"), this->sources,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<CSSSourcePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "css_origin"), this->css_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::extensions::mojom::CSSOrigin>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "operation"), this->operation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CSSInjection::Operation>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CSSInjection::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CodeInjection::CodeInjection() : tag_(Tag::kCss) {
  data_.css = new CSSInjectionPtr;
}

CodeInjection::~CodeInjection() {
  DestroyActive();
}


void CodeInjection::set_css(
    CSSInjectionPtr css) {
  if (tag_ == Tag::kCss) {
    *(data_.css) = std::move(css);
  } else {
    DestroyActive();
    tag_ = Tag::kCss;
    data_.css = new CSSInjectionPtr(
        std::move(css));
  }
}
void CodeInjection::set_js(
    JSInjectionPtr js) {
  if (tag_ == Tag::kJs) {
    *(data_.js) = std::move(js);
  } else {
    DestroyActive();
    tag_ = Tag::kJs;
    data_.js = new JSInjectionPtr(
        std::move(js));
  }
}

void CodeInjection::DestroyActive() {
  switch (tag_) {

    case Tag::kCss:

      delete data_.css;
      break;
    case Tag::kJs:

      delete data_.js;
      break;
  }
}

bool CodeInjection::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // extensions::mojom


namespace mojo {


// static
bool StructTraits<::extensions::mojom::JSSource::DataView, ::extensions::mojom::JSSourcePtr>::Read(
    ::extensions::mojom::JSSource::DataView input,
    ::extensions::mojom::JSSourcePtr* output) {
  bool success = true;
  ::extensions::mojom::JSSourcePtr result(::extensions::mojom::JSSource::New());
  
      if (success && !input.ReadCode(&result->code))
        success = false;
      if (success && !input.ReadScriptUrl(&result->script_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::extensions::mojom::CSSSource::DataView, ::extensions::mojom::CSSSourcePtr>::Read(
    ::extensions::mojom::CSSSource::DataView input,
    ::extensions::mojom::CSSSourcePtr* output) {
  bool success = true;
  ::extensions::mojom::CSSSourcePtr result(::extensions::mojom::CSSSource::New());
  
      if (success && !input.ReadCode(&result->code))
        success = false;
      if (success && !input.ReadKey(&result->key))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::extensions::mojom::JSInjection::DataView, ::extensions::mojom::JSInjectionPtr>::Read(
    ::extensions::mojom::JSInjection::DataView input,
    ::extensions::mojom::JSInjectionPtr* output) {
  bool success = true;
  ::extensions::mojom::JSInjectionPtr result(::extensions::mojom::JSInjection::New());
  
      if (success && !input.ReadSources(&result->sources))
        success = false;
      if (success && !input.ReadWorld(&result->world))
        success = false;
      if (success && !input.ReadWorldId(&result->world_id))
        success = false;
      if (success && !input.ReadWantsResult(&result->wants_result))
        success = false;
      if (success && !input.ReadUserGesture(&result->user_gesture))
        success = false;
      if (success && !input.ReadWaitForPromise(&result->wait_for_promise))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::extensions::mojom::CSSInjection::DataView, ::extensions::mojom::CSSInjectionPtr>::Read(
    ::extensions::mojom::CSSInjection::DataView input,
    ::extensions::mojom::CSSInjectionPtr* output) {
  bool success = true;
  ::extensions::mojom::CSSInjectionPtr result(::extensions::mojom::CSSInjection::New());
  
      if (success && !input.ReadSources(&result->sources))
        success = false;
      if (success && !input.ReadCssOrigin(&result->css_origin))
        success = false;
      if (success && !input.ReadOperation(&result->operation))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::extensions::mojom::CodeInjection::DataView, ::extensions::mojom::CodeInjectionPtr>::Read(
    ::extensions::mojom::CodeInjection::DataView input,
    ::extensions::mojom::CodeInjectionPtr* output) {
  using UnionType = ::extensions::mojom::CodeInjection;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kCss: {
      ::extensions::mojom::CSSInjectionPtr result_css;
      if (!input.ReadCss(&result_css))
        return false;

      *output = UnionType::NewCss(
          std::move(result_css));
      break;
    }
    case Tag::kJs: {
      ::extensions::mojom::JSInjectionPtr result_js;
      if (!input.ReadJs(&result_js))
        return false;

      *output = UnionType::NewJs(
          std::move(result_js));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace extensions::mojom {




}  // extensions::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif