// extensions/common/mojom/event_dispatcher.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_EVENT_DISPATCHER_MOJOM_SHARED_H_
#define EXTENSIONS_COMMON_MOJOM_EVENT_DISPATCHER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "extensions/common/mojom/event_dispatcher.mojom-shared-internal.h"
#include "extensions/common/mojom/host_id.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace extensions::mojom {
class EventFilteringInfoDataView;

class DispatchEventParamsDataView;



}  // extensions::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::extensions::mojom::EventFilteringInfoDataView> {
  using Data = ::extensions::mojom::internal::EventFilteringInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::extensions::mojom::DispatchEventParamsDataView> {
  using Data = ::extensions::mojom::internal::DispatchEventParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace extensions::mojom {
// Interface base classes. They are used for type safety check.
class EventDispatcherInterfaceBase {};

using EventDispatcherPtrDataView =
    mojo::InterfacePtrDataView<EventDispatcherInterfaceBase>;
using EventDispatcherRequestDataView =
    mojo::InterfaceRequestDataView<EventDispatcherInterfaceBase>;
using EventDispatcherAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<EventDispatcherInterfaceBase>;
using EventDispatcherAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<EventDispatcherInterfaceBase>;


class EventFilteringInfoDataView {
 public:
  EventFilteringInfoDataView() = default;

  EventFilteringInfoDataView(
      internal::EventFilteringInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrl` instead "
    "of `ReadUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetServiceTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceType(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `service_type` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadServiceType` instead "
    "of `ReadServiceType if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->service_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool has_instance_id() const {
    return data_->has_instance_id;
  }
  int32_t instance_id() const {
    return data_->instance_id;
  }
  inline void GetWindowTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWindowType(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `window_type` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWindowType` instead "
    "of `ReadWindowType if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->window_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool has_window_exposed_by_default() const {
    return data_->has_window_exposed_by_default;
  }
  bool window_exposed_by_default() const {
    return data_->window_exposed_by_default;
  }
 private:
  internal::EventFilteringInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DispatchEventParamsDataView {
 public:
  DispatchEventParamsDataView() = default;

  DispatchEventParamsDataView(
      internal::DispatchEventParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t worker_thread_id() const {
    return data_->worker_thread_id;
  }
  inline void GetHostIdDataView(
      ::extensions::mojom::HostIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHostId(UserType* output) {
    
    auto* pointer = data_->host_id.Get();
    return mojo::internal::Deserialize<::extensions::mojom::HostIDDataView>(
        pointer, output, message_);
  }
  inline void GetEventNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEventName(UserType* output) {
    
    auto* pointer = data_->event_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t event_id() const {
    return data_->event_id;
  }
  bool is_user_gesture() const {
    return data_->is_user_gesture;
  }
  inline void GetFilteringInfoDataView(
      EventFilteringInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilteringInfo(UserType* output) {
    
    auto* pointer = data_->filtering_info.Get();
    return mojo::internal::Deserialize<::extensions::mojom::EventFilteringInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::DispatchEventParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // extensions::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::EventFilteringInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::EventFilteringInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::EventFilteringInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, url_fragment);
    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
    decltype(Traits::service_type(input)) in_service_type = Traits::service_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->service_type)::BaseType> service_type_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_service_type, service_type_fragment);
    fragment->service_type.Set(
        service_type_fragment.is_null() ? nullptr : service_type_fragment.data());
    fragment->has_instance_id = Traits::has_instance_id(input);
    fragment->instance_id = Traits::instance_id(input);
    decltype(Traits::window_type(input)) in_window_type = Traits::window_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->window_type)::BaseType> window_type_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_window_type, window_type_fragment);
    fragment->window_type.Set(
        window_type_fragment.is_null() ? nullptr : window_type_fragment.data());
    fragment->has_window_exposed_by_default = Traits::has_window_exposed_by_default(input);
    fragment->window_exposed_by_default = Traits::window_exposed_by_default(input);
  }

  static bool Deserialize(::extensions::mojom::internal::EventFilteringInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mojom::EventFilteringInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::DispatchEventParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::DispatchEventParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::DispatchEventParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->worker_thread_id = Traits::worker_thread_id(input);
    decltype(Traits::host_id(input)) in_host_id = Traits::host_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->host_id)::BaseType> host_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::extensions::mojom::HostIDDataView>(
        in_host_id, host_id_fragment);
    fragment->host_id.Set(
        host_id_fragment.is_null() ? nullptr : host_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->host_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null host_id in DispatchEventParams struct");
    decltype(Traits::event_name(input)) in_event_name = Traits::event_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->event_name)::BaseType> event_name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_event_name, event_name_fragment);
    fragment->event_name.Set(
        event_name_fragment.is_null() ? nullptr : event_name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->event_name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null event_name in DispatchEventParams struct");
    fragment->event_id = Traits::event_id(input);
    fragment->is_user_gesture = Traits::is_user_gesture(input);
    decltype(Traits::filtering_info(input)) in_filtering_info = Traits::filtering_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->filtering_info)::BaseType> filtering_info_fragment(
            fragment.message());
    mojo::internal::Serialize<::extensions::mojom::EventFilteringInfoDataView>(
        in_filtering_info, filtering_info_fragment);
    fragment->filtering_info.Set(
        filtering_info_fragment.is_null() ? nullptr : filtering_info_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->filtering_info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null filtering_info in DispatchEventParams struct");
  }

  static bool Deserialize(::extensions::mojom::internal::DispatchEventParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mojom::DispatchEventParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace extensions::mojom {

inline void EventFilteringInfoDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void EventFilteringInfoDataView::GetServiceTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->service_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void EventFilteringInfoDataView::GetWindowTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->window_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void DispatchEventParamsDataView::GetHostIdDataView(
    ::extensions::mojom::HostIDDataView* output) {
  auto pointer = data_->host_id.Get();
  *output = ::extensions::mojom::HostIDDataView(pointer, message_);
}
inline void DispatchEventParamsDataView::GetEventNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->event_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DispatchEventParamsDataView::GetFilteringInfoDataView(
    EventFilteringInfoDataView* output) {
  auto pointer = data_->filtering_info.Get();
  *output = EventFilteringInfoDataView(pointer, message_);
}



}  // extensions::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // EXTENSIONS_COMMON_MOJOM_EVENT_DISPATCHER_MOJOM_SHARED_H_