// media/mojo/mojom/audio_encoder.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/audio_encoder.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/audio_encoder.mojom-params-data.h"
namespace media {
namespace mojom {

NOINLINE static const char* AacOutputFormatToStringHelper(AacOutputFormat value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AacOutputFormat::kAAC:
      return "kAAC";
    case AacOutputFormat::kADTS:
      return "kADTS";
    default:
      return nullptr;
  }
}

std::string AacOutputFormatToString(AacOutputFormat value) {
  const char *str = AacOutputFormatToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AacOutputFormat value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AacOutputFormat value) {
  return os << AacOutputFormatToString(value);
}

namespace internal {


// static
bool AacAudioEncoderConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AacAudioEncoderConfig_Data* object =
      static_cast<const AacAudioEncoderConfig_Data*>(data);


  if (!::media::mojom::internal::AacOutputFormat_Data
        ::Validate(object->format, validation_context))
    return false;

  return true;
}

AacAudioEncoderConfig_Data::AacAudioEncoderConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioEncoderConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioEncoderConfig_Data* object =
      static_cast<const AudioEncoderConfig_Data*>(data);


  if (!::media::mojom::internal::AudioCodec_Data
        ::Validate(object->codec, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->aac, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->aac, validation_context))
    return false;

  return true;
}

AudioEncoderConfig_Data::AudioEncoderConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EncodedAudioBuffer_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EncodedAudioBuffer_Data* object =
      static_cast<const EncodedAudioBuffer_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timestamp, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timestamp, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->duration, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->duration, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

EncodedAudioBuffer_Data::EncodedAudioBuffer_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioEncoder_Initialize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioEncoder_Initialize_Params_Data* object =
      static_cast<const AudioEncoder_Initialize_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->config, validation_context))
    return false;

  return true;
}

AudioEncoder_Initialize_Params_Data::AudioEncoder_Initialize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioEncoder_Initialize_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioEncoder_Initialize_ResponseParams_Data* object =
      static_cast<const AudioEncoder_Initialize_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->status, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->status, validation_context))
    return false;

  return true;
}

AudioEncoder_Initialize_ResponseParams_Data::AudioEncoder_Initialize_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioEncoder_Encode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioEncoder_Encode_Params_Data* object =
      static_cast<const AudioEncoder_Encode_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->buffer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->buffer, validation_context))
    return false;

  return true;
}

AudioEncoder_Encode_Params_Data::AudioEncoder_Encode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioEncoder_Encode_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioEncoder_Encode_ResponseParams_Data* object =
      static_cast<const AudioEncoder_Encode_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->status, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->status, validation_context))
    return false;

  return true;
}

AudioEncoder_Encode_ResponseParams_Data::AudioEncoder_Encode_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioEncoder_Flush_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioEncoder_Flush_Params_Data* object =
      static_cast<const AudioEncoder_Flush_Params_Data*>(data);

  return true;
}

AudioEncoder_Flush_Params_Data::AudioEncoder_Flush_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioEncoder_Flush_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioEncoder_Flush_ResponseParams_Data* object =
      static_cast<const AudioEncoder_Flush_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->status, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->status, validation_context))
    return false;

  return true;
}

AudioEncoder_Flush_ResponseParams_Data::AudioEncoder_Flush_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioEncoderClient_OnEncodedBufferReady_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioEncoderClient_OnEncodedBufferReady_Params_Data* object =
      static_cast<const AudioEncoderClient_OnEncodedBufferReady_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->buffer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->buffer, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& description_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->description, validation_context,
                                         &description_validate_params)) {
    return false;
  }

  return true;
}

AudioEncoderClient_OnEncodedBufferReady_Params_Data::AudioEncoderClient_OnEncodedBufferReady_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::AacOutputFormat>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::AacOutputFormat value) {
  return std::move(context).WriteString(::media::mojom::AacOutputFormatToString(value));
}

} // namespace perfetto