// media/mojo/mojom/audio_output_stream.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_AUDIO_OUTPUT_STREAM_MOJOM_PARAMS_DATA_H_
#define MEDIA_MOJO_MOJOM_AUDIO_OUTPUT_STREAM_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace media::mojom {
namespace internal {
class  AudioOutputStream_Play_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<AudioOutputStream_Play_Params_Data>;

  AudioOutputStream_Play_Params_Data();
  ~AudioOutputStream_Play_Params_Data() = delete;
};
static_assert(sizeof(AudioOutputStream_Play_Params_Data) == 8,
              "Bad sizeof(AudioOutputStream_Play_Params_Data)");
class  AudioOutputStream_Pause_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<AudioOutputStream_Pause_Params_Data>;

  AudioOutputStream_Pause_Params_Data();
  ~AudioOutputStream_Pause_Params_Data() = delete;
};
static_assert(sizeof(AudioOutputStream_Pause_Params_Data) == 8,
              "Bad sizeof(AudioOutputStream_Pause_Params_Data)");
class  AudioOutputStream_Flush_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<AudioOutputStream_Flush_Params_Data>;

  AudioOutputStream_Flush_Params_Data();
  ~AudioOutputStream_Flush_Params_Data() = delete;
};
static_assert(sizeof(AudioOutputStream_Flush_Params_Data) == 8,
              "Bad sizeof(AudioOutputStream_Flush_Params_Data)");
class  AudioOutputStream_SetVolume_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  double volume;

 private:
  friend class mojo::internal::MessageFragment<AudioOutputStream_SetVolume_Params_Data>;

  AudioOutputStream_SetVolume_Params_Data();
  ~AudioOutputStream_SetVolume_Params_Data() = delete;
};
static_assert(sizeof(AudioOutputStream_SetVolume_Params_Data) == 16,
              "Bad sizeof(AudioOutputStream_SetVolume_Params_Data)");
class  AudioOutputStreamObserver_DidStartPlaying_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<AudioOutputStreamObserver_DidStartPlaying_Params_Data>;

  AudioOutputStreamObserver_DidStartPlaying_Params_Data();
  ~AudioOutputStreamObserver_DidStartPlaying_Params_Data() = delete;
};
static_assert(sizeof(AudioOutputStreamObserver_DidStartPlaying_Params_Data) == 8,
              "Bad sizeof(AudioOutputStreamObserver_DidStartPlaying_Params_Data)");
class  AudioOutputStreamObserver_DidStopPlaying_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<AudioOutputStreamObserver_DidStopPlaying_Params_Data>;

  AudioOutputStreamObserver_DidStopPlaying_Params_Data();
  ~AudioOutputStreamObserver_DidStopPlaying_Params_Data() = delete;
};
static_assert(sizeof(AudioOutputStreamObserver_DidStopPlaying_Params_Data) == 8,
              "Bad sizeof(AudioOutputStreamObserver_DidStopPlaying_Params_Data)");
class  AudioOutputStreamObserver_DidChangeAudibleState_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t is_audible : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<AudioOutputStreamObserver_DidChangeAudibleState_Params_Data>;

  AudioOutputStreamObserver_DidChangeAudibleState_Params_Data();
  ~AudioOutputStreamObserver_DidChangeAudibleState_Params_Data() = delete;
};
static_assert(sizeof(AudioOutputStreamObserver_DidChangeAudibleState_Params_Data) == 16,
              "Bad sizeof(AudioOutputStreamObserver_DidChangeAudibleState_Params_Data)");
class  AudioOutputStreamProvider_Acquire_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::AudioParameters_Data> params;
  mojo::internal::Interface_Data client;

 private:
  friend class mojo::internal::MessageFragment<AudioOutputStreamProvider_Acquire_Params_Data>;

  AudioOutputStreamProvider_Acquire_Params_Data();
  ~AudioOutputStreamProvider_Acquire_Params_Data() = delete;
};
static_assert(sizeof(AudioOutputStreamProvider_Acquire_Params_Data) == 24,
              "Bad sizeof(AudioOutputStreamProvider_Acquire_Params_Data)");
class  AudioOutputStreamProviderClient_Created_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data stream;
  mojo::internal::Pointer<::media::mojom::internal::ReadWriteAudioDataPipe_Data> data_pipe;

 private:
  friend class mojo::internal::MessageFragment<AudioOutputStreamProviderClient_Created_Params_Data>;

  AudioOutputStreamProviderClient_Created_Params_Data();
  ~AudioOutputStreamProviderClient_Created_Params_Data() = delete;
};
static_assert(sizeof(AudioOutputStreamProviderClient_Created_Params_Data) == 24,
              "Bad sizeof(AudioOutputStreamProviderClient_Created_Params_Data)");
class  DeviceSwitchInterface_SwitchAudioOutputDeviceId_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> output_device_id;

 private:
  friend class mojo::internal::MessageFragment<DeviceSwitchInterface_SwitchAudioOutputDeviceId_Params_Data>;

  DeviceSwitchInterface_SwitchAudioOutputDeviceId_Params_Data();
  ~DeviceSwitchInterface_SwitchAudioOutputDeviceId_Params_Data() = delete;
};
static_assert(sizeof(DeviceSwitchInterface_SwitchAudioOutputDeviceId_Params_Data) == 16,
              "Bad sizeof(DeviceSwitchInterface_SwitchAudioOutputDeviceId_Params_Data)");

}  // namespace internal


class AudioOutputStream_Play_ParamsDataView {
 public:
  AudioOutputStream_Play_ParamsDataView() = default;

  AudioOutputStream_Play_ParamsDataView(
      internal::AudioOutputStream_Play_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::AudioOutputStream_Play_Params_Data* data_ = nullptr;
};


class AudioOutputStream_Pause_ParamsDataView {
 public:
  AudioOutputStream_Pause_ParamsDataView() = default;

  AudioOutputStream_Pause_ParamsDataView(
      internal::AudioOutputStream_Pause_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::AudioOutputStream_Pause_Params_Data* data_ = nullptr;
};


class AudioOutputStream_Flush_ParamsDataView {
 public:
  AudioOutputStream_Flush_ParamsDataView() = default;

  AudioOutputStream_Flush_ParamsDataView(
      internal::AudioOutputStream_Flush_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::AudioOutputStream_Flush_Params_Data* data_ = nullptr;
};


class AudioOutputStream_SetVolume_ParamsDataView {
 public:
  AudioOutputStream_SetVolume_ParamsDataView() = default;

  AudioOutputStream_SetVolume_ParamsDataView(
      internal::AudioOutputStream_SetVolume_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double volume() const {
    return data_->volume;
  }
 private:
  internal::AudioOutputStream_SetVolume_Params_Data* data_ = nullptr;
};


class AudioOutputStreamObserver_DidStartPlaying_ParamsDataView {
 public:
  AudioOutputStreamObserver_DidStartPlaying_ParamsDataView() = default;

  AudioOutputStreamObserver_DidStartPlaying_ParamsDataView(
      internal::AudioOutputStreamObserver_DidStartPlaying_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::AudioOutputStreamObserver_DidStartPlaying_Params_Data* data_ = nullptr;
};


class AudioOutputStreamObserver_DidStopPlaying_ParamsDataView {
 public:
  AudioOutputStreamObserver_DidStopPlaying_ParamsDataView() = default;

  AudioOutputStreamObserver_DidStopPlaying_ParamsDataView(
      internal::AudioOutputStreamObserver_DidStopPlaying_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::AudioOutputStreamObserver_DidStopPlaying_Params_Data* data_ = nullptr;
};


class AudioOutputStreamObserver_DidChangeAudibleState_ParamsDataView {
 public:
  AudioOutputStreamObserver_DidChangeAudibleState_ParamsDataView() = default;

  AudioOutputStreamObserver_DidChangeAudibleState_ParamsDataView(
      internal::AudioOutputStreamObserver_DidChangeAudibleState_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool is_audible() const {
    return data_->is_audible;
  }
 private:
  internal::AudioOutputStreamObserver_DidChangeAudibleState_Params_Data* data_ = nullptr;
};


class AudioOutputStreamProvider_Acquire_ParamsDataView {
 public:
  AudioOutputStreamProvider_Acquire_ParamsDataView() = default;

  AudioOutputStreamProvider_Acquire_ParamsDataView(
      internal::AudioOutputStreamProvider_Acquire_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      ::media::mojom::AudioParametersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::media::mojom::AudioParametersDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::AudioOutputStreamProviderClientInterfaceBase>>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::AudioOutputStreamProvider_Acquire_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AudioOutputStreamProviderClient_Created_ParamsDataView {
 public:
  AudioOutputStreamProviderClient_Created_ParamsDataView() = default;

  AudioOutputStreamProviderClient_Created_ParamsDataView(
      internal::AudioOutputStreamProviderClient_Created_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeStream() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::AudioOutputStreamInterfaceBase>>(
            &data_->stream, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetDataPipeDataView(
      ::media::mojom::ReadWriteAudioDataPipeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDataPipe(UserType* output) {
    
    auto* pointer = data_->data_pipe.Get();
    return mojo::internal::Deserialize<::media::mojom::ReadWriteAudioDataPipeDataView>(
        pointer, output, message_);
  }
 private:
  internal::AudioOutputStreamProviderClient_Created_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DeviceSwitchInterface_SwitchAudioOutputDeviceId_ParamsDataView {
 public:
  DeviceSwitchInterface_SwitchAudioOutputDeviceId_ParamsDataView() = default;

  DeviceSwitchInterface_SwitchAudioOutputDeviceId_ParamsDataView(
      internal::DeviceSwitchInterface_SwitchAudioOutputDeviceId_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOutputDeviceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputDeviceId(UserType* output) {
    
    auto* pointer = data_->output_device_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::DeviceSwitchInterface_SwitchAudioOutputDeviceId_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};















inline void AudioOutputStreamProvider_Acquire_ParamsDataView::GetParamsDataView(
    ::media::mojom::AudioParametersDataView* output) {
  auto pointer = data_->params.Get();
  *output = ::media::mojom::AudioParametersDataView(pointer, message_);
}


inline void AudioOutputStreamProviderClient_Created_ParamsDataView::GetDataPipeDataView(
    ::media::mojom::ReadWriteAudioDataPipeDataView* output) {
  auto pointer = data_->data_pipe.Get();
  *output = ::media::mojom::ReadWriteAudioDataPipeDataView(pointer, message_);
}


inline void DeviceSwitchInterface_SwitchAudioOutputDeviceId_ParamsDataView::GetOutputDeviceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->output_device_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // media::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // MEDIA_MOJO_MOJOM_AUDIO_OUTPUT_STREAM_MOJOM_PARAMS_DATA_H_