// media/mojo/mojom/audio_processing.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_AUDIO_PROCESSING_MOJOM_SHARED_H_
#define MEDIA_MOJO_MOJOM_AUDIO_PROCESSING_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/audio_processing.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace media::mojom {
class AudioProcessingStatsDataView;

class AudioProcessingSettingsDataView;

class AudioProcessingConfigDataView;



}  // media::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::AudioProcessingStatsDataView> {
  using Data = ::media::mojom::internal::AudioProcessingStats_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::AudioProcessingSettingsDataView> {
  using Data = ::media::mojom::internal::AudioProcessingSettings_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::AudioProcessingConfigDataView> {
  using Data = ::media::mojom::internal::AudioProcessingConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {
// Interface base classes. They are used for type safety check.
class AudioProcessorControlsInterfaceBase {};

using AudioProcessorControlsPtrDataView =
    mojo::InterfacePtrDataView<AudioProcessorControlsInterfaceBase>;
using AudioProcessorControlsRequestDataView =
    mojo::InterfaceRequestDataView<AudioProcessorControlsInterfaceBase>;
using AudioProcessorControlsAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AudioProcessorControlsInterfaceBase>;
using AudioProcessorControlsAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AudioProcessorControlsInterfaceBase>;


class AudioProcessingStatsDataView {
 public:
  AudioProcessingStatsDataView() = default;

  AudioProcessingStatsDataView(
      internal::AudioProcessingStats_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool has_echo_return_loss() const {
    return data_->has_echo_return_loss;
  }
  double echo_return_loss() const {
    return data_->echo_return_loss;
  }
  bool has_echo_return_loss_enhancement() const {
    return data_->has_echo_return_loss_enhancement;
  }
  double echo_return_loss_enhancement() const {
    return data_->echo_return_loss_enhancement;
  }
 private:
  internal::AudioProcessingStats_Data* data_ = nullptr;
};


class AudioProcessingSettingsDataView {
 public:
  AudioProcessingSettingsDataView() = default;

  AudioProcessingSettingsDataView(
      internal::AudioProcessingSettings_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool echo_cancellation() const {
    return data_->echo_cancellation;
  }
  bool noise_suppression() const {
    return data_->noise_suppression;
  }
  bool automatic_gain_control() const {
    return data_->automatic_gain_control;
  }
  bool multi_channel_capture_processing() const {
    return data_->multi_channel_capture_processing;
  }
 private:
  internal::AudioProcessingSettings_Data* data_ = nullptr;
};


class AudioProcessingConfigDataView {
 public:
  AudioProcessingConfigDataView() = default;

  AudioProcessingConfigDataView(
      internal::AudioProcessingConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeControlsReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::mojom::AudioProcessorControlsInterfaceBase>>(
            &data_->controls_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetSettingsDataView(
      AudioProcessingSettingsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSettings(UserType* output) {
    
    auto* pointer = data_->settings.Get();
    return mojo::internal::Deserialize<::media::mojom::AudioProcessingSettingsDataView>(
        pointer, output, message_);
  }
 private:
  internal::AudioProcessingConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::AudioProcessingStatsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::AudioProcessingStatsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::AudioProcessingStats_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->has_echo_return_loss = Traits::has_echo_return_loss(input);
    fragment->echo_return_loss = Traits::echo_return_loss(input);
    fragment->has_echo_return_loss_enhancement = Traits::has_echo_return_loss_enhancement(input);
    fragment->echo_return_loss_enhancement = Traits::echo_return_loss_enhancement(input);
  }

  static bool Deserialize(::media::mojom::internal::AudioProcessingStats_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::AudioProcessingStatsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::AudioProcessingSettingsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::AudioProcessingSettingsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::AudioProcessingSettings_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->echo_cancellation = Traits::echo_cancellation(input);
    fragment->noise_suppression = Traits::noise_suppression(input);
    fragment->automatic_gain_control = Traits::automatic_gain_control(input);
    fragment->multi_channel_capture_processing = Traits::multi_channel_capture_processing(input);
  }

  static bool Deserialize(::media::mojom::internal::AudioProcessingSettings_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::AudioProcessingSettingsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::AudioProcessingConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::AudioProcessingConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::AudioProcessingConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::controls_receiver(input)) in_controls_receiver = Traits::controls_receiver(input);
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::AudioProcessorControlsInterfaceBase>>(
        in_controls_receiver, &fragment->controls_receiver, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->controls_receiver),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid controls_receiver in AudioProcessingConfig struct");
    decltype(Traits::settings(input)) in_settings = Traits::settings(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->settings)::BaseType> settings_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::AudioProcessingSettingsDataView>(
        in_settings, settings_fragment);
    fragment->settings.Set(
        settings_fragment.is_null() ? nullptr : settings_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->settings.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null settings in AudioProcessingConfig struct");
  }

  static bool Deserialize(::media::mojom::internal::AudioProcessingConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::AudioProcessingConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::mojom {





inline void AudioProcessingConfigDataView::GetSettingsDataView(
    AudioProcessingSettingsDataView* output) {
  auto pointer = data_->settings.Get();
  *output = AudioProcessingSettingsDataView(pointer, message_);
}



}  // media::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // MEDIA_MOJO_MOJOM_AUDIO_PROCESSING_MOJOM_SHARED_H_