// services/device/public/mojom/smart_card.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/smart_card.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/smart_card.mojom-params-data.h"
#include "services/device/public/mojom/smart_card.mojom-shared-message-ids.h"

#include "services/device/public/mojom/smart_card.mojom-blink-import-headers.h"
#include "services/device/public/mojom/smart_card.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace device::mojom::blink {
SmartCardReaderStateFlags::SmartCardReaderStateFlags()
    : unaware(),
      ignore(),
      changed(),
      unknown(),
      unavailable(),
      empty(),
      present(),
      exclusive(),
      inuse(),
      mute(),
      unpowered() {}

SmartCardReaderStateFlags::SmartCardReaderStateFlags(
    bool unaware_in,
    bool ignore_in,
    bool changed_in,
    bool unknown_in,
    bool unavailable_in,
    bool empty_in,
    bool present_in,
    bool exclusive_in,
    bool inuse_in,
    bool mute_in,
    bool unpowered_in)
    : unaware(std::move(unaware_in)),
      ignore(std::move(ignore_in)),
      changed(std::move(changed_in)),
      unknown(std::move(unknown_in)),
      unavailable(std::move(unavailable_in)),
      empty(std::move(empty_in)),
      present(std::move(present_in)),
      exclusive(std::move(exclusive_in)),
      inuse(std::move(inuse_in)),
      mute(std::move(mute_in)),
      unpowered(std::move(unpowered_in)) {}

SmartCardReaderStateFlags::~SmartCardReaderStateFlags() = default;
size_t SmartCardReaderStateFlags::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->unaware);
  seed = mojo::internal::WTFHash(seed, this->ignore);
  seed = mojo::internal::WTFHash(seed, this->changed);
  seed = mojo::internal::WTFHash(seed, this->unknown);
  seed = mojo::internal::WTFHash(seed, this->unavailable);
  seed = mojo::internal::WTFHash(seed, this->empty);
  seed = mojo::internal::WTFHash(seed, this->present);
  seed = mojo::internal::WTFHash(seed, this->exclusive);
  seed = mojo::internal::WTFHash(seed, this->inuse);
  seed = mojo::internal::WTFHash(seed, this->mute);
  seed = mojo::internal::WTFHash(seed, this->unpowered);
  return seed;
}

void SmartCardReaderStateFlags::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unaware"), this->unaware,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ignore"), this->ignore,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "changed"), this->changed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unknown"), this->unknown,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unavailable"), this->unavailable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "empty"), this->empty,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "present"), this->present,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "exclusive"), this->exclusive,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "inuse"), this->inuse,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mute"), this->mute,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unpowered"), this->unpowered,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SmartCardReaderStateFlags::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SmartCardReaderStateIn::SmartCardReaderStateIn()
    : reader(),
      current_state(),
      current_count() {}

SmartCardReaderStateIn::SmartCardReaderStateIn(
    const WTF::String& reader_in,
    SmartCardReaderStateFlagsPtr current_state_in,
    uint16_t current_count_in)
    : reader(std::move(reader_in)),
      current_state(std::move(current_state_in)),
      current_count(std::move(current_count_in)) {}

SmartCardReaderStateIn::~SmartCardReaderStateIn() = default;
size_t SmartCardReaderStateIn::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->reader);
  seed = mojo::internal::WTFHash(seed, this->current_state);
  seed = mojo::internal::WTFHash(seed, this->current_count);
  return seed;
}

void SmartCardReaderStateIn::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reader"), this->reader,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "current_state"), this->current_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SmartCardReaderStateFlagsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "current_count"), this->current_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SmartCardReaderStateIn::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SmartCardReaderStateOut::SmartCardReaderStateOut()
    : reader(),
      event_state(),
      event_count(),
      answer_to_reset() {}

SmartCardReaderStateOut::SmartCardReaderStateOut(
    const WTF::String& reader_in,
    SmartCardReaderStateFlagsPtr event_state_in,
    uint16_t event_count_in,
    WTF::Vector<uint8_t> answer_to_reset_in)
    : reader(std::move(reader_in)),
      event_state(std::move(event_state_in)),
      event_count(std::move(event_count_in)),
      answer_to_reset(std::move(answer_to_reset_in)) {}

SmartCardReaderStateOut::~SmartCardReaderStateOut() = default;

void SmartCardReaderStateOut::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reader"), this->reader,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_state"), this->event_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SmartCardReaderStateFlagsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_count"), this->event_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "answer_to_reset"), this->answer_to_reset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SmartCardReaderStateOut::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SmartCardProtocols::SmartCardProtocols()
    : t0(),
      t1(),
      raw() {}

SmartCardProtocols::SmartCardProtocols(
    bool t0_in,
    bool t1_in,
    bool raw_in)
    : t0(std::move(t0_in)),
      t1(std::move(t1_in)),
      raw(std::move(raw_in)) {}

SmartCardProtocols::~SmartCardProtocols() = default;
size_t SmartCardProtocols::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->t0);
  seed = mojo::internal::WTFHash(seed, this->t1);
  seed = mojo::internal::WTFHash(seed, this->raw);
  return seed;
}

void SmartCardProtocols::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "t0"), this->t0,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "t1"), this->t1,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "raw"), this->raw,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SmartCardProtocols::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SmartCardStatus::SmartCardStatus()
    : reader_name(),
      state(),
      protocol(),
      answer_to_reset() {}

SmartCardStatus::SmartCardStatus(
    const WTF::String& reader_name_in,
    SmartCardConnectionState state_in,
    SmartCardProtocol protocol_in,
    WTF::Vector<uint8_t> answer_to_reset_in)
    : reader_name(std::move(reader_name_in)),
      state(std::move(state_in)),
      protocol(std::move(protocol_in)),
      answer_to_reset(std::move(answer_to_reset_in)) {}

SmartCardStatus::~SmartCardStatus() = default;

void SmartCardStatus::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reader_name"), this->reader_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state"), this->state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SmartCardConnectionState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "protocol"), this->protocol,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SmartCardProtocol>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "answer_to_reset"), this->answer_to_reset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SmartCardStatus::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SmartCardConnectSuccess::SmartCardConnectSuccess()
    : connection(),
      active_protocol() {}

SmartCardConnectSuccess::SmartCardConnectSuccess(
    ::mojo::PendingRemote<SmartCardConnection> connection_in,
    SmartCardProtocol active_protocol_in)
    : connection(std::move(connection_in)),
      active_protocol(std::move(active_protocol_in)) {}

SmartCardConnectSuccess::~SmartCardConnectSuccess() = default;

void SmartCardConnectSuccess::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "connection"), this->connection,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<SmartCardConnection>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "active_protocol"), this->active_protocol,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SmartCardProtocol>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SmartCardConnectSuccess::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SmartCardResult::SmartCardResult() : tag_(Tag::kSuccess) {
  data_.success = SmartCardSuccess();
}

SmartCardResult::~SmartCardResult() {
  DestroyActive();
}


void SmartCardResult::set_success(
    SmartCardSuccess success) {
  if (tag_ != Tag::kSuccess) {
    DestroyActive();
    tag_ = Tag::kSuccess;
  }
  data_.success = success;
}
void SmartCardResult::set_error(
    SmartCardError error) {
  if (tag_ != Tag::kError) {
    DestroyActive();
    tag_ = Tag::kError;
  }
  data_.error = error;
}

void SmartCardResult::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:

      break;
    case Tag::kError:

      break;
  }
}
size_t SmartCardResult::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kSuccess:
      return mojo::internal::WTFHash(seed, data_.success);
    case Tag::kError:
      return mojo::internal::WTFHash(seed, data_.error);
    default:
      NOTREACHED();
  }
}

bool SmartCardResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
SmartCardStatusChangeResult::SmartCardStatusChangeResult() : tag_(Tag::kReaderStates) {
  data_.reader_states = new WTF::Vector<SmartCardReaderStateOutPtr>;
}

SmartCardStatusChangeResult::~SmartCardStatusChangeResult() {
  DestroyActive();
}


void SmartCardStatusChangeResult::set_reader_states(
    WTF::Vector<SmartCardReaderStateOutPtr> reader_states) {
  if (tag_ == Tag::kReaderStates) {
    *(data_.reader_states) = std::move(reader_states);
  } else {
    DestroyActive();
    tag_ = Tag::kReaderStates;
    data_.reader_states = new WTF::Vector<SmartCardReaderStateOutPtr>(
        std::move(reader_states));
  }
}
void SmartCardStatusChangeResult::set_error(
    SmartCardError error) {
  if (tag_ != Tag::kError) {
    DestroyActive();
    tag_ = Tag::kError;
  }
  data_.error = error;
}

void SmartCardStatusChangeResult::DestroyActive() {
  switch (tag_) {

    case Tag::kReaderStates:

      delete data_.reader_states;
      break;
    case Tag::kError:

      break;
  }
}

bool SmartCardStatusChangeResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
SmartCardListReadersResult::SmartCardListReadersResult() : tag_(Tag::kReaders) {
  data_.readers = new WTF::Vector<WTF::String>;
}

SmartCardListReadersResult::~SmartCardListReadersResult() {
  DestroyActive();
}


void SmartCardListReadersResult::set_readers(
    WTF::Vector<WTF::String> readers) {
  if (tag_ == Tag::kReaders) {
    *(data_.readers) = std::move(readers);
  } else {
    DestroyActive();
    tag_ = Tag::kReaders;
    data_.readers = new WTF::Vector<WTF::String>(
        std::move(readers));
  }
}
void SmartCardListReadersResult::set_error(
    SmartCardError error) {
  if (tag_ != Tag::kError) {
    DestroyActive();
    tag_ = Tag::kError;
  }
  data_.error = error;
}

void SmartCardListReadersResult::DestroyActive() {
  switch (tag_) {

    case Tag::kReaders:

      delete data_.readers;
      break;
    case Tag::kError:

      break;
  }
}

bool SmartCardListReadersResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
SmartCardCreateContextResult::SmartCardCreateContextResult() : tag_(Tag::kContext) {
  data_.context = new ::mojo::PendingRemote<SmartCardContext>;
}

SmartCardCreateContextResult::~SmartCardCreateContextResult() {
  DestroyActive();
}


void SmartCardCreateContextResult::set_context(
    ::mojo::PendingRemote<SmartCardContext> context) {
  if (tag_ == Tag::kContext) {
    *(data_.context) = std::move(context);
  } else {
    DestroyActive();
    tag_ = Tag::kContext;
    data_.context = new ::mojo::PendingRemote<SmartCardContext>(
        std::move(context));
  }
}
void SmartCardCreateContextResult::set_error(
    SmartCardError error) {
  if (tag_ != Tag::kError) {
    DestroyActive();
    tag_ = Tag::kError;
  }
  data_.error = error;
}

void SmartCardCreateContextResult::DestroyActive() {
  switch (tag_) {

    case Tag::kContext:

      delete data_.context;
      break;
    case Tag::kError:

      break;
  }
}

bool SmartCardCreateContextResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
SmartCardConnectResult::SmartCardConnectResult() : tag_(Tag::kSuccess) {
  data_.success = new SmartCardConnectSuccessPtr;
}

SmartCardConnectResult::~SmartCardConnectResult() {
  DestroyActive();
}


void SmartCardConnectResult::set_success(
    SmartCardConnectSuccessPtr success) {
  if (tag_ == Tag::kSuccess) {
    *(data_.success) = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    data_.success = new SmartCardConnectSuccessPtr(
        std::move(success));
  }
}
void SmartCardConnectResult::set_error(
    SmartCardError error) {
  if (tag_ != Tag::kError) {
    DestroyActive();
    tag_ = Tag::kError;
  }
  data_.error = error;
}

void SmartCardConnectResult::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:

      delete data_.success;
      break;
    case Tag::kError:

      break;
  }
}

bool SmartCardConnectResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
SmartCardDataResult::SmartCardDataResult() : tag_(Tag::kData) {
  data_.data = new WTF::Vector<uint8_t>;
}

SmartCardDataResult::~SmartCardDataResult() {
  DestroyActive();
}


void SmartCardDataResult::set_data(
    WTF::Vector<uint8_t> data) {
  if (tag_ == Tag::kData) {
    *(data_.data) = std::move(data);
  } else {
    DestroyActive();
    tag_ = Tag::kData;
    data_.data = new WTF::Vector<uint8_t>(
        std::move(data));
  }
}
void SmartCardDataResult::set_error(
    SmartCardError error) {
  if (tag_ != Tag::kError) {
    DestroyActive();
    tag_ = Tag::kError;
  }
  data_.error = error;
}

void SmartCardDataResult::DestroyActive() {
  switch (tag_) {

    case Tag::kData:

      delete data_.data;
      break;
    case Tag::kError:

      break;
  }
}

bool SmartCardDataResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
SmartCardStatusResult::SmartCardStatusResult() : tag_(Tag::kStatus) {
  data_.status = new SmartCardStatusPtr;
}

SmartCardStatusResult::~SmartCardStatusResult() {
  DestroyActive();
}


void SmartCardStatusResult::set_status(
    SmartCardStatusPtr status) {
  if (tag_ == Tag::kStatus) {
    *(data_.status) = std::move(status);
  } else {
    DestroyActive();
    tag_ = Tag::kStatus;
    data_.status = new SmartCardStatusPtr(
        std::move(status));
  }
}
void SmartCardStatusResult::set_error(
    SmartCardError error) {
  if (tag_ != Tag::kError) {
    DestroyActive();
    tag_ = Tag::kError;
  }
  data_.error = error;
}

void SmartCardStatusResult::DestroyActive() {
  switch (tag_) {

    case Tag::kStatus:

      delete data_.status;
      break;
    case Tag::kError:

      break;
  }
}

bool SmartCardStatusResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
SmartCardTransactionResult::SmartCardTransactionResult() : tag_(Tag::kTransaction) {
  data_.transaction = new ::mojo::PendingAssociatedRemote<SmartCardTransaction>;
}

SmartCardTransactionResult::~SmartCardTransactionResult() {
  DestroyActive();
}


void SmartCardTransactionResult::set_transaction(
    ::mojo::PendingAssociatedRemote<SmartCardTransaction> transaction) {
  if (tag_ == Tag::kTransaction) {
    *(data_.transaction) = std::move(transaction);
  } else {
    DestroyActive();
    tag_ = Tag::kTransaction;
    data_.transaction = new ::mojo::PendingAssociatedRemote<SmartCardTransaction>(
        std::move(transaction));
  }
}
void SmartCardTransactionResult::set_error(
    SmartCardError error) {
  if (tag_ != Tag::kError) {
    DestroyActive();
    tag_ = Tag::kError;
  }
  data_.error = error;
}

void SmartCardTransactionResult::DestroyActive() {
  switch (tag_) {

    case Tag::kTransaction:

      delete data_.transaction;
      break;
    case Tag::kError:

      break;
  }
}

bool SmartCardTransactionResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char SmartCardTransaction::Name_[] = "device.mojom.SmartCardTransaction";

SmartCardTransaction::IPCStableHashFunction SmartCardTransaction::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SmartCardTransaction>(message.name())) {
    case messages::SmartCardTransaction::kEndTransaction: {
      return &SmartCardTransaction::EndTransaction_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SmartCardTransaction::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SmartCardTransaction>(message.name())) {
      case messages::SmartCardTransaction::kEndTransaction:
            return "Receive device::mojom::SmartCardTransaction::EndTransaction";
    }
  } else {
    switch (static_cast<messages::SmartCardTransaction>(message.name())) {
      case messages::SmartCardTransaction::kEndTransaction:
            return "Receive reply device::mojom::SmartCardTransaction::EndTransaction";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SmartCardTransaction::EndTransaction_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::SmartCardTransaction::EndTransaction");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SmartCardTransaction_EndTransaction_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SmartCardTransaction_EndTransaction_ForwardToCallback(
      SmartCardTransaction::EndTransactionCallback callback
      ) : callback_(std::move(callback)) {
  }

  SmartCardTransaction_EndTransaction_ForwardToCallback(const SmartCardTransaction_EndTransaction_ForwardToCallback&) = delete;
  SmartCardTransaction_EndTransaction_ForwardToCallback& operator=(const SmartCardTransaction_EndTransaction_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SmartCardTransaction::EndTransactionCallback callback_;
};

SmartCardTransactionProxy::SmartCardTransactionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SmartCardTransactionProxy::EndTransaction(
    SmartCardDisposition in_disposition, EndTransactionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::SmartCardTransaction::EndTransaction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disposition"), in_disposition,
                        "<value of type SmartCardDisposition>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SmartCardTransaction::kEndTransaction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SmartCardTransaction_EndTransaction_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::SmartCardDisposition>(
      in_disposition, &params->disposition);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SmartCardTransaction::Name_);
  message.set_method_name("EndTransaction");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SmartCardTransaction_EndTransaction_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SmartCardTransaction_EndTransaction_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SmartCardTransaction::EndTransactionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SmartCardTransaction_EndTransaction_ProxyToResponder> proxy(
        new SmartCardTransaction_EndTransaction_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SmartCardTransaction_EndTransaction_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SmartCardTransaction_EndTransaction_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SmartCardTransaction_EndTransaction_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SmartCardTransaction::EndTransactionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SmartCardResultPtr in_result);
};

bool SmartCardTransaction_EndTransaction_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SmartCardTransaction_EndTransaction_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SmartCardTransaction_EndTransaction_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for SmartCardTransaction.0
  bool success = true;
  SmartCardResultPtr p_result{};
  SmartCardTransaction_EndTransaction_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SmartCardTransaction::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void SmartCardTransaction_EndTransaction_ProxyToResponder::Run(
    SmartCardResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::SmartCardTransaction::EndTransaction", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type SmartCardResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SmartCardTransaction::kEndTransaction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SmartCardTransaction_EndTransaction_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::device::mojom::SmartCardResultDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SmartCardTransaction::Name_);
  message.set_method_name("EndTransaction");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SmartCardTransactionStubDispatch::Accept(
    SmartCardTransaction* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SmartCardTransaction>(message->header()->name)) {
    case messages::SmartCardTransaction::kEndTransaction: {
      break;
    }
  }
  return false;
}

// static
bool SmartCardTransactionStubDispatch::AcceptWithResponder(
    SmartCardTransaction* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SmartCardTransaction>(message->header()->name)) {
    case messages::SmartCardTransaction::kEndTransaction: {
      internal::SmartCardTransaction_EndTransaction_Params_Data* params =
          reinterpret_cast<
              internal::SmartCardTransaction_EndTransaction_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for SmartCardTransaction.0
      bool success = true;
      SmartCardDisposition p_disposition{};
      SmartCardTransaction_EndTransaction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDisposition(&p_disposition))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SmartCardTransaction::Name_, 0, false);
        return false;
      }
      SmartCardTransaction::EndTransactionCallback callback =
          SmartCardTransaction_EndTransaction_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EndTransaction(        
        std::move(p_disposition), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSmartCardTransactionValidationInfo[] = {
    {base::to_underlying(messages::SmartCardTransaction::kEndTransaction),
     { &internal::SmartCardTransaction_EndTransaction_Params_Data::Validate,
      &internal::SmartCardTransaction_EndTransaction_ResponseParams_Data::Validate}},
};

bool SmartCardTransactionRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::SmartCardTransaction::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSmartCardTransactionValidationInfo);
}

bool SmartCardTransactionResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::SmartCardTransaction::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kSmartCardTransactionValidationInfo);

}
const char SmartCardConnection::Name_[] = "device.mojom.SmartCardConnection";

SmartCardConnection::IPCStableHashFunction SmartCardConnection::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SmartCardConnection>(message.name())) {
    case messages::SmartCardConnection::kDisconnect: {
      return &SmartCardConnection::Disconnect_Sym::IPCStableHash;
    }
    case messages::SmartCardConnection::kTransmit: {
      return &SmartCardConnection::Transmit_Sym::IPCStableHash;
    }
    case messages::SmartCardConnection::kControl: {
      return &SmartCardConnection::Control_Sym::IPCStableHash;
    }
    case messages::SmartCardConnection::kGetAttrib: {
      return &SmartCardConnection::GetAttrib_Sym::IPCStableHash;
    }
    case messages::SmartCardConnection::kSetAttrib: {
      return &SmartCardConnection::SetAttrib_Sym::IPCStableHash;
    }
    case messages::SmartCardConnection::kStatus: {
      return &SmartCardConnection::Status_Sym::IPCStableHash;
    }
    case messages::SmartCardConnection::kBeginTransaction: {
      return &SmartCardConnection::BeginTransaction_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SmartCardConnection::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SmartCardConnection>(message.name())) {
      case messages::SmartCardConnection::kDisconnect:
            return "Receive device::mojom::SmartCardConnection::Disconnect";
      case messages::SmartCardConnection::kTransmit:
            return "Receive device::mojom::SmartCardConnection::Transmit";
      case messages::SmartCardConnection::kControl:
            return "Receive device::mojom::SmartCardConnection::Control";
      case messages::SmartCardConnection::kGetAttrib:
            return "Receive device::mojom::SmartCardConnection::GetAttrib";
      case messages::SmartCardConnection::kSetAttrib:
            return "Receive device::mojom::SmartCardConnection::SetAttrib";
      case messages::SmartCardConnection::kStatus:
            return "Receive device::mojom::SmartCardConnection::Status";
      case messages::SmartCardConnection::kBeginTransaction:
            return "Receive device::mojom::SmartCardConnection::BeginTransaction";
    }
  } else {
    switch (static_cast<messages::SmartCardConnection>(message.name())) {
      case messages::SmartCardConnection::kDisconnect:
            return "Receive reply device::mojom::SmartCardConnection::Disconnect";
      case messages::SmartCardConnection::kTransmit:
            return "Receive reply device::mojom::SmartCardConnection::Transmit";
      case messages::SmartCardConnection::kControl:
            return "Receive reply device::mojom::SmartCardConnection::Control";
      case messages::SmartCardConnection::kGetAttrib:
            return "Receive reply device::mojom::SmartCardConnection::GetAttrib";
      case messages::SmartCardConnection::kSetAttrib:
            return "Receive reply device::mojom::SmartCardConnection::SetAttrib";
      case messages::SmartCardConnection::kStatus:
            return "Receive reply device::mojom::SmartCardConnection::Status";
      case messages::SmartCardConnection::kBeginTransaction:
            return "Receive reply device::mojom::SmartCardConnection::BeginTransaction";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SmartCardConnection::Disconnect_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::SmartCardConnection::Disconnect");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SmartCardConnection::Transmit_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::SmartCardConnection::Transmit");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SmartCardConnection::Control_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::SmartCardConnection::Control");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SmartCardConnection::GetAttrib_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::SmartCardConnection::GetAttrib");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SmartCardConnection::SetAttrib_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::SmartCardConnection::SetAttrib");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SmartCardConnection::Status_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::SmartCardConnection::Status");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SmartCardConnection::BeginTransaction_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::SmartCardConnection::BeginTransaction");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SmartCardConnection_Disconnect_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SmartCardConnection_Disconnect_ForwardToCallback(
      SmartCardConnection::DisconnectCallback callback
      ) : callback_(std::move(callback)) {
  }

  SmartCardConnection_Disconnect_ForwardToCallback(const SmartCardConnection_Disconnect_ForwardToCallback&) = delete;
  SmartCardConnection_Disconnect_ForwardToCallback& operator=(const SmartCardConnection_Disconnect_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SmartCardConnection::DisconnectCallback callback_;
};

class SmartCardConnection_Transmit_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SmartCardConnection_Transmit_ForwardToCallback(
      SmartCardConnection::TransmitCallback callback
      ) : callback_(std::move(callback)) {
  }

  SmartCardConnection_Transmit_ForwardToCallback(const SmartCardConnection_Transmit_ForwardToCallback&) = delete;
  SmartCardConnection_Transmit_ForwardToCallback& operator=(const SmartCardConnection_Transmit_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SmartCardConnection::TransmitCallback callback_;
};

class SmartCardConnection_Control_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SmartCardConnection_Control_ForwardToCallback(
      SmartCardConnection::ControlCallback callback
      ) : callback_(std::move(callback)) {
  }

  SmartCardConnection_Control_ForwardToCallback(const SmartCardConnection_Control_ForwardToCallback&) = delete;
  SmartCardConnection_Control_ForwardToCallback& operator=(const SmartCardConnection_Control_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SmartCardConnection::ControlCallback callback_;
};

class SmartCardConnection_GetAttrib_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SmartCardConnection_GetAttrib_ForwardToCallback(
      SmartCardConnection::GetAttribCallback callback
      ) : callback_(std::move(callback)) {
  }

  SmartCardConnection_GetAttrib_ForwardToCallback(const SmartCardConnection_GetAttrib_ForwardToCallback&) = delete;
  SmartCardConnection_GetAttrib_ForwardToCallback& operator=(const SmartCardConnection_GetAttrib_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SmartCardConnection::GetAttribCallback callback_;
};

class SmartCardConnection_SetAttrib_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SmartCardConnection_SetAttrib_ForwardToCallback(
      SmartCardConnection::SetAttribCallback callback
      ) : callback_(std::move(callback)) {
  }

  SmartCardConnection_SetAttrib_ForwardToCallback(const SmartCardConnection_SetAttrib_ForwardToCallback&) = delete;
  SmartCardConnection_SetAttrib_ForwardToCallback& operator=(const SmartCardConnection_SetAttrib_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SmartCardConnection::SetAttribCallback callback_;
};

class SmartCardConnection_Status_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SmartCardConnection_Status_ForwardToCallback(
      SmartCardConnection::StatusCallback callback
      ) : callback_(std::move(callback)) {
  }

  SmartCardConnection_Status_ForwardToCallback(const SmartCardConnection_Status_ForwardToCallback&) = delete;
  SmartCardConnection_Status_ForwardToCallback& operator=(const SmartCardConnection_Status_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SmartCardConnection::StatusCallback callback_;
};

class SmartCardConnection_BeginTransaction_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SmartCardConnection_BeginTransaction_ForwardToCallback(
      SmartCardConnection::BeginTransactionCallback callback
      ) : callback_(std::move(callback)) {
  }

  SmartCardConnection_BeginTransaction_ForwardToCallback(const SmartCardConnection_BeginTransaction_ForwardToCallback&) = delete;
  SmartCardConnection_BeginTransaction_ForwardToCallback& operator=(const SmartCardConnection_BeginTransaction_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SmartCardConnection::BeginTransactionCallback callback_;
};

SmartCardConnectionProxy::SmartCardConnectionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SmartCardConnectionProxy::Disconnect(
    SmartCardDisposition in_disposition, DisconnectCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::SmartCardConnection::Disconnect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disposition"), in_disposition,
                        "<value of type SmartCardDisposition>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SmartCardConnection::kDisconnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SmartCardConnection_Disconnect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::SmartCardDisposition>(
      in_disposition, &params->disposition);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SmartCardConnection::Name_);
  message.set_method_name("Disconnect");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SmartCardConnection_Disconnect_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SmartCardConnectionProxy::Transmit(
    SmartCardProtocol in_protocol, const WTF::Vector<uint8_t>& in_data, TransmitCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::SmartCardConnection::Transmit", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("protocol"), in_protocol,
                        "<value of type SmartCardProtocol>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const WTF::Vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SmartCardConnection::kTransmit), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SmartCardConnection_Transmit_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::SmartCardProtocol>(
      in_protocol, &params->protocol);
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_data, data_fragment, &data_validate_params);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in SmartCardConnection.Transmit request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SmartCardConnection::Name_);
  message.set_method_name("Transmit");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SmartCardConnection_Transmit_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SmartCardConnectionProxy::Control(
    uint32_t in_control_code, const WTF::Vector<uint8_t>& in_data, ControlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::SmartCardConnection::Control", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("control_code"), in_control_code,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const WTF::Vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SmartCardConnection::kControl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SmartCardConnection_Control_Params_Data> params(
          message);
  params.Allocate();
  params->control_code = in_control_code;
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_data, data_fragment, &data_validate_params);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in SmartCardConnection.Control request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SmartCardConnection::Name_);
  message.set_method_name("Control");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SmartCardConnection_Control_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SmartCardConnectionProxy::GetAttrib(
    uint32_t in_id, GetAttribCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::SmartCardConnection::GetAttrib", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SmartCardConnection::kGetAttrib), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SmartCardConnection_GetAttrib_Params_Data> params(
          message);
  params.Allocate();
  params->id = in_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SmartCardConnection::Name_);
  message.set_method_name("GetAttrib");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SmartCardConnection_GetAttrib_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SmartCardConnectionProxy::SetAttrib(
    uint32_t in_id, const WTF::Vector<uint8_t>& in_data, SetAttribCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::SmartCardConnection::SetAttrib", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const WTF::Vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SmartCardConnection::kSetAttrib), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SmartCardConnection_SetAttrib_Params_Data> params(
          message);
  params.Allocate();
  params->id = in_id;
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_data, data_fragment, &data_validate_params);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in SmartCardConnection.SetAttrib request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SmartCardConnection::Name_);
  message.set_method_name("SetAttrib");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SmartCardConnection_SetAttrib_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SmartCardConnectionProxy::Status(
    StatusCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::SmartCardConnection::Status");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SmartCardConnection::kStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SmartCardConnection_Status_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SmartCardConnection::Name_);
  message.set_method_name("Status");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SmartCardConnection_Status_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SmartCardConnectionProxy::BeginTransaction(
    BeginTransactionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::SmartCardConnection::BeginTransaction");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SmartCardConnection::kBeginTransaction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SmartCardConnection_BeginTransaction_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SmartCardConnection::Name_);
  message.set_method_name("BeginTransaction");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SmartCardConnection_BeginTransaction_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SmartCardConnection_Disconnect_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SmartCardConnection::DisconnectCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SmartCardConnection_Disconnect_ProxyToResponder> proxy(
        new SmartCardConnection_Disconnect_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SmartCardConnection_Disconnect_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SmartCardConnection_Disconnect_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SmartCardConnection_Disconnect_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SmartCardConnection::DisconnectCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SmartCardResultPtr in_result);
};

bool SmartCardConnection_Disconnect_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SmartCardConnection_Disconnect_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SmartCardConnection_Disconnect_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for SmartCardConnection.0
  bool success = true;
  SmartCardResultPtr p_result{};
  SmartCardConnection_Disconnect_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SmartCardConnection::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void SmartCardConnection_Disconnect_ProxyToResponder::Run(
    SmartCardResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::SmartCardConnection::Disconnect", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type SmartCardResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SmartCardConnection::kDisconnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SmartCardConnection_Disconnect_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::device::mojom::SmartCardResultDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SmartCardConnection::Name_);
  message.set_method_name("Disconnect");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SmartCardConnection_Transmit_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SmartCardConnection::TransmitCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SmartCardConnection_Transmit_ProxyToResponder> proxy(
        new SmartCardConnection_Transmit_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SmartCardConnection_Transmit_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SmartCardConnection_Transmit_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SmartCardConnection_Transmit_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SmartCardConnection::TransmitCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SmartCardDataResultPtr in_result);
};

bool SmartCardConnection_Transmit_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SmartCardConnection_Transmit_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SmartCardConnection_Transmit_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for SmartCardConnection.1
  bool success = true;
  SmartCardDataResultPtr p_result{};
  SmartCardConnection_Transmit_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SmartCardConnection::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void SmartCardConnection_Transmit_ProxyToResponder::Run(
    SmartCardDataResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::SmartCardConnection::Transmit", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type SmartCardDataResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SmartCardConnection::kTransmit), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SmartCardConnection_Transmit_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::device::mojom::SmartCardDataResultDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SmartCardConnection::Name_);
  message.set_method_name("Transmit");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SmartCardConnection_Control_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SmartCardConnection::ControlCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SmartCardConnection_Control_ProxyToResponder> proxy(
        new SmartCardConnection_Control_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SmartCardConnection_Control_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SmartCardConnection_Control_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SmartCardConnection_Control_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SmartCardConnection::ControlCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SmartCardDataResultPtr in_result);
};

bool SmartCardConnection_Control_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SmartCardConnection_Control_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SmartCardConnection_Control_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for SmartCardConnection.2
  bool success = true;
  SmartCardDataResultPtr p_result{};
  SmartCardConnection_Control_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SmartCardConnection::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void SmartCardConnection_Control_ProxyToResponder::Run(
    SmartCardDataResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::SmartCardConnection::Control", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type SmartCardDataResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SmartCardConnection::kControl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SmartCardConnection_Control_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::device::mojom::SmartCardDataResultDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SmartCardConnection::Name_);
  message.set_method_name("Control");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SmartCardConnection_GetAttrib_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SmartCardConnection::GetAttribCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SmartCardConnection_GetAttrib_ProxyToResponder> proxy(
        new SmartCardConnection_GetAttrib_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SmartCardConnection_GetAttrib_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SmartCardConnection_GetAttrib_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SmartCardConnection_GetAttrib_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SmartCardConnection::GetAttribCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SmartCardDataResultPtr in_result);
};

bool SmartCardConnection_GetAttrib_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SmartCardConnection_GetAttrib_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SmartCardConnection_GetAttrib_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for SmartCardConnection.3
  bool success = true;
  SmartCardDataResultPtr p_result{};
  SmartCardConnection_GetAttrib_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SmartCardConnection::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void SmartCardConnection_GetAttrib_ProxyToResponder::Run(
    SmartCardDataResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::SmartCardConnection::GetAttrib", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type SmartCardDataResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SmartCardConnection::kGetAttrib), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SmartCardConnection_GetAttrib_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::device::mojom::SmartCardDataResultDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SmartCardConnection::Name_);
  message.set_method_name("GetAttrib");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SmartCardConnection_SetAttrib_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SmartCardConnection::SetAttribCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SmartCardConnection_SetAttrib_ProxyToResponder> proxy(
        new SmartCardConnection_SetAttrib_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SmartCardConnection_SetAttrib_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SmartCardConnection_SetAttrib_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SmartCardConnection_SetAttrib_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SmartCardConnection::SetAttribCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SmartCardResultPtr in_result);
};

bool SmartCardConnection_SetAttrib_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SmartCardConnection_SetAttrib_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SmartCardConnection_SetAttrib_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for SmartCardConnection.4
  bool success = true;
  SmartCardResultPtr p_result{};
  SmartCardConnection_SetAttrib_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SmartCardConnection::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void SmartCardConnection_SetAttrib_ProxyToResponder::Run(
    SmartCardResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::SmartCardConnection::SetAttrib", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type SmartCardResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SmartCardConnection::kSetAttrib), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SmartCardConnection_SetAttrib_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::device::mojom::SmartCardResultDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SmartCardConnection::Name_);
  message.set_method_name("SetAttrib");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SmartCardConnection_Status_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SmartCardConnection::StatusCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SmartCardConnection_Status_ProxyToResponder> proxy(
        new SmartCardConnection_Status_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SmartCardConnection_Status_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SmartCardConnection_Status_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SmartCardConnection_Status_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SmartCardConnection::StatusCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SmartCardStatusResultPtr in_result);
};

bool SmartCardConnection_Status_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SmartCardConnection_Status_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SmartCardConnection_Status_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for SmartCardConnection.5
  bool success = true;
  SmartCardStatusResultPtr p_result{};
  SmartCardConnection_Status_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SmartCardConnection::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void SmartCardConnection_Status_ProxyToResponder::Run(
    SmartCardStatusResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::SmartCardConnection::Status", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type SmartCardStatusResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SmartCardConnection::kStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SmartCardConnection_Status_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::device::mojom::SmartCardStatusResultDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SmartCardConnection::Name_);
  message.set_method_name("Status");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SmartCardConnection_BeginTransaction_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SmartCardConnection::BeginTransactionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SmartCardConnection_BeginTransaction_ProxyToResponder> proxy(
        new SmartCardConnection_BeginTransaction_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SmartCardConnection_BeginTransaction_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SmartCardConnection_BeginTransaction_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SmartCardConnection_BeginTransaction_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SmartCardConnection::BeginTransactionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SmartCardTransactionResultPtr in_result);
};

bool SmartCardConnection_BeginTransaction_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SmartCardConnection_BeginTransaction_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SmartCardConnection_BeginTransaction_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for SmartCardConnection.6
  bool success = true;
  SmartCardTransactionResultPtr p_result{};
  SmartCardConnection_BeginTransaction_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SmartCardConnection::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void SmartCardConnection_BeginTransaction_ProxyToResponder::Run(
    SmartCardTransactionResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::SmartCardConnection::BeginTransaction", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type SmartCardTransactionResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SmartCardConnection::kBeginTransaction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SmartCardConnection_BeginTransaction_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::device::mojom::SmartCardTransactionResultDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SmartCardConnection::Name_);
  message.set_method_name("BeginTransaction");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SmartCardConnectionStubDispatch::Accept(
    SmartCardConnection* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SmartCardConnection>(message->header()->name)) {
    case messages::SmartCardConnection::kDisconnect: {
      break;
    }
    case messages::SmartCardConnection::kTransmit: {
      break;
    }
    case messages::SmartCardConnection::kControl: {
      break;
    }
    case messages::SmartCardConnection::kGetAttrib: {
      break;
    }
    case messages::SmartCardConnection::kSetAttrib: {
      break;
    }
    case messages::SmartCardConnection::kStatus: {
      break;
    }
    case messages::SmartCardConnection::kBeginTransaction: {
      break;
    }
  }
  return false;
}

// static
bool SmartCardConnectionStubDispatch::AcceptWithResponder(
    SmartCardConnection* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SmartCardConnection>(message->header()->name)) {
    case messages::SmartCardConnection::kDisconnect: {
      internal::SmartCardConnection_Disconnect_Params_Data* params =
          reinterpret_cast<
              internal::SmartCardConnection_Disconnect_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for SmartCardConnection.0
      bool success = true;
      SmartCardDisposition p_disposition{};
      SmartCardConnection_Disconnect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDisposition(&p_disposition))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SmartCardConnection::Name_, 0, false);
        return false;
      }
      SmartCardConnection::DisconnectCallback callback =
          SmartCardConnection_Disconnect_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Disconnect(        
        std::move(p_disposition), std::move(callback));
      return true;
    }
    case messages::SmartCardConnection::kTransmit: {
      internal::SmartCardConnection_Transmit_Params_Data* params =
          reinterpret_cast<
              internal::SmartCardConnection_Transmit_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for SmartCardConnection.1
      bool success = true;
      SmartCardProtocol p_protocol{};
      WTF::Vector<uint8_t> p_data{};
      SmartCardConnection_Transmit_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProtocol(&p_protocol))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SmartCardConnection::Name_, 1, false);
        return false;
      }
      SmartCardConnection::TransmitCallback callback =
          SmartCardConnection_Transmit_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Transmit(        
        std::move(p_protocol), 
        std::move(p_data), std::move(callback));
      return true;
    }
    case messages::SmartCardConnection::kControl: {
      internal::SmartCardConnection_Control_Params_Data* params =
          reinterpret_cast<
              internal::SmartCardConnection_Control_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for SmartCardConnection.2
      bool success = true;
      uint32_t p_control_code{};
      WTF::Vector<uint8_t> p_data{};
      SmartCardConnection_Control_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_control_code = input_data_view.control_code();
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SmartCardConnection::Name_, 2, false);
        return false;
      }
      SmartCardConnection::ControlCallback callback =
          SmartCardConnection_Control_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Control(        
        std::move(p_control_code), 
        std::move(p_data), std::move(callback));
      return true;
    }
    case messages::SmartCardConnection::kGetAttrib: {
      internal::SmartCardConnection_GetAttrib_Params_Data* params =
          reinterpret_cast<
              internal::SmartCardConnection_GetAttrib_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for SmartCardConnection.3
      bool success = true;
      uint32_t p_id{};
      SmartCardConnection_GetAttrib_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SmartCardConnection::Name_, 3, false);
        return false;
      }
      SmartCardConnection::GetAttribCallback callback =
          SmartCardConnection_GetAttrib_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAttrib(        
        std::move(p_id), std::move(callback));
      return true;
    }
    case messages::SmartCardConnection::kSetAttrib: {
      internal::SmartCardConnection_SetAttrib_Params_Data* params =
          reinterpret_cast<
              internal::SmartCardConnection_SetAttrib_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for SmartCardConnection.4
      bool success = true;
      uint32_t p_id{};
      WTF::Vector<uint8_t> p_data{};
      SmartCardConnection_SetAttrib_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SmartCardConnection::Name_, 4, false);
        return false;
      }
      SmartCardConnection::SetAttribCallback callback =
          SmartCardConnection_SetAttrib_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAttrib(        
        std::move(p_id), 
        std::move(p_data), std::move(callback));
      return true;
    }
    case messages::SmartCardConnection::kStatus: {
      internal::SmartCardConnection_Status_Params_Data* params =
          reinterpret_cast<
              internal::SmartCardConnection_Status_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for SmartCardConnection.5
      bool success = true;
      SmartCardConnection_Status_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SmartCardConnection::Name_, 5, false);
        return false;
      }
      SmartCardConnection::StatusCallback callback =
          SmartCardConnection_Status_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Status(std::move(callback));
      return true;
    }
    case messages::SmartCardConnection::kBeginTransaction: {
      internal::SmartCardConnection_BeginTransaction_Params_Data* params =
          reinterpret_cast<
              internal::SmartCardConnection_BeginTransaction_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for SmartCardConnection.6
      bool success = true;
      SmartCardConnection_BeginTransaction_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SmartCardConnection::Name_, 6, false);
        return false;
      }
      SmartCardConnection::BeginTransactionCallback callback =
          SmartCardConnection_BeginTransaction_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BeginTransaction(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSmartCardConnectionValidationInfo[] = {
    {base::to_underlying(messages::SmartCardConnection::kDisconnect),
     { &internal::SmartCardConnection_Disconnect_Params_Data::Validate,
      &internal::SmartCardConnection_Disconnect_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::SmartCardConnection::kTransmit),
     { &internal::SmartCardConnection_Transmit_Params_Data::Validate,
      &internal::SmartCardConnection_Transmit_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::SmartCardConnection::kControl),
     { &internal::SmartCardConnection_Control_Params_Data::Validate,
      &internal::SmartCardConnection_Control_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::SmartCardConnection::kGetAttrib),
     { &internal::SmartCardConnection_GetAttrib_Params_Data::Validate,
      &internal::SmartCardConnection_GetAttrib_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::SmartCardConnection::kSetAttrib),
     { &internal::SmartCardConnection_SetAttrib_Params_Data::Validate,
      &internal::SmartCardConnection_SetAttrib_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::SmartCardConnection::kStatus),
     { &internal::SmartCardConnection_Status_Params_Data::Validate,
      &internal::SmartCardConnection_Status_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::SmartCardConnection::kBeginTransaction),
     { &internal::SmartCardConnection_BeginTransaction_Params_Data::Validate,
      &internal::SmartCardConnection_BeginTransaction_ResponseParams_Data::Validate}},
};

bool SmartCardConnectionRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::SmartCardConnection::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSmartCardConnectionValidationInfo);
}

bool SmartCardConnectionResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::SmartCardConnection::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kSmartCardConnectionValidationInfo);

}
const char SmartCardContext::Name_[] = "device.mojom.SmartCardContext";

SmartCardContext::IPCStableHashFunction SmartCardContext::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SmartCardContext>(message.name())) {
    case messages::SmartCardContext::kListReaders: {
      return &SmartCardContext::ListReaders_Sym::IPCStableHash;
    }
    case messages::SmartCardContext::kGetStatusChange: {
      return &SmartCardContext::GetStatusChange_Sym::IPCStableHash;
    }
    case messages::SmartCardContext::kCancel: {
      return &SmartCardContext::Cancel_Sym::IPCStableHash;
    }
    case messages::SmartCardContext::kConnect: {
      return &SmartCardContext::Connect_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SmartCardContext::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SmartCardContext>(message.name())) {
      case messages::SmartCardContext::kListReaders:
            return "Receive device::mojom::SmartCardContext::ListReaders";
      case messages::SmartCardContext::kGetStatusChange:
            return "Receive device::mojom::SmartCardContext::GetStatusChange";
      case messages::SmartCardContext::kCancel:
            return "Receive device::mojom::SmartCardContext::Cancel";
      case messages::SmartCardContext::kConnect:
            return "Receive device::mojom::SmartCardContext::Connect";
    }
  } else {
    switch (static_cast<messages::SmartCardContext>(message.name())) {
      case messages::SmartCardContext::kListReaders:
            return "Receive reply device::mojom::SmartCardContext::ListReaders";
      case messages::SmartCardContext::kGetStatusChange:
            return "Receive reply device::mojom::SmartCardContext::GetStatusChange";
      case messages::SmartCardContext::kCancel:
            return "Receive reply device::mojom::SmartCardContext::Cancel";
      case messages::SmartCardContext::kConnect:
            return "Receive reply device::mojom::SmartCardContext::Connect";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SmartCardContext::ListReaders_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::SmartCardContext::ListReaders");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SmartCardContext::GetStatusChange_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::SmartCardContext::GetStatusChange");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SmartCardContext::Cancel_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::SmartCardContext::Cancel");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SmartCardContext::Connect_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::SmartCardContext::Connect");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SmartCardContext_ListReaders_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SmartCardContext_ListReaders_ForwardToCallback(
      SmartCardContext::ListReadersCallback callback
      ) : callback_(std::move(callback)) {
  }

  SmartCardContext_ListReaders_ForwardToCallback(const SmartCardContext_ListReaders_ForwardToCallback&) = delete;
  SmartCardContext_ListReaders_ForwardToCallback& operator=(const SmartCardContext_ListReaders_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SmartCardContext::ListReadersCallback callback_;
};

class SmartCardContext_GetStatusChange_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SmartCardContext_GetStatusChange_ForwardToCallback(
      SmartCardContext::GetStatusChangeCallback callback
      ) : callback_(std::move(callback)) {
  }

  SmartCardContext_GetStatusChange_ForwardToCallback(const SmartCardContext_GetStatusChange_ForwardToCallback&) = delete;
  SmartCardContext_GetStatusChange_ForwardToCallback& operator=(const SmartCardContext_GetStatusChange_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SmartCardContext::GetStatusChangeCallback callback_;
};

class SmartCardContext_Cancel_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SmartCardContext_Cancel_ForwardToCallback(
      SmartCardContext::CancelCallback callback
      ) : callback_(std::move(callback)) {
  }

  SmartCardContext_Cancel_ForwardToCallback(const SmartCardContext_Cancel_ForwardToCallback&) = delete;
  SmartCardContext_Cancel_ForwardToCallback& operator=(const SmartCardContext_Cancel_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SmartCardContext::CancelCallback callback_;
};

class SmartCardContext_Connect_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SmartCardContext_Connect_ForwardToCallback(
      SmartCardContext::ConnectCallback callback
      ) : callback_(std::move(callback)) {
  }

  SmartCardContext_Connect_ForwardToCallback(const SmartCardContext_Connect_ForwardToCallback&) = delete;
  SmartCardContext_Connect_ForwardToCallback& operator=(const SmartCardContext_Connect_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SmartCardContext::ConnectCallback callback_;
};

SmartCardContextProxy::SmartCardContextProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SmartCardContextProxy::ListReaders(
    ListReadersCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::SmartCardContext::ListReaders");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SmartCardContext::kListReaders), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SmartCardContext_ListReaders_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SmartCardContext::Name_);
  message.set_method_name("ListReaders");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SmartCardContext_ListReaders_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SmartCardContextProxy::GetStatusChange(
    ::base::TimeDelta in_timeout, WTF::Vector<SmartCardReaderStateInPtr> in_reader_states, GetStatusChangeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::SmartCardContext::GetStatusChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timeout"), in_timeout,
                        "<value of type ::base::TimeDelta>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reader_states"), in_reader_states,
                        "<value of type WTF::Vector<SmartCardReaderStateInPtr>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SmartCardContext::kGetStatusChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SmartCardContext_GetStatusChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->timeout)::BaseType> timeout_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_timeout, timeout_fragment);
  params->timeout.Set(
      timeout_fragment.is_null() ? nullptr : timeout_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->timeout.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timeout in SmartCardContext.GetStatusChange request");
  mojo::internal::MessageFragment<
      typename decltype(params->reader_states)::BaseType>
      reader_states_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& reader_states_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::SmartCardReaderStateInDataView>>(
      in_reader_states, reader_states_fragment, &reader_states_validate_params);
  params->reader_states.Set(
      reader_states_fragment.is_null() ? nullptr : reader_states_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->reader_states.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null reader_states in SmartCardContext.GetStatusChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SmartCardContext::Name_);
  message.set_method_name("GetStatusChange");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SmartCardContext_GetStatusChange_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SmartCardContextProxy::Cancel(
    CancelCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::SmartCardContext::Cancel");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SmartCardContext::kCancel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SmartCardContext_Cancel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SmartCardContext::Name_);
  message.set_method_name("Cancel");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SmartCardContext_Cancel_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SmartCardContextProxy::Connect(
    const WTF::String& in_reader, SmartCardShareMode in_share_mode, SmartCardProtocolsPtr in_preferred_protocols, ConnectCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::SmartCardContext::Connect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reader"), in_reader,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("share_mode"), in_share_mode,
                        "<value of type SmartCardShareMode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("preferred_protocols"), in_preferred_protocols,
                        "<value of type SmartCardProtocolsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SmartCardContext::kConnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SmartCardContext_Connect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->reader)::BaseType> reader_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_reader, reader_fragment);
  params->reader.Set(
      reader_fragment.is_null() ? nullptr : reader_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->reader.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null reader in SmartCardContext.Connect request");
  mojo::internal::Serialize<::device::mojom::SmartCardShareMode>(
      in_share_mode, &params->share_mode);
  mojo::internal::MessageFragment<
      typename decltype(params->preferred_protocols)::BaseType> preferred_protocols_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::SmartCardProtocolsDataView>(
      in_preferred_protocols, preferred_protocols_fragment);
  params->preferred_protocols.Set(
      preferred_protocols_fragment.is_null() ? nullptr : preferred_protocols_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->preferred_protocols.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null preferred_protocols in SmartCardContext.Connect request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SmartCardContext::Name_);
  message.set_method_name("Connect");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SmartCardContext_Connect_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SmartCardContext_ListReaders_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SmartCardContext::ListReadersCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SmartCardContext_ListReaders_ProxyToResponder> proxy(
        new SmartCardContext_ListReaders_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SmartCardContext_ListReaders_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SmartCardContext_ListReaders_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SmartCardContext_ListReaders_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SmartCardContext::ListReadersCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SmartCardListReadersResultPtr in_result);
};

bool SmartCardContext_ListReaders_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SmartCardContext_ListReaders_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SmartCardContext_ListReaders_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for SmartCardContext.0
  bool success = true;
  SmartCardListReadersResultPtr p_result{};
  SmartCardContext_ListReaders_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SmartCardContext::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void SmartCardContext_ListReaders_ProxyToResponder::Run(
    SmartCardListReadersResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::SmartCardContext::ListReaders", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type SmartCardListReadersResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SmartCardContext::kListReaders), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SmartCardContext_ListReaders_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::device::mojom::SmartCardListReadersResultDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SmartCardContext::Name_);
  message.set_method_name("ListReaders");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SmartCardContext_GetStatusChange_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SmartCardContext::GetStatusChangeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SmartCardContext_GetStatusChange_ProxyToResponder> proxy(
        new SmartCardContext_GetStatusChange_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SmartCardContext_GetStatusChange_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SmartCardContext_GetStatusChange_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SmartCardContext_GetStatusChange_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SmartCardContext::GetStatusChangeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SmartCardStatusChangeResultPtr in_result);
};

bool SmartCardContext_GetStatusChange_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SmartCardContext_GetStatusChange_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SmartCardContext_GetStatusChange_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for SmartCardContext.1
  bool success = true;
  SmartCardStatusChangeResultPtr p_result{};
  SmartCardContext_GetStatusChange_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SmartCardContext::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void SmartCardContext_GetStatusChange_ProxyToResponder::Run(
    SmartCardStatusChangeResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::SmartCardContext::GetStatusChange", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type SmartCardStatusChangeResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SmartCardContext::kGetStatusChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SmartCardContext_GetStatusChange_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::device::mojom::SmartCardStatusChangeResultDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SmartCardContext::Name_);
  message.set_method_name("GetStatusChange");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SmartCardContext_Cancel_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SmartCardContext::CancelCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SmartCardContext_Cancel_ProxyToResponder> proxy(
        new SmartCardContext_Cancel_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SmartCardContext_Cancel_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SmartCardContext_Cancel_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SmartCardContext_Cancel_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SmartCardContext::CancelCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SmartCardResultPtr in_result);
};

bool SmartCardContext_Cancel_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SmartCardContext_Cancel_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SmartCardContext_Cancel_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for SmartCardContext.2
  bool success = true;
  SmartCardResultPtr p_result{};
  SmartCardContext_Cancel_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SmartCardContext::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void SmartCardContext_Cancel_ProxyToResponder::Run(
    SmartCardResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::SmartCardContext::Cancel", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type SmartCardResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SmartCardContext::kCancel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SmartCardContext_Cancel_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::device::mojom::SmartCardResultDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SmartCardContext::Name_);
  message.set_method_name("Cancel");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SmartCardContext_Connect_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SmartCardContext::ConnectCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SmartCardContext_Connect_ProxyToResponder> proxy(
        new SmartCardContext_Connect_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SmartCardContext_Connect_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SmartCardContext_Connect_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SmartCardContext_Connect_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SmartCardContext::ConnectCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SmartCardConnectResultPtr in_result);
};

bool SmartCardContext_Connect_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SmartCardContext_Connect_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SmartCardContext_Connect_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for SmartCardContext.3
  bool success = true;
  SmartCardConnectResultPtr p_result{};
  SmartCardContext_Connect_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SmartCardContext::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void SmartCardContext_Connect_ProxyToResponder::Run(
    SmartCardConnectResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::SmartCardContext::Connect", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type SmartCardConnectResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SmartCardContext::kConnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SmartCardContext_Connect_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::device::mojom::SmartCardConnectResultDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SmartCardContext::Name_);
  message.set_method_name("Connect");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SmartCardContextStubDispatch::Accept(
    SmartCardContext* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SmartCardContext>(message->header()->name)) {
    case messages::SmartCardContext::kListReaders: {
      break;
    }
    case messages::SmartCardContext::kGetStatusChange: {
      break;
    }
    case messages::SmartCardContext::kCancel: {
      break;
    }
    case messages::SmartCardContext::kConnect: {
      break;
    }
  }
  return false;
}

// static
bool SmartCardContextStubDispatch::AcceptWithResponder(
    SmartCardContext* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SmartCardContext>(message->header()->name)) {
    case messages::SmartCardContext::kListReaders: {
      internal::SmartCardContext_ListReaders_Params_Data* params =
          reinterpret_cast<
              internal::SmartCardContext_ListReaders_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for SmartCardContext.0
      bool success = true;
      SmartCardContext_ListReaders_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SmartCardContext::Name_, 0, false);
        return false;
      }
      SmartCardContext::ListReadersCallback callback =
          SmartCardContext_ListReaders_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ListReaders(std::move(callback));
      return true;
    }
    case messages::SmartCardContext::kGetStatusChange: {
      internal::SmartCardContext_GetStatusChange_Params_Data* params =
          reinterpret_cast<
              internal::SmartCardContext_GetStatusChange_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for SmartCardContext.1
      bool success = true;
      ::base::TimeDelta p_timeout{};
      WTF::Vector<SmartCardReaderStateInPtr> p_reader_states{};
      SmartCardContext_GetStatusChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTimeout(&p_timeout))
        success = false;
      if (success && !input_data_view.ReadReaderStates(&p_reader_states))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SmartCardContext::Name_, 1, false);
        return false;
      }
      SmartCardContext::GetStatusChangeCallback callback =
          SmartCardContext_GetStatusChange_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetStatusChange(        
        std::move(p_timeout), 
        std::move(p_reader_states), std::move(callback));
      return true;
    }
    case messages::SmartCardContext::kCancel: {
      internal::SmartCardContext_Cancel_Params_Data* params =
          reinterpret_cast<
              internal::SmartCardContext_Cancel_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for SmartCardContext.2
      bool success = true;
      SmartCardContext_Cancel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SmartCardContext::Name_, 2, false);
        return false;
      }
      SmartCardContext::CancelCallback callback =
          SmartCardContext_Cancel_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cancel(std::move(callback));
      return true;
    }
    case messages::SmartCardContext::kConnect: {
      internal::SmartCardContext_Connect_Params_Data* params =
          reinterpret_cast<
              internal::SmartCardContext_Connect_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for SmartCardContext.3
      bool success = true;
      WTF::String p_reader{};
      SmartCardShareMode p_share_mode{};
      SmartCardProtocolsPtr p_preferred_protocols{};
      SmartCardContext_Connect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReader(&p_reader))
        success = false;
      if (success && !input_data_view.ReadShareMode(&p_share_mode))
        success = false;
      if (success && !input_data_view.ReadPreferredProtocols(&p_preferred_protocols))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SmartCardContext::Name_, 3, false);
        return false;
      }
      SmartCardContext::ConnectCallback callback =
          SmartCardContext_Connect_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Connect(        
        std::move(p_reader), 
        std::move(p_share_mode), 
        std::move(p_preferred_protocols), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSmartCardContextValidationInfo[] = {
    {base::to_underlying(messages::SmartCardContext::kListReaders),
     { &internal::SmartCardContext_ListReaders_Params_Data::Validate,
      &internal::SmartCardContext_ListReaders_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::SmartCardContext::kGetStatusChange),
     { &internal::SmartCardContext_GetStatusChange_Params_Data::Validate,
      &internal::SmartCardContext_GetStatusChange_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::SmartCardContext::kCancel),
     { &internal::SmartCardContext_Cancel_Params_Data::Validate,
      &internal::SmartCardContext_Cancel_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::SmartCardContext::kConnect),
     { &internal::SmartCardContext_Connect_Params_Data::Validate,
      &internal::SmartCardContext_Connect_ResponseParams_Data::Validate}},
};

bool SmartCardContextRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::SmartCardContext::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSmartCardContextValidationInfo);
}

bool SmartCardContextResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::SmartCardContext::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kSmartCardContextValidationInfo);

}
const char SmartCardContextFactory::Name_[] = "device.mojom.SmartCardContextFactory";

SmartCardContextFactory::IPCStableHashFunction SmartCardContextFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SmartCardContextFactory>(message.name())) {
    case messages::SmartCardContextFactory::kCreateContext: {
      return &SmartCardContextFactory::CreateContext_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SmartCardContextFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SmartCardContextFactory>(message.name())) {
      case messages::SmartCardContextFactory::kCreateContext:
            return "Receive device::mojom::SmartCardContextFactory::CreateContext";
    }
  } else {
    switch (static_cast<messages::SmartCardContextFactory>(message.name())) {
      case messages::SmartCardContextFactory::kCreateContext:
            return "Receive reply device::mojom::SmartCardContextFactory::CreateContext";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SmartCardContextFactory::CreateContext_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::SmartCardContextFactory::CreateContext");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SmartCardContextFactory_CreateContext_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SmartCardContextFactory_CreateContext_ForwardToCallback(
      SmartCardContextFactory::CreateContextCallback callback
      ) : callback_(std::move(callback)) {
  }

  SmartCardContextFactory_CreateContext_ForwardToCallback(const SmartCardContextFactory_CreateContext_ForwardToCallback&) = delete;
  SmartCardContextFactory_CreateContext_ForwardToCallback& operator=(const SmartCardContextFactory_CreateContext_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SmartCardContextFactory::CreateContextCallback callback_;
};

SmartCardContextFactoryProxy::SmartCardContextFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SmartCardContextFactoryProxy::CreateContext(
    CreateContextCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::SmartCardContextFactory::CreateContext");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SmartCardContextFactory::kCreateContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SmartCardContextFactory_CreateContext_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SmartCardContextFactory::Name_);
  message.set_method_name("CreateContext");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SmartCardContextFactory_CreateContext_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SmartCardContextFactory_CreateContext_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SmartCardContextFactory::CreateContextCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SmartCardContextFactory_CreateContext_ProxyToResponder> proxy(
        new SmartCardContextFactory_CreateContext_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SmartCardContextFactory_CreateContext_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SmartCardContextFactory_CreateContext_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SmartCardContextFactory_CreateContext_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SmartCardContextFactory::CreateContextCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SmartCardCreateContextResultPtr in_result);
};

bool SmartCardContextFactory_CreateContext_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SmartCardContextFactory_CreateContext_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SmartCardContextFactory_CreateContext_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for SmartCardContextFactory.0
  bool success = true;
  SmartCardCreateContextResultPtr p_result{};
  SmartCardContextFactory_CreateContext_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SmartCardContextFactory::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void SmartCardContextFactory_CreateContext_ProxyToResponder::Run(
    SmartCardCreateContextResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::SmartCardContextFactory::CreateContext", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type SmartCardCreateContextResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SmartCardContextFactory::kCreateContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SmartCardContextFactory_CreateContext_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::device::mojom::SmartCardCreateContextResultDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SmartCardContextFactory::Name_);
  message.set_method_name("CreateContext");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SmartCardContextFactoryStubDispatch::Accept(
    SmartCardContextFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SmartCardContextFactory>(message->header()->name)) {
    case messages::SmartCardContextFactory::kCreateContext: {
      break;
    }
  }
  return false;
}

// static
bool SmartCardContextFactoryStubDispatch::AcceptWithResponder(
    SmartCardContextFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SmartCardContextFactory>(message->header()->name)) {
    case messages::SmartCardContextFactory::kCreateContext: {
      internal::SmartCardContextFactory_CreateContext_Params_Data* params =
          reinterpret_cast<
              internal::SmartCardContextFactory_CreateContext_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for SmartCardContextFactory.0
      bool success = true;
      SmartCardContextFactory_CreateContext_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SmartCardContextFactory::Name_, 0, false);
        return false;
      }
      SmartCardContextFactory::CreateContextCallback callback =
          SmartCardContextFactory_CreateContext_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateContext(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSmartCardContextFactoryValidationInfo[] = {
    {base::to_underlying(messages::SmartCardContextFactory::kCreateContext),
     { &internal::SmartCardContextFactory_CreateContext_Params_Data::Validate,
      &internal::SmartCardContextFactory_CreateContext_ResponseParams_Data::Validate}},
};

bool SmartCardContextFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::SmartCardContextFactory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSmartCardContextFactoryValidationInfo);
}

bool SmartCardContextFactoryResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::SmartCardContextFactory::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kSmartCardContextFactoryValidationInfo);

}


}  // device::mojom::blink


namespace mojo {


// static
bool StructTraits<::device::mojom::blink::SmartCardReaderStateFlags::DataView, ::device::mojom::blink::SmartCardReaderStateFlagsPtr>::Read(
    ::device::mojom::blink::SmartCardReaderStateFlags::DataView input,
    ::device::mojom::blink::SmartCardReaderStateFlagsPtr* output) {
  bool success = true;
  ::device::mojom::blink::SmartCardReaderStateFlagsPtr result(::device::mojom::blink::SmartCardReaderStateFlags::New());
  
      if (success)
        result->unaware = input.unaware();
      if (success)
        result->ignore = input.ignore();
      if (success)
        result->changed = input.changed();
      if (success)
        result->unknown = input.unknown();
      if (success)
        result->unavailable = input.unavailable();
      if (success)
        result->empty = input.empty();
      if (success)
        result->present = input.present();
      if (success)
        result->exclusive = input.exclusive();
      if (success)
        result->inuse = input.inuse();
      if (success)
        result->mute = input.mute();
      if (success)
        result->unpowered = input.unpowered();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::SmartCardReaderStateIn::DataView, ::device::mojom::blink::SmartCardReaderStateInPtr>::Read(
    ::device::mojom::blink::SmartCardReaderStateIn::DataView input,
    ::device::mojom::blink::SmartCardReaderStateInPtr* output) {
  bool success = true;
  ::device::mojom::blink::SmartCardReaderStateInPtr result(::device::mojom::blink::SmartCardReaderStateIn::New());
  
      if (success && !input.ReadReader(&result->reader))
        success = false;
      if (success && !input.ReadCurrentState(&result->current_state))
        success = false;
      if (success)
        result->current_count = input.current_count();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::SmartCardReaderStateOut::DataView, ::device::mojom::blink::SmartCardReaderStateOutPtr>::Read(
    ::device::mojom::blink::SmartCardReaderStateOut::DataView input,
    ::device::mojom::blink::SmartCardReaderStateOutPtr* output) {
  bool success = true;
  ::device::mojom::blink::SmartCardReaderStateOutPtr result(::device::mojom::blink::SmartCardReaderStateOut::New());
  
      if (success && !input.ReadReader(&result->reader))
        success = false;
      if (success && !input.ReadEventState(&result->event_state))
        success = false;
      if (success)
        result->event_count = input.event_count();
      if (success && !input.ReadAnswerToReset(&result->answer_to_reset))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::SmartCardProtocols::DataView, ::device::mojom::blink::SmartCardProtocolsPtr>::Read(
    ::device::mojom::blink::SmartCardProtocols::DataView input,
    ::device::mojom::blink::SmartCardProtocolsPtr* output) {
  bool success = true;
  ::device::mojom::blink::SmartCardProtocolsPtr result(::device::mojom::blink::SmartCardProtocols::New());
  
      if (success)
        result->t0 = input.t0();
      if (success)
        result->t1 = input.t1();
      if (success)
        result->raw = input.raw();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::SmartCardStatus::DataView, ::device::mojom::blink::SmartCardStatusPtr>::Read(
    ::device::mojom::blink::SmartCardStatus::DataView input,
    ::device::mojom::blink::SmartCardStatusPtr* output) {
  bool success = true;
  ::device::mojom::blink::SmartCardStatusPtr result(::device::mojom::blink::SmartCardStatus::New());
  
      if (success && !input.ReadReaderName(&result->reader_name))
        success = false;
      if (success && !input.ReadState(&result->state))
        success = false;
      if (success && !input.ReadProtocol(&result->protocol))
        success = false;
      if (success && !input.ReadAnswerToReset(&result->answer_to_reset))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::SmartCardConnectSuccess::DataView, ::device::mojom::blink::SmartCardConnectSuccessPtr>::Read(
    ::device::mojom::blink::SmartCardConnectSuccess::DataView input,
    ::device::mojom::blink::SmartCardConnectSuccessPtr* output) {
  bool success = true;
  ::device::mojom::blink::SmartCardConnectSuccessPtr result(::device::mojom::blink::SmartCardConnectSuccess::New());
  
      if (success) {
        result->connection =
            input.TakeConnection<decltype(result->connection)>();
      }
      if (success && !input.ReadActiveProtocol(&result->active_protocol))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::device::mojom::blink::SmartCardResult::DataView, ::device::mojom::blink::SmartCardResultPtr>::Read(
    ::device::mojom::blink::SmartCardResult::DataView input,
    ::device::mojom::blink::SmartCardResultPtr* output) {
  using UnionType = ::device::mojom::blink::SmartCardResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::device::mojom::blink::SmartCardSuccess result_success;
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(result_success);
      break;
    }
    case Tag::kError: {
      ::device::mojom::blink::SmartCardError result_error;
      if (!input.ReadError(&result_error))
        return false;

      *output = UnionType::NewError(result_error);
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::device::mojom::blink::SmartCardStatusChangeResult::DataView, ::device::mojom::blink::SmartCardStatusChangeResultPtr>::Read(
    ::device::mojom::blink::SmartCardStatusChangeResult::DataView input,
    ::device::mojom::blink::SmartCardStatusChangeResultPtr* output) {
  using UnionType = ::device::mojom::blink::SmartCardStatusChangeResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kReaderStates: {
      WTF::Vector<::device::mojom::blink::SmartCardReaderStateOutPtr> result_reader_states;
      if (!input.ReadReaderStates(&result_reader_states))
        return false;

      *output = UnionType::NewReaderStates(
          std::move(result_reader_states));
      break;
    }
    case Tag::kError: {
      ::device::mojom::blink::SmartCardError result_error;
      if (!input.ReadError(&result_error))
        return false;

      *output = UnionType::NewError(result_error);
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::device::mojom::blink::SmartCardListReadersResult::DataView, ::device::mojom::blink::SmartCardListReadersResultPtr>::Read(
    ::device::mojom::blink::SmartCardListReadersResult::DataView input,
    ::device::mojom::blink::SmartCardListReadersResultPtr* output) {
  using UnionType = ::device::mojom::blink::SmartCardListReadersResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kReaders: {
      WTF::Vector<WTF::String> result_readers;
      if (!input.ReadReaders(&result_readers))
        return false;

      *output = UnionType::NewReaders(
          std::move(result_readers));
      break;
    }
    case Tag::kError: {
      ::device::mojom::blink::SmartCardError result_error;
      if (!input.ReadError(&result_error))
        return false;

      *output = UnionType::NewError(result_error);
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::device::mojom::blink::SmartCardCreateContextResult::DataView, ::device::mojom::blink::SmartCardCreateContextResultPtr>::Read(
    ::device::mojom::blink::SmartCardCreateContextResult::DataView input,
    ::device::mojom::blink::SmartCardCreateContextResultPtr* output) {
  using UnionType = ::device::mojom::blink::SmartCardCreateContextResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kContext: {
      *output = UnionType::NewContext(
          input.TakeContext<::mojo::PendingRemote<::device::mojom::blink::SmartCardContext>>());
      break;
    }
    case Tag::kError: {
      ::device::mojom::blink::SmartCardError result_error;
      if (!input.ReadError(&result_error))
        return false;

      *output = UnionType::NewError(result_error);
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::device::mojom::blink::SmartCardConnectResult::DataView, ::device::mojom::blink::SmartCardConnectResultPtr>::Read(
    ::device::mojom::blink::SmartCardConnectResult::DataView input,
    ::device::mojom::blink::SmartCardConnectResultPtr* output) {
  using UnionType = ::device::mojom::blink::SmartCardConnectResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::device::mojom::blink::SmartCardConnectSuccessPtr result_success;
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kError: {
      ::device::mojom::blink::SmartCardError result_error;
      if (!input.ReadError(&result_error))
        return false;

      *output = UnionType::NewError(result_error);
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::device::mojom::blink::SmartCardDataResult::DataView, ::device::mojom::blink::SmartCardDataResultPtr>::Read(
    ::device::mojom::blink::SmartCardDataResult::DataView input,
    ::device::mojom::blink::SmartCardDataResultPtr* output) {
  using UnionType = ::device::mojom::blink::SmartCardDataResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kData: {
      WTF::Vector<uint8_t> result_data;
      if (!input.ReadData(&result_data))
        return false;

      *output = UnionType::NewData(
          std::move(result_data));
      break;
    }
    case Tag::kError: {
      ::device::mojom::blink::SmartCardError result_error;
      if (!input.ReadError(&result_error))
        return false;

      *output = UnionType::NewError(result_error);
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::device::mojom::blink::SmartCardStatusResult::DataView, ::device::mojom::blink::SmartCardStatusResultPtr>::Read(
    ::device::mojom::blink::SmartCardStatusResult::DataView input,
    ::device::mojom::blink::SmartCardStatusResultPtr* output) {
  using UnionType = ::device::mojom::blink::SmartCardStatusResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kStatus: {
      ::device::mojom::blink::SmartCardStatusPtr result_status;
      if (!input.ReadStatus(&result_status))
        return false;

      *output = UnionType::NewStatus(
          std::move(result_status));
      break;
    }
    case Tag::kError: {
      ::device::mojom::blink::SmartCardError result_error;
      if (!input.ReadError(&result_error))
        return false;

      *output = UnionType::NewError(result_error);
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::device::mojom::blink::SmartCardTransactionResult::DataView, ::device::mojom::blink::SmartCardTransactionResultPtr>::Read(
    ::device::mojom::blink::SmartCardTransactionResult::DataView input,
    ::device::mojom::blink::SmartCardTransactionResultPtr* output) {
  using UnionType = ::device::mojom::blink::SmartCardTransactionResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kTransaction: {
      *output = UnionType::NewTransaction(
          input.TakeTransaction<::mojo::PendingAssociatedRemote<::device::mojom::blink::SmartCardTransaction>>());
      break;
    }
    case Tag::kError: {
      ::device::mojom::blink::SmartCardError result_error;
      if (!input.ReadError(&result_error))
        return false;

      *output = UnionType::NewError(result_error);
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom::blink {


void SmartCardTransactionInterceptorForTesting::EndTransaction(SmartCardDisposition disposition, EndTransactionCallback callback) {
  GetForwardingInterface()->EndTransaction(
    std::move(disposition)
    , std::move(callback));
}
SmartCardTransactionAsyncWaiter::SmartCardTransactionAsyncWaiter(
    SmartCardTransaction* proxy) : proxy_(proxy) {}

SmartCardTransactionAsyncWaiter::~SmartCardTransactionAsyncWaiter() = default;

void SmartCardTransactionAsyncWaiter::EndTransaction(
    SmartCardDisposition disposition, SmartCardResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->EndTransaction(
      std::move(disposition),
      base::BindOnce(
          [](base::RunLoop* loop,
             SmartCardResultPtr* out_result
,
             SmartCardResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

SmartCardResultPtr SmartCardTransactionAsyncWaiter::EndTransaction(
    SmartCardDisposition disposition) {
  SmartCardResultPtr async_wait_result;
  EndTransaction(std::move(disposition),&async_wait_result);
  return async_wait_result;
}




void SmartCardConnectionInterceptorForTesting::Disconnect(SmartCardDisposition disposition, DisconnectCallback callback) {
  GetForwardingInterface()->Disconnect(
    std::move(disposition)
    , std::move(callback));
}
void SmartCardConnectionInterceptorForTesting::Transmit(SmartCardProtocol protocol, const WTF::Vector<uint8_t>& data, TransmitCallback callback) {
  GetForwardingInterface()->Transmit(
    std::move(protocol)
    , 
    std::move(data)
    , std::move(callback));
}
void SmartCardConnectionInterceptorForTesting::Control(uint32_t control_code, const WTF::Vector<uint8_t>& data, ControlCallback callback) {
  GetForwardingInterface()->Control(
    std::move(control_code)
    , 
    std::move(data)
    , std::move(callback));
}
void SmartCardConnectionInterceptorForTesting::GetAttrib(uint32_t id, GetAttribCallback callback) {
  GetForwardingInterface()->GetAttrib(
    std::move(id)
    , std::move(callback));
}
void SmartCardConnectionInterceptorForTesting::SetAttrib(uint32_t id, const WTF::Vector<uint8_t>& data, SetAttribCallback callback) {
  GetForwardingInterface()->SetAttrib(
    std::move(id)
    , 
    std::move(data)
    , std::move(callback));
}
void SmartCardConnectionInterceptorForTesting::Status(StatusCallback callback) {
  GetForwardingInterface()->Status(std::move(callback));
}
void SmartCardConnectionInterceptorForTesting::BeginTransaction(BeginTransactionCallback callback) {
  GetForwardingInterface()->BeginTransaction(std::move(callback));
}
SmartCardConnectionAsyncWaiter::SmartCardConnectionAsyncWaiter(
    SmartCardConnection* proxy) : proxy_(proxy) {}

SmartCardConnectionAsyncWaiter::~SmartCardConnectionAsyncWaiter() = default;

void SmartCardConnectionAsyncWaiter::Disconnect(
    SmartCardDisposition disposition, SmartCardResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->Disconnect(
      std::move(disposition),
      base::BindOnce(
          [](base::RunLoop* loop,
             SmartCardResultPtr* out_result
,
             SmartCardResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

SmartCardResultPtr SmartCardConnectionAsyncWaiter::Disconnect(
    SmartCardDisposition disposition) {
  SmartCardResultPtr async_wait_result;
  Disconnect(std::move(disposition),&async_wait_result);
  return async_wait_result;
}

void SmartCardConnectionAsyncWaiter::Transmit(
    SmartCardProtocol protocol, const WTF::Vector<uint8_t>& data, SmartCardDataResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->Transmit(
      std::move(protocol),
      std::move(data),
      base::BindOnce(
          [](base::RunLoop* loop,
             SmartCardDataResultPtr* out_result
,
             SmartCardDataResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

SmartCardDataResultPtr SmartCardConnectionAsyncWaiter::Transmit(
    SmartCardProtocol protocol, const WTF::Vector<uint8_t>& data) {
  SmartCardDataResultPtr async_wait_result;
  Transmit(std::move(protocol),std::move(data),&async_wait_result);
  return async_wait_result;
}

void SmartCardConnectionAsyncWaiter::Control(
    uint32_t control_code, const WTF::Vector<uint8_t>& data, SmartCardDataResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->Control(
      std::move(control_code),
      std::move(data),
      base::BindOnce(
          [](base::RunLoop* loop,
             SmartCardDataResultPtr* out_result
,
             SmartCardDataResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

SmartCardDataResultPtr SmartCardConnectionAsyncWaiter::Control(
    uint32_t control_code, const WTF::Vector<uint8_t>& data) {
  SmartCardDataResultPtr async_wait_result;
  Control(std::move(control_code),std::move(data),&async_wait_result);
  return async_wait_result;
}

void SmartCardConnectionAsyncWaiter::GetAttrib(
    uint32_t id, SmartCardDataResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->GetAttrib(
      std::move(id),
      base::BindOnce(
          [](base::RunLoop* loop,
             SmartCardDataResultPtr* out_result
,
             SmartCardDataResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

SmartCardDataResultPtr SmartCardConnectionAsyncWaiter::GetAttrib(
    uint32_t id) {
  SmartCardDataResultPtr async_wait_result;
  GetAttrib(std::move(id),&async_wait_result);
  return async_wait_result;
}

void SmartCardConnectionAsyncWaiter::SetAttrib(
    uint32_t id, const WTF::Vector<uint8_t>& data, SmartCardResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->SetAttrib(
      std::move(id),
      std::move(data),
      base::BindOnce(
          [](base::RunLoop* loop,
             SmartCardResultPtr* out_result
,
             SmartCardResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

SmartCardResultPtr SmartCardConnectionAsyncWaiter::SetAttrib(
    uint32_t id, const WTF::Vector<uint8_t>& data) {
  SmartCardResultPtr async_wait_result;
  SetAttrib(std::move(id),std::move(data),&async_wait_result);
  return async_wait_result;
}

void SmartCardConnectionAsyncWaiter::Status(
    SmartCardStatusResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->Status(
      base::BindOnce(
          [](base::RunLoop* loop,
             SmartCardStatusResultPtr* out_result
,
             SmartCardStatusResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

SmartCardStatusResultPtr SmartCardConnectionAsyncWaiter::Status(
    ) {
  SmartCardStatusResultPtr async_wait_result;
  Status(&async_wait_result);
  return async_wait_result;
}

void SmartCardConnectionAsyncWaiter::BeginTransaction(
    SmartCardTransactionResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->BeginTransaction(
      base::BindOnce(
          [](base::RunLoop* loop,
             SmartCardTransactionResultPtr* out_result
,
             SmartCardTransactionResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

SmartCardTransactionResultPtr SmartCardConnectionAsyncWaiter::BeginTransaction(
    ) {
  SmartCardTransactionResultPtr async_wait_result;
  BeginTransaction(&async_wait_result);
  return async_wait_result;
}




void SmartCardContextInterceptorForTesting::ListReaders(ListReadersCallback callback) {
  GetForwardingInterface()->ListReaders(std::move(callback));
}
void SmartCardContextInterceptorForTesting::GetStatusChange(::base::TimeDelta timeout, WTF::Vector<SmartCardReaderStateInPtr> reader_states, GetStatusChangeCallback callback) {
  GetForwardingInterface()->GetStatusChange(
    std::move(timeout)
    , 
    std::move(reader_states)
    , std::move(callback));
}
void SmartCardContextInterceptorForTesting::Cancel(CancelCallback callback) {
  GetForwardingInterface()->Cancel(std::move(callback));
}
void SmartCardContextInterceptorForTesting::Connect(const WTF::String& reader, SmartCardShareMode share_mode, SmartCardProtocolsPtr preferred_protocols, ConnectCallback callback) {
  GetForwardingInterface()->Connect(
    std::move(reader)
    , 
    std::move(share_mode)
    , 
    std::move(preferred_protocols)
    , std::move(callback));
}
SmartCardContextAsyncWaiter::SmartCardContextAsyncWaiter(
    SmartCardContext* proxy) : proxy_(proxy) {}

SmartCardContextAsyncWaiter::~SmartCardContextAsyncWaiter() = default;

void SmartCardContextAsyncWaiter::ListReaders(
    SmartCardListReadersResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->ListReaders(
      base::BindOnce(
          [](base::RunLoop* loop,
             SmartCardListReadersResultPtr* out_result
,
             SmartCardListReadersResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

SmartCardListReadersResultPtr SmartCardContextAsyncWaiter::ListReaders(
    ) {
  SmartCardListReadersResultPtr async_wait_result;
  ListReaders(&async_wait_result);
  return async_wait_result;
}

void SmartCardContextAsyncWaiter::GetStatusChange(
    ::base::TimeDelta timeout, WTF::Vector<SmartCardReaderStateInPtr> reader_states, SmartCardStatusChangeResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->GetStatusChange(
      std::move(timeout),
      std::move(reader_states),
      base::BindOnce(
          [](base::RunLoop* loop,
             SmartCardStatusChangeResultPtr* out_result
,
             SmartCardStatusChangeResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

SmartCardStatusChangeResultPtr SmartCardContextAsyncWaiter::GetStatusChange(
    ::base::TimeDelta timeout, WTF::Vector<SmartCardReaderStateInPtr> reader_states) {
  SmartCardStatusChangeResultPtr async_wait_result;
  GetStatusChange(std::move(timeout),std::move(reader_states),&async_wait_result);
  return async_wait_result;
}

void SmartCardContextAsyncWaiter::Cancel(
    SmartCardResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->Cancel(
      base::BindOnce(
          [](base::RunLoop* loop,
             SmartCardResultPtr* out_result
,
             SmartCardResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

SmartCardResultPtr SmartCardContextAsyncWaiter::Cancel(
    ) {
  SmartCardResultPtr async_wait_result;
  Cancel(&async_wait_result);
  return async_wait_result;
}

void SmartCardContextAsyncWaiter::Connect(
    const WTF::String& reader, SmartCardShareMode share_mode, SmartCardProtocolsPtr preferred_protocols, SmartCardConnectResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->Connect(
      std::move(reader),
      std::move(share_mode),
      std::move(preferred_protocols),
      base::BindOnce(
          [](base::RunLoop* loop,
             SmartCardConnectResultPtr* out_result
,
             SmartCardConnectResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

SmartCardConnectResultPtr SmartCardContextAsyncWaiter::Connect(
    const WTF::String& reader, SmartCardShareMode share_mode, SmartCardProtocolsPtr preferred_protocols) {
  SmartCardConnectResultPtr async_wait_result;
  Connect(std::move(reader),std::move(share_mode),std::move(preferred_protocols),&async_wait_result);
  return async_wait_result;
}




void SmartCardContextFactoryInterceptorForTesting::CreateContext(CreateContextCallback callback) {
  GetForwardingInterface()->CreateContext(std::move(callback));
}
SmartCardContextFactoryAsyncWaiter::SmartCardContextFactoryAsyncWaiter(
    SmartCardContextFactory* proxy) : proxy_(proxy) {}

SmartCardContextFactoryAsyncWaiter::~SmartCardContextFactoryAsyncWaiter() = default;

void SmartCardContextFactoryAsyncWaiter::CreateContext(
    SmartCardCreateContextResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->CreateContext(
      base::BindOnce(
          [](base::RunLoop* loop,
             SmartCardCreateContextResultPtr* out_result
,
             SmartCardCreateContextResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

SmartCardCreateContextResultPtr SmartCardContextFactoryAsyncWaiter::CreateContext(
    ) {
  SmartCardCreateContextResultPtr async_wait_result;
  CreateContext(&async_wait_result);
  return async_wait_result;
}






}  // device::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif