// services/network/public/mojom/network_param.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/network_param.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/network_param.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* ProxySchemeToStringHelper(ProxyScheme value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ProxyScheme::kInvalid:
      return "kInvalid";
    case ProxyScheme::kHttp:
      return "kHttp";
    case ProxyScheme::kSocks4:
      return "kSocks4";
    case ProxyScheme::kSocks5:
      return "kSocks5";
    case ProxyScheme::kHttps:
      return "kHttps";
    case ProxyScheme::kQuic:
      return "kQuic";
    default:
      return nullptr;
  }
}

std::string ProxySchemeToString(ProxyScheme value) {
  const char *str = ProxySchemeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ProxyScheme value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ProxyScheme value) {
  return os << ProxySchemeToString(value);
}

namespace internal {


// static
bool AuthChallengeInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AuthChallengeInfo_Data* object =
      static_cast<const AuthChallengeInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->challenger, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->challenger, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scheme, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& scheme_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->scheme, validation_context,
                                         &scheme_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->realm, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& realm_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->realm, validation_context,
                                         &realm_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->challenge, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& challenge_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->challenge, validation_context,
                                         &challenge_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& path_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->path, validation_context,
                                         &path_validate_params)) {
    return false;
  }

  return true;
}

AuthChallengeInfo_Data::AuthChallengeInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HttpVersion_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HttpVersion_Data* object =
      static_cast<const HttpVersion_Data*>(data);

  return true;
}

HttpVersion_Data::HttpVersion_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HostPortPair_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HostPortPair_Data* object =
      static_cast<const HostPortPair_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& host_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->host, validation_context,
                                         &host_validate_params)) {
    return false;
  }

  return true;
}

HostPortPair_Data::HostPortPair_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProxyServer_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProxyServer_Data* object =
      static_cast<const ProxyServer_Data*>(data);


  if (!::network::mojom::internal::ProxyScheme_Data
        ::Validate(object->scheme, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->host_and_port, validation_context))
    return false;

  return true;
}

ProxyServer_Data::ProxyServer_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProxyChain_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProxyChain_Data* object =
      static_cast<const ProxyChain_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& proxy_servers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->proxy_servers, validation_context,
                                         &proxy_servers_validate_params)) {
    return false;
  }

  return true;
}

ProxyChain_Data::ProxyChain_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ResolveErrorInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ResolveErrorInfo_Data* object =
      static_cast<const ResolveErrorInfo_Data*>(data);

  return true;
}

ResolveErrorInfo_Data::ResolveErrorInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SSLCertRequestInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SSLCertRequestInfo_Data* object =
      static_cast<const SSLCertRequestInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host_and_port, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->host_and_port, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cert_authorities, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cert_authorities_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->cert_authorities, validation_context,
                                         &cert_authorities_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->signature_algorithms, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& signature_algorithms_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->signature_algorithms, validation_context,
                                         &signature_algorithms_validate_params)) {
    return false;
  }

  return true;
}

SSLCertRequestInfo_Data::SSLCertRequestInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetLogSource_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetLogSource_Data* object =
      static_cast<const NetLogSource_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->start_time, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->start_time, validation_context))
    return false;

  return true;
}

NetLogSource_Data::NetLogSource_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::ProxyScheme>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::ProxyScheme value) {
  return std::move(context).WriteString(::network::mojom::ProxySchemeToString(value));
}

} // namespace perfetto