// services/network/public/mojom/service_worker_router_info.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/service_worker_router_info.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/service_worker_router_info.mojom-params-data.h"
#include "services/network/public/mojom/service_worker_router_info.mojom-shared-message-ids.h"

#include "services/network/public/mojom/service_worker_router_info.mojom-import-headers.h"
#include "services/network/public/mojom/service_worker_router_info.mojom-test-utils.h"


namespace network::mojom {
ServiceWorkerRouterInfo::ServiceWorkerRouterInfo()
    : rule_id_matched(0),
      matched_source_type(),
      actual_source_type(),
      route_rule_num(0ULL),
      router_evaluation_time(),
      cache_lookup_time(),
      evaluation_worker_status() {}

ServiceWorkerRouterInfo::ServiceWorkerRouterInfo(
    std::optional<uint32_t> rule_id_matched_in,
    std::optional<ServiceWorkerRouterSourceType> matched_source_type_in,
    std::optional<ServiceWorkerRouterSourceType> actual_source_type_in,
    uint64_t route_rule_num_in,
    ::base::TimeDelta router_evaluation_time_in,
    ::base::TimeDelta cache_lookup_time_in,
    std::optional<ServiceWorkerStatus> evaluation_worker_status_in)
    : rule_id_matched(std::move(rule_id_matched_in)),
      matched_source_type(std::move(matched_source_type_in)),
      actual_source_type(std::move(actual_source_type_in)),
      route_rule_num(std::move(route_rule_num_in)),
      router_evaluation_time(std::move(router_evaluation_time_in)),
      cache_lookup_time(std::move(cache_lookup_time_in)),
      evaluation_worker_status(std::move(evaluation_worker_status_in)) {}

ServiceWorkerRouterInfo::~ServiceWorkerRouterInfo() = default;

void ServiceWorkerRouterInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rule_id_matched"), this->rule_id_matched,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "matched_source_type"), this->matched_source_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<ServiceWorkerRouterSourceType>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "actual_source_type"), this->actual_source_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<ServiceWorkerRouterSourceType>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "route_rule_num"), this->route_rule_num,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "router_evaluation_time"), this->router_evaluation_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cache_lookup_time"), this->cache_lookup_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "evaluation_worker_status"), this->evaluation_worker_status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<ServiceWorkerStatus>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceWorkerRouterInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::ServiceWorkerRouterInfo::DataView, ::network::mojom::ServiceWorkerRouterInfoPtr>::Read(
    ::network::mojom::ServiceWorkerRouterInfo::DataView input,
    ::network::mojom::ServiceWorkerRouterInfoPtr* output) {
  bool success = true;
  ::network::mojom::ServiceWorkerRouterInfoPtr result(::network::mojom::ServiceWorkerRouterInfo::New());
  
      if (success) {
        result->rule_id_matched = input.rule_id_matched();
      }
      if (success && !input.ReadMatchedSourceType(&result->matched_source_type)) {
        success = false;
      }
      if (success && !input.ReadActualSourceType(&result->actual_source_type)) {
        success = false;
      }
      if (success)
        result->route_rule_num = input.route_rule_num();
      if (success && !input.ReadRouterEvaluationTime(&result->router_evaluation_time))
        success = false;
      if (success && !input.ReadCacheLookupTime(&result->cache_lookup_time))
        success = false;
      if (success && !input.ReadEvaluationWorkerStatus(&result->evaluation_worker_status)) {
        success = false;
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {




}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif