// services/network/public/mojom/supports_loading_mode.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/supports_loading_mode.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/supports_loading_mode.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* LoadingModeToStringHelper(LoadingMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LoadingMode::kDefault:
      return "kDefault";
    case LoadingMode::kUncredentialedPrefetch:
      return "kUncredentialedPrefetch";
    case LoadingMode::kUncredentialedPrerender:
      return "kUncredentialedPrerender";
    case LoadingMode::kCredentialedPrerender:
      return "kCredentialedPrerender";
    case LoadingMode::kFencedFrame:
      return "kFencedFrame";
    default:
      return nullptr;
  }
}

std::string LoadingModeToString(LoadingMode value) {
  const char *str = LoadingModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LoadingMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LoadingMode value) {
  return os << LoadingModeToString(value);
}

namespace internal {


// static
bool SupportsLoadingMode_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SupportsLoadingMode_Data* object =
      static_cast<const SupportsLoadingMode_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->supported_modes, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& supported_modes_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::LoadingMode_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->supported_modes, validation_context,
                                         &supported_modes_validate_params)) {
    return false;
  }

  return true;
}

SupportsLoadingMode_Data::SupportsLoadingMode_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::LoadingMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::LoadingMode value) {
  return std::move(context).WriteString(::network::mojom::LoadingModeToString(value));
}

} // namespace perfetto